/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.image.GIFFileFormat;
import org.eclipse.swt.internal.image.JPEGFileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.OS2BMPFileFormat;
import org.eclipse.swt.internal.image.PNGFileFormat;
import org.eclipse.swt.internal.image.SVGFileFormat;
import org.eclipse.swt.internal.image.TIFFFileFormat;
import org.eclipse.swt.internal.image.WinBMPFileFormat;
import org.eclipse.swt.internal.image.WinICOFileFormat;

public abstract class FileFormat {
    private static final List<Supplier<FileFormat>> FORMAT_FACTORIES = new ArrayList<Supplier<FileFormat>>();
    public static final int DEFAULT_ZOOM = 100;
    private static final int MAX_SIGNATURE_BYTES = 20;
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageLoader loader;
    int compression;

    private static Optional<FileFormat> determineFileFormat(LEDataInputStream stream) {
        return FORMAT_FACTORIES.stream().skip(1L).map(Supplier::get).filter(f -> {
            try {
                return f.isFileFormat(stream);
            }
            catch (IOException e) {
                return false;
            }
        }).findFirst();
    }

    public static boolean isDynamicallySizableFormat(InputStream is) {
        Optional<FileFormat> format = FileFormat.determineFileFormat(new LEDataInputStream(is, 20));
        return format.isPresent() && !(format.get() instanceof StaticImageFileFormat);
    }

    abstract boolean isFileFormat(LEDataInputStream var1) throws IOException;

    abstract List<DPIUtil.ElementAtZoom<ImageData>> loadFromByteStream(int var1, int var2);

    abstract ImageData loadFromByteStreamBySize(int var1, int var2);

    public List<DPIUtil.ElementAtZoom<ImageData>> loadFromStream(LEDataInputStream stream, int fileZoom, int targetZoom) {
        try {
            this.inputStream = stream;
            return this.loadFromByteStream(fileZoom, targetZoom);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                SWT.error(39, e);
            } else {
                SWT.error(40, e);
            }
            return null;
        }
    }

    public ImageData loadFromStreamBySize(LEDataInputStream stream, int width, int height) {
        try {
            this.inputStream = stream;
            return this.loadFromByteStreamBySize(width, height);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                SWT.error(39, e);
            } else {
                SWT.error(40, e);
            }
            return null;
        }
    }

    public static List<DPIUtil.ElementAtZoom<ImageData>> load(DPIUtil.ElementAtZoom<InputStream> is, ImageLoader loader, int targetZoom) {
        LEDataInputStream stream = new LEDataInputStream(is.element());
        FileFormat fileFormat = FileFormat.determineFileFormat(stream).orElseGet(() -> {
            SWT.error(42);
            return null;
        });
        fileFormat.loader = loader;
        return fileFormat.loadFromStream(stream, is.zoom(), targetZoom);
    }

    public static ImageData load(InputStream is, ImageLoader loader, int width, int height) {
        LEDataInputStream stream = new LEDataInputStream(is);
        FileFormat fileFormat = FileFormat.determineFileFormat(stream).orElseGet(() -> {
            SWT.error(42);
            return null;
        });
        fileFormat.loader = loader;
        return fileFormat.loadFromStreamBySize(stream, width, height);
    }

    public static boolean canLoadAtZoom(DPIUtil.ElementAtZoom<InputStream> is, int targetZoom) {
        return is.zoom() == targetZoom || FileFormat.isDynamicallySizableFormat(is.element());
    }

    public static void save(OutputStream os, int format, ImageLoader loader) {
        if (format < 0 || format >= FORMAT_FACTORIES.size()) {
            SWT.error(42);
        }
        if (loader.data == null || loader.data.length < 1) {
            SWT.error(5);
        }
        LEDataOutputStream stream = new LEDataOutputStream(os);
        FileFormat fileFormat = FORMAT_FACTORIES.get(format).get();
        if (format == 1) {
            switch (loader.data[0].depth) {
                case 8: {
                    fileFormat.compression = 1;
                    break;
                }
                case 4: {
                    fileFormat.compression = 2;
                }
            }
        }
        fileFormat.unloadIntoStream(loader, stream);
    }

    abstract void unloadIntoByteStream(ImageLoader var1);

    public void unloadIntoStream(ImageLoader loader, LEDataOutputStream stream) {
        try {
            this.outputStream = stream;
            this.unloadIntoByteStream(loader);
            this.outputStream.flush();
        }
        catch (Exception e) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SWT.error(39, e);
        }
    }

    static {
        try {
            FORMAT_FACTORIES.add(WinBMPFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(WinBMPFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(GIFFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(WinICOFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(JPEGFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(PNGFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(TIFFFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(OS2BMPFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            FORMAT_FACTORIES.add(SVGFileFormat::new);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static abstract class StaticImageFileFormat
    extends FileFormat {
        StaticImageFileFormat() {
        }

        abstract ImageData[] loadFromByteStream();

        @Override
        List<DPIUtil.ElementAtZoom<ImageData>> loadFromByteStream(int fileZoom, int targetZoom) {
            return Arrays.stream(this.loadFromByteStream()).map(d -> new DPIUtil.ElementAtZoom<ImageData>((ImageData)d, fileZoom)).toList();
        }

        @Override
        ImageData loadFromByteStreamBySize(int width, int height) {
            return this.loadFromByteStream()[0];
        }
    }
}

