/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.NativeImageLoader;
import org.eclipse.swt.internal.image.FileFormat;

public class ImageLoader {
    public static final int MAX_SIZE = Integer.getInteger("org.eclipse.swt.internal.imageLoader.maxSize", 5000);
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    List<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream stream) {
        this.loadByZoom(stream, 100, 100);
        return this.data;
    }

    List<DPIUtil.ElementAtZoom<ImageData>> loadByZoom(InputStream stream, int fileZoom, int targetZoom) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        List<DPIUtil.ElementAtZoom<ImageData>> images = NativeImageLoader.load(new DPIUtil.ElementAtZoom<InputStream>(stream, fileZoom), this, targetZoom);
        this.data = (ImageData[])images.stream().map(DPIUtil.ElementAtZoom::element).toArray(ImageData[]::new);
        return images;
    }

    ImageData loadBySize(InputStream stream, int width, int height) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        ImageData image = NativeImageLoader.load(stream, this, width, height);
        this.data = new ImageData[]{image};
        return image;
    }

    static boolean canLoadAtZoom(InputStream stream, int fileZoom, int targetZoom) {
        if (stream == null) {
            SWT.error(4);
        }
        return FileFormat.canLoadAtZoom(new DPIUtil.ElementAtZoom<InputStream>(stream, fileZoom), targetZoom);
    }

    public ImageData[] load(String filename) {
        this.loadByZoom(filename, 100, 100);
        return this.data;
    }

    List<DPIUtil.ElementAtZoom<ImageData>> loadByZoom(String filename, int fileZoom, int targetZoom) {
        List<DPIUtil.ElementAtZoom<ImageData>> list;
        if (filename == null) {
            SWT.error(4);
        }
        FileInputStream stream = new FileInputStream(filename);
        try {
            list = this.loadByZoom(stream, fileZoom, targetZoom);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SWT.error(39, e);
                return null;
            }
        }
        ((InputStream)stream).close();
        return list;
    }

    ImageData loadBySize(String filename, int width, int height) {
        ImageData imageData;
        if (filename == null) {
            SWT.error(4);
        }
        FileInputStream stream = new FileInputStream(filename);
        try {
            imageData = this.loadBySize(stream, width, height);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SWT.error(39, e);
                return null;
            }
        }
        ((InputStream)stream).close();
        return imageData;
    }

    static boolean canLoadAtZoom(String filename, int fileZoom, int targetZoom) {
        boolean bl;
        if (filename == null) {
            SWT.error(4);
        }
        FileInputStream stream = new FileInputStream(filename);
        try {
            bl = ImageLoader.canLoadAtZoom(stream, fileZoom, targetZoom);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SWT.error(39, e);
                return false;
            }
        }
        ((InputStream)stream).close();
        return bl;
    }

    static boolean isDynamicallySizable(String filename) {
        boolean bl;
        FileInputStream stream = new FileInputStream(filename);
        try {
            bl = FileFormat.isDynamicallySizableFormat(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SWT.error(39, e);
                return false;
            }
        }
        ((InputStream)stream).close();
        return bl;
    }

    static boolean isDynamicallySizable(InputStream stream) {
        return FileFormat.isDynamicallySizableFormat(stream);
    }

    public void save(OutputStream stream, int format) {
        if (stream == null) {
            SWT.error(4);
        }
        NativeImageLoader.save(stream, format, this);
    }

    public void save(String filename, int format) {
        if (filename == null) {
            SWT.error(4);
        }
        try (FileOutputStream stream = new FileOutputStream(filename);){
            this.save(stream, format);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
    }

    public void addImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new ArrayList<ImageLoaderListener>();
        }
        this.imageLoaderListeners.add(listener);
    }

    public void removeImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.remove(listener);
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        for (int i = 0; i < size; ++i) {
            ImageLoaderListener listener = this.imageLoaderListeners.get(i);
            listener.imageDataLoaded(event);
        }
    }
}

