/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.StrictChecks;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.BLENDFUNCTION;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TRIVERTEX;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;

public final class GC
extends Resource {
    public long handle;
    Drawable drawable;
    GCData data;
    private final GCData originalData = new GCData();
    private final List<Operation> operations = new ArrayList<Operation>();
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_WIDTH = 16;
    static final int LINE_CAP = 32;
    static final int LINE_JOIN = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_TEXT = 256;
    static final int BACKGROUND_TEXT = 512;
    static final int BRUSH = 1024;
    static final int PEN = 2048;
    static final int NULL_BRUSH = 4096;
    static final int NULL_PEN = 8192;
    static final int DRAW_OFFSET = 16384;
    static final int DRAW = 22777;
    static final int FILL = 9218;
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.style = GC.checkStyle(style);
        data.copyTo(this.originalData);
        long hDC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = data.device = device;
        this.init(drawable, data, hDC);
        this.init();
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    private void validateGCState() {
        if (this.drawable == null) {
            return;
        }
        try {
            GCData newData = new GCData();
            long newHdc = this.drawable.internal_new_GC(newData);
            if (this.data.nativeZoom != newData.nativeZoom) {
                System.err.println("***WARNING: Zoom of the underlying Drawable of the GC has changed. This indicates a long running GC that should be recreated.");
            }
            this.drawable.internal_dispose_GC(newHdc, newData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void checkGC(int mask) {
        StrictChecks.runIfStrictChecksEnabled(() -> this.validateGCState());
        int state = this.data.state;
        if ((state & mask) == mask) {
            return;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            long pen = this.data.gdipPen;
            float width = this.data.lineWidth;
            if ((state & 1) != 0 || pen == 0L && (state & 0xF8) != 0) {
                long brush;
                if (this.data.gdipFgBrush != 0L) {
                    Gdip.SolidBrush_delete(this.data.gdipFgBrush);
                }
                this.data.gdipFgBrush = 0L;
                Pattern pattern = this.data.foregroundPattern;
                if (pattern != null) {
                    if (this.data.alpha == 255) {
                        brush = pattern.getHandle(this.getZoom());
                    } else {
                        this.data.gdipFgPatternBrushAlpha = brush = this.data.gdipFgPatternBrushAlpha != 0L ? Gdip.Brush_Clone(this.data.gdipFgPatternBrushAlpha) : GC.createAlphaTextureBrush(pattern.getHandle(this.getZoom()), this.data.alpha);
                    }
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType(brush)) {
                            case 2: {
                                brush = Gdip.Brush_Clone(brush);
                                if (brush == 0L) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                                this.data.gdipFgBrush = brush;
                            }
                        }
                    }
                } else {
                    int foreground = this.data.foreground;
                    int color = this.data.alpha << 24 | foreground >> 16 & 0xFF | foreground & 0xFF00 | (foreground & 0xFF) << 16;
                    brush = Gdip.SolidBrush_new(color);
                    if (brush == 0L) {
                        SWT.error(2);
                    }
                    this.data.gdipFgBrush = brush;
                }
                if (pen != 0L) {
                    Gdip.Pen_SetBrush(pen, brush);
                } else {
                    pen = this.data.gdipPen = Gdip.Pen_new(brush, width);
                }
            }
            if ((state & 0x10) != 0) {
                Gdip.Pen_SetWidth(pen, width);
                switch (this.data.lineStyle) {
                    case 6: {
                        state |= 8;
                    }
                }
            }
            if ((state & 8) != 0) {
                float[] dashes = null;
                float dashOffset = 0.0f;
                int dashStyle = 0;
                switch (this.data.lineStyle) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        dashStyle = 2;
                        if (width != 0.0f) break;
                        dashes = LINE_DOT_ZERO;
                        break;
                    }
                    case 2: {
                        dashStyle = 1;
                        if (width != 0.0f) break;
                        dashes = LINE_DASH_ZERO;
                        break;
                    }
                    case 4: {
                        dashStyle = 3;
                        if (width != 0.0f) break;
                        dashes = LINE_DASHDOT_ZERO;
                        break;
                    }
                    case 5: {
                        dashStyle = 4;
                        if (width != 0.0f) break;
                        dashes = LINE_DASHDOTDOT_ZERO;
                        break;
                    }
                    case 6: {
                        if (this.data.lineDashes == null) break;
                        dashOffset = this.data.lineDashesOffset / Math.max(1.0f, width);
                        dashes = new float[this.data.lineDashes.length * 2];
                        for (int i = 0; i < this.data.lineDashes.length; ++i) {
                            float dash;
                            dashes[i] = dash = this.data.lineDashes[i] / Math.max(1.0f, width);
                            dashes[i + this.data.lineDashes.length] = dash;
                        }
                        break;
                    }
                }
                if (dashes != null) {
                    Gdip.Pen_SetDashPattern(pen, dashes, dashes.length);
                    Gdip.Pen_SetDashStyle(pen, 5);
                    Gdip.Pen_SetDashOffset(pen, dashOffset);
                } else {
                    Gdip.Pen_SetDashStyle(pen, dashStyle);
                }
            }
            if ((state & 0x80) != 0) {
                Gdip.Pen_SetMiterLimit(pen, this.data.lineMiterLimit);
            }
            if ((state & 0x40) != 0) {
                int joinStyle = 0;
                switch (this.data.lineJoin) {
                    case 1: {
                        joinStyle = 0;
                        break;
                    }
                    case 3: {
                        joinStyle = 1;
                        break;
                    }
                    case 2: {
                        joinStyle = 2;
                    }
                }
                Gdip.Pen_SetLineJoin(pen, joinStyle);
            }
            if ((state & 0x20) != 0) {
                int dashCap = 0;
                int capStyle = 0;
                switch (this.data.lineCap) {
                    case 1: {
                        capStyle = 0;
                        break;
                    }
                    case 2: {
                        capStyle = 2;
                        dashCap = 2;
                        break;
                    }
                    case 3: {
                        capStyle = 1;
                    }
                }
                Gdip.Pen_SetLineCap(pen, capStyle, capStyle, dashCap);
            }
            if ((state & 2) != 0) {
                if (this.data.gdipBgBrush != 0L) {
                    Gdip.SolidBrush_delete(this.data.gdipBgBrush);
                }
                this.data.gdipBgBrush = 0L;
                Pattern pattern = this.data.backgroundPattern;
                if (pattern != null) {
                    long brush;
                    this.data.gdipBrush = this.data.alpha == 255 ? pattern.getHandle(this.getZoom()) : (this.data.gdipBgBrush = (brush = this.data.gdipBgPatternBrushAlpha != 0L ? Gdip.Brush_Clone(this.data.gdipBgPatternBrushAlpha) : GC.createAlphaTextureBrush(pattern.getHandle(this.getZoom()), this.data.alpha)));
                    if ((this.data.style & 0x8000000) != 0) {
                        switch (Gdip.Brush_GetType(this.data.gdipBrush)) {
                            case 2: {
                                brush = Gdip.Brush_Clone(this.data.gdipBrush);
                                if (brush == 0L) {
                                    SWT.error(2);
                                }
                                Gdip.TextureBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                                this.data.gdipBrush = this.data.gdipBgBrush = brush;
                            }
                        }
                    }
                } else {
                    int background = this.data.background;
                    int color = this.data.alpha << 24 | background >> 16 & 0xFF | background & 0xFF00 | (background & 0xFF) << 16;
                    long brush = Gdip.SolidBrush_new(color);
                    if (brush == 0L) {
                        SWT.error(2);
                    }
                    this.data.gdipBrush = this.data.gdipBgBrush = brush;
                }
            }
            if ((state & 4) != 0) {
                long fontHandle = SWTFontProvider.getFontHandle(this.data.font, this.data.nativeZoom);
                OS.SelectObject(this.handle, fontHandle);
                long[] hFont = new long[1];
                long gdipFont = GC.createGdipFont(this.handle, fontHandle, gdipGraphics, this.device.fontCollection, null, hFont);
                if (hFont[0] != 0L) {
                    OS.SelectObject(this.handle, hFont[0]);
                }
                if (this.data.hGDIFont != 0L) {
                    OS.DeleteObject(this.data.hGDIFont);
                }
                this.data.hGDIFont = hFont[0];
                if (this.data.gdipFont != 0L) {
                    Gdip.Font_delete(this.data.gdipFont);
                }
                this.data.gdipFont = gdipFont;
            }
            if ((state & 0x4000) != 0) {
                int effectiveLineWidth;
                int n = effectiveLineWidth = this.data.lineWidth < 1.0f ? 1 : Math.round(this.data.lineWidth);
                if (effectiveLineWidth % 2 == 1) {
                    PointF offset = new PointF();
                    offset.Y = 0.5f;
                    offset.X = 0.5f;
                    long newMatrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                    Gdip.Graphics_GetTransform(gdipGraphics, newMatrix);
                    Gdip.Matrix_Invert(newMatrix);
                    Gdip.Matrix_TransformVectors(newMatrix, offset, 1);
                    Gdip.Matrix_delete(newMatrix);
                    this.data.gdipXOffset = Math.abs(offset.X);
                    this.data.gdipYOffset = Math.abs(offset.Y);
                } else {
                    this.data.gdipYOffset = 0.0f;
                    this.data.gdipXOffset = 0.0f;
                }
            }
            return;
        }
        if ((state & 0x79) != 0) {
            long newPen;
            int color = this.data.foreground;
            int width = (int)this.data.lineWidth;
            int[] dashes = null;
            int lineStyle = 0;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    lineStyle = 1;
                    break;
                }
                case 3: {
                    lineStyle = 2;
                    break;
                }
                case 4: {
                    lineStyle = 3;
                    break;
                }
                case 5: {
                    lineStyle = 4;
                    break;
                }
                case 6: {
                    if (this.data.lineDashes == null) break;
                    lineStyle = 7;
                    dashes = new int[this.data.lineDashes.length];
                    for (int i = 0; i < dashes.length; ++i) {
                        dashes[i] = (int)this.data.lineDashes[i];
                    }
                    break;
                }
            }
            if ((state & 8) != 0) {
                OS.SetBkMode(this.handle, this.data.lineStyle == 1 ? 2 : 1);
            }
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 8192;
                    break;
                }
                case 2: {
                    joinStyle = 0;
                    break;
                }
                case 3: {
                    joinStyle = 4096;
                }
            }
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 2: {
                    capStyle = 0;
                    break;
                }
                case 1: {
                    capStyle = 512;
                    break;
                }
                case 3: {
                    capStyle = 256;
                }
            }
            int style = lineStyle | joinStyle | capStyle;
            if (width == 0 && lineStyle != 7 || style == 0) {
                newPen = OS.CreatePen(style & 0xF, width, color);
            } else {
                LOGBRUSH logBrush = new LOGBRUSH();
                logBrush.lbStyle = 0;
                logBrush.lbColor = color;
                newPen = OS.ExtCreatePen(style | 0x10000, Math.max(1, width), logBrush, dashes != null ? dashes.length : 0, dashes);
            }
            OS.SelectObject(this.handle, newPen);
            this.data.state |= 0x800;
            this.data.state &= 0xFFFFDFFF;
            if (this.data.hPen != 0L) {
                OS.DeleteObject(this.data.hPen);
            }
            this.data.hPen = this.data.hOldPen = newPen;
        } else if ((state & 0x800) != 0) {
            OS.SelectObject(this.handle, this.data.hOldPen);
            this.data.state &= 0xFFFFDFFF;
        } else if ((state & 0x2000) != 0) {
            this.data.hOldPen = OS.SelectObject(this.handle, OS.GetStockObject(8));
            this.data.state &= 0xFFFFF7FF;
        }
        if ((state & 2) != 0) {
            long newBrush = OS.CreateSolidBrush(this.data.background);
            OS.SelectObject(this.handle, newBrush);
            this.data.state |= 0x400;
            this.data.state &= 0xFFFFEFFF;
            if (this.data.hBrush != 0L) {
                OS.DeleteObject(this.data.hBrush);
            }
            this.data.hOldBrush = this.data.hBrush = newBrush;
        } else if ((state & 0x400) != 0) {
            OS.SelectObject(this.handle, this.data.hOldBrush);
            this.data.state &= 0xFFFFEFFF;
        } else if ((state & 0x1000) != 0) {
            this.data.hOldBrush = OS.SelectObject(this.handle, OS.GetStockObject(5));
            this.data.state &= 0xFFFFFBFF;
        }
        if ((state & 0x200) != 0) {
            OS.SetBkColor(this.handle, this.data.background);
        }
        if ((state & 0x100) != 0) {
            OS.SetTextColor(this.handle, this.data.foreground);
        }
        if ((state & 4) != 0) {
            long fontHandle = SWTFontProvider.getFontHandle(this.data.font, this.data.nativeZoom);
            OS.SelectObject(this.handle, fontHandle);
        }
    }

    public void copyArea(Image image, int x, int y) {
        this.checkNonDisposed();
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new CopyAreaToImageOperation(image, x, y));
    }

    private void copyAreaInPixels(Image image, int x, int y) {
        if (image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds(this.getZoom());
        long memHdc = OS.CreateCompatibleDC(this.handle);
        long hOldBitmap = OS.SelectObject(memHdc, Image.win32_getHandle(image, this.getZoom()));
        OS.BitBlt(memHdc, 0, 0, rect.width, rect.height, this.handle, x, y, 0xCC0020);
        OS.SelectObject(memHdc, hOldBitmap);
        OS.DeleteDC(memHdc);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.checkNonDisposed();
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new CopyAreaOperation(new Rectangle(srcX, srcY, width, height), new Rectangle(destX, destY, width, height), paint));
    }

    private void copyAreaInPixels(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        this.checkNonDisposed();
        long hwnd = this.data.hwnd;
        if (hwnd == 0L) {
            OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
        } else {
            RECT lprcClip = null;
            long hrgn = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, hrgn) == 1) {
                lprcClip = new RECT();
                OS.GetRgnBox(hrgn, lprcClip);
            }
            OS.DeleteObject(hrgn);
            RECT lprcScroll = new RECT();
            OS.SetRect(lprcScroll, srcX, srcY, srcX + width, srcY + height);
            int flags = paint ? 6 : 0;
            OS.ScrollWindowEx(hwnd, destX - srcX, destY - srcY, lprcScroll, lprcClip, 0L, null, flags);
        }
    }

    static long createGdipFont(long hDC, long hFont, long graphics, long fontCollection, long[] outFamily, long[] outFont) {
        long font = Gdip.Font_new(hDC, hFont);
        if (font == 0L) {
            SWT.error(2);
        }
        long family = 0L;
        if (!Gdip.Font_IsAvailable(font)) {
            int index;
            Gdip.Font_delete(font);
            LOGFONT logFont = new LOGFONT();
            OS.GetObject(hFont, LOGFONT.sizeof, logFont);
            int size = Math.abs(logFont.lfHeight);
            int style = 0;
            if (logFont.lfWeight == 700) {
                style |= 1;
            }
            if (logFont.lfItalic != 0) {
                style |= 2;
            }
            char[] chars = logFont.lfFaceName;
            for (index = 0; index < chars.length && chars[index] != '\u0000'; ++index) {
            }
            String name = new String(chars, 0, index);
            if (name.equalsIgnoreCase("Courier")) {
                name = "Courier New";
            }
            char[] buffer = new char[name.length() + 1];
            name.getChars(0, name.length(), buffer, 0);
            if (fontCollection != 0L && !Gdip.FontFamily_IsAvailable(family = Gdip.FontFamily_new(buffer, fontCollection))) {
                Gdip.FontFamily_delete(family);
                family = Gdip.FontFamily_new(buffer, 0L);
                if (!Gdip.FontFamily_IsAvailable(family)) {
                    Gdip.FontFamily_delete(family);
                    family = 0L;
                }
            }
            font = family != 0L ? Gdip.Font_new(family, size, style, 2) : Gdip.Font_new(buffer, size, style, 2, 0L);
            if (outFont != null && font != 0L) {
                long hHeap = OS.GetProcessHeap();
                long pLogFont = OS.HeapAlloc(hHeap, 8, LOGFONT.sizeof);
                Gdip.Font_GetLogFontW(font, graphics, pLogFont);
                outFont[0] = OS.CreateFontIndirect(pLogFont);
                OS.HeapFree(hHeap, 0, pLogFont);
            }
        }
        if (outFamily != null && font != 0L) {
            if (family == 0L) {
                family = Gdip.FontFamily_new();
                Gdip.Font_GetFamily(font, family);
            }
            outFamily[0] = family;
        } else if (family != 0L) {
            Gdip.FontFamily_delete(family);
        }
        if (font == 0L) {
            SWT.error(2);
        }
        return font;
    }

    static long createAlphaTextureBrush(long brush, int alpha) {
        long transparentHatchImage;
        if (Gdip.Brush_GetType(brush) != 2) {
            return Gdip.Brush_Clone(brush);
        }
        long hatchImage = Gdip.TextureBrush_GetImage(brush);
        if (hatchImage == 0L) {
            SWT.error(7);
        }
        if ((transparentHatchImage = Gdip.Image_Clone(hatchImage)) == 0L) {
            SWT.error(2);
        }
        long attrib = Gdip.ImageAttributes_new();
        Gdip.ImageAttributes_SetWrapMode(attrib, 0);
        float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (float)alpha / 255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        Gdip.ImageAttributes_SetColorMatrix(attrib, matrix, 0, 1);
        Rect rect = new Rect();
        rect.X = 0;
        rect.Y = 0;
        rect.Width = Gdip.Image_GetWidth(transparentHatchImage);
        rect.Height = Gdip.Image_GetHeight(transparentHatchImage);
        long transparentBrush = Gdip.TextureBrush_new(transparentHatchImage, rect, attrib);
        if (brush == 0L) {
            SWT.error(2);
        }
        Gdip.ImageAttributes_delete(attrib);
        Gdip.Image_delete(transparentHatchImage);
        return transparentBrush;
    }

    static void destroyGdipBrush(long brush) {
        int type = Gdip.Brush_GetType(brush);
        switch (type) {
            case 0: {
                Gdip.SolidBrush_delete(brush);
                break;
            }
            case 1: {
                Gdip.HatchBrush_delete(brush);
                break;
            }
            case 4: {
                Gdip.LinearGradientBrush_delete(brush);
                break;
            }
            case 2: {
                Gdip.TextureBrush_delete(brush);
            }
        }
    }

    @Override
    void destroy() {
        Image image;
        long hNullBitmap;
        boolean gdip = this.data.gdipGraphics != 0L;
        this.disposeGdip();
        if (gdip && (this.data.style & 0x8000000) != 0) {
            OS.SetLayout(this.handle, OS.GetLayout(this.handle) | 1);
        }
        if (this.data.hPen != 0L) {
            OS.SelectObject(this.handle, OS.GetStockObject(8));
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0L;
        }
        if (this.data.hBrush != 0L) {
            OS.SelectObject(this.handle, OS.GetStockObject(5));
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0L;
        }
        if ((hNullBitmap = this.data.hNullBitmap) != 0L) {
            OS.SelectObject(this.handle, hNullBitmap);
            this.data.hNullBitmap = 0L;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.drawable = null;
        this.handle = 0L;
        this.data.image = null;
        this.data.ps = null;
        this.data = null;
    }

    void disposeGdip() {
        if (this.data.gdipPen != 0L) {
            Gdip.Pen_delete(this.data.gdipPen);
        }
        if (this.data.gdipBgBrush != 0L) {
            GC.destroyGdipBrush(this.data.gdipBgBrush);
        }
        if (this.data.gdipFgBrush != 0L) {
            GC.destroyGdipBrush(this.data.gdipFgBrush);
        }
        if (this.data.gdipFont != 0L) {
            Gdip.Font_delete(this.data.gdipFont);
        }
        if (this.data.hGDIFont != 0L) {
            OS.DeleteObject(this.data.hGDIFont);
        }
        if (this.data.gdipGraphics != 0L) {
            Gdip.Graphics_delete(this.data.gdipGraphics);
        }
        if (this.data.gdipBgPatternBrushAlpha != 0L) {
            GC.destroyGdipBrush(this.data.gdipBgPatternBrushAlpha);
        }
        if (this.data.gdipFgPatternBrushAlpha != 0L) {
            GC.destroyGdipBrush(this.data.gdipFgPatternBrushAlpha);
        }
        this.data.gdipFgPatternBrushAlpha = 0L;
        this.data.gdipBgPatternBrushAlpha = 0L;
        this.data.hGDIFont = 0L;
        this.data.gdipPen = 0L;
        this.data.gdipFont = 0L;
        this.data.gdipFgBrush = 0L;
        this.data.gdipBgBrush = 0L;
        this.data.gdipBrush = 0L;
        this.data.gdipGraphics = 0L;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawArcOperation(new Rectangle(x, y, width, height), startAngle, arcAngle));
    }

    private void drawArcInPixels(int x, int y, int width, int height, int startAngle, int arcAngle) {
        int y1;
        int y2;
        int x1;
        int x2;
        this.checkGC(22777);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            if (width == height) {
                Gdip.Graphics_DrawArc(gdipGraphics, this.data.gdipPen, x, y, width, height, -startAngle, -arcAngle);
            } else {
                long matrix;
                long path = Gdip.GraphicsPath_new(0);
                if (path == 0L) {
                    SWT.error(2);
                }
                if ((matrix = Gdip.Matrix_new(width, 0.0f, 0.0f, height, x, y)) == 0L) {
                    SWT.error(2);
                }
                Gdip.GraphicsPath_AddArc(path, 0.0f, 0.0f, 1.0f, 1.0f, -startAngle, -arcAngle);
                Gdip.GraphicsPath_Transform(path, matrix);
                Gdip.Graphics_DrawPath(gdipGraphics, this.data.gdipPen, path);
                Gdip.Matrix_delete(matrix);
                Gdip.GraphicsPath_delete(path);
            }
            Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x;
        }
        if (arcAngle >= 360 || arcAngle <= -360) {
            x1 = x2 = x + width;
            y1 = y2 = y + height / 2;
        } else {
            boolean isNegative = arcAngle < 0;
            arcAngle += startAngle;
            if (isNegative) {
                int tmp = startAngle;
                startAngle = arcAngle;
                arcAngle = tmp;
            }
            x1 = GC.cos(startAngle, width) + x + width / 2;
            y1 = -1 * GC.sin(startAngle, height) + y + height / 2;
            x2 = GC.cos(arcAngle, width) + x + width / 2;
            y2 = -1 * GC.sin(arcAngle, height) + y + height / 2;
        }
        OS.Arc(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
    }

    public void drawFocus(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawFocusOperation(new Rectangle(x, y, width, height)));
    }

    private void drawFocusInPixels(int x, int y, int width, int height) {
        if ((this.data.uiState & 1) != 0) {
            return;
        }
        this.data.focusDrawn = true;
        long hdc = this.handle;
        int state = 0;
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            long clipRgn = 0L;
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            long rgn = Gdip.Region_new();
            if (rgn == 0L) {
                SWT.error(2);
            }
            Gdip.Graphics_GetClip(gdipGraphics, rgn);
            if (!Gdip.Region_IsInfinite(rgn, gdipGraphics)) {
                clipRgn = Gdip.Region_GetHRGN(rgn, gdipGraphics);
            }
            Gdip.Region_delete(rgn);
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            float[] lpXform = null;
            long matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (matrix == 0L) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(gdipGraphics, matrix);
            if (!Gdip.Matrix_IsIdentity(matrix)) {
                lpXform = new float[6];
                Gdip.Matrix_GetElements(matrix, lpXform);
            }
            Gdip.Matrix_delete(matrix);
            hdc = Gdip.Graphics_GetHDC(gdipGraphics);
            state = OS.SaveDC(hdc);
            if (lpXform != null) {
                OS.SetGraphicsMode(hdc, 2);
                OS.SetWorldTransform(hdc, lpXform);
            }
            if (clipRgn != 0L) {
                OS.SelectClipRgn(hdc, clipRgn);
                OS.DeleteObject(clipRgn);
            }
        }
        OS.SetBkColor(hdc, 0xFFFFFF);
        OS.SetTextColor(hdc, 0);
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        OS.DrawFocusRect(hdc, rect);
        if (gdipGraphics != 0L) {
            OS.RestoreDC(hdc, state);
            Gdip.Graphics_ReleaseHDC(gdipGraphics, hdc);
        } else {
            this.data.state &= 0xFFFFFCFF;
        }
    }

    public void drawImage(Image image, int x, int y) {
        this.checkNonDisposed();
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawImageOperation(image, new Point(x, y)));
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        this.checkNonDisposed();
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawScalingImageToImageOperation(image, new Rectangle(srcX, srcY, srcWidth, srcHeight), new Rectangle(destX, destY, destWidth, destHeight)));
    }

    public void drawImage(Image image, int destX, int destY, int destWidth, int destHeight) {
        this.checkNonDisposed();
        if (destWidth == 0 || destHeight == 0) {
            return;
        }
        if (destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawScaledImageOperation(image, new Rectangle(destX, destY, destWidth, destHeight)));
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        this.storeAndApplyOperationForExistingHandle(new DrawImageToImageOperation(srcImage, new Rectangle(srcX, srcY, srcWidth, srcHeight), new Rectangle(destX, destY, destWidth, destHeight), simple));
    }

    private void drawImage(Image image, int destX, int destY, int destWidth, int destHeight, int imageZoom) {
        Rectangle destPixels = Win32DPIUtils.pointToPixel(this.drawable, new Rectangle(destX, destY, destWidth, destHeight), imageZoom);
        image.executeOnImageHandleAtBestFittingSize(tempHandle -> this.drawImage(image, 0, 0, tempHandle.getWidth(), tempHandle.getHeight(), destPixels.x, destPixels.y, destPixels.width, destPixels.height, false, (Image.ImageHandle)tempHandle), destPixels.width, destPixels.height);
    }

    private void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, int imageZoom, int scaledImageZoom) {
        Rectangle src = Win32DPIUtils.pointToPixel(this.drawable, new Rectangle(srcX, srcY, srcWidth, srcHeight), scaledImageZoom);
        Rectangle dest = Win32DPIUtils.pointToPixel(this.drawable, new Rectangle(destX, destY, destWidth, destHeight), imageZoom);
        if (scaledImageZoom != 100) {
            Rectangle b = image.getBounds(scaledImageZoom);
            int errX = src.x + src.width - b.width;
            int errY = src.y + src.height - b.height;
            if (errX != 0 || errY != 0) {
                if (errX <= scaledImageZoom / 100 && errY <= scaledImageZoom / 100) {
                    src.intersect(b);
                } else {
                    SWT.error(5);
                }
            }
        }
        this.drawImage(image, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height, false, image.getHandle(scaledImageZoom, this.data.nativeZoom));
    }

    private void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, Image.ImageHandle tempImageHandle) {
        if (this.data.gdipGraphics != 0L) {
            long[] gdipImage = srcImage.createGdipImageFromHandle(tempImageHandle);
            long img = gdipImage[0];
            int imgWidth = Gdip.Image_GetWidth(img);
            int imgHeight = Gdip.Image_GetHeight(img);
            if (srcWidth == 0 && srcHeight == 0) {
                srcWidth = imgWidth;
                srcHeight = imgHeight;
            }
            if (simple) {
                srcWidth = destWidth = imgWidth;
                srcHeight = destHeight = imgHeight;
            } else {
                if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                    SWT.error(5);
                }
                simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            }
            Rect rect = new Rect();
            rect.X = destX;
            rect.Y = destY;
            rect.Width = destWidth;
            rect.Height = destHeight;
            long attrib = Gdip.ImageAttributes_new();
            Gdip.ImageAttributes_SetWrapMode(attrib, 3);
            if (this.data.alpha != 255) {
                float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, (float)this.data.alpha / 255.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
                Gdip.ImageAttributes_SetColorMatrix(attrib, matrix, 0, 1);
            }
            int gstate = 0;
            if ((this.data.style & 0x8000000) != 0) {
                gstate = Gdip.Graphics_Save(this.data.gdipGraphics);
                Gdip.Graphics_ScaleTransform(this.data.gdipGraphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(this.data.gdipGraphics, -2 * destX - destWidth, 0.0f, 0);
            }
            Gdip.Graphics_DrawImage(this.data.gdipGraphics, img, rect, srcX, srcY, srcWidth, srcHeight, 2, attrib, 0L, 0L);
            if ((this.data.style & 0x8000000) != 0) {
                Gdip.Graphics_Restore(this.data.gdipGraphics, gstate);
            }
            Gdip.ImageAttributes_delete(attrib);
            Gdip.Bitmap_delete(img);
            if (gdipImage[1] != 0L) {
                long hHeap = OS.GetProcessHeap();
                OS.HeapFree(hHeap, 0, gdipImage[1]);
            }
            return;
        }
        switch (srcImage.type) {
            case 0: {
                this.drawBitmap(srcImage, tempImageHandle, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            case 1: {
                this.drawIcon(tempImageHandle.getHandle(), srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
            }
        }
    }

    private void drawIcon(long imageHandle, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        boolean failed;
        int technology = OS.GetDeviceCaps(this.handle, 2);
        boolean drawIcon = true;
        int flags = 3;
        int offsetX = 0;
        int offsetY = 0;
        if ((OS.GetLayout(this.handle) & 1) != 0) {
            flags |= 0x10;
            POINT pt = new POINT();
            OS.GetWindowOrgEx(this.handle, pt);
            offsetX = pt.x;
            offsetY = pt.y;
        }
        if (simple && technology != 2 && drawIcon) {
            if (offsetX != 0 || offsetY != 0) {
                OS.SetWindowOrgEx(this.handle, 0, 0, null);
            }
            OS.DrawIconEx(this.handle, destX - offsetX, destY - offsetY, imageHandle, 0, 0, 0, 0L, flags);
            if (offsetX != 0 || offsetY != 0) {
                OS.SetWindowOrgEx(this.handle, offsetX, offsetY, null);
            }
            return;
        }
        ICONINFO srcIconInfo = new ICONINFO();
        OS.GetIconInfo(imageHandle, srcIconInfo);
        long hBitmap = srcIconInfo.hbmColor;
        if (hBitmap == 0L) {
            hBitmap = srcIconInfo.hbmMask;
        }
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, BITMAP.sizeof, bm);
        int iconWidth = bm.bmWidth;
        int iconHeight = bm.bmHeight;
        if (hBitmap == srcIconInfo.hbmMask) {
            iconHeight /= 2;
        }
        if (srcWidth == 0 && srcHeight == 0) {
            srcWidth = iconWidth;
            srcHeight = iconHeight;
        }
        if (simple) {
            srcWidth = destWidth = iconWidth;
            srcHeight = destHeight = iconHeight;
        }
        boolean bl = failed = srcX + srcWidth > iconWidth || srcY + srcHeight > iconHeight;
        if (!failed) {
            boolean bl2 = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && srcHeight == destHeight && srcWidth == iconWidth && srcHeight == iconHeight;
            if (!drawIcon) {
                this.drawBitmapMask(srcIconInfo.hbmColor, srcIconInfo.hbmMask, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, iconWidth, iconHeight, false);
            } else if (simple && technology != 2) {
                if (offsetX != 0 || offsetY != 0) {
                    OS.SetWindowOrgEx(this.handle, 0, 0, null);
                }
                OS.DrawIconEx(this.handle, destX - offsetX, destY - offsetY, imageHandle, 0, 0, 0, 0L, flags);
                if (offsetX != 0 || offsetY != 0) {
                    OS.SetWindowOrgEx(this.handle, offsetX, offsetY, null);
                }
            } else {
                boolean stretch;
                ICONINFO newIconInfo = new ICONINFO();
                newIconInfo.fIcon = true;
                long srcHdc = OS.CreateCompatibleDC(this.handle);
                long dstHdc = OS.CreateCompatibleDC(this.handle);
                int srcColorY = srcY;
                long srcColor = srcIconInfo.hbmColor;
                if (srcColor == 0L) {
                    srcColor = srcIconInfo.hbmMask;
                    srcColorY += iconHeight;
                }
                long oldSrcBitmap = OS.SelectObject(srcHdc, srcColor);
                newIconInfo.hbmColor = OS.CreateCompatibleBitmap(srcHdc, destWidth, destHeight);
                if (newIconInfo.hbmColor == 0L) {
                    SWT.error(2);
                }
                long oldDestBitmap = OS.SelectObject(dstHdc, newIconInfo.hbmColor);
                boolean bl3 = stretch = !simple && (srcWidth != destWidth || srcHeight != destHeight);
                if (stretch) {
                    OS.SetStretchBltMode(dstHdc, 3);
                    OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0xCC0020);
                } else {
                    OS.BitBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, 0xCC0020);
                }
                OS.SelectObject(srcHdc, srcIconInfo.hbmMask);
                newIconInfo.hbmMask = OS.CreateBitmap(destWidth, destHeight, 1, 1, null);
                if (newIconInfo.hbmMask == 0L) {
                    SWT.error(2);
                }
                OS.SelectObject(dstHdc, newIconInfo.hbmMask);
                if (stretch) {
                    OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0xCC0020);
                } else {
                    OS.BitBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0xCC0020);
                }
                if (technology == 2) {
                    OS.SelectObject(srcHdc, newIconInfo.hbmColor);
                    OS.SelectObject(dstHdc, newIconInfo.hbmMask);
                    this.drawBitmapTransparentByClipping(srcHdc, dstHdc, 0, 0, destWidth, destHeight, destX, destY, destWidth, destHeight, true, destWidth, destHeight);
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(dstHdc, oldDestBitmap);
                } else {
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(dstHdc, oldDestBitmap);
                    long hIcon = OS.CreateIconIndirect(newIconInfo);
                    if (hIcon == 0L) {
                        SWT.error(2);
                    }
                    if (offsetX != 0 || offsetY != 0) {
                        OS.SetWindowOrgEx(this.handle, 0, 0, null);
                    }
                    OS.DrawIconEx(this.handle, destX - offsetX, destY - offsetY, hIcon, destWidth, destHeight, 0, 0L, flags);
                    if (offsetX != 0 || offsetY != 0) {
                        OS.SetWindowOrgEx(this.handle, offsetX, offsetY, null);
                    }
                    OS.DestroyIcon(hIcon);
                }
                OS.DeleteObject(newIconInfo.hbmMask);
                OS.DeleteObject(newIconInfo.hbmColor);
                OS.DeleteDC(dstHdc);
                OS.DeleteDC(srcHdc);
            }
        }
        OS.DeleteObject(srcIconInfo.hbmMask);
        if (srcIconInfo.hbmColor != 0L) {
            OS.DeleteObject(srcIconInfo.hbmColor);
        }
        if (failed) {
            SWT.error(5);
        }
    }

    private void drawBitmap(Image srcImage, Image.ImageHandle imageHandle, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        BITMAP bm = new BITMAP();
        long handle = imageHandle.getHandle();
        OS.GetObject(handle, BITMAP.sizeof, bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        if (srcWidth == 0 && srcHeight == 0) {
            srcWidth = imgWidth;
            srcHeight = imgHeight;
        }
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
        }
        boolean mustRestore = false;
        GC memGC = srcImage.memGC;
        if (memGC != null && !memGC.isDisposed()) {
            memGC.flush();
            mustRestore = true;
            GCData data = memGC.data;
            if (data.hNullBitmap != 0L) {
                OS.SelectObject(memGC.handle, data.hNullBitmap);
                data.hNullBitmap = 0L;
            }
        }
        boolean isDib = bm.bmBits != 0L;
        int depth = bm.bmPlanes * bm.bmBitsPixel;
        if (isDib && depth == 32) {
            this.drawBitmapAlpha(handle, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
        } else if (imageHandle.transparentPixel != -1) {
            this.drawBitmapTransparent(imageHandle, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else {
            this.drawBitmapColor(handle, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
        }
        if (mustRestore) {
            long hOldBitmap;
            memGC.data.hNullBitmap = hOldBitmap = OS.SelectObject(memGC.handle, handle);
        }
    }

    private void drawBitmapAlpha(long imageHandle, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        long oldSrcBitmap;
        long srcHdc;
        int caps;
        boolean alphaBlendSupport = true;
        boolean isPrinter = OS.GetDeviceCaps(this.handle, 2) == 2;
        int sourceAlpha = -1;
        if (isPrinter && (caps = OS.GetDeviceCaps(this.handle, 120)) != 0) {
            srcHdc = OS.CreateCompatibleDC(this.handle);
            oldSrcBitmap = OS.SelectObject(srcHdc, imageHandle);
            long memDib = Image.createDIB(srcWidth, srcHeight, 32);
            if (memDib == 0L) {
                SWT.error(2);
            }
            long memHdc = OS.CreateCompatibleDC(this.handle);
            long oldMemBitmap = OS.SelectObject(memHdc, memDib);
            BITMAP dibBM = new BITMAP();
            OS.GetObject(memDib, BITMAP.sizeof, dibBM);
            OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc, srcX, srcY, 0xCC0020);
            byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
            OS.MoveMemory(srcData, dibBM.bmBits, srcData.length);
            int size = srcData.length;
            sourceAlpha = srcData[3] & 0xFF;
            for (int sp = 7; sp < size; sp += 4) {
                int currentAlpha = srcData[sp] & 0xFF;
                if (sourceAlpha == currentAlpha) continue;
                sourceAlpha = -1;
                break;
            }
            OS.SelectObject(memHdc, oldMemBitmap);
            OS.DeleteDC(memHdc);
            OS.DeleteObject(memDib);
            OS.SelectObject(srcHdc, oldSrcBitmap);
            OS.DeleteDC(srcHdc);
            if (sourceAlpha != -1) {
                if (sourceAlpha == 0) {
                    return;
                }
                if (sourceAlpha == 255) {
                    this.drawBitmapColor(imageHandle, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                    return;
                }
                alphaBlendSupport = (caps & 1) != 0;
            } else {
                boolean bl = alphaBlendSupport = (caps & 2) != 0;
            }
        }
        if (alphaBlendSupport) {
            BLENDFUNCTION blend = new BLENDFUNCTION();
            blend.BlendOp = 0;
            srcHdc = OS.CreateCompatibleDC(this.handle);
            oldSrcBitmap = OS.SelectObject(srcHdc, imageHandle);
            blend.SourceConstantAlpha = (byte)sourceAlpha;
            blend.AlphaFormat = 1;
            OS.AlphaBlend(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, blend);
            OS.SelectObject(srcHdc, oldSrcBitmap);
            OS.DeleteDC(srcHdc);
            return;
        }
        Rectangle rect = this.getClippingInPixels();
        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
            return;
        }
        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
        destX = rect.x;
        destY = rect.y;
        destWidth = rect.width;
        destHeight = rect.height;
        srcX = sx1;
        srcY = sy1;
        srcWidth = Math.max(1, sx2 - sx1);
        srcHeight = Math.max(1, sy2 - sy1);
        long srcHdc2 = OS.CreateCompatibleDC(this.handle);
        long oldSrcBitmap2 = OS.SelectObject(srcHdc2, imageHandle);
        long memHdc = OS.CreateCompatibleDC(this.handle);
        long memDib = Image.createDIB(Math.max(srcWidth, destWidth), Math.max(srcHeight, destHeight), 32);
        if (memDib == 0L) {
            SWT.error(2);
        }
        long oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, BITMAP.sizeof, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
        byte[] destData = new byte[sizeInBytes];
        OS.MoveMemory(destData, dibBM.bmBits, sizeInBytes);
        OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc2, srcX, srcY, 0xCC0020);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        if (isPrinter) {
            long tempHdc = OS.CreateCompatibleDC(this.handle);
            long tempDib = Image.createDIB(destWidth, destHeight, 32);
            if (tempDib == 0L) {
                SWT.error(2);
            }
            long oldTempBitmap = OS.SelectObject(tempHdc, tempDib);
            if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                OS.SetStretchBltMode(memHdc, 3);
                OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
            } else {
                OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
            }
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteObject(tempDib);
            OS.DeleteDC(tempHdc);
        } else if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            OS.SetStretchBltMode(memHdc, 3);
            OS.StretchBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
        } else {
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        }
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int dpinc = dibBM.bmWidthBytes - destWidth * 4;
        int dp = 0;
        for (int y = 0; y < destHeight; ++y) {
            for (int x = 0; x < destWidth; ++x) {
                int alpha = srcData[dp + 3] & 0xFF;
                int n = dp;
                destData[n] = (byte)(destData[n] + ((srcData[dp] & 0xFF) - (destData[dp] & 0xFF) * alpha / 255));
                int n2 = dp + 1;
                destData[n2] = (byte)(destData[n2] + ((srcData[dp + 1] & 0xFF) - (destData[dp + 1] & 0xFF) * alpha / 255));
                int n3 = dp + 2;
                destData[n3] = (byte)(destData[n3] + ((srcData[dp + 2] & 0xFF) - (destData[dp + 2] & 0xFF) * alpha / 255));
                dp += 4;
            }
            dp += dpinc;
        }
        OS.MoveMemory(dibBM.bmBits, destData, sizeInBytes);
        OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        OS.SelectObject(memHdc, oldMemBitmap);
        OS.DeleteDC(memHdc);
        OS.DeleteObject(memDib);
        OS.SelectObject(srcHdc2, oldSrcBitmap2);
        OS.DeleteDC(srcHdc2);
    }

    private void drawBitmapTransparentByClipping(long srcHdc, long maskHdc, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight) {
        int dwRop;
        long rgn = OS.CreateRectRgn(0, 0, 0, 0);
        for (int y = 0; y < imgHeight; ++y) {
            for (int x = 0; x < imgWidth; ++x) {
                if (OS.GetPixel(maskHdc, x, y) != 0) continue;
                long tempRgn = OS.CreateRectRgn(x, y, x + 1, y + 1);
                OS.CombineRgn(rgn, rgn, tempRgn, 2);
                OS.DeleteObject(tempRgn);
            }
        }
        if (destWidth != srcWidth || destHeight != srcHeight) {
            int nBytes = OS.GetRegionData(rgn, 0, null);
            int[] lpRgnData = new int[nBytes / 4];
            OS.GetRegionData(rgn, nBytes, lpRgnData);
            float[] lpXform = new float[]{(float)destWidth / (float)srcWidth, 0.0f, 0.0f, (float)destHeight / (float)srcHeight, 0.0f, 0.0f};
            long tmpRgn = OS.ExtCreateRegion(lpXform, nBytes, lpRgnData);
            OS.DeleteObject(rgn);
            rgn = tmpRgn;
        }
        OS.OffsetRgn(rgn, destX, destY);
        long clip = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, clip);
        if (result == 1) {
            OS.CombineRgn(rgn, rgn, clip, 1);
        }
        OS.SelectClipRgn(this.handle, rgn);
        int n = dwRop = OS.GetROP2(this.handle) == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = OS.SetStretchBltMode(this.handle, 3);
            OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
            OS.SetStretchBltMode(this.handle, mode);
        } else {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, dwRop);
        }
        OS.SelectClipRgn(this.handle, result == 1 ? clip : 0L);
        OS.DeleteObject(clip);
        OS.DeleteObject(rgn);
    }

    private void drawBitmapMask(long srcColor, long srcMask, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, int imgWidth, int imgHeight, boolean offscreen) {
        int srcColorY = srcY;
        if (srcColor == 0L) {
            srcColor = srcMask;
            srcColorY += imgHeight;
        }
        long srcHdc = OS.CreateCompatibleDC(this.handle);
        long oldSrcBitmap = OS.SelectObject(srcHdc, srcColor);
        long destHdc = this.handle;
        int x = destX;
        int y = destY;
        long tempHdc = 0L;
        long tempBitmap = 0L;
        long oldTempBitmap = 0L;
        int oldBkColor = 0;
        int oldTextColor = 0;
        if (offscreen) {
            tempHdc = OS.CreateCompatibleDC(this.handle);
            tempBitmap = OS.CreateCompatibleBitmap(this.handle, destWidth, destHeight);
            oldTempBitmap = OS.SelectObject(tempHdc, tempBitmap);
            OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
            destHdc = tempHdc;
            y = 0;
            x = 0;
        } else {
            oldBkColor = OS.SetBkColor(this.handle, 0xFFFFFF);
            oldTextColor = OS.SetTextColor(this.handle, 0);
        }
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = OS.SetStretchBltMode(this.handle, 3);
            OS.StretchBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0x660046);
            OS.SelectObject(srcHdc, srcMask);
            OS.StretchBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 8913094);
            OS.SelectObject(srcHdc, srcColor);
            OS.StretchBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0x660046);
            OS.SetStretchBltMode(this.handle, mode);
        } else {
            OS.BitBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, 0x660046);
            OS.SetTextColor(destHdc, 0);
            OS.SelectObject(srcHdc, srcMask);
            OS.BitBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcY, 8913094);
            OS.SelectObject(srcHdc, srcColor);
            OS.BitBlt(destHdc, x, y, destWidth, destHeight, srcHdc, srcX, srcColorY, 0x660046);
        }
        if (offscreen) {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteDC(tempHdc);
            OS.DeleteObject(tempBitmap);
        } else {
            OS.SetBkColor(this.handle, oldBkColor);
            OS.SetTextColor(this.handle, oldTextColor);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    private void drawBitmapTransparent(Image.ImageHandle imageHandle, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        boolean isDib = bm.bmBits != 0L;
        long hBitmap = imageHandle.getHandle();
        long srcHdc = OS.CreateCompatibleDC(this.handle);
        long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        byte[] originalColors = null;
        int transparentColor = imageHandle.transparentColor;
        if (transparentColor == -1) {
            int transBlue = 0;
            int transGreen = 0;
            int transRed = 0;
            boolean fixPalette = false;
            if (bm.bmBitsPixel <= 8) {
                if (isDib) {
                    int maxColors = 1 << bm.bmBitsPixel;
                    byte[] oldColors = new byte[maxColors * 4];
                    OS.GetDIBColorTable(srcHdc, 0, maxColors, oldColors);
                    int offset = imageHandle.transparentPixel * 4;
                    for (int i = 0; i < oldColors.length; i += 4) {
                        if (i == offset || oldColors[offset] != oldColors[i] || oldColors[offset + 1] != oldColors[i + 1] || oldColors[offset + 2] != oldColors[i + 2]) continue;
                        fixPalette = true;
                        break;
                    }
                    if (fixPalette) {
                        byte[] newColors = new byte[oldColors.length];
                        transBlue = 255;
                        transGreen = 255;
                        transRed = 255;
                        newColors[offset] = (byte)transBlue;
                        newColors[offset + 1] = (byte)transGreen;
                        newColors[offset + 2] = (byte)transRed;
                        OS.SetDIBColorTable(srcHdc, 0, maxColors, newColors);
                        originalColors = oldColors;
                    } else {
                        transBlue = oldColors[offset] & 0xFF;
                        transGreen = oldColors[offset + 1] & 0xFF;
                        transRed = oldColors[offset + 2] & 0xFF;
                    }
                } else {
                    int numColors = 1 << bm.bmBitsPixel;
                    BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biPlanes = bm.bmPlanes;
                    bmiHeader.biBitCount = bm.bmBitsPixel;
                    byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                    OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                    OS.GetDIBits(srcHdc, imageHandle.getHandle(), 0, 0, null, bmi, 0);
                    int offset = BITMAPINFOHEADER.sizeof + 4 * imageHandle.transparentPixel;
                    transRed = bmi[offset + 2] & 0xFF;
                    transGreen = bmi[offset + 1] & 0xFF;
                    transBlue = bmi[offset] & 0xFF;
                }
            } else {
                int pixel = imageHandle.transparentPixel;
                switch (bm.bmBitsPixel) {
                    case 16: {
                        transBlue = (pixel & 0x1F) << 3;
                        transGreen = (pixel & 0x3E0) >> 2;
                        transRed = (pixel & 0x7C00) >> 7;
                        break;
                    }
                    case 24: {
                        transBlue = (pixel & 0xFF0000) >> 16;
                        transGreen = (pixel & 0xFF00) >> 8;
                        transRed = pixel & 0xFF;
                        break;
                    }
                    case 32: {
                        transBlue = (pixel & 0xFF000000) >>> 24;
                        transGreen = (pixel & 0xFF0000) >> 16;
                        transRed = (pixel & 0xFF00) >> 8;
                    }
                }
            }
            transparentColor = transBlue << 16 | transGreen << 8 | transRed;
            if (!fixPalette) {
                imageHandle.transparentColor = transparentColor;
            }
        }
        if (originalColors == null) {
            int mode = OS.SetStretchBltMode(this.handle, 3);
            OS.TransparentBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, transparentColor);
            OS.SetStretchBltMode(this.handle, mode);
        } else {
            long maskHdc = OS.CreateCompatibleDC(this.handle);
            long maskBitmap = OS.CreateBitmap(imgWidth, imgHeight, 1, 1, null);
            long oldMaskBitmap = OS.SelectObject(maskHdc, maskBitmap);
            OS.SetBkColor(srcHdc, transparentColor);
            OS.BitBlt(maskHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
            if (originalColors != null) {
                OS.SetDIBColorTable(srcHdc, 0, 1 << bm.bmBitsPixel, originalColors);
            }
            if (OS.GetDeviceCaps(this.handle, 2) == 2) {
                this.drawBitmapTransparentByClipping(srcHdc, maskHdc, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, imgWidth, imgHeight);
            } else {
                long tempHdc = OS.CreateCompatibleDC(this.handle);
                long tempBitmap = OS.CreateCompatibleBitmap(this.handle, destWidth, destHeight);
                long oldTempBitmap = OS.SelectObject(tempHdc, tempBitmap);
                OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
                if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
                    OS.SetStretchBltMode(tempHdc, 3);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, srcWidth, srcHeight, 8913094);
                    OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
                } else {
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0x660046);
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, 8913094);
                    OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, 0x660046);
                }
                OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
                OS.SelectObject(tempHdc, oldTempBitmap);
                OS.DeleteDC(tempHdc);
                OS.DeleteObject(tempBitmap);
            }
            OS.SelectObject(maskHdc, oldMaskBitmap);
            OS.DeleteDC(maskHdc);
            OS.DeleteObject(maskBitmap);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        if (hBitmap != imageHandle.getHandle()) {
            OS.DeleteObject(hBitmap);
        }
        OS.DeleteDC(srcHdc);
    }

    private void drawBitmapColor(long imageHandle, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int dwRop;
        long srcHdc = OS.CreateCompatibleDC(this.handle);
        long oldSrcBitmap = OS.SelectObject(srcHdc, imageHandle);
        int n = dwRop = OS.GetROP2(this.handle) == 7 ? 0x660046 : 0xCC0020;
        if (!(simple || srcWidth == destWidth && srcHeight == destHeight)) {
            int mode = OS.SetStretchBltMode(this.handle, 3);
            OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
            OS.SetStretchBltMode(this.handle, mode);
        } else {
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, dwRop);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawLineOperation(x1, y1, x2, y2));
    }

    private void drawLineInPixels(int x1, int y1, int x2, int y2) {
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawLine(gdipGraphics, this.data.gdipPen, x1, y1, x2, y2);
            Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x1;
            --x2;
        }
        OS.MoveToEx(this.handle, x1, y1, 0L);
        OS.LineTo(this.handle, x2, y2);
        if (this.data.lineWidth <= 1.0f) {
            OS.SetPixel(this.handle, x2, y2, this.data.foreground);
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawOvalOperation(new Rectangle(x, y, width, height)));
    }

    private void drawOvalInPixels(int x, int y, int width, int height) {
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawEllipse(gdipGraphics, this.data.gdipPen, x, y, width, height);
            Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x;
        }
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
    }

    public void drawPath(Path path) {
        this.checkNonDisposed();
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawPathOperation(path));
    }

    public void drawPoint(int x, int y) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawPointOperation(x, y));
    }

    private void drawPointInPixels(int x, int y) {
        if (this.data.gdipGraphics != 0L) {
            this.checkGC(22777);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.getFgBrush(), x, y, 1, 1);
            return;
        }
        OS.SetPixel(this.handle, x, y, this.data.foreground);
    }

    public void drawPolygon(int[] pointArray) {
        this.checkNonDisposed();
        if (pointArray == null) {
            SWT.error(4);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawPolygonOperation(pointArray));
    }

    private void drawPolygonInPixels(int[] pointArray) {
        int i;
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawPolygon(gdipGraphics, this.data.gdipPen, pointArray, pointArray.length / 2);
            Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (i = 0; i < pointArray.length; i += 2) {
                int n = i;
                pointArray[n] = pointArray[n] - 1;
            }
        }
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (i = 0; i < pointArray.length; i += 2) {
                int n = i;
                pointArray[n] = pointArray[n] + 1;
            }
        }
    }

    public void drawPolyline(int[] pointArray) {
        this.checkNonDisposed();
        if (pointArray == null) {
            SWT.error(4);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawPolylineOperation(pointArray));
    }

    private void drawPolylineInPixels(int[] pointArray) {
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawLines(gdipGraphics, this.data.gdipPen, pointArray, pointArray.length / 2);
            Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (int i = 0; i < pointArray.length; i += 2) {
                int n = i;
                pointArray[n] = pointArray[n] - 1;
            }
        }
        OS.Polyline(this.handle, pointArray, pointArray.length / 2);
        int length = pointArray.length;
        if (length >= 2 && this.data.lineWidth <= 1.0f) {
            OS.SetPixel(this.handle, pointArray[length - 2], pointArray[length - 1], this.data.foreground);
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            for (int i = 0; i < pointArray.length; i += 2) {
                int n = i;
                pointArray[n] = pointArray[n] + 1;
            }
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawRectangleOperation(new Rectangle(x, y, width, height)));
    }

    private void drawRectangleInPixels(int x, int y, int width, int height) {
        this.checkGC(22777);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
            Gdip.Graphics_DrawRectangle(gdipGraphics, this.data.gdipPen, x, y, width, height);
            Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            if (this.data.lineWidth > 1.0f) {
                if (this.data.lineWidth % 2.0f == 1.0f) {
                    ++x;
                }
            } else if (this.data.hPen != 0L && OS.GetObject(this.data.hPen, 0, 0L) != OS.LOGPEN_sizeof()) {
                ++x;
            }
        }
        OS.Rectangle(this.handle, x, y, x + width + 1, y + height + 1);
    }

    public void drawRectangle(Rectangle rect) {
        this.checkNonDisposed();
        if (rect == null) {
            SWT.error(4);
        }
        this.storeAndApplyOperationForExistingHandle(new DrawRectangleOperation(rect));
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawRoundRectangleOperation(new Rectangle(x, y, width, height), arcWidth, arcHeight));
    }

    private void drawRoundRectangleInPixels(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkGC(22777);
        if (this.data.gdipGraphics != 0L) {
            this.drawRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipPen, x, y, width, height, arcWidth, arcHeight);
            return;
        }
        if ((this.data.style & 0x8000000) != 0 && this.data.lineWidth != 0.0f && this.data.lineWidth % 2.0f == 0.0f) {
            --x;
        }
        OS.RoundRect(this.handle, x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
    }

    private void drawRoundRectangleGdip(long gdipGraphics, long pen, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        Gdip.Graphics_TranslateTransform(gdipGraphics, this.data.gdipXOffset, this.data.gdipYOffset, 0);
        if (naw == 0 || nah == 0) {
            Gdip.Graphics_DrawRectangle(gdipGraphics, this.data.gdipPen, x, y, width, height);
        } else {
            long path = Gdip.GraphicsPath_new(0);
            if (path == 0L) {
                SWT.error(2);
            }
            if (nw > naw) {
                if (nh > nah) {
                    Gdip.GraphicsPath_AddArc(path, nx + nw - naw, ny, naw, nah, 0.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(path, nx, ny, naw, nah, -90.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(path, nx, ny + nh - nah, naw, nah, -180.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(path, nx + nw - naw, ny + nh - nah, naw, nah, -270.0f, -90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc(path, nx + nw - naw, ny, naw, nh, -270.0f, -180.0f);
                    Gdip.GraphicsPath_AddArc(path, nx, ny, naw, nh, -90.0f, -180.0f);
                }
            } else if (nh > nah) {
                Gdip.GraphicsPath_AddArc(path, nx, ny, nw, nah, 0.0f, -180.0f);
                Gdip.GraphicsPath_AddArc(path, nx, ny + nh - nah, nw, nah, -180.0f, -180.0f);
            } else {
                Gdip.GraphicsPath_AddArc(path, nx, ny, nw, nh, 0.0f, 360.0f);
            }
            Gdip.GraphicsPath_CloseFigure(path);
            Gdip.Graphics_DrawPath(gdipGraphics, pen, path);
            Gdip.GraphicsPath_delete(path);
        }
        Gdip.Graphics_TranslateTransform(gdipGraphics, -this.data.gdipXOffset, -this.data.gdipYOffset, 0);
    }

    public void drawString(String string, int x, int y) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new DrawStringOperation(string, new Point(x, y), false));
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.checkNonDisposed();
        if (string == null) {
            SWT.error(4);
        }
        if (string.isEmpty()) {
            return;
        }
        this.storeAndApplyOperationForExistingHandle(new DrawStringOperation(string, new Point(x, y), isTransparent));
    }

    private void drawStringInPixels(String string, int x, int y, boolean isTransparent) {
        char[] buffer = string.toCharArray();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            this.checkGC(5 | (isTransparent ? 0 : 2));
            this.drawText(gdipGraphics, string, x, y, isTransparent ? 1 : 0, null);
            return;
        }
        this.checkGC(772);
        int oldBkMode = OS.SetBkMode(this.handle, isTransparent ? 1 : 2);
        RECT rect = null;
        SIZE size = null;
        int flags = 0;
        if ((this.data.style & 0x8000000) != 0) {
            if (!isTransparent) {
                size = new SIZE();
                OS.GetTextExtentPoint32(this.handle, buffer, buffer.length, size);
                rect = new RECT();
                rect.left = x;
                rect.right = x + size.cx;
                rect.top = y;
                rect.bottom = y + size.cy;
                flags = 4;
            }
            --x;
        }
        if (OS.GetROP2(this.handle) != 7) {
            OS.ExtTextOut(this.handle, x, y, flags, rect, buffer, buffer.length, null);
        } else {
            int foreground = OS.GetTextColor(this.handle);
            if (isTransparent) {
                int height;
                int width;
                long hBitmap;
                if (size == null) {
                    size = new SIZE();
                    OS.GetTextExtentPoint32(this.handle, buffer, buffer.length, size);
                }
                if ((hBitmap = OS.CreateCompatibleBitmap(this.handle, width = size.cx, height = size.cy)) == 0L) {
                    SWT.error(2);
                }
                long memDC = OS.CreateCompatibleDC(this.handle);
                long hOldBitmap = OS.SelectObject(memDC, hBitmap);
                OS.PatBlt(memDC, 0, 0, width, height, 66);
                OS.SetBkMode(memDC, 1);
                OS.SetTextColor(memDC, foreground);
                OS.SelectObject(memDC, OS.GetCurrentObject(this.handle, 6));
                OS.ExtTextOut(memDC, 0, 0, 0, null, buffer, buffer.length, null);
                OS.BitBlt(this.handle, x, y, width, height, memDC, 0, 0, 0x660046);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
                OS.DeleteObject(hBitmap);
            } else {
                int background = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, foreground ^ background);
                OS.ExtTextOut(this.handle, x, y, flags, rect, buffer, buffer.length, null);
                OS.SetTextColor(this.handle, foreground);
            }
        }
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public void drawText(String string, int x, int y) {
        this.checkNonDisposed();
        if (string == null) {
            SWT.error(4);
        }
        if (string.isEmpty()) {
            return;
        }
        this.storeAndApplyOperationForExistingHandle(new DrawTextOperation(string, new Point(x, y), 6));
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        this.checkNonDisposed();
        if (string == null) {
            SWT.error(4);
        }
        if (string.isEmpty()) {
            return;
        }
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.storeAndApplyOperationForExistingHandle(new DrawTextOperation(string, new Point(x, y), flags));
    }

    public void drawText(String string, int x, int y, int flags) {
        this.checkNonDisposed();
        if (string == null) {
            SWT.error(4);
        }
        if (string.isEmpty()) {
            return;
        }
        this.storeAndApplyOperationForExistingHandle(new DrawTextOperation(string, new Point(x, y), flags));
    }

    private void drawTextInPixels(String string, int x, int y, int flags) {
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            this.checkGC(5 | ((flags & 1) != 0 ? 0 : 2));
            this.drawText(gdipGraphics, string, x, y, flags, null);
            return;
        }
        char[] buffer = string.toCharArray();
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, 0x6FFFFFF, 0x6FFFFFF);
        int uFormat = 0;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        if ((flags & 8) != 0 && (this.data.uiState & 2) != 0) {
            uFormat |= 0x100000;
        }
        this.checkGC(772);
        int oldBkMode = OS.SetBkMode(this.handle, (flags & 1) != 0 ? 1 : 2);
        if (OS.GetROP2(this.handle) != 7) {
            OS.DrawText(this.handle, buffer, buffer.length, rect, uFormat);
        } else {
            int foreground = OS.GetTextColor(this.handle);
            if ((flags & 1) != 0) {
                OS.DrawText(this.handle, buffer, buffer.length, rect, uFormat | 0x400);
                int width = rect.right - rect.left;
                int height = rect.bottom - rect.top;
                long hBitmap = OS.CreateCompatibleBitmap(this.handle, width, height);
                if (hBitmap == 0L) {
                    SWT.error(2);
                }
                long memDC = OS.CreateCompatibleDC(this.handle);
                long hOldBitmap = OS.SelectObject(memDC, hBitmap);
                OS.PatBlt(memDC, 0, 0, width, height, 66);
                OS.SetBkMode(memDC, 1);
                OS.SetTextColor(memDC, foreground);
                OS.SelectObject(memDC, OS.GetCurrentObject(this.handle, 6));
                OS.SetRect(rect, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
                OS.DrawText(memDC, buffer, buffer.length, rect, uFormat);
                OS.BitBlt(this.handle, x, y, width, height, memDC, 0, 0, 0x660046);
                OS.SelectObject(memDC, hOldBitmap);
                OS.DeleteDC(memDC);
                OS.DeleteObject(hBitmap);
            } else {
                int background = OS.GetBkColor(this.handle);
                OS.SetTextColor(this.handle, foreground ^ background);
                OS.DrawText(this.handle, buffer, buffer.length, rect, uFormat);
                OS.SetTextColor(this.handle, foreground);
            }
        }
        OS.SetBkMode(this.handle, oldBkMode);
    }

    private boolean useGDIP(long hdc, char[] buffer) {
        short[] glyphs = new short[buffer.length];
        OS.GetGlyphIndices(hdc, buffer, buffer.length, glyphs, 1);
        block3: for (int i = 0; i < glyphs.length; ++i) {
            if (glyphs[i] != -1) continue;
            switch (buffer[i]) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    void drawText(long gdipGraphics, String string, int x, int y, int flags, Point size) {
        int length = string.length();
        char[] chars = string.toCharArray();
        long hdc = Gdip.Graphics_GetHDC(gdipGraphics);
        long hFont = this.data.hGDIFont;
        if (hFont == 0L && this.data.font != null) {
            hFont = SWTFontProvider.getFontHandle(this.data.font, this.data.nativeZoom);
        }
        long oldFont = 0L;
        if (hFont != 0L) {
            oldFont = OS.SelectObject(hdc, hFont);
        }
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics(hdc, lptm);
        boolean gdip = this.useGDIP(hdc, chars);
        if (hFont != 0L) {
            OS.SelectObject(hdc, oldFont);
        }
        Gdip.Graphics_ReleaseHDC(gdipGraphics, hdc);
        if (gdip) {
            this.drawTextGDIP(gdipGraphics, string, x, y, flags, size == null, size);
            return;
        }
        int i = 0;
        int start = 0;
        int end = 0;
        int drawX = x;
        int drawY = y;
        int width = 0;
        int mnemonicIndex = -1;
        if ((flags & 0xE) != 0) {
            int tabWidth = lptm.tmAveCharWidth * 8;
            while (i < length) {
                int n = end++;
                char c = chars[i++];
                chars[n] = c;
                char c2 = c;
                switch (c2) {
                    case '\t': {
                        if ((flags & 4) == 0) break;
                        int l = end - start - 1;
                        RectF bounds = this.drawText(gdipGraphics, chars, start, l, drawX, drawY, flags, mnemonicIndex, lptm, size == null);
                        drawX = (int)((double)drawX + Math.ceil(bounds.Width));
                        drawX = x + ((drawX - x) / tabWidth + 1) * tabWidth;
                        mnemonicIndex = -1;
                        start = end;
                        break;
                    }
                    case '&': {
                        if ((flags & 8) == 0) break;
                        if (i == length) {
                            --end;
                            break;
                        }
                        if (chars[i] == '&') {
                            ++i;
                            break;
                        }
                        mnemonicIndex = --end - start;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((flags & 2) == 0) break;
                        int l = end - start - 1;
                        if (c2 == '\r' && end != length && chars[end] == '\n') {
                            ++end;
                            ++i;
                        }
                        RectF bounds = this.drawText(gdipGraphics, chars, start, l, drawX, drawY, flags, mnemonicIndex, lptm, size == null);
                        drawY = (int)((double)drawY + Math.ceil(bounds.Height));
                        width = Math.max(width, drawX + (int)Math.ceil(bounds.Width));
                        drawX = x;
                        mnemonicIndex = -1;
                        start = end;
                    }
                }
            }
            length = end;
        }
        RectF bounds = this.drawText(gdipGraphics, chars, start, length - start, drawX, drawY, flags, mnemonicIndex, lptm, size == null);
        if (size != null) {
            drawY = (int)((double)drawY + Math.ceil(bounds.Height));
            size.x = width = Math.max(width, drawX + (int)Math.ceil(bounds.Width));
            size.y = drawY;
        }
    }

    private RectF drawText(long gdipGraphics, char[] buffer, int start, int length, int x, int y, int flags, int mnemonicIndex, TEXTMETRIC lptm, boolean draw) {
        boolean needsBounds;
        boolean drawMnemonic = draw && mnemonicIndex != -1 && (this.data.uiState & 2) == 0;
        boolean bl = needsBounds = !draw || drawMnemonic || (flags & 1) == 0 || (this.data.style & 0x8000000) != 0 || (flags & 2) != 0;
        if (length <= 0) {
            RectF bounds = null;
            if (needsBounds) {
                bounds = new RectF();
                bounds.Height = lptm.tmHeight;
            }
            return bounds;
        }
        int nGlyphs = length * 3 / 2 + 16;
        GCP_RESULTS result = new GCP_RESULTS();
        result.lStructSize = GCP_RESULTS.sizeof;
        result.nGlyphs = nGlyphs;
        long hHeap = OS.GetProcessHeap();
        long lpDx = result.lpDx = OS.HeapAlloc(hHeap, 8, nGlyphs * 4);
        long lpGlyphs = result.lpGlyphs = OS.HeapAlloc(hHeap, 8, nGlyphs * 2);
        long lpOrder = 0L;
        int dwFlags = 50;
        if (drawMnemonic) {
            lpOrder = result.lpOrder = OS.HeapAlloc(hHeap, 8, nGlyphs * 4);
        }
        long hdc = Gdip.Graphics_GetHDC(gdipGraphics);
        long hFont = this.data.hGDIFont;
        if (hFont == 0L && this.data.font != null) {
            hFont = SWTFontProvider.getFontHandle(this.data.font, this.data.nativeZoom);
        }
        long oldFont = 0L;
        if (hFont != 0L) {
            oldFont = OS.SelectObject(hdc, hFont);
        }
        if (start != 0) {
            char[] temp = new char[length];
            System.arraycopy(buffer, start, temp, 0, length);
            buffer = temp;
        }
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(hdc, OS.GetLayout(hdc) | 1);
        }
        OS.GetCharacterPlacement(hdc, buffer, length, 0, result, dwFlags);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(hdc, OS.GetLayout(hdc) & 0xFFFFFFFE);
        }
        if (hFont != 0L) {
            OS.SelectObject(hdc, oldFont);
        }
        Gdip.Graphics_ReleaseHDC(gdipGraphics, hdc);
        nGlyphs = result.nGlyphs;
        int drawX = x;
        int drawY = y + lptm.tmAscent;
        int[] dx = new int[nGlyphs];
        OS.MoveMemory(dx, result.lpDx, nGlyphs * 4);
        float[] points = new float[dx.length * 2];
        int j = 0;
        for (int i = 0; i < dx.length; ++i) {
            points[j++] = drawX;
            points[j++] = drawY;
            drawX += dx[i];
        }
        RectF bounds = null;
        if (needsBounds) {
            bounds = new RectF();
            Gdip.Graphics_MeasureDriverString(gdipGraphics, lpGlyphs, nGlyphs, this.data.gdipFont, points, 0, 0L, bounds);
        }
        if (draw) {
            long pen;
            if ((flags & 1) == 0) {
                Gdip.Graphics_FillRectangle(gdipGraphics, this.data.gdipBrush, x, y, (int)Math.ceil(bounds.Width), (int)Math.ceil(bounds.Height));
            }
            int gstate = 0;
            long brush = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                        Gdip.LinearGradientBrush_TranslateTransform(brush, (float)(-2 * x) - bounds.Width, 0.0f, 0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                        Gdip.TextureBrush_TranslateTransform(brush, (float)(-2 * x) - bounds.Width, 0.0f, 0);
                    }
                }
                gstate = Gdip.Graphics_Save(gdipGraphics);
                Gdip.Graphics_ScaleTransform(gdipGraphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(gdipGraphics, (float)(-2 * x) - bounds.Width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(gdipGraphics, lpGlyphs, result.nGlyphs, this.data.gdipFont, brush, points, 0, 0L);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform(brush);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform(brush);
                    }
                }
                Gdip.Graphics_Restore(gdipGraphics, gstate);
            }
            if (drawMnemonic && (pen = Gdip.Pen_new(brush, 1.0f)) != 0L) {
                int mnemonicRight;
                int mnemonicLeft;
                int[] order = new int[1];
                OS.MoveMemory(order, result.lpOrder + (long)(mnemonicIndex * 4), 4);
                if ((this.data.style & 0x8000000) != 0) {
                    mnemonicLeft = (int)Math.ceil(bounds.Width) - (int)points[order[0] * 2] + 2 * x;
                    mnemonicRight = mnemonicLeft - dx[order[0]];
                } else {
                    mnemonicLeft = (int)points[order[0] * 2];
                    mnemonicRight = mnemonicLeft + dx[order[0]];
                }
                int mnemonicY = y + lptm.tmAscent + 2;
                int smoothingMode = Gdip.Graphics_GetSmoothingMode(gdipGraphics);
                Gdip.Graphics_SetSmoothingMode(gdipGraphics, 3);
                Gdip.Graphics_DrawLine(gdipGraphics, pen, mnemonicLeft, mnemonicY, mnemonicRight, mnemonicY);
                Gdip.Graphics_SetSmoothingMode(gdipGraphics, smoothingMode);
                Gdip.Pen_delete(pen);
            }
        }
        if (lpOrder != 0L) {
            OS.HeapFree(hHeap, 0, lpOrder);
        }
        OS.HeapFree(hHeap, 0, lpGlyphs);
        OS.HeapFree(hHeap, 0, lpDx);
        return bounds;
    }

    private void drawTextGDIP(long gdipGraphics, String string, int x, int y, int flags, boolean draw, Point size) {
        int hotkeyPrefix;
        float[] fArray;
        char[] buffer;
        boolean needsBounds = !draw || (flags & 1) == 0;
        int length = string.length();
        if (length != 0) {
            buffer = string.toCharArray();
        } else {
            if (draw) {
                return;
            }
            buffer = new char[]{' '};
        }
        PointF pt = new PointF();
        long format = Gdip.StringFormat_Clone(Gdip.StringFormat_GenericTypographic());
        int formatFlags = Gdip.StringFormat_GetFormatFlags(format) | 0x800;
        if ((this.data.style & 0x8000000) != 0) {
            formatFlags |= 1;
        }
        Gdip.StringFormat_SetFormatFlags(format, formatFlags);
        if ((flags & 4) != 0) {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = this.measureSpace(this.data.gdipFont, format) * 8.0f;
        } else {
            fArray = new float[1];
        }
        float[] tabs = fArray;
        Gdip.StringFormat_SetTabStops(format, 0.0f, tabs.length, tabs);
        int n = hotkeyPrefix = (flags & 8) != 0 ? 1 : 0;
        if ((flags & 8) != 0 && (this.data.uiState & 2) != 0) {
            hotkeyPrefix = 2;
        }
        Gdip.StringFormat_SetHotkeyPrefix(format, hotkeyPrefix);
        RectF bounds = null;
        if (needsBounds) {
            bounds = new RectF();
            Gdip.Graphics_MeasureString(gdipGraphics, buffer, buffer.length, this.data.gdipFont, pt, format, bounds);
        }
        if (draw) {
            if ((flags & 1) == 0) {
                Gdip.Graphics_FillRectangle(gdipGraphics, this.data.gdipBrush, x, y, (int)Math.ceil(bounds.Width), (int)Math.ceil(bounds.Height));
            }
            int gstate = 0;
            long brush = this.getFgBrush();
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                        Gdip.LinearGradientBrush_TranslateTransform(brush, -2 * x, 0.0f, 0);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                        Gdip.TextureBrush_TranslateTransform(brush, -2 * x, 0.0f, 0);
                    }
                }
                gstate = Gdip.Graphics_Save(gdipGraphics);
                Gdip.Graphics_ScaleTransform(gdipGraphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(gdipGraphics, -2 * x, 0.0f, 0);
            }
            pt.X = x;
            pt.Y = y;
            Gdip.Graphics_DrawString(gdipGraphics, buffer, buffer.length, this.data.gdipFont, pt, format, brush);
            if ((this.data.style & 0x8000000) != 0) {
                switch (Gdip.Brush_GetType(brush)) {
                    case 4: {
                        Gdip.LinearGradientBrush_ResetTransform(brush);
                        break;
                    }
                    case 2: {
                        Gdip.TextureBrush_ResetTransform(brush);
                    }
                }
                Gdip.Graphics_Restore(gdipGraphics, gstate);
            }
        }
        Gdip.StringFormat_delete(format);
        if (length == 0) {
            bounds.Width = 0.0f;
        }
        if (size != null) {
            size.x = (int)Math.ceil(bounds.Width);
            size.y = (int)Math.ceil(bounds.Height);
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new FillArcOperation(new Rectangle(x, y, width, height), startAngle, arcAngle));
    }

    private void fillArcInPixels(int x, int y, int width, int height, int startAngle, int arcAngle) {
        int y1;
        int y2;
        int x1;
        int x2;
        this.checkNonDisposed();
        this.checkGC(9218);
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            if (width == height) {
                Gdip.Graphics_FillPie(gdipGraphics, this.data.gdipBrush, x, y, width, height, -startAngle, -arcAngle);
            } else {
                int state = Gdip.Graphics_Save(gdipGraphics);
                Gdip.Graphics_TranslateTransform(gdipGraphics, x, y, 0);
                Gdip.Graphics_ScaleTransform(gdipGraphics, width, height, 0);
                Gdip.Graphics_FillPie(gdipGraphics, this.data.gdipBrush, 0, 0, 1, 1, -startAngle, -arcAngle);
                Gdip.Graphics_Restore(gdipGraphics, state);
            }
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --x;
        }
        if (arcAngle >= 360 || arcAngle <= -360) {
            x1 = x2 = x + width;
            y1 = y2 = y + height / 2;
        } else {
            boolean isNegative = arcAngle < 0;
            arcAngle += startAngle;
            if (isNegative) {
                int tmp = startAngle;
                startAngle = arcAngle;
                arcAngle = tmp;
            }
            x1 = GC.cos(startAngle, width) + x + width / 2;
            y1 = -1 * GC.sin(startAngle, height) + y + height / 2;
            x2 = GC.cos(arcAngle, width) + x + width / 2;
            y2 = -1 * GC.sin(arcAngle, height) + y + height / 2;
        }
        OS.Pie(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new FillGradientRectangleOperation(new Rectangle(x, y, width, height), vertical));
    }

    private void fillGradientRectangleInPixels(int x, int y, int width, int height, boolean vertical, int zoom) {
        int depth;
        RGB foregroundRGB;
        if (width == 0 || height == 0) {
            return;
        }
        RGB backgroundRGB = this.getBackground().getRGB();
        RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
        RGB toRGB = backgroundRGB;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            fromRGB = backgroundRGB;
            toRGB = foregroundRGB;
        }
        if (fromRGB.equals(toRGB)) {
            this.fillRectangleInPixels(x, y, width, height);
            return;
        }
        if (this.data.gdipGraphics != 0L) {
            this.initGdip();
            PointF p1 = new PointF();
            PointF p2 = new PointF();
            p1.X = x;
            p1.Y = y;
            if (vertical) {
                p2.X = p1.X;
                p2.Y = p1.Y + (float)height;
            } else {
                p2.X = p1.X + (float)width;
                p2.Y = p1.Y;
            }
            int fromGpColor = this.data.alpha << 24 | (fromRGB.red & 0xFF) << 16 | (fromRGB.green & 0xFF) << 8 | fromRGB.blue & 0xFF;
            int toGpColor = this.data.alpha << 24 | (toRGB.red & 0xFF) << 16 | (toRGB.green & 0xFF) << 8 | toRGB.blue & 0xFF;
            long brush = Gdip.LinearGradientBrush_new(p1, p2, fromGpColor, toGpColor);
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, brush, x, y, width, height);
            Gdip.LinearGradientBrush_delete(brush);
            return;
        }
        if (OS.GetROP2(this.handle) != 7 && OS.GetDeviceCaps(this.handle, 2) != 2) {
            long hHeap = OS.GetProcessHeap();
            long pMesh = OS.HeapAlloc(hHeap, 8, GRADIENT_RECT.sizeof + TRIVERTEX.sizeof * 2);
            if (pMesh == 0L) {
                SWT.error(2);
            }
            long pVertex = pMesh + (long)GRADIENT_RECT.sizeof;
            GRADIENT_RECT gradientRect = new GRADIENT_RECT();
            gradientRect.UpperLeft = 0;
            gradientRect.LowerRight = 1;
            OS.MoveMemory(pMesh, gradientRect, GRADIENT_RECT.sizeof);
            TRIVERTEX trivertex = new TRIVERTEX();
            trivertex.x = x;
            trivertex.y = y;
            trivertex.Red = (short)(fromRGB.red << 8 | fromRGB.red);
            trivertex.Green = (short)(fromRGB.green << 8 | fromRGB.green);
            trivertex.Blue = (short)(fromRGB.blue << 8 | fromRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex, trivertex, TRIVERTEX.sizeof);
            trivertex.x = x + width;
            trivertex.y = y + height;
            trivertex.Red = (short)(toRGB.red << 8 | toRGB.red);
            trivertex.Green = (short)(toRGB.green << 8 | toRGB.green);
            trivertex.Blue = (short)(toRGB.blue << 8 | toRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex + (long)TRIVERTEX.sizeof, trivertex, TRIVERTEX.sizeof);
            boolean success = OS.GradientFill(this.handle, pVertex, 2, pMesh, 1, vertical ? 1 : 0);
            OS.HeapFree(hHeap, 0, pMesh);
            if (success) {
                return;
            }
        }
        int bitResolution = (depth = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (depth >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, bitResolution, bitResolution, bitResolution, zoom);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new FillOvalOperation(new Rectangle(x, y, width, height)));
    }

    private void fillOvalInPixels(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            Gdip.Graphics_FillEllipse(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --x;
        }
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
    }

    public void fillPath(Path path) {
        this.checkNonDisposed();
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new FillPathOperation(path));
    }

    public void fillPolygon(int[] pointArray) {
        this.checkNonDisposed();
        if (pointArray == null) {
            SWT.error(4);
        }
        this.storeAndApplyOperationForExistingHandle(new FillPolygonOperation(pointArray));
    }

    private void fillPolygonInPixels(int[] pointArray) {
        int i;
        this.checkNonDisposed();
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            int mode = OS.GetPolyFillMode(this.handle) == 2 ? 1 : 0;
            float offsetCorrection = 0.5f;
            Gdip.Graphics_TranslateTransform(this.data.gdipGraphics, this.data.gdipXOffset + offsetCorrection, this.data.gdipYOffset + offsetCorrection, 0);
            Gdip.Graphics_FillPolygon(this.data.gdipGraphics, this.data.gdipBrush, pointArray, pointArray.length / 2, mode);
            Gdip.Graphics_TranslateTransform(this.data.gdipGraphics, -(this.data.gdipXOffset + offsetCorrection), -(this.data.gdipYOffset + offsetCorrection), 0);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            for (i = 0; i < pointArray.length; i += 2) {
                int n = i;
                pointArray[n] = pointArray[n] - 1;
            }
        }
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        if ((this.data.style & 0x8000000) != 0) {
            for (i = 0; i < pointArray.length; i += 2) {
                int n = i;
                pointArray[n] = pointArray[n] + 1;
            }
        }
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.storeAndApplyOperationForExistingHandle(new FillRectangleOperation(new Rectangle(x, y, width, height)));
    }

    void fillRectangleInPixels(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height);
            return;
        }
        int dwRop = OS.GetROP2(this.handle) == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, x, y, width, height, dwRop);
    }

    public void fillRectangle(Rectangle rect) {
        this.checkNonDisposed();
        if (rect == null) {
            SWT.error(4);
        }
        this.storeAndApplyOperationForExistingHandle(new FillRectangleOperation(rect));
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new FillRoundRectangleOperation(new Rectangle(x, y, width, height), arcWidth, arcHeight));
    }

    private void fillRoundRectangleInPixels(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.checkNonDisposed();
        this.checkGC(9218);
        if (this.data.gdipGraphics != 0L) {
            this.fillRoundRectangleGdip(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height, arcWidth, arcHeight);
            return;
        }
        if ((this.data.style & 0x8000000) != 0) {
            --x;
        }
        OS.RoundRect(this.handle, x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
    }

    private void fillRoundRectangleGdip(long gdipGraphics, long brush, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int nx = x;
        int ny = y;
        int nw = width;
        int nh = height;
        int naw = arcWidth;
        int nah = arcHeight;
        if (nw < 0) {
            nw = 0 - nw;
            nx -= nw;
        }
        if (nh < 0) {
            nh = 0 - nh;
            ny -= nh;
        }
        if (naw < 0) {
            naw = 0 - naw;
        }
        if (nah < 0) {
            nah = 0 - nah;
        }
        if (naw == 0 || nah == 0) {
            Gdip.Graphics_FillRectangle(this.data.gdipGraphics, this.data.gdipBrush, x, y, width, height);
        } else {
            long path = Gdip.GraphicsPath_new(0);
            if (path == 0L) {
                SWT.error(2);
            }
            if (nw > naw) {
                if (nh > nah) {
                    Gdip.GraphicsPath_AddArc(path, nx + nw - naw, ny, naw, nah, 0.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(path, nx, ny, naw, nah, -90.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(path, nx, ny + nh - nah, naw, nah, -180.0f, -90.0f);
                    Gdip.GraphicsPath_AddArc(path, nx + nw - naw, ny + nh - nah, naw, nah, -270.0f, -90.0f);
                } else {
                    Gdip.GraphicsPath_AddArc(path, nx + nw - naw, ny, naw, nh, -270.0f, -180.0f);
                    Gdip.GraphicsPath_AddArc(path, nx, ny, naw, nh, -90.0f, -180.0f);
                }
            } else if (nh > nah) {
                Gdip.GraphicsPath_AddArc(path, nx, ny, nw, nah, 0.0f, -180.0f);
                Gdip.GraphicsPath_AddArc(path, nx, ny + nh - nah, nw, nah, -180.0f, -180.0f);
            } else {
                Gdip.GraphicsPath_AddArc(path, nx, ny, nw, nh, 0.0f, 360.0f);
            }
            Gdip.GraphicsPath_CloseFigure(path);
            Gdip.Graphics_FillPath(gdipGraphics, brush, path);
            Gdip.GraphicsPath_delete(path);
        }
    }

    private void flush() {
        if (this.data.gdipGraphics != 0L) {
            Gdip.Graphics_Flush(this.data.gdipGraphics, 0);
            long hdc = Gdip.Graphics_GetHDC(this.data.gdipGraphics);
            Gdip.Graphics_ReleaseHDC(this.data.gdipGraphics, hdc);
        }
    }

    public int getAdvanceWidth(char ch) {
        this.checkNonDisposed();
        this.checkGC(4);
        int[] width = new int[1];
        OS.GetCharWidth(this.handle, ch, ch, width);
        return width[0];
    }

    public boolean getAdvanced() {
        this.checkNonDisposed();
        return this.data.gdipGraphics != 0L;
    }

    public int getAlpha() {
        this.checkNonDisposed();
        return this.data.alpha;
    }

    public int getAntialias() {
        this.checkNonDisposed();
        if (this.data.gdipGraphics == 0L) {
            return -1;
        }
        int mode = Gdip.Graphics_GetSmoothingMode(this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public Color getBackground() {
        this.checkNonDisposed();
        return Color.win32_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        this.checkNonDisposed();
        return this.data.backgroundPattern;
    }

    public int getCharWidth(char ch) {
        this.checkNonDisposed();
        this.checkGC(4);
        int[] width = new int[3];
        if (OS.GetCharABCWidths(this.handle, ch, ch, width)) {
            return width[1];
        }
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics(this.handle, lptm);
        SIZE size = new SIZE();
        OS.GetTextExtentPoint32(this.handle, new char[]{ch}, 1, size);
        return size.cx - lptm.tmOverhang;
    }

    public Rectangle getClipping() {
        return Win32DPIUtils.pixelToPoint(this.drawable, this.getClippingInPixels(), this.getZoom());
    }

    Rectangle getClippingInPixels() {
        this.checkNonDisposed();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Rect rect = new Rect();
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
            Gdip.Graphics_GetVisibleClipBounds(gdipGraphics, rect);
            Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
            return new Rectangle(rect.X, rect.Y, rect.Width, rect.Height);
        }
        RECT rect = new RECT();
        OS.GetClipBox(this.handle, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void getClipping(Region region) {
        this.checkNonDisposed();
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new GetClippingOperation(region));
    }

    private long getClippingRegion() {
        long regionHandle = OS.CreateRectRgn(0, 0, 0, 0);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            long rgn = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, rgn);
            if (Gdip.Region_IsInfinite(rgn, gdipGraphics)) {
                Rect rect = new Rect();
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
                Gdip.Graphics_GetVisibleClipBounds(gdipGraphics, rect);
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
                OS.SetRectRgn(regionHandle, rect.X, rect.Y, rect.X + rect.Width, rect.Y + rect.Height);
            } else {
                long matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                long identity = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                Gdip.Graphics_GetTransform(gdipGraphics, matrix);
                Gdip.Graphics_SetTransform(gdipGraphics, identity);
                long hRgn = Gdip.Region_GetHRGN(rgn, this.data.gdipGraphics);
                Gdip.Graphics_SetTransform(gdipGraphics, matrix);
                Gdip.Matrix_delete(identity);
                Gdip.Matrix_delete(matrix);
                POINT pt = new POINT();
                OS.GetWindowOrgEx(this.handle, pt);
                OS.OffsetRgn(hRgn, pt.x, pt.y);
                OS.CombineRgn(regionHandle, hRgn, 0L, 5);
                OS.DeleteObject(hRgn);
            }
            Gdip.Region_delete(rgn);
            return regionHandle;
        }
        POINT pt = new POINT();
        OS.GetWindowOrgEx(this.handle, pt);
        int result = OS.GetClipRgn(this.handle, regionHandle);
        if (result != 1) {
            RECT rect = new RECT();
            OS.GetClipBox(this.handle, rect);
            OS.SetRectRgn(regionHandle, rect.left, rect.top, rect.right, rect.bottom);
        } else {
            OS.OffsetRgn(regionHandle, pt.x, pt.y);
        }
        long metaRgn = OS.CreateRectRgn(0, 0, 0, 0);
        if (OS.GetMetaRgn(this.handle, metaRgn) != 0) {
            OS.OffsetRgn(metaRgn, pt.x, pt.y);
            OS.CombineRgn(regionHandle, metaRgn, regionHandle, 1);
        }
        OS.DeleteObject(metaRgn);
        long hwnd = this.data.hwnd;
        if (hwnd != 0L && this.data.ps != null) {
            long sysRgn = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetRandomRgn(this.handle, sysRgn, 4) == 1) {
                if ((OS.GetLayout(this.handle) & 1) != 0) {
                    int nBytes = OS.GetRegionData(sysRgn, 0, null);
                    int[] lpRgnData = new int[nBytes / 4];
                    OS.GetRegionData(sysRgn, nBytes, lpRgnData);
                    long newSysRgn = OS.ExtCreateRegion(new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, nBytes, lpRgnData);
                    OS.DeleteObject(sysRgn);
                    sysRgn = newSysRgn;
                }
                OS.MapWindowPoints(0L, hwnd, pt, 1);
                OS.OffsetRgn(sysRgn, pt.x, pt.y);
                OS.CombineRgn(regionHandle, sysRgn, regionHandle, 1);
            }
            OS.DeleteObject(sysRgn);
        }
        return regionHandle;
    }

    long getFgBrush() {
        return this.data.foregroundPattern != null ? this.data.foregroundPattern.getHandle(this.getZoom()) : this.data.gdipFgBrush;
    }

    public int getFillRule() {
        this.checkNonDisposed();
        return OS.GetPolyFillMode(this.handle) == 2 ? 2 : 1;
    }

    public Font getFont() {
        this.checkNonDisposed();
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        this.checkNonDisposed();
        this.checkGC(4);
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics(this.handle, lptm);
        return FontMetrics.win32_new(lptm, this.data.nativeZoom);
    }

    public Color getForeground() {
        this.checkNonDisposed();
        return Color.win32_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        this.checkNonDisposed();
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        this.checkNonDisposed();
        return this.data;
    }

    public int getInterpolation() {
        this.checkNonDisposed();
        if (this.data.gdipGraphics == 0L) {
            return -1;
        }
        int mode = Gdip.Graphics_GetInterpolationMode(this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 5: {
                return 0;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        LineAttributes attributes = this.getLineAttributesInPixels();
        int deviceZoom = this.getZoom();
        attributes.width = Win32DPIUtils.pixelToPoint(this.drawable, attributes.width, deviceZoom);
        if (attributes.dash != null) {
            attributes.dash = Win32DPIUtils.pixelToPoint(this.drawable, attributes.dash, deviceZoom);
        }
        return attributes;
    }

    LineAttributes getLineAttributesInPixels() {
        this.checkNonDisposed();
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        this.checkNonDisposed();
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        this.checkNonDisposed();
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        int deviceZoom = this.getZoom();
        for (int i = 0; i < lineDashes.length; ++i) {
            lineDashes[i] = Win32DPIUtils.pixelToPoint(this.drawable, (int)this.data.lineDashes[i], deviceZoom);
        }
        return lineDashes;
    }

    public int getLineJoin() {
        this.checkNonDisposed();
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        this.checkNonDisposed();
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        return Win32DPIUtils.pixelToPoint(this.drawable, this.getLineWidthInPixels(), this.getZoom());
    }

    int getLineWidthInPixels() {
        this.checkNonDisposed();
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        this.checkNonDisposed();
        return this.data.style;
    }

    public int getTextAntialias() {
        this.checkNonDisposed();
        if (this.data.gdipGraphics == 0L) {
            return -1;
        }
        int mode = Gdip.Graphics_GetTextRenderingHint(this.data.gdipGraphics);
        switch (mode) {
            case 0: {
                return -1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: {
                return 1;
            }
        }
        return -1;
    }

    public void getTransform(Transform transform) {
        long gdipGraphics;
        this.checkNonDisposed();
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((gdipGraphics = this.data.gdipGraphics) != 0L) {
            Gdip.Graphics_GetTransform(gdipGraphics, transform.getHandle(this.getZoom()));
            long identity = this.identity();
            Gdip.Matrix_Invert(identity);
            Gdip.Matrix_Multiply(transform.getHandle(this.getZoom()), identity, 1);
            Gdip.Matrix_delete(identity);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        this.checkNonDisposed();
        return OS.GetROP2(this.handle) == 7;
    }

    void initGdip() {
        this.data.device.checkGDIP();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            return;
        }
        long hRgn = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, hRgn);
        POINT pt = new POINT();
        OS.GetWindowOrgEx(this.handle, pt);
        OS.OffsetRgn(hRgn, pt.x, pt.y);
        OS.SelectClipRgn(this.handle, 0L);
        if ((this.data.style & 0x8000000) != 0) {
            OS.SetLayout(this.handle, OS.GetLayout(this.handle) & 0xFFFFFFFE);
        }
        if ((gdipGraphics = (this.data.gdipGraphics = Gdip.Graphics_new(this.handle))) == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_SetPageUnit(gdipGraphics, 2);
        Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
        if ((this.data.style & 0x8000000) != 0) {
            long matrix = this.identity();
            Gdip.Graphics_SetTransform(gdipGraphics, matrix);
            Gdip.Matrix_delete(matrix);
        }
        if (result == 1) {
            this.setClipping(hRgn);
        }
        OS.DeleteObject(hRgn);
        this.data.state = 0;
        if (this.data.hPen != 0L) {
            OS.SelectObject(this.handle, OS.GetStockObject(8));
            OS.DeleteObject(this.data.hPen);
            this.data.hPen = 0L;
        }
        if (this.data.hBrush != 0L) {
            OS.SelectObject(this.handle, OS.GetStockObject(5));
            OS.DeleteObject(this.data.hBrush);
            this.data.hBrush = 0L;
        }
    }

    private long identity() {
        if ((this.data.style & 0x8000000) != 0) {
            int width = 0;
            int technology = OS.GetDeviceCaps(this.handle, 2);
            if (technology == 2) {
                width = OS.GetDeviceCaps(this.handle, 110);
            } else {
                Image image = this.data.image;
                if (image != null) {
                    BITMAP bm = new BITMAP();
                    OS.GetObject(Image.win32_getHandle(image, this.getZoom()), BITMAP.sizeof, bm);
                    width = bm.bmWidth;
                } else {
                    long hwnd = OS.WindowFromDC(this.handle);
                    if (hwnd != 0L) {
                        RECT rect = new RECT();
                        OS.GetClientRect(hwnd, rect);
                        width = rect.right - rect.left;
                    } else {
                        long hBitmap = OS.GetCurrentObject(this.handle, 7);
                        BITMAP bm = new BITMAP();
                        OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                        width = bm.bmWidth;
                    }
                }
            }
            POINT pt = new POINT();
            OS.GetWindowOrgEx(this.handle, pt);
            return Gdip.Matrix_new(-1.0f, 0.0f, 0.0f, 1.0f, width + 2 * pt.x, 0.0f);
        }
        return Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    private void init(Drawable drawable, GCData data, long hDC) {
        int layout;
        int foreground = data.foreground;
        if (foreground != -1) {
            data.state &= 0xFFFFF6FE;
        } else {
            data.foreground = OS.GetTextColor(hDC);
        }
        int background = data.background;
        if (background != -1) {
            data.state &= 0xFFFFF9FD;
        } else {
            data.background = OS.GetBkColor(hDC);
        }
        data.state &= 0xFFFFCFFF;
        if (data.nativeZoom == 0) {
            data.nativeZoom = GC.extractZoom(hDC);
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
            data.font = Font.win32_new(data.font, data.nativeZoom);
        } else {
            data.font = SWTFontProvider.getFont(this.device, OS.GetCurrentObject(hDC, 6), data.nativeZoom);
        }
        Image image = data.image;
        if (image != null) {
            data.hNullBitmap = OS.SelectObject(hDC, image.getHandle(data.imageZoom, data.nativeZoom).getHandle());
            image.memGC = this;
        }
        if ((layout = data.layout) != -1) {
            int flags = OS.GetLayout(hDC);
            if ((flags & 1) != (layout & 1)) {
                OS.SetLayout(hDC, (flags &= 0xFFFFFFFE) | layout);
            }
            if ((data.style & 0x4000000) != 0) {
                data.style |= 0x8000000;
            }
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = hDC;
    }

    private static int extractZoom(long hDC) {
        StrictChecks.runIfStrictChecksEnabled(() -> System.err.println("***WARNING: GC is initialized with a missing zoom. This indicates an incompatible custom Drawable implementation."));
        long hwnd = OS.WindowFromDC(hDC);
        long parentWindow = OS.GetAncestor(hwnd, 2);
        long monitorParent = OS.MonitorFromWindow(parentWindow, 2);
        int[] dpiX = new int[1];
        int[] dpiY = new int[1];
        int result = OS.GetDpiForMonitor(monitorParent, 0, dpiX, dpiY);
        return result == 0 ? DPIUtil.mapDPIToZoom(dpiX[0]) : DPIUtil.getNativeDeviceZoom();
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public boolean isClipped() {
        this.checkNonDisposed();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            long rgn = Gdip.Region_new();
            Gdip.Graphics_GetClip(this.data.gdipGraphics, rgn);
            boolean isInfinite = Gdip.Region_IsInfinite(rgn, gdipGraphics);
            Gdip.Region_delete(rgn);
            return !isInfinite;
        }
        long region = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, region);
        OS.DeleteObject(region);
        return result > 0;
    }

    private void checkNonDisposed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    private float measureSpace(long font, long format) {
        PointF pt = new PointF();
        RectF bounds = new RectF();
        Gdip.Graphics_MeasureString(this.data.gdipGraphics, new char[]{' '}, 1, font, pt, format, bounds);
        return bounds.Width;
    }

    public void setAdvanced(boolean advanced) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetAdvancedOperation(advanced));
    }

    public void setAntialias(int antialias) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetAntialiasOperation(antialias));
    }

    public void setAlpha(int alpha) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetAlphaOperation(alpha));
    }

    public void setBackground(Color color) {
        this.checkNonDisposed();
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetBackgroundOperation(color));
    }

    public void setBackgroundPattern(Pattern pattern) {
        this.checkNonDisposed();
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetBackgroundPatternOperation(pattern));
    }

    private void setClipping(long clipRgn) {
        this.checkNonDisposed();
        this.setClippingRegion(clipRgn);
    }

    private void setClippingRegion(long hRgn) {
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            if (hRgn != 0L) {
                long region = Gdip.Region_new(hRgn);
                Gdip.Graphics_SetClip(gdipGraphics, region, 0);
                Gdip.Region_delete(region);
            } else {
                Gdip.Graphics_ResetClip(gdipGraphics);
            }
        } else {
            POINT pt = null;
            if (hRgn != 0L) {
                pt = new POINT();
                OS.GetWindowOrgEx(this.handle, pt);
                OS.OffsetRgn(hRgn, -pt.x, -pt.y);
            }
            OS.SelectClipRgn(this.handle, hRgn);
            if (hRgn != 0L) {
                OS.OffsetRgn(hRgn, pt.x, pt.y);
            }
        }
    }

    public void setClipping(int x, int y, int width, int height) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetClippingOperation(new Rectangle(x, y, width, height)));
    }

    private void setClippingInPixels(int x, int y, int width, int height) {
        this.checkNonDisposed();
        long hRgn = OS.CreateRectRgn(x, y, x + width, y + height);
        this.setClippingRegion(hRgn);
        OS.DeleteObject(hRgn);
    }

    public void setClipping(Path path) {
        this.checkNonDisposed();
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetClippingPathOperation(path));
    }

    public void setClipping(Rectangle rect) {
        this.checkNonDisposed();
        if (rect == null) {
            this.storeAndApplyOperationForExistingHandle(new SetClippingRegionOperation(null));
        } else {
            this.storeAndApplyOperationForExistingHandle(new SetClippingOperation(rect));
        }
    }

    public void setClipping(Region region) {
        this.checkNonDisposed();
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetClippingRegionOperation(region));
    }

    public void setFillRule(int rule) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetFillRuleOperation(rule));
    }

    public void setFont(Font font) {
        this.checkNonDisposed();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetFontOperation(font));
    }

    public void setForeground(Color color) {
        this.checkNonDisposed();
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetForegroundOperation(color));
    }

    public void setForegroundPattern(Pattern pattern) {
        this.checkNonDisposed();
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetForegroundPatternOperation(pattern));
    }

    public void setInterpolation(int interpolation) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetInterpolationOperation(interpolation));
    }

    public void setLineAttributes(LineAttributes attributes) {
        if (attributes == null) {
            SWT.error(4);
        }
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetLineAttributesOperation(attributes));
    }

    private void setLineAttributesInPixels(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        this.checkNonDisposed();
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x4010;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x40;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x20;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            for (int i = 0; i < dashes.length; ++i) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (changed || lineDashes[i] == dash) continue;
                changed = true;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                int deviceZoom = this.getZoom();
                for (int i = 0; i < newDashes.length; ++i) {
                    newDashes[i] = Win32DPIUtils.pointToPixel(this.drawable, dashes[i], deviceZoom);
                }
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        this.initGdip();
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetLineCapOperation(cap));
    }

    public void setLineDash(int[] dashes) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetLineDashOperation(dashes));
    }

    public void setLineJoin(int join) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetLineJoinOperation(join));
    }

    public void setLineStyle(int lineStyle) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetLineStyleOperation(lineStyle));
    }

    public void setLineWidth(int lineWidth) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetLineWidthOperation(lineWidth));
    }

    private void setLineWidthInPixels(int lineWidth) {
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFBFEF;
    }

    public void setXORMode(boolean xor) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetXORModeOperation(xor));
    }

    public void setTextAntialias(int antialias) {
        this.checkNonDisposed();
        this.storeAndApplyOperationForExistingHandle(new SetTextAntialiasOperation(antialias));
    }

    public void setTransform(Transform transform) {
        this.checkNonDisposed();
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        this.storeAndApplyOperationForExistingHandle(new SetTransformOperation(transform));
    }

    public Point stringExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        return Win32DPIUtils.pixelToPointAsSize(this.drawable, this.stringExtentInPixels(string), this.getZoom());
    }

    Point stringExtentInPixels(String string) {
        this.checkNonDisposed();
        this.checkGC(4);
        int length = string.length();
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Point size = new Point(0, 0);
            this.drawText(gdipGraphics, string, 0, 0, 0, size);
            return size;
        }
        SIZE size = new SIZE();
        if (length == 0) {
            OS.GetTextExtentPoint32(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        char[] buffer = string.toCharArray();
        OS.GetTextExtentPoint32(this.handle, buffer, length, size);
        return new Point(size.cx, size.cy);
    }

    public Point textExtent(String string) {
        return Win32DPIUtils.pixelToPointAsSize(this.drawable, this.textExtentInPixels(string, 6), this.getZoom());
    }

    public Point textExtent(String string, int flags) {
        return Win32DPIUtils.pixelToPointAsSize(this.drawable, this.textExtentInPixels(string, flags), this.getZoom());
    }

    Point textExtentInPixels(String string, int flags) {
        this.checkNonDisposed();
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(4);
        long gdipGraphics = this.data.gdipGraphics;
        if (gdipGraphics != 0L) {
            Point size = new Point(0, 0);
            this.drawText(gdipGraphics, string, 0, 0, flags, size);
            return size;
        }
        if (string.length() == 0) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        RECT rect = new RECT();
        char[] buffer = string.toCharArray();
        int uFormat = 1024;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        OS.DrawText(this.handle, buffer, buffer.length, rect, uFormat);
        return new Point(rect.right, rect.bottom);
    }

    void refreshFor(Drawable drawable) {
        if (drawable == null) {
            SWT.error(4);
        }
        this.destroy();
        GCData newData = new GCData();
        this.originalData.copyTo(newData);
        this.createGcHandle(drawable, newData);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        data.copyTo(gc.originalData);
        long hDC = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, hDC);
        return gc;
    }

    public static GC win32_new(long hDC, GCData data) {
        GC gc = new GC();
        gc.device = data.device;
        data.style |= 0x2000000;
        int flags = OS.GetLayout(hDC);
        if ((flags & 1) != 0) {
            data.style |= 0xC000000;
        }
        data.copyTo(gc.originalData);
        gc.init(null, data, hDC);
        return gc;
    }

    private static int cos(int angle, int length) {
        return (int)(Math.cos((double)angle * (Math.PI / 180)) * (double)length);
    }

    private static int sin(int angle, int length) {
        return (int)(Math.sin((double)angle * (Math.PI / 180)) * (double)length);
    }

    int getZoom() {
        return DPIUtil.getZoomForAutoscaleProperty(this.data.nativeZoom);
    }

    private void storeAndApplyOperationForExistingHandle(Operation operation) {
        this.removePreviousOperationIfSupercededBy(operation);
        this.operations.add(operation);
        operation.apply();
    }

    private void removePreviousOperationIfSupercededBy(Operation operation) {
        if (this.operations.isEmpty()) {
            return;
        }
        int lastIndex = this.operations.size() - 1;
        Operation lastOperation = this.operations.get(lastIndex);
        if (lastOperation.canBeReplacedBy(operation)) {
            lastOperation.disposeAll();
            this.operations.remove(lastIndex);
        }
    }

    private void createGcHandle(Drawable drawable, GCData newData) {
        long newHandle = drawable.internal_new_GC(newData);
        if (newHandle == 0L) {
            SWT.error(2);
        }
        this.init(drawable, newData, newHandle);
        for (Operation operation : this.operations) {
            operation.apply();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeOperations();
    }

    private void disposeOperations() {
        for (Operation op : this.operations) {
            op.disposeAll();
        }
        this.operations.clear();
    }

    private class CopyAreaToImageOperation
    extends ImageOperation {
        private final int x;
        private final int y;

        CopyAreaToImageOperation(Image image, int x, int y) {
            super(image);
            this.x = x;
            this.y = y;
        }

        @Override
        void apply() {
            int zoom = GC.this.getZoom();
            int scaledX = Win32DPIUtils.pointToPixel(GC.this.drawable, this.x, zoom);
            int scaledY = Win32DPIUtils.pointToPixel(GC.this.drawable, this.y, zoom);
            GC.this.copyAreaInPixels(this.getImage(), scaledX, scaledY);
        }
    }

    private abstract class Operation {
        private final List<Resource> disposables = new ArrayList<Resource>();

        private Operation(GC gC) {
        }

        abstract void apply();

        protected void registerForDisposal(Resource resource) {
            if (resource != null) {
                this.disposables.add(resource);
            }
        }

        void disposeAll() {
            for (Resource r : this.disposables) {
                r.dispose();
            }
            this.disposables.clear();
        }

        boolean canBeReplacedBy(Operation operation) {
            return false;
        }
    }

    private class CopyAreaOperation
    extends Operation {
        private final Rectangle source;
        private final Rectangle destination;
        private final boolean paint;

        CopyAreaOperation(Rectangle source, Rectangle destination, boolean paint) {
            super(GC.this);
            this.source = source;
            this.destination = destination;
            this.paint = paint;
        }

        @Override
        void apply() {
            int zoom = GC.this.getZoom();
            Rectangle sourceRect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.source, zoom);
            Rectangle destRect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.destination, zoom);
            GC.this.copyAreaInPixels(sourceRect.x, sourceRect.y, sourceRect.width, sourceRect.height, destRect.x, destRect.y, this.paint);
        }
    }

    private class DrawArcOperation
    extends Operation {
        private final Rectangle rectangle;
        private final int startAngle;
        private final int arcAngle;

        DrawArcOperation(Rectangle rectangle, int startAngle, int arcAngle) {
            super(GC.this);
            this.rectangle = rectangle;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, GC.this.getZoom());
            GC.this.drawArcInPixels(rect.x, rect.y, rect.width, rect.height, this.startAngle, this.arcAngle);
        }
    }

    private class DrawFocusOperation
    extends Operation {
        private final Rectangle rectangle;

        DrawFocusOperation(Rectangle rectangle) {
            super(GC.this);
            this.rectangle = rectangle;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, GC.this.getZoom());
            GC.this.drawFocusInPixels(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class DrawImageOperation
    extends ImageOperation {
        private final Point location;

        DrawImageOperation(Image image, Point location) {
            super(image);
            this.location = location;
        }

        @Override
        void apply() {
            this.drawImageInPixels(this.getImage(), Win32DPIUtils.pointToPixelAsLocation(GC.this.drawable, this.location, GC.this.getZoom()));
        }

        private void drawImageInPixels(Image image, Point location) {
            if (image.isDisposed()) {
                SWT.error(5);
            }
            Image.ImageHandle handle = image.getHandle(GC.this.getZoom(), GC.this.data.nativeZoom);
            GC.this.drawImage(image, 0, 0, -1, -1, location.x, location.y, -1, -1, true, handle);
        }
    }

    private class DrawScalingImageToImageOperation
    extends ImageOperation {
        private final Rectangle source;
        private final Rectangle destination;

        DrawScalingImageToImageOperation(Image image, Rectangle source, Rectangle destination) {
            super(image);
            this.source = source;
            this.destination = destination;
        }

        @Override
        void apply() {
            int gcZoom = GC.this.getZoom();
            int srcImageZoom = this.calculateZoomForImage(gcZoom, this.source.width, this.source.height, this.destination.width, this.destination.height);
            GC.this.drawImage(this.getImage(), this.source.x, this.source.y, this.source.width, this.source.height, this.destination.x, this.destination.y, this.destination.width, this.destination.height, gcZoom, srcImageZoom);
        }

        private Collection<Integer> getAllCurrentMonitorZooms() {
            Device device = GC.this.device;
            if (device instanceof Display) {
                Display display = (Display)device;
                return Arrays.stream(display.getMonitors()).map(Monitor::getZoom).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }

        private int calculateZoomForImage(int gcZoom, int srcWidth, int srcHeight, int destWidth, int destHeight) {
            if (srcWidth == 1 && srcHeight == 1) {
                return gcZoom;
            }
            if (destWidth == srcWidth && destHeight == srcHeight) {
                return gcZoom;
            }
            if (GC.this.drawable != null && !GC.this.drawable.isAutoScalable()) {
                return gcZoom;
            }
            float imageScaleFactor = 1.0f * (float)destWidth / (float)srcWidth;
            int imageZoom = Math.round((float)gcZoom * imageScaleFactor);
            if (this.getAllCurrentMonitorZooms().contains(imageZoom)) {
                return imageZoom;
            }
            if (imageZoom > 150) {
                return 200;
            }
            return 100;
        }
    }

    private class DrawScaledImageOperation
    extends ImageOperation {
        private final Rectangle destination;

        DrawScaledImageOperation(Image image, Rectangle destination) {
            super(image);
            this.destination = destination;
        }

        @Override
        void apply() {
            int gcZoom = GC.this.getZoom();
            GC.this.drawImage(this.getImage(), this.destination.x, this.destination.y, this.destination.width, this.destination.height, gcZoom);
        }
    }

    private class DrawImageToImageOperation
    extends ImageOperation {
        private final Rectangle source;
        private final Rectangle destination;
        private final boolean simple;

        DrawImageToImageOperation(Image image, Rectangle source, Rectangle destination, boolean simple) {
            super(image);
            this.source = source;
            this.destination = destination;
            this.simple = simple;
        }

        @Override
        void apply() {
            Image.ImageHandle handle = this.getImage().getHandle(GC.this.getZoom(), GC.this.data.nativeZoom);
            GC.this.drawImage(this.getImage(), this.source.x, this.source.y, this.source.width, this.source.height, this.destination.x, this.destination.y, this.destination.width, this.destination.height, this.simple, handle);
        }
    }

    private class DrawLineOperation
    extends Operation {
        private final Point start;
        private final Point end;

        DrawLineOperation(int x1, int y1, int x2, int y2) {
            super(GC.this);
            this.start = new Point(x1, y1);
            this.end = new Point(x2, y2);
        }

        @Override
        void apply() {
            int deviceZoom = GC.this.getZoom();
            Point startInPixels = Win32DPIUtils.pointToPixelAsLocation(GC.this.drawable, this.start, deviceZoom);
            Point endInPixels = Win32DPIUtils.pointToPixelAsLocation(GC.this.drawable, this.end, deviceZoom);
            GC.this.drawLineInPixels(startInPixels.x, startInPixels.y, endInPixels.x, endInPixels.y);
        }
    }

    private class DrawOvalOperation
    extends Operation {
        private final Rectangle bounds;

        DrawOvalOperation(Rectangle bounds) {
            super(GC.this);
            this.bounds = bounds;
        }

        @Override
        void apply() {
            Rectangle boundsInPixels = Win32DPIUtils.pointToPixel(GC.this.drawable, this.bounds, GC.this.getZoom());
            GC.this.drawOvalInPixels(boundsInPixels.x, boundsInPixels.y, boundsInPixels.width, boundsInPixels.height);
        }
    }

    private class DrawPathOperation
    extends Operation {
        private final PathData pathData;

        DrawPathOperation(Path path) {
            super(GC.this);
            this.pathData = path.getPathData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void apply() {
            Path path = new Path(GC.this.device, this.pathData);
            try {
                long pathHandle = path.getHandle(GC.this.getZoom());
                if (pathHandle == 0L) {
                    SWT.error(5);
                }
                GC.this.initGdip();
                GC.this.checkGC(22777);
                long gdipGraphics = GC.this.data.gdipGraphics;
                Gdip.Graphics_TranslateTransform(gdipGraphics, GC.this.data.gdipXOffset, GC.this.data.gdipYOffset, 0);
                Gdip.Graphics_DrawPath(gdipGraphics, GC.this.data.gdipPen, pathHandle);
                Gdip.Graphics_TranslateTransform(gdipGraphics, -GC.this.data.gdipXOffset, -GC.this.data.gdipYOffset, 0);
            }
            finally {
                path.dispose();
            }
        }
    }

    private class DrawPointOperation
    extends Operation {
        private final Point location;

        DrawPointOperation(int x, int y) {
            super(GC.this);
            this.location = new Point(x, y);
        }

        @Override
        void apply() {
            Point scaleUpLocation = Win32DPIUtils.pointToPixelAsLocation(this.location, GC.this.getZoom());
            GC.this.drawPointInPixels(scaleUpLocation.x, scaleUpLocation.y);
        }
    }

    private class DrawPolygonOperation
    extends Operation {
        private final int[] pointArray;

        DrawPolygonOperation(int[] pointArray) {
            super(GC.this);
            this.pointArray = pointArray;
        }

        @Override
        void apply() {
            GC.this.drawPolygonInPixels(Win32DPIUtils.pointToPixel(GC.this.drawable, this.pointArray, GC.this.getZoom()));
        }
    }

    private class DrawPolylineOperation
    extends Operation {
        private final int[] pointArray;

        DrawPolylineOperation(int[] pointArray) {
            super(GC.this);
            this.pointArray = pointArray;
        }

        @Override
        void apply() {
            GC.this.drawPolylineInPixels(Win32DPIUtils.pointToPixel(GC.this.drawable, this.pointArray, GC.this.getZoom()));
        }
    }

    private class DrawRectangleOperation
    extends Operation {
        private final Rectangle rectangle;

        DrawRectangleOperation(Rectangle rectangle) {
            super(GC.this);
            this.rectangle = rectangle;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, GC.this.getZoom());
            GC.this.drawRectangleInPixels(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class DrawRoundRectangleOperation
    extends Operation {
        private final Rectangle rectangle;
        private final int arcWidth;
        private final int arcHeight;

        DrawRoundRectangleOperation(Rectangle rectangle, int arcWidth, int arcHeight) {
            super(GC.this);
            this.rectangle = rectangle;
            this.arcWidth = arcWidth;
            this.arcHeight = arcHeight;
        }

        @Override
        void apply() {
            int zoom = GC.this.getZoom();
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, zoom);
            int scaledArcWidth = Win32DPIUtils.pointToPixel(GC.this.drawable, this.arcWidth, zoom);
            int scaledArcHeight = Win32DPIUtils.pointToPixel(GC.this.drawable, this.arcHeight, zoom);
            GC.this.drawRoundRectangleInPixels(rect.x, rect.y, rect.width, rect.height, scaledArcWidth, scaledArcHeight);
        }
    }

    private class DrawStringOperation
    extends Operation {
        private final String string;
        private final Point location;
        private final boolean isTransparent;

        DrawStringOperation(String string, Point location, boolean isTransparent) {
            super(GC.this);
            this.string = string;
            this.location = location;
            this.isTransparent = isTransparent;
        }

        @Override
        void apply() {
            Point scaledLocation = Win32DPIUtils.pointToPixelAsLocation(GC.this.drawable, this.location, GC.this.getZoom());
            GC.this.drawStringInPixels(this.string, scaledLocation.x, scaledLocation.y, this.isTransparent);
        }
    }

    private class DrawTextOperation
    extends Operation {
        private final String string;
        private final Point location;
        private final int flags;

        DrawTextOperation(String string, Point location, int flags) {
            super(GC.this);
            this.string = string;
            this.location = location;
            this.flags = flags;
        }

        @Override
        void apply() {
            Point scaledLocation = Win32DPIUtils.pointToPixelAsLocation(GC.this.drawable, this.location, GC.this.getZoom());
            GC.this.drawTextInPixels(this.string, scaledLocation.x, scaledLocation.y, this.flags);
        }
    }

    private class FillArcOperation
    extends Operation {
        private final Rectangle bounds;
        private final int startAngle;
        private final int arcAngle;

        FillArcOperation(Rectangle bounds, int startAngle, int arcAngle) {
            super(GC.this);
            this.bounds = bounds;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.bounds, GC.this.getZoom());
            GC.this.fillArcInPixels(rect.x, rect.y, rect.width, rect.height, this.startAngle, this.arcAngle);
        }
    }

    private class FillGradientRectangleOperation
    extends FillRectangleOperation {
        private final boolean vertical;

        FillGradientRectangleOperation(Rectangle rectangle, boolean vertical) {
            super(rectangle);
            this.vertical = vertical;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, GC.this.getZoom());
            GC.this.fillGradientRectangleInPixels(rect.x, rect.y, rect.width, rect.height, this.vertical, GC.this.getZoom());
        }
    }

    private class FillOvalOperation
    extends Operation {
        private final Rectangle bounds;

        FillOvalOperation(Rectangle bounds) {
            super(GC.this);
            this.bounds = bounds;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.bounds, GC.this.getZoom());
            GC.this.fillOvalInPixels(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class FillPathOperation
    extends Operation {
        private final PathData pathData;

        FillPathOperation(Path path) {
            super(GC.this);
            this.pathData = path.getPathData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void apply() {
            Path path = new Path(GC.this.device, this.pathData);
            try {
                long pathHandle = path.getHandle(GC.this.getZoom());
                if (pathHandle == 0L) {
                    SWT.error(5);
                }
                GC.this.initGdip();
                GC.this.checkGC(9218);
                int mode = OS.GetPolyFillMode(GC.this.handle) == 2 ? 1 : 0;
                Gdip.GraphicsPath_SetFillMode(pathHandle, mode);
                Gdip.Graphics_FillPath(GC.this.data.gdipGraphics, GC.this.data.gdipBrush, pathHandle);
            }
            finally {
                path.dispose();
            }
        }
    }

    private class FillPolygonOperation
    extends Operation {
        private final int[] pointArray;

        FillPolygonOperation(int[] pointArray) {
            super(GC.this);
            this.pointArray = pointArray;
        }

        @Override
        void apply() {
            GC.this.fillPolygonInPixels(Win32DPIUtils.pointToPixel(GC.this.drawable, this.pointArray, GC.this.getZoom()));
        }
    }

    private class FillRectangleOperation
    extends Operation {
        protected final Rectangle rectangle;

        FillRectangleOperation(Rectangle rectangle) {
            super(GC.this);
            this.rectangle = rectangle;
        }

        @Override
        void apply() {
            Rectangle scaledBounds = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, GC.this.getZoom());
            GC.this.fillRectangleInPixels(scaledBounds.x, scaledBounds.y, scaledBounds.width, scaledBounds.height);
        }
    }

    private class FillRoundRectangleOperation
    extends Operation {
        private final Rectangle rectangle;
        private final int arcWidth;
        private final int arcHeight;

        FillRoundRectangleOperation(Rectangle rectangle, int arcWidth, int arcHeight) {
            super(GC.this);
            this.rectangle = rectangle;
            this.arcWidth = arcWidth;
            this.arcHeight = arcHeight;
        }

        @Override
        void apply() {
            int zoom = GC.this.getZoom();
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, zoom);
            int scaledArcWidth = Win32DPIUtils.pointToPixel(GC.this.drawable, this.arcWidth, zoom);
            int scaledArcHeight = Win32DPIUtils.pointToPixel(GC.this.drawable, this.arcHeight, zoom);
            GC.this.fillRoundRectangleInPixels(rect.x, rect.y, rect.width, rect.height, scaledArcWidth, scaledArcHeight);
        }
    }

    private class GetClippingOperation
    extends Operation {
        private final Map<Integer, Long> zoomToRegionHandle;

        public GetClippingOperation(Region region) {
            super(GC.this);
            this.zoomToRegionHandle = new HashMap<Integer, Long>();
            region.set(zoom -> {
                if (!this.zoomToRegionHandle.containsKey(zoom)) {
                    System.err.println("No clipping handle for zoom " + zoom + " has been created on this GC");
                    return this.zoomToRegionHandle.values().iterator().next();
                }
                return this.zoomToRegionHandle.get(zoom);
            }, GC.this.getZoom());
        }

        @Override
        void apply() {
            this.zoomToRegionHandle.computeIfAbsent(GC.this.getZoom(), __ -> GC.this.getClippingRegion());
        }

        @Override
        void disposeAll() {
            for (long handle : this.zoomToRegionHandle.values()) {
                OS.DeleteObject(handle);
            }
            super.disposeAll();
        }
    }

    private class SetAdvancedOperation
    extends Operation {
        private final boolean advanced;

        SetAdvancedOperation(boolean advanced) {
            super(GC.this);
            this.advanced = advanced;
        }

        @Override
        void apply() {
            if (this.advanced && GC.this.data.gdipGraphics != 0L) {
                return;
            }
            if (this.advanced) {
                GC.this.initGdip();
            } else {
                GC.this.disposeGdip();
                GC.this.data.alpha = 255;
                GC.this.data.foregroundPattern = null;
                GC.this.data.backgroundPattern = null;
                GC.this.data.state = 0;
                GC.this.setClipping(0L);
                if ((GC.this.data.style & 0x8000000) != 0) {
                    OS.SetLayout(GC.this.handle, OS.GetLayout(GC.this.handle) | 1);
                }
            }
        }
    }

    private class SetAntialiasOperation
    extends Operation {
        private final int antialias;

        SetAntialiasOperation(int antialias) {
            super(GC.this);
            this.antialias = antialias;
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && this.antialias == -1) {
                return;
            }
            int mode = 0;
            switch (this.antialias) {
                case -1: {
                    mode = 0;
                    break;
                }
                case 0: {
                    mode = 3;
                    break;
                }
                case 1: {
                    mode = 4;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            GC.this.initGdip();
            Gdip.Graphics_SetSmoothingMode(GC.this.data.gdipGraphics, mode);
        }
    }

    private class SetAlphaOperation
    extends Operation {
        private final int alpha;

        SetAlphaOperation(int alpha) {
            super(GC.this);
            this.alpha = alpha;
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && (this.alpha & 0xFF) == 255) {
                return;
            }
            GC.this.initGdip();
            GC.this.data.alpha = this.alpha & 0xFF;
            GC.this.data.state &= 0xFFFFFFFC;
            if (GC.this.data.gdipFgPatternBrushAlpha != 0L) {
                Gdip.TextureBrush_delete(GC.this.data.gdipFgPatternBrushAlpha);
                GC.this.data.gdipFgPatternBrushAlpha = 0L;
            }
            if (GC.this.data.gdipBgPatternBrushAlpha != 0L) {
                Gdip.TextureBrush_delete(GC.this.data.gdipBgPatternBrushAlpha);
                GC.this.data.gdipBgPatternBrushAlpha = 0L;
            }
        }
    }

    private class SetBackgroundOperation
    extends ReplaceableOperation {
        private final Color color;

        SetBackgroundOperation(Color color) {
            super(GC.this);
            RGB rgb = color.getRGB();
            this.color = new Color(color.getDevice(), rgb);
            this.registerForDisposal(this.color);
        }

        @Override
        void apply() {
            if (GC.this.data.backgroundPattern == null && GC.this.data.background == this.color.handle) {
                return;
            }
            GC.this.data.backgroundPattern = null;
            GC.this.data.background = this.color.handle;
            GC.this.data.state &= 0xFFFFFDFD;
        }
    }

    private class SetBackgroundPatternOperation
    extends Operation {
        private final Pattern pattern;

        SetBackgroundPatternOperation(Pattern pattern) {
            super(GC.this);
            this.pattern = pattern == null ? null : pattern.copy();
            this.registerForDisposal(this.pattern);
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && this.pattern == null) {
                return;
            }
            GC.this.initGdip();
            if (GC.this.data.backgroundPattern == this.pattern) {
                return;
            }
            GC.this.data.backgroundPattern = this.pattern;
            GC.this.data.state &= 0xFFFFFFFD;
            if (GC.this.data.gdipBgPatternBrushAlpha != 0L) {
                Gdip.TextureBrush_delete(GC.this.data.gdipBgPatternBrushAlpha);
                GC.this.data.gdipBgPatternBrushAlpha = 0L;
            }
        }
    }

    private class SetClippingOperation
    extends Operation {
        private final Rectangle rectangle;

        SetClippingOperation(Rectangle rectangle) {
            super(GC.this);
            this.rectangle = rectangle;
        }

        @Override
        void apply() {
            Rectangle rect = Win32DPIUtils.pointToPixel(GC.this.drawable, this.rectangle, GC.this.getZoom());
            GC.this.setClippingInPixels(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class SetClippingPathOperation
    extends Operation {
        private final PathData pathData;

        SetClippingPathOperation(Path path) {
            super(GC.this);
            this.pathData = path == null ? null : path.getPathData();
        }

        @Override
        void apply() {
            GC.this.setClipping(0L);
            if (this.pathData != null) {
                Path path = new Path(GC.this.device, this.pathData);
                GC.this.initGdip();
                int mode = OS.GetPolyFillMode(GC.this.handle) == 2 ? 1 : 0;
                long pathHandle = path.getHandle(GC.this.getZoom());
                Gdip.GraphicsPath_SetFillMode(pathHandle, mode);
                Gdip.Graphics_SetClipPath(GC.this.data.gdipGraphics, pathHandle);
                path.dispose();
            }
        }
    }

    private class SetClippingRegionOperation
    extends Operation {
        private final Region clipRgn;

        SetClippingRegionOperation(Region clipRgn) {
            super(GC.this);
            this.clipRgn = clipRgn != null ? clipRgn.copy() : null;
            this.registerForDisposal(this.clipRgn);
        }

        @Override
        void apply() {
            GC.this.setClippingRegion(this.clipRgn != null ? Region.win32_getHandle(this.clipRgn, GC.this.getZoom()) : 0L);
        }
    }

    private class SetFillRuleOperation
    extends Operation {
        private final int rule;

        SetFillRuleOperation(int rule) {
            super(GC.this);
            this.rule = rule;
        }

        @Override
        void apply() {
            int mode = 1;
            switch (this.rule) {
                case 2: {
                    mode = 2;
                    break;
                }
                case 1: {
                    mode = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            OS.SetPolyFillMode(GC.this.handle, mode);
        }
    }

    private class SetFontOperation
    extends ReplaceableOperation {
        private final Font font;

        SetFontOperation(Font font) {
            super(GC.this);
            this.font = font != null ? SWTFontProvider.getFont(font.getDevice(), font.getFontData()[0], GC.this.data.nativeZoom) : null;
        }

        @Override
        void apply() {
            GC.this.data.font = this.font != null ? SWTFontProvider.getFont(this.font.getDevice(), this.font.getFontData()[0], GC.this.data.nativeZoom) : SWTFontProvider.getSystemFont(GC.this.device, GC.this.data.nativeZoom);
            GC.this.data.state &= 0xFFFFFFFB;
        }
    }

    private class SetForegroundOperation
    extends ReplaceableOperation {
        private final Color color;

        SetForegroundOperation(Color color) {
            super(GC.this);
            RGB rgb = color.getRGB();
            this.color = new Color(color.getDevice(), rgb);
            this.registerForDisposal(this.color);
        }

        @Override
        void apply() {
            if (GC.this.data.foregroundPattern == null && this.color.handle == GC.this.data.foreground) {
                return;
            }
            GC.this.data.foregroundPattern = null;
            GC.this.data.foreground = this.color.handle;
            GC.this.data.state &= 0xFFFFFEFE;
        }
    }

    private class SetForegroundPatternOperation
    extends Operation {
        private final Pattern pattern;

        SetForegroundPatternOperation(Pattern pattern) {
            super(GC.this);
            this.pattern = pattern == null ? null : pattern.copy();
            this.registerForDisposal(this.pattern);
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && this.pattern == null) {
                return;
            }
            GC.this.initGdip();
            if (GC.this.data.foregroundPattern == this.pattern) {
                return;
            }
            GC.this.data.foregroundPattern = this.pattern;
            GC.this.data.state &= 0xFFFFFFFE;
            if (GC.this.data.gdipFgPatternBrushAlpha != 0L) {
                Gdip.TextureBrush_delete(GC.this.data.gdipFgPatternBrushAlpha);
                GC.this.data.gdipFgPatternBrushAlpha = 0L;
            }
        }
    }

    private class SetInterpolationOperation
    extends Operation {
        private final int interpolation;

        SetInterpolationOperation(int interpolation) {
            super(GC.this);
            this.interpolation = interpolation;
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && this.interpolation == -1) {
                return;
            }
            int mode = 0;
            switch (this.interpolation) {
                case -1: {
                    mode = 0;
                    break;
                }
                case 0: {
                    mode = 5;
                    break;
                }
                case 1: {
                    mode = 1;
                    break;
                }
                case 2: {
                    mode = 2;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            GC.this.initGdip();
            Gdip.Graphics_SetInterpolationMode(GC.this.data.gdipGraphics, mode);
        }
    }

    private class SetLineAttributesOperation
    extends ReplaceableOperation {
        private final LineAttributes attributes;

        SetLineAttributesOperation(LineAttributes attributes) {
            super(GC.this);
            this.attributes = new LineAttributes(attributes.width, attributes.cap, attributes.join, attributes.style, attributes.dash, attributes.dashOffset, attributes.miterLimit);
        }

        @Override
        void apply() {
            this.attributes.width = Win32DPIUtils.pointToPixel(GC.this.drawable, this.attributes.width, GC.this.getZoom());
            GC.this.setLineAttributesInPixels(this.attributes);
        }
    }

    private class SetLineCapOperation
    extends ReplaceableOperation {
        private final int cap;

        SetLineCapOperation(int cap) {
            super(GC.this);
            this.cap = cap;
        }

        @Override
        void apply() {
            if (GC.this.data.lineCap == this.cap) {
                return;
            }
            switch (this.cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            GC.this.data.lineCap = this.cap;
            GC.this.data.state &= 0xFFFFFFDF;
        }
    }

    private class SetLineDashOperation
    extends ReplaceableOperation {
        private final int[] dashes;

        SetLineDashOperation(int[] dashes) {
            super(GC.this);
            this.dashes = dashes == null ? null : Arrays.copyOf(dashes, dashes.length);
        }

        @Override
        void apply() {
            float[] lineDashes = GC.this.data.lineDashes;
            if (this.dashes != null && this.dashes.length > 0) {
                boolean changed = GC.this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != this.dashes.length;
                float[] newDashes = new float[this.dashes.length];
                int deviceZoom = GC.this.getZoom();
                for (int i = 0; i < this.dashes.length; ++i) {
                    if (this.dashes[i] <= 0) {
                        SWT.error(5);
                    }
                    newDashes[i] = Win32DPIUtils.pointToPixel(GC.this.drawable, (float)this.dashes[i], deviceZoom);
                    if (changed || lineDashes[i] == newDashes[i]) continue;
                    changed = true;
                }
                if (!changed) {
                    return;
                }
                GC.this.data.lineDashes = newDashes;
                GC.this.data.lineStyle = 6;
            } else {
                if (GC.this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                    return;
                }
                GC.this.data.lineDashes = null;
                GC.this.data.lineStyle = 1;
            }
            GC.this.data.state &= 0xFFFFFFF7;
        }
    }

    private class SetLineJoinOperation
    extends ReplaceableOperation {
        private final int join;

        SetLineJoinOperation(int join) {
            super(GC.this);
            this.join = join;
        }

        @Override
        void apply() {
            if (GC.this.data.lineJoin == this.join) {
                return;
            }
            switch (this.join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            GC.this.data.lineJoin = this.join;
            GC.this.data.state &= 0xFFFFFFBF;
        }
    }

    private class SetLineStyleOperation
    extends ReplaceableOperation {
        private final int lineStyle;

        SetLineStyleOperation(int lineStyle) {
            super(GC.this);
            this.lineStyle = lineStyle;
        }

        @Override
        void apply() {
            if (GC.this.data.lineStyle == this.lineStyle) {
                return;
            }
            int newLineStyle = this.lineStyle;
            switch (newLineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (GC.this.data.lineDashes != null) break;
                    newLineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            GC.this.data.lineStyle = newLineStyle;
            GC.this.data.state &= 0xFFFFFFF7;
        }
    }

    private class SetLineWidthOperation
    extends ReplaceableOperation {
        private final int width;

        SetLineWidthOperation(int width) {
            super(GC.this);
            this.width = width;
        }

        @Override
        void apply() {
            int lineWidth = Win32DPIUtils.pointToPixel(GC.this.drawable, this.width, GC.this.getZoom());
            GC.this.setLineWidthInPixels(lineWidth);
        }
    }

    private class SetXORModeOperation
    extends Operation {
        private final boolean xor;

        SetXORModeOperation(boolean xor) {
            super(GC.this);
            this.xor = xor;
        }

        @Override
        void apply() {
            OS.SetROP2(GC.this.handle, this.xor ? 7 : 13);
        }
    }

    private class SetTextAntialiasOperation
    extends Operation {
        private final int antialias;

        SetTextAntialiasOperation(int antialias) {
            super(GC.this);
            this.antialias = antialias;
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && this.antialias == -1) {
                return;
            }
            int textMode = 0;
            switch (this.antialias) {
                case -1: {
                    textMode = 0;
                    break;
                }
                case 0: {
                    textMode = 1;
                    break;
                }
                case 1: {
                    int[] type = new int[1];
                    OS.SystemParametersInfo(8202, 0, type, 0);
                    if (type[0] == 2) {
                        textMode = 5;
                        break;
                    }
                    textMode = 3;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            GC.this.initGdip();
            Gdip.Graphics_SetTextRenderingHint(GC.this.data.gdipGraphics, textMode);
        }
    }

    private class SetTransformOperation
    extends Operation {
        private final Transform transform;

        SetTransformOperation(Transform transform) {
            super(GC.this);
            if (transform != null) {
                float[] elements = new float[6];
                transform.getElements(elements);
                this.transform = new Transform(GC.this.device, elements[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
                this.registerForDisposal(this.transform);
            } else {
                this.transform = null;
            }
        }

        @Override
        void apply() {
            if (GC.this.data.gdipGraphics == 0L && this.transform == null) {
                return;
            }
            GC.this.initGdip();
            long identity = GC.this.identity();
            if (this.transform != null) {
                Gdip.Matrix_Multiply(identity, this.transform.getHandle(GC.this.getZoom()), 0);
            }
            Gdip.Graphics_SetTransform(GC.this.data.gdipGraphics, identity);
            Gdip.Matrix_delete(identity);
            GC.this.data.state &= 0xFFFFBFFF;
        }
    }

    private abstract class ReplaceableOperation
    extends Operation {
        private ReplaceableOperation(GC gC) {
            super(gC);
        }

        @Override
        boolean canBeReplacedBy(Operation operation) {
            return operation.getClass().equals(this.getClass());
        }
    }

    private abstract class ImageOperation
    extends Operation {
        private Image image;
        private final Consumer<Image> disposeCallback;

        ImageOperation(Image image) {
            super(GC.this);
            this.disposeCallback = this::setCopyOfImage;
            this.setImage(image);
            image.addOnDisposeListener(this.disposeCallback);
        }

        private void setImage(Image image) {
            this.image = image;
        }

        private void setCopyOfImage(Image image) {
            if (!GC.this.isDisposed()) {
                Image copiedImage = new Image(image.device, image, 0);
                this.setImage(copiedImage);
                this.registerForDisposal(copiedImage);
            }
        }

        protected Image getImage() {
            return this.image;
        }

        @Override
        void disposeAll() {
            this.image.removeOnDisposeListener(this.disposeCallback);
            super.disposeAll();
        }
    }
}

