/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.StringJsonLexer;

public final class StringJsonLexerWithComments
extends StringJsonLexer {
    public StringJsonLexerWithComments(String source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        super(source2);
    }

    @Override
    public byte consumeNextToken() {
        String source2 = this.getSource();
        int cpos = this.skipWhitespaces();
        if (cpos >= source2.length() || cpos == -1) {
            return 10;
        }
        this.currentPosition = cpos + 1;
        return AbstractJsonLexerKt.charToTokenClass(source2.charAt(cpos));
    }

    @Override
    public boolean canConsumeValue() {
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        return this.isValidValueStart(this.getSource().charAt(current));
    }

    @Override
    public void consumeNextToken(char expected) {
        String source2 = this.getSource();
        int current = this.skipWhitespaces();
        if (current >= source2.length() || current == -1) {
            this.currentPosition = -1;
            this.unexpectedToken(expected);
        }
        char c = source2.charAt(current);
        this.currentPosition = current + 1;
        if (c == expected) {
            return;
        }
        this.unexpectedToken(expected);
    }

    @Override
    public byte peekNextToken() {
        String source2 = this.getSource();
        int cpos = this.skipWhitespaces();
        if (cpos >= source2.length() || cpos == -1) {
            return 10;
        }
        this.currentPosition = cpos;
        return AbstractJsonLexerKt.charToTokenClass(source2.charAt(cpos));
    }

    @Override
    public int skipWhitespaces() {
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        String source2 = this.getSource();
        block4: while (current < source2.length()) {
            char c = source2.charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            if (c != '/' || current + 1 >= source2.length()) break;
            switch (source2.charAt(current + 1)) {
                case '/': {
                    current = StringsKt.indexOf$default((CharSequence)source2, '\n', current + 2, false, 4, null);
                    if (current == -1) {
                        current = source2.length();
                        continue block4;
                    }
                    ++current;
                    continue block4;
                }
                case '*': {
                    current = StringsKt.indexOf$default((CharSequence)source2, "*/", current + 2, false, 4, null);
                    if (current == -1) {
                        this.currentPosition = source2.length();
                        AbstractJsonLexer.fail$default(this, "Expected end of the block comment: \"*/\", but had EOF instead", 0, null, 6, null);
                        throw new KotlinNothingValueException();
                    }
                    current += 2;
                    continue block4;
                }
            }
            break;
        }
        this.currentPosition = current;
        return current;
    }
}

