/*
 * Decompiled with CFR 0.152.
 */
package com.syntevo.smartgit.graphql.github;

import com.apollographql.apollo.api.Adapter;
import com.apollographql.apollo.api.Adapters;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Optional;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Query$Data;
import com.apollographql.apollo.api.json.JsonWriter;
import com.syntevo.smartgit.graphql.github.adapter.IssuesQuery_ResponseAdapter;
import com.syntevo.smartgit.graphql.github.adapter.IssuesQuery_VariablesAdapter;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

public final class IssuesQuery
implements Query<Data> {
    public static final Companion Companion = new Companion(null);
    private final String user;
    private final String project;
    private final int pageSize;
    private final Optional<String> after;

    public IssuesQuery(String user, String project, int pageSize, Optional<String> after) {
        Intrinsics.checkNotNullParameter(user, "user");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(after, "after");
        this.user = user;
        this.project = project;
        this.pageSize = pageSize;
        this.after = after;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getProject() {
        return this.project;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final Optional<String> getAfter() {
        return this.after;
    }

    @Override
    public String id() {
        return "c2caaa8776cdb33ba87670a64ae5d5018a45152a0ae361cb33bd7a59dc5bbd1a";
    }

    @Override
    public String document() {
        return Companion.getOPERATION_DOCUMENT();
    }

    @Override
    public String name() {
        return "Issues";
    }

    @Override
    public void serializeVariables(JsonWriter writer, CustomScalarAdapters customScalarAdapters, boolean withDefaultValues) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        IssuesQuery_VariablesAdapter.INSTANCE.serializeVariables(writer, this, customScalarAdapters, withDefaultValues);
    }

    @Override
    public Adapter<Data> adapter() {
        return Adapters.-obj$default(IssuesQuery_ResponseAdapter.Data.INSTANCE, false, 1, null);
    }

    public String toString() {
        return "IssuesQuery(user=" + this.user + ", project=" + this.project + ", pageSize=" + this.pageSize + ", after=" + this.after + ")";
    }

    public int hashCode() {
        int result2 = this.user.hashCode();
        result2 = result2 * 31 + this.project.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + this.after.hashCode();
        return result2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IssuesQuery)) {
            return false;
        }
        IssuesQuery issuesQuery = (IssuesQuery)other;
        if (!Intrinsics.areEqual(this.user, issuesQuery.user)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.project, issuesQuery.project)) {
            return false;
        }
        if (this.pageSize != issuesQuery.pageSize) {
            return false;
        }
        return Intrinsics.areEqual(this.after, issuesQuery.after);
    }

    public static final class Companion {
        private Companion() {
        }

        public final String getOPERATION_DOCUMENT() {
            return "query Issues($user: String!, $project: String!, $pageSize: Int!, $after: String) { repository(owner: $user, name: $project) { issues(states: OPEN, first: $pageSize, after: $after, orderBy: { field: UPDATED_AT direction: DESC } ) { __typename ...Issues } } }  fragment Pagination on PageInfo { hasNextPage endCursor }  fragment IssueNode on Issue { id number title state }  fragment Issues on IssueConnection { pageInfo { __typename ...Pagination } edges { node { __typename ...IssueNode } } }";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Data
    implements Query$Data {
        private final Repository repository;

        public Data(Repository repository) {
            this.repository = repository;
        }

        public final Repository getRepository() {
            return this.repository;
        }

        public String toString() {
            return "Data(repository=" + this.repository + ")";
        }

        public int hashCode() {
            return this.repository == null ? 0 : this.repository.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return Intrinsics.areEqual(this.repository, data.repository);
        }
    }

    public static final class Issues {
        private final String __typename;
        private final com.syntevo.smartgit.graphql.github.fragment.Issues issues;

        public Issues(String __typename, com.syntevo.smartgit.graphql.github.fragment.Issues issues) {
            Intrinsics.checkNotNullParameter(__typename, "__typename");
            Intrinsics.checkNotNullParameter(issues, "issues");
            this.__typename = __typename;
            this.issues = issues;
        }

        public final String get__typename() {
            return this.__typename;
        }

        public final com.syntevo.smartgit.graphql.github.fragment.Issues getIssues() {
            return this.issues;
        }

        public String toString() {
            return "Issues(__typename=" + this.__typename + ", issues=" + this.issues + ")";
        }

        public int hashCode() {
            int result2 = this.__typename.hashCode();
            result2 = result2 * 31 + this.issues.hashCode();
            return result2;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Issues)) {
                return false;
            }
            Issues issues = (Issues)other;
            if (!Intrinsics.areEqual(this.__typename, issues.__typename)) {
                return false;
            }
            return Intrinsics.areEqual(this.issues, issues.issues);
        }
    }

    public static final class Repository {
        private final Issues issues;

        public Repository(Issues issues) {
            Intrinsics.checkNotNullParameter(issues, "issues");
            this.issues = issues;
        }

        public final Issues getIssues() {
            return this.issues;
        }

        public String toString() {
            return "Repository(issues=" + this.issues + ")";
        }

        public int hashCode() {
            return this.issues.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Repository)) {
                return false;
            }
            Repository repository = (Repository)other;
            return Intrinsics.areEqual(this.issues, repository.issues);
        }
    }
}

