/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.StreamResetException;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http2Stream {
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final Http2Connection connection;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final ArrayDeque<Headers> headersQueue;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    private final FramingSink sink;
    private final StreamTimeout readTimeout;
    private final StreamTimeout writeTimeout;
    private ErrorCode errorCode;
    private IOException errorException;

    public Http2Stream(int id, Http2Connection connection, boolean outFinished, boolean inFinished, Headers headers) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        this.id = id;
        this.connection = connection;
        this.writeBytesMaximum = this.connection.getPeerSettings().getInitialWindowSize();
        this.headersQueue = new ArrayDeque();
        this.source = new FramingSource(this.connection.getOkHttpSettings().getInitialWindowSize(), inFinished);
        this.sink = new FramingSink(outFinished);
        this.readTimeout = new StreamTimeout();
        this.writeTimeout = new StreamTimeout();
        if (headers != null) {
            if (!(!this.isLocallyInitiated())) {
                boolean $i$a$-check-Http2Stream$32 = false;
                String $i$a$-check-Http2Stream$32 = "locally-initiated streams shouldn't have headers yet";
                throw new IllegalStateException($i$a$-check-Http2Stream$32.toString());
            }
            ((Collection)this.headersQueue).add(headers);
        } else if (!this.isLocallyInitiated()) {
            boolean bl = false;
            String string = "remotely-initiated streams should have headers";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getId() {
        return this.id;
    }

    public final Http2Connection getConnection() {
        return this.connection;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    public final void setReadBytesTotal$okhttp(long l) {
        this.readBytesTotal = l;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    public final void setReadBytesAcknowledged$okhttp(long l) {
        this.readBytesAcknowledged = l;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final void setWriteBytesTotal$okhttp(long l) {
        this.writeBytesTotal = l;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final FramingSource getSource$okhttp() {
        return this.source;
    }

    public final FramingSink getSink$okhttp() {
        return this.sink;
    }

    public final StreamTimeout getReadTimeout$okhttp() {
        return this.readTimeout;
    }

    public final StreamTimeout getWriteTimeout$okhttp() {
        return this.writeTimeout;
    }

    public final synchronized ErrorCode getErrorCode$okhttp() {
        return this.errorCode;
    }

    public final void setErrorCode$okhttp(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public final IOException getErrorException$okhttp() {
        return this.errorException;
    }

    public final void setErrorException$okhttp(IOException iOException) {
        this.errorException = iOException;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.getFinished$okhttp() && !this.source.getClosed$okhttp() || !this.sink.getFinished() && !this.sink.getClosed() || !this.hasResponseHeaders;
    }

    public final boolean isLocallyInitiated() {
        boolean streamIsClient = (this.id & 1) == 1;
        return this.connection.getClient$okhttp() == streamIsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Headers takeHeaders() throws IOException {
        Throwable throwable;
        this.readTimeout.enter();
        try {
            while (this.headersQueue.isEmpty() && this.errorCode == null) {
                this.waitForIo$okhttp();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (!((Collection)this.headersQueue).isEmpty()) {
            Headers headers = this.headersQueue.removeFirst();
            Intrinsics.checkNotNullExpressionValue(headers, "headersQueue.removeFirst()");
            return headers;
        }
        IOException iOException = this.errorException;
        if (iOException == null) {
            ErrorCode errorCode = this.errorCode;
            Intrinsics.checkNotNull((Object)errorCode);
            throwable = new StreamResetException(errorCode);
        } else {
            throwable = iOException;
        }
        throw throwable;
    }

    public final Timeout readTimeout() {
        return this.readTimeout;
    }

    public final Timeout writeTimeout() {
        return this.writeTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean bl = false;
            if (!(this.hasResponseHeaders || this.isLocallyInitiated())) {
                boolean bl2 = false;
                String string = "reply before requesting the sink";
                throw new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.sink;
    }

    public final void close(ErrorCode rstStatusCode, IOException errorException) throws IOException {
        Intrinsics.checkNotNullParameter((Object)rstStatusCode, "rstStatusCode");
        if (!this.closeInternal(rstStatusCode, errorException)) {
            return;
        }
        this.connection.writeSynReset$okhttp(this.id, rstStatusCode);
    }

    public final void closeLater(ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater$okhttp(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean closeInternal(ErrorCode errorCode, IOException errorException) {
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            block7: {
                block6: {
                    boolean bl = false;
                    if (this.getErrorCode$okhttp() == null) break block6;
                    boolean bl2 = false;
                    return bl2;
                }
                if (!this.getSource$okhttp().getFinished$okhttp() || !this.getSink$okhttp().getFinished()) break block7;
                boolean bl = false;
                return bl;
            }
            this.setErrorCode$okhttp(errorCode);
            this.setErrorException$okhttp(errorException);
            Http2Stream $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            ((Object)$this$notifyAll$iv).notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        this.connection.removeStream$okhttp(this.id);
        return true;
    }

    public final void receiveData(BufferedSource source2, int length) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        this.source.receive$okhttp(source2, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveHeaders(Headers headers, boolean inFinished) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        boolean open2 = false;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean bl = false;
            if (!this.hasResponseHeaders || !inFinished) {
                this.hasResponseHeaders = true;
                ((Collection)this.headersQueue).add(headers);
            } else {
                this.getSource$okhttp().setTrailers(headers);
            }
            if (inFinished) {
                this.getSource$okhttp().setFinished$okhttp(true);
            }
            open2 = this.isOpen();
            Http2Stream $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            ((Object)$this$notifyAll$iv).notifyAll();
            Unit unit = Unit.INSTANCE;
        }
        if (!open2) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    public final synchronized void receiveRstStream(ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            Http2Stream $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            ((Object)$this$notifyAll$iv).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelStreamIfNecessary$okhttp() throws IOException {
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        boolean open2 = false;
        boolean cancel = false;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            boolean bl = false;
            cancel = !this.getSource$okhttp().getFinished$okhttp() && this.getSource$okhttp().getClosed$okhttp() && (this.getSink$okhttp().getFinished() || this.getSink$okhttp().getClosed());
            open2 = this.isOpen();
            Unit unit = Unit.INSTANCE;
        }
        if (cancel) {
            this.close(ErrorCode.CANCEL, null);
        } else if (!open2) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    public final void addBytesToWriteWindow(long delta) {
        this.writeBytesMaximum += delta;
        if (delta > 0L) {
            Http2Stream $this$notifyAll$iv = this;
            boolean $i$f$notifyAll = false;
            ((Object)$this$notifyAll$iv).notifyAll();
        }
    }

    public final void checkOutNotClosed$okhttp() throws IOException {
        if (this.sink.getClosed()) {
            throw new IOException("stream closed");
        }
        if (this.sink.getFinished()) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            Throwable throwable;
            IOException iOException = this.errorException;
            if (iOException == null) {
                ErrorCode errorCode = this.errorCode;
                Intrinsics.checkNotNull((Object)errorCode);
                throwable = new StreamResetException(errorCode);
            } else {
                throwable = iOException;
            }
            throw throwable;
        }
    }

    public final void waitForIo$okhttp() throws InterruptedIOException {
        try {
            Http2Stream $this$wait$iv = this;
            boolean $i$f$wait = false;
            ((Object)$this$wait$iv).wait();
        }
        catch (InterruptedException _) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    public final class FramingSource
    implements Source {
        private final long maxByteCount;
        private boolean finished;
        private final Buffer receiveBuffer;
        private final Buffer readBuffer;
        private Headers trailers;
        private boolean closed;

        public FramingSource(long maxByteCount, boolean finished) {
            Intrinsics.checkNotNullParameter(Http2Stream.this, "this$0");
            this.maxByteCount = maxByteCount;
            this.finished = finished;
            this.receiveBuffer = new Buffer();
            this.readBuffer = new Buffer();
        }

        public final boolean getFinished$okhttp() {
            return this.finished;
        }

        public final void setFinished$okhttp(boolean bl) {
            this.finished = bl;
        }

        public final Buffer getReceiveBuffer() {
            return this.receiveBuffer;
        }

        public final Buffer getReadBuffer() {
            return this.readBuffer;
        }

        public final void setTrailers(Headers headers) {
            this.trailers = headers;
        }

        public final boolean getClosed$okhttp() {
            return this.closed;
        }

        public final void setClosed$okhttp(boolean bl) {
            this.closed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer sink2, long byteCount) throws IOException {
            IOException errorExceptionToDeliver;
            long readBytesDelivered;
            boolean tryAgain;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean bl = false;
                String string = Intrinsics.stringPlus("byteCount < 0: ", byteCount);
                throw new IllegalArgumentException(string.toString());
            }
            do {
                tryAgain = false;
                readBytesDelivered = 0L;
                readBytesDelivered = -1L;
                errorExceptionToDeliver = null;
                Http2Stream http2Stream = Http2Stream.this;
                Http2Stream http2Stream2 = Http2Stream.this;
                Http2Stream http2Stream3 = http2Stream;
                synchronized (http2Stream3) {
                    boolean bl = false;
                    http2Stream2.getReadTimeout$okhttp().enter();
                    try {
                        IOException iOException;
                        if (http2Stream2.getErrorCode$okhttp() != null && !this.getFinished$okhttp() && (iOException = http2Stream2.getErrorException$okhttp()) == null) {
                            ErrorCode errorCode = http2Stream2.getErrorCode$okhttp();
                            Intrinsics.checkNotNull((Object)errorCode);
                            iOException = errorExceptionToDeliver = (IOException)new StreamResetException(errorCode);
                        }
                        if (this.getClosed$okhttp()) {
                            throw new IOException("stream closed");
                        }
                        if (this.getReadBuffer().size() > 0L) {
                            long l = this.getReadBuffer().size();
                            readBytesDelivered = this.getReadBuffer().read(sink2, Math.min(byteCount, l));
                            http2Stream2.setReadBytesTotal$okhttp(http2Stream2.getReadBytesTotal() + readBytesDelivered);
                            long unacknowledgedBytesRead = http2Stream2.getReadBytesTotal() - http2Stream2.getReadBytesAcknowledged();
                            if (errorExceptionToDeliver == null && unacknowledgedBytesRead >= (long)(http2Stream2.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                                http2Stream2.getConnection().writeWindowUpdateLater$okhttp(http2Stream2.getId(), unacknowledgedBytesRead);
                                http2Stream2.setReadBytesAcknowledged$okhttp(http2Stream2.getReadBytesTotal());
                            }
                        } else if (!this.getFinished$okhttp() && errorExceptionToDeliver == null) {
                            http2Stream2.waitForIo$okhttp();
                            tryAgain = true;
                        }
                    }
                    finally {
                        http2Stream2.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            } while (tryAgain);
            if (readBytesDelivered != -1L) {
                this.updateConnectionFlowControl(readBytesDelivered);
                return readBytesDelivered;
            }
            if (errorExceptionToDeliver != null) {
                throw (Throwable)errorExceptionToDeliver;
            }
            return -1L;
        }

        private final void updateConnectionFlowControl(long read) {
            Http2Stream $this$assertThreadDoesntHoldLock$iv = Http2Stream.this;
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            Http2Stream.this.getConnection().updateConnectionFlowControl$okhttp(read);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void receive$okhttp(BufferedSource source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Http2Stream $this$assertThreadDoesntHoldLock$iv = Http2Stream.this;
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            long byteCount2 = 0L;
            byteCount2 = byteCount;
            while (byteCount2 > 0L) {
                boolean finished = false;
                boolean flowControlError = false;
                Http2Stream http2Stream = Http2Stream.this;
                synchronized (http2Stream) {
                    boolean bl = false;
                    finished = this.getFinished$okhttp();
                    flowControlError = byteCount2 + this.getReadBuffer().size() > this.maxByteCount;
                    Unit unit = Unit.INSTANCE;
                }
                if (flowControlError) {
                    source2.skip(byteCount2);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (finished) {
                    source2.skip(byteCount2);
                    return;
                }
                long read = source2.read(this.receiveBuffer, byteCount2);
                if (read == -1L) {
                    throw new EOFException();
                }
                byteCount2 -= read;
                long bytesDiscarded = 0L;
                Http2Stream http2Stream2 = Http2Stream.this;
                Http2Stream http2Stream3 = Http2Stream.this;
                Http2Stream http2Stream4 = http2Stream2;
                synchronized (http2Stream4) {
                    boolean bl = false;
                    if (this.getClosed$okhttp()) {
                        bytesDiscarded = this.getReceiveBuffer().size();
                        this.getReceiveBuffer().clear();
                    } else {
                        boolean wasEmpty = this.getReadBuffer().size() == 0L;
                        this.getReadBuffer().writeAll(this.getReceiveBuffer());
                        if (wasEmpty) {
                            Http2Stream $this$notifyAll$iv = http2Stream3;
                            boolean $i$f$notifyAll = false;
                            ((Object)$this$notifyAll$iv).notifyAll();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (bytesDiscarded <= 0L) continue;
                this.updateConnectionFlowControl(bytesDiscarded);
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.getReadTimeout$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            long bytesDiscarded = 0L;
            Http2Stream http2Stream = Http2Stream.this;
            Http2Stream http2Stream2 = Http2Stream.this;
            Http2Stream http2Stream3 = http2Stream;
            synchronized (http2Stream3) {
                boolean bl = false;
                this.setClosed$okhttp(true);
                bytesDiscarded = this.getReadBuffer().size();
                this.getReadBuffer().clear();
                Http2Stream $this$notifyAll$iv = http2Stream2;
                boolean $i$f$notifyAll = false;
                ((Object)$this$notifyAll$iv).notifyAll();
                Unit unit = Unit.INSTANCE;
            }
            if (bytesDiscarded > 0L) {
                this.updateConnectionFlowControl(bytesDiscarded);
            }
            Http2Stream.this.cancelStreamIfNecessary$okhttp();
        }
    }

    public final class FramingSink
    implements Sink {
        private boolean finished;
        private final Buffer sendBuffer;
        private Headers trailers;
        private boolean closed;

        public FramingSink(boolean finished) {
            Intrinsics.checkNotNullParameter(Http2Stream.this, "this$0");
            this.finished = finished;
            this.sendBuffer = new Buffer();
        }

        public final boolean getFinished() {
            return this.finished;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public void write(Buffer source2, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            Http2Stream $this$assertThreadDoesntHoldLock$iv = Http2Stream.this;
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            this.sendBuffer.write(source2, byteCount);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void emitFrame(boolean outFinishedOnLastFrame) throws IOException {
            long toWrite = 0L;
            boolean outFinished = false;
            Http2Stream http2Stream = Http2Stream.this;
            Http2Stream http2Stream2 = Http2Stream.this;
            Http2Stream http2Stream3 = http2Stream;
            synchronized (http2Stream3) {
                boolean bl = false;
                http2Stream2.getWriteTimeout$okhttp().enter();
                try {
                    while (http2Stream2.getWriteBytesTotal() >= http2Stream2.getWriteBytesMaximum() && !this.getFinished() && !this.getClosed() && http2Stream2.getErrorCode$okhttp() == null) {
                        http2Stream2.waitForIo$okhttp();
                    }
                }
                finally {
                    http2Stream2.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
                }
                http2Stream2.checkOutNotClosed$okhttp();
                toWrite = Math.min(http2Stream2.getWriteBytesMaximum() - http2Stream2.getWriteBytesTotal(), this.sendBuffer.size());
                http2Stream2.setWriteBytesTotal$okhttp(http2Stream2.getWriteBytesTotal() + toWrite);
                outFinished = outFinishedOnLastFrame && toWrite == this.sendBuffer.size();
                Unit unit = Unit.INSTANCE;
            }
            Http2Stream.this.getWriteTimeout$okhttp().enter();
            try {
                Http2Stream.this.getConnection().writeData(Http2Stream.this.getId(), outFinished, this.sendBuffer, toWrite);
            }
            finally {
                Http2Stream.this.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Http2Stream $this$assertThreadDoesntHoldLock$iv = Http2Stream.this;
            boolean $i$f$assertThreadDoesntHoldLock = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            Http2Stream http2Stream = Http2Stream.this;
            Http2Stream http2Stream2 = Http2Stream.this;
            Http2Stream http2Stream3 = http2Stream;
            synchronized (http2Stream3) {
                boolean bl = false;
                http2Stream2.checkOutNotClosed$okhttp();
                Unit unit = Unit.INSTANCE;
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                Http2Stream.this.getConnection().flush();
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.getWriteTimeout$okhttp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Http2Stream $this$assertThreadDoesntHoldLock$iv = Http2Stream.this;
            boolean $i$f$assertThreadDoesntHoldLock22 = false;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            boolean outFinished = false;
            Http2Stream $i$f$assertThreadDoesntHoldLock22 = Http2Stream.this;
            Http2Stream http2Stream = Http2Stream.this;
            Http2Stream http2Stream2 = $i$f$assertThreadDoesntHoldLock22;
            synchronized (http2Stream2) {
                boolean bl = false;
                if (this.getClosed()) {
                    return;
                }
                outFinished = http2Stream.getErrorCode$okhttp() == null;
                Unit unit = Unit.INSTANCE;
            }
            if (!Http2Stream.this.getSink$okhttp().finished) {
                boolean hasData = this.sendBuffer.size() > 0L;
                boolean hasTrailers = this.trailers != null;
                if (hasTrailers) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Connection http2Connection = Http2Stream.this.getConnection();
                    int n = Http2Stream.this.getId();
                    Headers headers = this.trailers;
                    Intrinsics.checkNotNull(headers);
                    http2Connection.writeHeaders$okhttp(n, outFinished, Util.toHeaderList(headers));
                } else if (hasData) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else if (outFinished) {
                    Http2Stream.this.getConnection().writeData(Http2Stream.this.getId(), true, null, 0L);
                }
            }
            Http2Stream http2Stream3 = Http2Stream.this;
            synchronized (http2Stream3) {
                boolean bl = false;
                this.setClosed(true);
                Unit unit = Unit.INSTANCE;
            }
            Http2Stream.this.getConnection().flush();
            Http2Stream.this.cancelStreamIfNecessary$okhttp();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class StreamTimeout
    extends AsyncTimeout {
        public StreamTimeout() {
            Intrinsics.checkNotNullParameter(Http2Stream.this, "this$0");
        }

        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
            Http2Stream.this.getConnection().sendDegradedPingLater$okhttp();
        }

        @Override
        protected IOException newTimeoutException(IOException cause) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException $this$newTimeoutException_u24lambda_u2d0 = socketTimeoutException = new SocketTimeoutException("timeout");
            boolean bl = false;
            if (cause != null) {
                $this$newTimeoutException_u24lambda_u2d0.initCause(cause);
            }
            return socketTimeoutException;
        }

        public final void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }
}

