/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

public final class ArrayDeque<E>
extends AbstractMutableList<E> {
    public static final Companion Companion = new Companion(null);
    private int head;
    private Object[] elementData = emptyElementData;
    private int size;
    private static final Object[] emptyElementData = new Object[0];

    @Override
    public int getSize() {
        return this.size;
    }

    private final void ensureCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Deque is too big.");
        }
        if (minCapacity <= this.elementData.length) {
            return;
        }
        if (this.elementData == emptyElementData) {
            this.elementData = new Object[RangesKt.coerceAtLeast(minCapacity, 10)];
            return;
        }
        int newCapacity = AbstractList.Companion.newCapacity$kotlin_stdlib(this.elementData.length, minCapacity);
        this.copyElements(newCapacity);
    }

    private final void copyElements(int newCapacity) {
        Object[] newElements = new Object[newCapacity];
        ArraysKt.copyInto(this.elementData, newElements, 0, this.head, this.elementData.length);
        ArraysKt.copyInto(this.elementData, newElements, this.elementData.length - this.head, 0, this.head);
        this.head = 0;
        this.elementData = newElements;
    }

    private final int positiveMod(int index) {
        return index >= this.elementData.length ? index - this.elementData.length : index;
    }

    private final int negativeMod(int index) {
        return index < 0 ? index + this.elementData.length : index;
    }

    private final int incremented(int index) {
        return index == ArraysKt.getLastIndex(this.elementData) ? 0 : index + 1;
    }

    private final int decremented(int index) {
        return index == 0 ? ArraysKt.getLastIndex(this.elementData) : index - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final void addFirst(E element) {
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        this.head = this.decremented(this.head);
        this.elementData[this.head] = element;
        this.size = this.size() + 1;
    }

    @Override
    public final void addLast(E element) {
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        ArrayDeque arrayDeque = this;
        this.elementData[arrayDeque.positiveMod((int)(arrayDeque.head + this.size()))] = element;
        this.size = this.size() + 1;
    }

    @Override
    public final E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        Object element = this.elementData[this.head];
        this.elementData[this.head] = null;
        this.head = this.incremented(this.head);
        this.size = this.size() - 1;
        return (E)element;
    }

    public final E removeFirstOrNull() {
        return this.isEmpty() ? null : (E)this.removeFirst();
    }

    @Override
    public final E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("ArrayDeque is empty.");
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int internalLastIndex = arrayDeque.positiveMod(arrayDeque.head + CollectionsKt.getLastIndex(this));
        Object element = this.elementData[internalLastIndex];
        this.elementData[internalLastIndex] = null;
        this.size = this.size() - 1;
        return (E)element;
    }

    public final E removeLastOrNull() {
        return this.isEmpty() ? null : (E)this.removeLast();
    }

    @Override
    public boolean add(E element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.size());
        if (index == this.size()) {
            this.addLast(element);
            return;
        }
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        this.registerModification();
        this.ensureCapacity(this.size() + 1);
        ArrayDeque arrayDeque = this;
        int internalIndex = arrayDeque.positiveMod(arrayDeque.head + index);
        if (index < this.size() + 1 >> 1) {
            int decrementedInternalIndex = this.decremented(internalIndex);
            int decrementedHead = this.decremented(this.head);
            if (decrementedInternalIndex >= this.head) {
                this.elementData[decrementedHead] = this.elementData[this.head];
                ArraysKt.copyInto(this.elementData, this.elementData, this.head, this.head + 1, decrementedInternalIndex + 1);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head - 1, this.head, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, decrementedInternalIndex + 1);
            }
            this.elementData[decrementedInternalIndex] = element;
            this.head = decrementedHead;
        } else {
            ArrayDeque arrayDeque2 = this;
            int tail = arrayDeque2.positiveMod(arrayDeque2.head + this.size());
            if (internalIndex < tail) {
                ArraysKt.copyInto(this.elementData, this.elementData, internalIndex + 1, internalIndex, tail);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, tail);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                ArraysKt.copyInto(this.elementData, this.elementData, internalIndex + 1, internalIndex, this.elementData.length - 1);
            }
            this.elementData[internalIndex] = element;
        }
        this.size = this.size() + 1;
    }

    private final void copyCollectionElements(int internalIndex, Collection<? extends E> elements) {
        int index;
        Iterator<E> iterator2 = elements.iterator();
        int n = this.elementData.length;
        for (index = internalIndex; index < n && iterator2.hasNext(); ++index) {
            this.elementData[index] = iterator2.next();
        }
        n = this.head;
        for (index = 0; index < n && iterator2.hasNext(); ++index) {
            this.elementData[index] = iterator2.next();
        }
        this.size = this.size() + elements.size();
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (elements.isEmpty()) {
            return false;
        }
        this.registerModification();
        this.ensureCapacity(this.size() + elements.size());
        ArrayDeque arrayDeque = this;
        this.copyCollectionElements(arrayDeque.positiveMod(arrayDeque.head + this.size()), elements);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.size());
        if (elements.isEmpty()) {
            return false;
        }
        if (index == this.size()) {
            return this.addAll(elements);
        }
        this.registerModification();
        this.ensureCapacity(this.size() + elements.size());
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        ArrayDeque arrayDeque2 = this;
        int internalIndex = arrayDeque2.positiveMod(arrayDeque2.head + index);
        int elementsSize = elements.size();
        if (index < this.size() + 1 >> 1) {
            int shiftedHead = this.head - elementsSize;
            if (internalIndex >= this.head) {
                if (shiftedHead >= 0) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, internalIndex);
                } else {
                    int shiftToBack = this.elementData.length - (shiftedHead += this.elementData.length);
                    int elementsToShift = internalIndex - this.head;
                    if (shiftToBack >= elementsToShift) {
                        ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, internalIndex);
                    } else {
                        ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, this.head + shiftToBack);
                        ArraysKt.copyInto(this.elementData, this.elementData, 0, this.head + shiftToBack, internalIndex);
                    }
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, shiftedHead, this.head, this.elementData.length);
                if (elementsSize >= internalIndex) {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - elementsSize, 0, internalIndex);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, this.elementData.length - elementsSize, 0, elementsSize);
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, elementsSize, internalIndex);
                }
            }
            this.head = shiftedHead;
            this.copyCollectionElements(this.negativeMod(internalIndex - elementsSize), elements);
        } else {
            int shiftedInternalIndex = internalIndex + elementsSize;
            if (internalIndex < tail) {
                if (tail + elementsSize <= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex, internalIndex, tail);
                } else if (shiftedInternalIndex >= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex - this.elementData.length, internalIndex, tail);
                } else {
                    int shiftToFront = tail + elementsSize - this.elementData.length;
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, tail - shiftToFront, tail);
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex, internalIndex, tail - shiftToFront);
                }
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, elementsSize, 0, tail);
                if (shiftedInternalIndex >= this.elementData.length) {
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex - this.elementData.length, internalIndex, this.elementData.length);
                } else {
                    ArraysKt.copyInto(this.elementData, this.elementData, 0, this.elementData.length - elementsSize, this.elementData.length);
                    ArraysKt.copyInto(this.elementData, this.elementData, shiftedInternalIndex, internalIndex, this.elementData.length - elementsSize);
                }
            }
            this.copyCollectionElements(internalIndex, elements);
        }
        return true;
    }

    @Override
    public E get(int index) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.size());
        ArrayDeque arrayDeque = this;
        return (E)this.elementData[arrayDeque.positiveMod(arrayDeque.head + index)];
    }

    @Override
    public E set(int index, E element) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.size());
        ArrayDeque arrayDeque = this;
        int internalIndex = arrayDeque.positiveMod(arrayDeque.head + index);
        Object oldElement = this.elementData[internalIndex];
        this.elementData[internalIndex] = element;
        return (E)oldElement;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public int indexOf(Object element) {
        block4: {
            int index;
            int tail;
            block3: {
                ArrayDeque arrayDeque = this;
                tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
                if (this.head >= tail) break block3;
                for (int index2 = this.head; index2 < tail; ++index2) {
                    if (!Intrinsics.areEqual(element, this.elementData[index2])) continue;
                    return index2 - this.head;
                }
                break block4;
            }
            if (this.head < tail) break block4;
            int n = this.elementData.length;
            for (index = this.head; index < n; ++index) {
                if (!Intrinsics.areEqual(element, this.elementData[index])) continue;
                return index - this.head;
            }
            for (index = 0; index < tail; ++index) {
                if (!Intrinsics.areEqual(element, this.elementData[index])) continue;
                return index + this.elementData.length - this.head;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < tail) {
            int n = this.head;
            int index = tail - 1;
            if (n <= index) {
                while (true) {
                    if (Intrinsics.areEqual(element, this.elementData[index])) {
                        return index - this.head;
                    }
                    if (index != n) {
                        --index;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.head > tail) {
            int index;
            for (index = tail - 1; -1 < index; --index) {
                if (!Intrinsics.areEqual(element, this.elementData[index])) continue;
                return index + this.elementData.length - this.head;
            }
            int n = this.head;
            index = ArraysKt.getLastIndex(this.elementData);
            if (n <= index) {
                while (true) {
                    if (Intrinsics.areEqual(element, this.elementData[index])) {
                        return index - this.head;
                    }
                    if (index == n) break;
                    --index;
                }
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public E removeAt(int index) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.size());
        if (index == CollectionsKt.getLastIndex(this)) {
            return this.removeLast();
        }
        if (index == 0) {
            return this.removeFirst();
        }
        this.registerModification();
        ArrayDeque arrayDeque = this;
        int internalIndex = arrayDeque.positiveMod(arrayDeque.head + index);
        Object element = this.elementData[internalIndex];
        if (index < this.size() >> 1) {
            if (internalIndex >= this.head) {
                ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, internalIndex);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, 1, 0, internalIndex);
                this.elementData[0] = this.elementData[this.elementData.length - 1];
                ArraysKt.copyInto(this.elementData, this.elementData, this.head + 1, this.head, this.elementData.length - 1);
            }
            this.elementData[this.head] = null;
            this.head = this.incremented(this.head);
        } else {
            ArrayDeque arrayDeque2 = this;
            int internalLastIndex = arrayDeque2.positiveMod(arrayDeque2.head + CollectionsKt.getLastIndex(this));
            if (internalIndex <= internalLastIndex) {
                ArraysKt.copyInto(this.elementData, this.elementData, internalIndex, internalIndex + 1, internalLastIndex + 1);
            } else {
                ArraysKt.copyInto(this.elementData, this.elementData, internalIndex, internalIndex + 1, this.elementData.length);
                this.elementData[this.elementData.length - 1] = this.elementData[0];
                ArraysKt.copyInto(this.elementData, this.elementData, 0, 1, internalLastIndex + 1);
            }
            this.elementData[internalLastIndex] = null;
        }
        this.size = this.size() - 1;
        return (E)element;
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        boolean bl;
        Intrinsics.checkNotNullParameter(elements, "elements");
        ArrayDeque this_$iv = this;
        boolean $i$f$filterInPlace = false;
        if (this_$iv.isEmpty() || this_$iv.elementData.length == 0) {
            bl = false;
        } else {
            ArrayDeque arrayDeque = this_$iv;
            int tail$iv = arrayDeque.positiveMod(arrayDeque.head + this_$iv.size());
            int newTail$iv = this_$iv.head;
            boolean modified$iv = false;
            if (this_$iv.head < tail$iv) {
                for (int index$iv = this_$iv.head; index$iv < tail$iv; ++index$iv) {
                    Object element$iv;
                    Object it = element$iv = this_$iv.elementData[index$iv];
                    boolean bl2 = false;
                    if (!elements.contains(it)) {
                        this_$iv.elementData[newTail$iv++] = element$iv;
                        continue;
                    }
                    modified$iv = true;
                }
                ArraysKt.fill(this_$iv.elementData, null, newTail$iv, tail$iv);
            } else {
                boolean bl3;
                Object it;
                int index$iv;
                int element$iv = this_$iv.elementData.length;
                for (index$iv = this_$iv.head; index$iv < element$iv; ++index$iv) {
                    Object element$iv2 = this_$iv.elementData[index$iv];
                    this_$iv.elementData[index$iv] = null;
                    it = element$iv2;
                    bl3 = false;
                    if (!elements.contains(it)) {
                        this_$iv.elementData[newTail$iv++] = element$iv2;
                        continue;
                    }
                    modified$iv = true;
                }
                newTail$iv = this_$iv.positiveMod(newTail$iv);
                for (index$iv = 0; index$iv < tail$iv; ++index$iv) {
                    Object element$iv3 = this_$iv.elementData[index$iv];
                    this_$iv.elementData[index$iv] = null;
                    it = element$iv3;
                    bl3 = false;
                    if (!elements.contains(it)) {
                        this_$iv.elementData[newTail$iv] = element$iv3;
                        newTail$iv = this_$iv.incremented(newTail$iv);
                        continue;
                    }
                    modified$iv = true;
                }
            }
            if (modified$iv) {
                this_$iv.registerModification();
                this_$iv.size = this_$iv.negativeMod(newTail$iv - this_$iv.head);
            }
            bl = modified$iv;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        boolean bl;
        Intrinsics.checkNotNullParameter(elements, "elements");
        ArrayDeque this_$iv = this;
        boolean $i$f$filterInPlace = false;
        if (this_$iv.isEmpty() || this_$iv.elementData.length == 0) {
            bl = false;
        } else {
            ArrayDeque arrayDeque = this_$iv;
            int tail$iv = arrayDeque.positiveMod(arrayDeque.head + this_$iv.size());
            int newTail$iv = this_$iv.head;
            boolean modified$iv = false;
            if (this_$iv.head < tail$iv) {
                for (int index$iv = this_$iv.head; index$iv < tail$iv; ++index$iv) {
                    Object element$iv;
                    Object it = element$iv = this_$iv.elementData[index$iv];
                    boolean bl2 = false;
                    if (elements.contains(it)) {
                        this_$iv.elementData[newTail$iv++] = element$iv;
                        continue;
                    }
                    modified$iv = true;
                }
                ArraysKt.fill(this_$iv.elementData, null, newTail$iv, tail$iv);
            } else {
                boolean bl3;
                Object it;
                int index$iv;
                int element$iv = this_$iv.elementData.length;
                for (index$iv = this_$iv.head; index$iv < element$iv; ++index$iv) {
                    Object element$iv2 = this_$iv.elementData[index$iv];
                    this_$iv.elementData[index$iv] = null;
                    it = element$iv2;
                    bl3 = false;
                    if (elements.contains(it)) {
                        this_$iv.elementData[newTail$iv++] = element$iv2;
                        continue;
                    }
                    modified$iv = true;
                }
                newTail$iv = this_$iv.positiveMod(newTail$iv);
                for (index$iv = 0; index$iv < tail$iv; ++index$iv) {
                    Object element$iv3 = this_$iv.elementData[index$iv];
                    this_$iv.elementData[index$iv] = null;
                    it = element$iv3;
                    bl3 = false;
                    if (elements.contains(it)) {
                        this_$iv.elementData[newTail$iv] = element$iv3;
                        newTail$iv = this_$iv.incremented(newTail$iv);
                        continue;
                    }
                    modified$iv = true;
                }
            }
            if (modified$iv) {
                this_$iv.registerModification();
                this_$iv.size = this_$iv.negativeMod(newTail$iv - this_$iv.head);
            }
            bl = modified$iv;
        }
        return bl;
    }

    @Override
    public void clear() {
        if (!((Collection)this).isEmpty()) {
            this.registerModification();
            ArrayDeque arrayDeque = this;
            int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
            this.nullifyNonEmpty(this.head, tail);
        }
        this.head = 0;
        this.size = 0;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        Object[] dest = array.length >= this.size() ? array : ArraysKt.arrayOfNulls(array, this.size());
        ArrayDeque arrayDeque = this;
        int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
        if (this.head < tail) {
            ArraysKt.copyInto$default(this.elementData, dest, 0, this.head, tail, 2, null);
        } else if (!((Collection)this).isEmpty()) {
            ArraysKt.copyInto(this.elementData, dest, 0, this.head, this.elementData.length);
            ArraysKt.copyInto(this.elementData, dest, this.elementData.length - this.head, 0, tail);
        }
        return CollectionsKt.terminateCollectionToArray(this.size(), dest);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        int length;
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.size());
        int n = length = toIndex - fromIndex;
        if (n == 0) {
            return;
        }
        if (n == this.size()) {
            this.clear();
            return;
        }
        if (n == 1) {
            this.remove(fromIndex);
            return;
        }
        this.registerModification();
        if (fromIndex < this.size() - toIndex) {
            this.removeRangeShiftPreceding(fromIndex, toIndex);
            int newHead = this.positiveMod(this.head + length);
            this.nullifyNonEmpty(this.head, newHead);
            this.head = newHead;
        } else {
            this.removeRangeShiftSucceeding(fromIndex, toIndex);
            ArrayDeque arrayDeque = this;
            int tail = arrayDeque.positiveMod(arrayDeque.head + this.size());
            this.nullifyNonEmpty(this.negativeMod(tail - length), tail);
        }
        this.size = this.size() - length;
    }

    private final void removeRangeShiftPreceding(int fromIndex, int toIndex) {
        int segmentLength;
        ArrayDeque arrayDeque = this;
        int copyFromIndex = arrayDeque.positiveMod(arrayDeque.head + (fromIndex - 1));
        ArrayDeque arrayDeque2 = this;
        int copyToIndex = arrayDeque2.positiveMod(arrayDeque2.head + (toIndex - 1));
        for (int copyCount = fromIndex; copyCount > 0; copyCount -= segmentLength) {
            int n = copyFromIndex + 1;
            int n2 = copyToIndex + 1;
            segmentLength = Math.min(copyCount, Math.min(n, n2));
            ArraysKt.copyInto(this.elementData, this.elementData, copyToIndex - segmentLength + 1, copyFromIndex - segmentLength + 1, copyFromIndex + 1);
            copyFromIndex = this.negativeMod(copyFromIndex - segmentLength);
            copyToIndex = this.negativeMod(copyToIndex - segmentLength);
        }
    }

    private final void removeRangeShiftSucceeding(int fromIndex, int toIndex) {
        int segmentLength;
        ArrayDeque arrayDeque = this;
        int copyFromIndex = arrayDeque.positiveMod(arrayDeque.head + toIndex);
        ArrayDeque arrayDeque2 = this;
        int copyToIndex = arrayDeque2.positiveMod(arrayDeque2.head + fromIndex);
        for (int copyCount = this.size() - toIndex; copyCount > 0; copyCount -= segmentLength) {
            int n = this.elementData.length - copyFromIndex;
            int n2 = this.elementData.length - copyToIndex;
            segmentLength = Math.min(copyCount, Math.min(n, n2));
            ArraysKt.copyInto(this.elementData, this.elementData, copyToIndex, copyFromIndex, copyFromIndex + segmentLength);
            copyFromIndex = this.positiveMod(copyFromIndex + segmentLength);
            copyToIndex = this.positiveMod(copyToIndex + segmentLength);
        }
    }

    private final void nullifyNonEmpty(int internalFromIndex, int internalToIndex) {
        if (internalFromIndex < internalToIndex) {
            ArraysKt.fill(this.elementData, null, internalFromIndex, internalToIndex);
        } else {
            ArraysKt.fill(this.elementData, null, internalFromIndex, this.elementData.length);
            ArraysKt.fill(this.elementData, null, 0, internalToIndex);
        }
    }

    private final void registerModification() {
        ++this.modCount;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

