/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ConcurrencyInfo;
import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Mutation$Data;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Query$Data;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.DefaultInterceptorChain;
import com.apollographql.apollo.interceptor.NetworkInterceptor;
import com.apollographql.apollo.interceptor.RetryOnErrorInterceptorKt;
import com.apollographql.apollo.internal.ApolloClientListener;
import com.apollographql.apollo.internal.Dispatchers_concurrentKt;
import com.apollographql.apollo.network.NetworkTransport;
import com.apollographql.apollo.network.http.HttpEngine;
import com.apollographql.apollo.network.http.HttpInterceptor;
import com.apollographql.apollo.network.http.HttpNetworkTransport;
import com.apollographql.apollo.network.ws.WebSocketEngine;
import com.apollographql.apollo.network.ws.WebSocketNetworkTransport;
import com.apollographql.apollo.network.ws.WsProtocol;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;

public final class ApolloClient
implements Closeable {
    public static final Companion Companion = new Companion(null);
    private final Builder builder;
    private final ConcurrencyInfo concurrencyInfo;
    private final NetworkTransport networkTransport;
    private final NetworkTransport subscriptionNetworkTransport;
    private final List<ApolloInterceptor> interceptors;
    private final CustomScalarAdapters customScalarAdapters;
    private final Function1<ApolloRequest<?>, Boolean> retryOnError;
    private final ApolloInterceptor retryOnErrorInterceptor;
    private final Boolean failFastIfOffline;
    private final List<ApolloClientListener> listeners;
    private final ExecutionContext executionContext;
    private final HttpMethod httpMethod;
    private final List<HttpHeader> httpHeaders;
    private final Boolean sendApqExtensions;
    private final Boolean sendDocument;
    private final Boolean enableAutoPersistedQueries;
    private final Boolean canBeBatched;
    private final NetworkInterceptor networkInterceptor;

    /*
     * WARNING - void declaration
     */
    private ApolloClient(Builder builder) {
        CoroutineDispatcher coroutineDispatcher;
        NetworkTransport networkTransport;
        ApolloClient apolloClient;
        NetworkTransport networkTransport2;
        this.builder = builder;
        this.interceptors = this.builder.getInterceptors();
        this.customScalarAdapters = this.builder.getCustomScalarAdapters();
        this.retryOnError = this.builder.getRetryOnError();
        this.retryOnErrorInterceptor = this.builder.getRetryOnErrorInterceptor();
        this.failFastIfOffline = this.builder.getFailFastIfOffline();
        this.listeners = this.builder.getListeners$apollo_runtime();
        this.executionContext = this.builder.getExecutionContext();
        this.httpMethod = this.builder.getHttpMethod();
        this.httpHeaders = this.builder.getHttpHeaders();
        this.sendApqExtensions = this.builder.getSendApqExtensions();
        this.sendDocument = this.builder.getSendDocument();
        this.enableAutoPersistedQueries = this.builder.getEnableAutoPersistedQueries();
        this.canBeBatched = this.builder.getCanBeBatched();
        ApolloClient apolloClient2 = this;
        if (this.builder.getNetworkTransport() != null) {
            if (!(this.builder.getHttpServerUrl() == null)) {
                ApolloClient apolloClient3 = apolloClient2;
                boolean $i$a$-check-ApolloClient$62 = false;
                ApolloClient apolloClient4 = apolloClient3;
                String $i$a$-check-ApolloClient$62 = "Apollo: 'httpServerUrl' has no effect if 'networkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$62.toString());
            }
            if (!(this.builder.getHttpEngine() == null)) {
                ApolloClient apolloClient5 = apolloClient2;
                boolean $i$a$-check-ApolloClient$132 = false;
                ApolloClient apolloClient6 = apolloClient5;
                String $i$a$-check-ApolloClient$132 = "Apollo: 'httpEngine' has no effect if 'networkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$132.toString());
            }
            if (!this.builder.getHttpInterceptors().isEmpty()) {
                ApolloClient apolloClient7 = apolloClient2;
                boolean $i$a$-check-ApolloClient$142 = false;
                ApolloClient apolloClient8 = apolloClient7;
                String $i$a$-check-ApolloClient$142 = "Apollo: 'addHttpInterceptor' has no effect if 'networkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$142.toString());
            }
            if (!(this.builder.getHttpExposeErrorBody() == null)) {
                ApolloClient apolloClient9 = apolloClient2;
                boolean $i$a$-check-ApolloClient$152 = false;
                ApolloClient apolloClient10 = apolloClient9;
                String $i$a$-check-ApolloClient$152 = "Apollo: 'httpExposeErrorBody' has no effect if 'networkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$152.toString());
            }
            NetworkTransport networkTransport3 = this.builder.getNetworkTransport();
            networkTransport2 = networkTransport3;
            Intrinsics.checkNotNull(networkTransport3);
        } else {
            void $this$_init__u24lambda_u245;
            HttpNetworkTransport.Builder builder2;
            if (!(this.builder.getHttpServerUrl() != null)) {
                ApolloClient apolloClient11 = apolloClient2;
                boolean $i$a$-check-ApolloClient$162 = false;
                ApolloClient apolloClient12 = apolloClient11;
                String $i$a$-check-ApolloClient$162 = "Apollo: 'serverUrl' is required";
                throw new IllegalStateException($i$a$-check-ApolloClient$162.toString());
            }
            HttpNetworkTransport.Builder builder3 = new HttpNetworkTransport.Builder();
            String string = this.builder.getHttpServerUrl();
            Intrinsics.checkNotNull(string);
            HttpNetworkTransport.Builder $i$a$-check-ApolloClient$162 = builder2 = builder3.serverUrl(string);
            apolloClient = apolloClient2;
            boolean bl = false;
            if (this.builder.getHttpEngine() != null) {
                HttpEngine httpEngine = this.builder.getHttpEngine();
                Intrinsics.checkNotNull(httpEngine);
                $this$_init__u24lambda_u245.httpEngine(httpEngine);
            }
            if (this.builder.getHttpExposeErrorBody() != null) {
                Boolean bl2 = this.builder.getHttpExposeErrorBody();
                Intrinsics.checkNotNull(bl2);
                $this$_init__u24lambda_u245.exposeErrorBody(bl2);
            }
            apolloClient2 = apolloClient;
            networkTransport2 = builder2.interceptors(this.builder.getHttpInterceptors()).build();
        }
        apolloClient2.networkTransport = networkTransport2;
        ApolloClient apolloClient13 = this;
        if (this.builder.getSubscriptionNetworkTransport() != null) {
            if (!(this.builder.getWebSocketServerUrl() == null)) {
                apolloClient = apolloClient13;
                boolean $i$a$-check-ApolloClient$172 = false;
                ApolloClient apolloClient14 = apolloClient;
                String $i$a$-check-ApolloClient$172 = "Apollo: 'webSocketServerUrl' has no effect if 'subscriptionNetworkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$172.toString());
            }
            if (!(this.builder.getWebSocketEngine() == null)) {
                apolloClient = apolloClient13;
                boolean $i$a$-check-ApolloClient$182 = false;
                ApolloClient apolloClient15 = apolloClient;
                String $i$a$-check-ApolloClient$182 = "Apollo: 'webSocketEngine' has no effect if 'subscriptionNetworkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$182.toString());
            }
            if (!(this.builder.getWebSocketIdleTimeoutMillis() == null)) {
                apolloClient = apolloClient13;
                boolean $i$a$-check-ApolloClient$192 = false;
                ApolloClient apolloClient16 = apolloClient;
                String $i$a$-check-ApolloClient$192 = "Apollo: 'webSocketIdleTimeoutMillis' has no effect if 'subscriptionNetworkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$192.toString());
            }
            if (!(this.builder.getWsProtocolFactory() == null)) {
                apolloClient = apolloClient13;
                boolean $i$a$-check-ApolloClient$202 = false;
                ApolloClient apolloClient17 = apolloClient;
                String $i$a$-check-ApolloClient$202 = "Apollo: 'wsProtocolFactory' has no effect if 'subscriptionNetworkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$202.toString());
            }
            if (!(this.builder.getWebSocketReopenWhen() == null)) {
                apolloClient = apolloClient13;
                boolean $i$a$-check-ApolloClient$212 = false;
                ApolloClient apolloClient18 = apolloClient;
                String $i$a$-check-ApolloClient$212 = "Apollo: 'webSocketReopenWhen' has no effect if 'subscriptionNetworkTransport' is set";
                throw new IllegalStateException($i$a$-check-ApolloClient$212.toString());
            }
            if (!(this.builder.getWebSocketReopenServerUrl() == null)) {
                apolloClient = apolloClient13;
                boolean bl = false;
                ApolloClient apolloClient19 = apolloClient;
                String string = "Apollo: 'webSocketReopenServerUrl' has no effect if 'subscriptionNetworkTransport' is set";
                throw new IllegalStateException(string.toString());
            }
            NetworkTransport networkTransport4 = this.builder.getSubscriptionNetworkTransport();
            networkTransport = networkTransport4;
            Intrinsics.checkNotNull(networkTransport4);
        } else {
            String url;
            String string = this.builder.getWebSocketServerUrl();
            if (string == null) {
                string = this.builder.getHttpServerUrl();
            }
            if ((url = string) == null) {
                networkTransport = this.networkTransport;
            } else {
                void $this$_init__u24lambda_u2412;
                WebSocketNetworkTransport.Builder builder4;
                WebSocketNetworkTransport.Builder bl = builder4 = new WebSocketNetworkTransport.Builder().serverUrl(url);
                apolloClient = apolloClient13;
                boolean bl3 = false;
                if (this.builder.getWebSocketEngine() != null) {
                    WebSocketEngine webSocketEngine = this.builder.getWebSocketEngine();
                    Intrinsics.checkNotNull(webSocketEngine);
                    $this$_init__u24lambda_u2412.webSocketEngine(webSocketEngine);
                }
                if (this.builder.getWebSocketIdleTimeoutMillis() != null) {
                    Long l = this.builder.getWebSocketIdleTimeoutMillis();
                    Intrinsics.checkNotNull(l);
                    $this$_init__u24lambda_u2412.idleTimeoutMillis(l);
                }
                if (this.builder.getWsProtocolFactory() != null) {
                    WsProtocol.Factory factory2 = this.builder.getWsProtocolFactory();
                    Intrinsics.checkNotNull(factory2);
                    $this$_init__u24lambda_u2412.protocol(factory2);
                }
                if (this.builder.getWebSocketReopenWhen() != null) {
                    $this$_init__u24lambda_u2412.reopenWhen(this.builder.getWebSocketReopenWhen());
                }
                if (this.builder.getWebSocketReopenServerUrl() != null) {
                    $this$_init__u24lambda_u2412.serverUrl(this.builder.getWebSocketReopenServerUrl());
                }
                apolloClient13 = apolloClient;
                networkTransport = apolloClient13.subscriptionNetworkTransport = (NetworkTransport)builder4.build();
            }
        }
        if ((coroutineDispatcher = this.builder.getDispatcher()) == null) {
            coroutineDispatcher = Dispatchers_concurrentKt.getDefaultDispatcher();
        }
        CoroutineDispatcher dispatcher = coroutineDispatcher;
        this.concurrencyInfo = new ConcurrencyInfo(dispatcher, CoroutineScopeKt.CoroutineScope(dispatcher));
        this.networkInterceptor = new NetworkInterceptor(this.networkTransport, this.subscriptionNetworkTransport);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public List<HttpHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Boolean getSendApqExtensions() {
        return this.sendApqExtensions;
    }

    public Boolean getSendDocument() {
        return this.sendDocument;
    }

    public Boolean getEnableAutoPersistedQueries() {
        return this.enableAutoPersistedQueries;
    }

    public Boolean getCanBeBatched() {
        return this.canBeBatched;
    }

    public final <D extends Query$Data> ApolloCall<D> query(Query<D> query2) {
        Intrinsics.checkNotNullParameter(query2, "query");
        return new ApolloCall(this, query2);
    }

    public final <D extends Mutation$Data> ApolloCall<D> mutation(Mutation<D> mutation2) {
        Intrinsics.checkNotNullParameter(mutation2, "mutation");
        return new ApolloCall(this, mutation2);
    }

    @Override
    public void close() {
        CoroutineScopeKt.cancel$default(this.concurrencyInfo.getCoroutineScope(), null, 1, null);
        this.networkTransport.dispose();
        this.subscriptionNetworkTransport.dispose();
    }

    public final <D extends Operation.Data> Flow<ApolloResponse<D>> executeAsFlowInternal$apollo_runtime(ApolloRequest<D> apolloRequest, boolean throwing) {
        Intrinsics.checkNotNullParameter(apolloRequest, "apolloRequest");
        Flow flow2 = FlowKt.channelFlow(new Function2<ProducerScope<? super ApolloResponse<D>>, Continuation<? super Unit>, Object>(this, apolloRequest, throwing, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ApolloClient this$0;
            final /* synthetic */ ApolloRequest<D> $apolloRequest;
            final /* synthetic */ boolean $throwing;
            {
                this.this$0 = $receiver;
                this.$apolloRequest = $apolloRequest;
                this.$throwing = $throwing;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ApolloClientListener it;
                        Iterable $this$forEach$iv;
                        ResultKt.throwOnFailure(object);
                        ProducerScope $this$channelFlow = (ProducerScope)this.L$0;
                        Iterable iterable = ApolloClient.access$getListeners$p(this.this$0);
                        ApolloRequest<D> apolloRequest = this.$apolloRequest;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (ApolloClientListener)element$iv;
                            boolean bl = false;
                            it.requestStarted(apolloRequest);
                        }
                        this.label = 1;
                        Object object3 = BuildersKt.withContext(ApolloClient.access$getConcurrencyInfo$p(this.this$0).getDispatcher(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$apolloRequest, this.$throwing, $this$channelFlow, null){
                            int label;
                            final /* synthetic */ ApolloClient this$0;
                            final /* synthetic */ ApolloRequest<D> $apolloRequest;
                            final /* synthetic */ boolean $throwing;
                            final /* synthetic */ ProducerScope<ApolloResponse<D>> $$this$channelFlow;
                            {
                                this.this$0 = $receiver;
                                this.$apolloRequest = $apolloRequest;
                                this.$throwing = $throwing;
                                this.$$this$channelFlow = $$this$channelFlow;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.label = 1;
                                        Object object3 = this.this$0.apolloResponses$apollo_runtime(this.$apolloRequest, this.$throwing).collect(new FlowCollector(this.$$this$channelFlow){
                                            final /* synthetic */ ProducerScope<ApolloResponse<D>> $$this$channelFlow;
                                            {
                                                this.$$this$channelFlow = $$this$channelFlow;
                                            }

                                            public final Object emit(ApolloResponse<D> it, Continuation<? super Unit> $completion) {
                                                Object object = this.$$this$channelFlow.send(it, $completion);
                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                    return object;
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure($result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        ApolloClientListener it;
                        Iterable $this$forEach$iv;
                        boolean $i$f$forEach;
                        ApolloRequest<D> apolloRequest;
                        try {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            $this$forEach$iv = ApolloClient.access$getListeners$p(this.this$0);
                            apolloRequest = this.$apolloRequest;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (ApolloClientListener)element$iv;
                                boolean bl = false;
                                it.requestCompleted(apolloRequest);
                            }
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<ProducerScope<? super ApolloResponse<D>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(ProducerScope<? super ApolloResponse<D>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return FlowKt.buffer$default(FlowKt.flowOn(flow2, Dispatchers.getUnconfined()), Integer.MAX_VALUE, null, 2, null);
    }

    public final <D extends Operation.Data> Flow<ApolloResponse<D>> apolloResponses$apollo_runtime(ApolloRequest<D> apolloRequest, boolean throwing) {
        List<ApolloInterceptor> list;
        Boolean bl;
        Boolean canBeBatched;
        List<HttpHeader> list2;
        List list3;
        ApolloRequest.Builder<D> builder;
        Intrinsics.checkNotNullParameter(apolloRequest, "apolloRequest");
        ApolloClient apolloClient = this;
        ApolloRequest.Builder<D> $this$apolloResponses_u24lambda_u2414 = builder = apolloRequest.newBuilder();
        boolean bl2 = false;
        $this$apolloResponses_u24lambda_u2414.executionContext(this.concurrencyInfo.plus(this.customScalarAdapters).plus(apolloClient.getExecutionContext()).plus($this$apolloResponses_u24lambda_u2414.getExecutionContext()));
        HttpMethod httpMethod = $this$apolloResponses_u24lambda_u2414.getHttpMethod();
        if (httpMethod == null) {
            httpMethod = apolloClient.getHttpMethod();
        }
        $this$apolloResponses_u24lambda_u2414.httpMethod(httpMethod);
        Boolean bl3 = $this$apolloResponses_u24lambda_u2414.getSendApqExtensions();
        if (bl3 == null) {
            bl3 = apolloClient.getSendApqExtensions();
        }
        $this$apolloResponses_u24lambda_u2414.sendApqExtensions(bl3);
        Boolean bl4 = $this$apolloResponses_u24lambda_u2414.getSendDocument();
        if (bl4 == null) {
            bl4 = apolloClient.getSendDocument();
        }
        $this$apolloResponses_u24lambda_u2414.sendDocument(bl4);
        Boolean bl5 = $this$apolloResponses_u24lambda_u2414.getEnableAutoPersistedQueries();
        if (bl5 == null) {
            bl5 = apolloClient.getEnableAutoPersistedQueries();
        }
        $this$apolloResponses_u24lambda_u2414.enableAutoPersistedQueries(bl5);
        List $this$apolloResponses_u24lambda_u2414_u24lambda_u2413 = list3 = CollectionsKt.createListBuilder();
        boolean bl6 = false;
        if (!Intrinsics.areEqual($this$apolloResponses_u24lambda_u2414.getIgnoreApolloClientHttpHeaders(), true)) {
            List<HttpHeader> list4 = apolloClient.getHttpHeaders();
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            $this$apolloResponses_u24lambda_u2414_u24lambda_u2413.addAll(list4);
        }
        if ((list2 = $this$apolloResponses_u24lambda_u2414.getHttpHeaders()) == null) {
            list2 = CollectionsKt.emptyList();
        }
        $this$apolloResponses_u24lambda_u2414_u24lambda_u2413.addAll(list2);
        List<HttpHeader> headers = CollectionsKt.build(list3);
        $this$apolloResponses_u24lambda_u2414.httpHeaders(headers);
        Boolean bl7 = $this$apolloResponses_u24lambda_u2414.getCanBeBatched();
        if (bl7 == null) {
            bl7 = apolloClient.getCanBeBatched();
        }
        if ((canBeBatched = bl7) != null) {
            $this$apolloResponses_u24lambda_u2414.addHttpHeader("X-APOLLO-CAN-BE-BATCHED", canBeBatched.toString());
        }
        if ((bl = $this$apolloResponses_u24lambda_u2414.getRetryOnError()) == null) {
            Function1<ApolloRequest<?>, Boolean> function1 = apolloClient.retryOnError;
            bl = function1 != null ? function1.invoke(apolloRequest) : null;
        }
        $this$apolloResponses_u24lambda_u2414.retryOnError(bl);
        Boolean bl8 = $this$apolloResponses_u24lambda_u2414.getFailFastIfOffline();
        if (bl8 == null) {
            bl8 = apolloClient.failFastIfOffline;
        }
        $this$apolloResponses_u24lambda_u2414.failFastIfOffline(bl8);
        ApolloRequest<D> request = builder.build();
        List<ApolloInterceptor> $this$apolloResponses_u24lambda_u2415 = list = CollectionsKt.createListBuilder();
        boolean bl9 = false;
        $this$apolloResponses_u24lambda_u2415.addAll((Collection)this.interceptors);
        ApolloInterceptor apolloInterceptor = this.retryOnErrorInterceptor;
        if (apolloInterceptor == null) {
            apolloInterceptor = RetryOnErrorInterceptorKt.RetryOnErrorInterceptor();
        }
        $this$apolloResponses_u24lambda_u2415.add(apolloInterceptor);
        $this$apolloResponses_u24lambda_u2415.add(this.networkInterceptor);
        List allInterceptors = CollectionsKt.build(list);
        Flow<ApolloResponse<D>> it = new DefaultInterceptorChain(allInterceptors, 0).proceed(request);
        boolean bl10 = false;
        return throwing ? FlowKt.onEach(it, new Function2<ApolloResponse<D>, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        ApolloResponse response = (ApolloResponse)this.L$0;
                        if (response.exception != null) {
                            ApolloException apolloException = response.exception;
                            Intrinsics.checkNotNull(apolloException);
                            throw apolloException;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<ApolloResponse<D>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(ApolloResponse<D> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }) : it;
    }

    public static final /* synthetic */ List access$getListeners$p(ApolloClient $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ ConcurrencyInfo access$getConcurrencyInfo$p(ApolloClient $this) {
        return $this.concurrencyInfo;
    }

    public /* synthetic */ ApolloClient(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public static final class Builder {
        private final CustomScalarAdapters.Builder _customScalarAdaptersBuilder = new CustomScalarAdapters.Builder();
        private final List<ApolloInterceptor> _interceptors = new ArrayList();
        private final List<ApolloInterceptor> interceptors = this._interceptors;
        private final List<HttpInterceptor> _httpInterceptors = new ArrayList();
        private final List<HttpInterceptor> httpInterceptors = this._httpInterceptors;
        private final List<ApolloClientListener> _listeners = new ArrayList();
        private final List<ApolloClientListener> listeners = this._listeners;
        private ExecutionContext executionContext = ExecutionContext.Empty;
        private HttpMethod httpMethod;
        private List<HttpHeader> httpHeaders;
        private Boolean sendApqExtensions;
        private Boolean sendDocument;
        private Boolean enableAutoPersistedQueries;
        private Boolean canBeBatched;
        private NetworkTransport networkTransport;
        private NetworkTransport subscriptionNetworkTransport;
        private CoroutineDispatcher dispatcher;
        private String httpServerUrl;
        private HttpEngine httpEngine;
        private String webSocketServerUrl;
        private Long webSocketIdleTimeoutMillis;
        private WsProtocol.Factory wsProtocolFactory;
        private Boolean httpExposeErrorBody;
        private WebSocketEngine webSocketEngine;
        private Function3<? super Throwable, ? super Long, ? super Continuation<? super Boolean>, ? extends Object> webSocketReopenWhen;
        private Function1<? super Continuation<? super String>, ? extends Object> webSocketReopenServerUrl;
        private Function1<? super ApolloRequest<?>, Boolean> retryOnError;
        private ApolloInterceptor retryOnErrorInterceptor;
        private Boolean failFastIfOffline;

        public final CustomScalarAdapters getCustomScalarAdapters() {
            return this._customScalarAdaptersBuilder.build();
        }

        public final List<ApolloInterceptor> getInterceptors() {
            return this.interceptors;
        }

        public final List<HttpInterceptor> getHttpInterceptors() {
            return this.httpInterceptors;
        }

        public final List<ApolloClientListener> getListeners$apollo_runtime() {
            return this.listeners;
        }

        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        public List<HttpHeader> getHttpHeaders() {
            return this.httpHeaders;
        }

        public Boolean getSendApqExtensions() {
            return this.sendApqExtensions;
        }

        public Boolean getSendDocument() {
            return this.sendDocument;
        }

        public Boolean getEnableAutoPersistedQueries() {
            return this.enableAutoPersistedQueries;
        }

        public Boolean getCanBeBatched() {
            return this.canBeBatched;
        }

        public final NetworkTransport getNetworkTransport() {
            return this.networkTransport;
        }

        public final NetworkTransport getSubscriptionNetworkTransport() {
            return this.subscriptionNetworkTransport;
        }

        public final CoroutineDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public final String getHttpServerUrl() {
            return this.httpServerUrl;
        }

        public final HttpEngine getHttpEngine() {
            return this.httpEngine;
        }

        public final String getWebSocketServerUrl() {
            return this.webSocketServerUrl;
        }

        public final Long getWebSocketIdleTimeoutMillis() {
            return this.webSocketIdleTimeoutMillis;
        }

        public final WsProtocol.Factory getWsProtocolFactory() {
            return this.wsProtocolFactory;
        }

        public final Boolean getHttpExposeErrorBody() {
            return this.httpExposeErrorBody;
        }

        public final WebSocketEngine getWebSocketEngine() {
            return this.webSocketEngine;
        }

        public final Function3<Throwable, Long, Continuation<? super Boolean>, Object> getWebSocketReopenWhen() {
            return this.webSocketReopenWhen;
        }

        public final Function1<Continuation<? super String>, Object> getWebSocketReopenServerUrl() {
            return this.webSocketReopenServerUrl;
        }

        public final Function1<ApolloRequest<?>, Boolean> getRetryOnError() {
            return this.retryOnError;
        }

        public final ApolloInterceptor getRetryOnErrorInterceptor() {
            return this.retryOnErrorInterceptor;
        }

        public final Boolean getFailFastIfOffline() {
            return this.failFastIfOffline;
        }

        public final Builder failFastIfOffline(Boolean failFastIfOffline) {
            Builder builder;
            Builder $this$failFastIfOffline_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$failFastIfOffline_u24lambda_u240.failFastIfOffline = failFastIfOffline;
            return builder;
        }

        public final Builder retryOnError(Function1<? super ApolloRequest<?>, Boolean> retryOnError) {
            Builder builder;
            Builder $this$retryOnError_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$retryOnError_u24lambda_u241.retryOnError = retryOnError;
            return builder;
        }

        public final Builder retryOnErrorInterceptor(ApolloInterceptor retryOnErrorInterceptor) {
            Builder builder;
            Builder $this$retryOnErrorInterceptor_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$retryOnErrorInterceptor_u24lambda_u242.retryOnErrorInterceptor = retryOnErrorInterceptor;
            return builder;
        }

        public Builder httpMethod(HttpMethod httpMethod) {
            Builder builder;
            Builder $this$httpMethod_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$httpMethod_u24lambda_u243.httpMethod = httpMethod;
            return builder;
        }

        public Builder httpHeaders(List<HttpHeader> httpHeaders) {
            Builder builder;
            Builder $this$httpHeaders_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$httpHeaders_u24lambda_u244.httpHeaders = httpHeaders;
            return builder;
        }

        public Builder addHttpHeader(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$addHttpHeader_u24lambda_u245 = builder = this;
            boolean bl = false;
            List<HttpHeader> list = $this$addHttpHeader_u24lambda_u245.getHttpHeaders();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            $this$addHttpHeader_u24lambda_u245.httpHeaders = CollectionsKt.plus((Collection)list, new HttpHeader(name, value));
            return builder;
        }

        public Builder sendApqExtensions(Boolean sendApqExtensions) {
            Builder builder;
            Builder $this$sendApqExtensions_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$sendApqExtensions_u24lambda_u246.sendApqExtensions = sendApqExtensions;
            return builder;
        }

        public Builder sendDocument(Boolean sendDocument) {
            Builder builder;
            Builder $this$sendDocument_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$sendDocument_u24lambda_u247.sendDocument = sendDocument;
            return builder;
        }

        public Builder enableAutoPersistedQueries(Boolean enableAutoPersistedQueries) {
            Builder builder;
            Builder $this$enableAutoPersistedQueries_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$enableAutoPersistedQueries_u24lambda_u248.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return builder;
        }

        public Builder canBeBatched(Boolean canBeBatched) {
            Builder builder;
            Builder $this$canBeBatched_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$canBeBatched_u24lambda_u249.canBeBatched = canBeBatched;
            return builder;
        }

        public final Builder serverUrl(String serverUrl2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(serverUrl2, "serverUrl");
            Builder $this$serverUrl_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$serverUrl_u24lambda_u2410.httpServerUrl = serverUrl2;
            return builder;
        }

        public final Builder httpServerUrl(String httpServerUrl) {
            Builder builder;
            Builder $this$httpServerUrl_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$httpServerUrl_u24lambda_u2411.httpServerUrl = httpServerUrl;
            return builder;
        }

        public final Builder httpEngine(HttpEngine httpEngine) {
            Builder builder;
            Builder $this$httpEngine_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$httpEngine_u24lambda_u2412.httpEngine = httpEngine;
            return builder;
        }

        public final Builder httpExposeErrorBody(Boolean httpExposeErrorBody) {
            Builder builder;
            Builder $this$httpExposeErrorBody_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$httpExposeErrorBody_u24lambda_u2413.httpExposeErrorBody = httpExposeErrorBody;
            return builder;
        }

        public final Builder httpInterceptors(List<? extends HttpInterceptor> httpInterceptors) {
            Builder builder;
            Intrinsics.checkNotNullParameter(httpInterceptors, "httpInterceptors");
            Builder $this$httpInterceptors_u24lambda_u2414 = builder = this;
            boolean bl = false;
            $this$httpInterceptors_u24lambda_u2414._httpInterceptors.clear();
            $this$httpInterceptors_u24lambda_u2414._httpInterceptors.addAll((Collection<HttpInterceptor>)httpInterceptors);
            return builder;
        }

        public final Builder webSocketServerUrl(String webSocketServerUrl) {
            Builder builder;
            Builder $this$webSocketServerUrl_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$webSocketServerUrl_u24lambda_u2417.webSocketServerUrl = webSocketServerUrl;
            return builder;
        }

        public final Builder webSocketServerUrl(Function1<? super Continuation<? super String>, ? extends Object> webSocketServerUrl) {
            Builder builder;
            Builder $this$webSocketServerUrl_u24lambda_u2418 = builder = this;
            boolean bl = false;
            $this$webSocketServerUrl_u24lambda_u2418.webSocketReopenServerUrl = webSocketServerUrl;
            return builder;
        }

        public final Builder webSocketIdleTimeoutMillis(Long webSocketIdleTimeoutMillis) {
            Builder builder;
            Builder $this$webSocketIdleTimeoutMillis_u24lambda_u2419 = builder = this;
            boolean bl = false;
            $this$webSocketIdleTimeoutMillis_u24lambda_u2419.webSocketIdleTimeoutMillis = webSocketIdleTimeoutMillis;
            return builder;
        }

        public final Builder wsProtocol(WsProtocol.Factory wsProtocolFactory) {
            Builder builder;
            Builder $this$wsProtocol_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$wsProtocol_u24lambda_u2420.wsProtocolFactory = wsProtocolFactory;
            return builder;
        }

        public final Builder webSocketEngine(WebSocketEngine webSocketEngine) {
            Builder builder;
            Builder $this$webSocketEngine_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$webSocketEngine_u24lambda_u2421.webSocketEngine = webSocketEngine;
            return builder;
        }

        public final Builder webSocketReopenWhen(Function3<? super Throwable, ? super Long, ? super Continuation<? super Boolean>, ? extends Object> webSocketReopenWhen) {
            Builder builder;
            Builder $this$webSocketReopenWhen_u24lambda_u2422 = builder = this;
            boolean bl = false;
            $this$webSocketReopenWhen_u24lambda_u2422.webSocketReopenWhen = webSocketReopenWhen;
            return builder;
        }

        public final Builder networkTransport(NetworkTransport networkTransport) {
            Builder builder;
            Builder $this$networkTransport_u24lambda_u2423 = builder = this;
            boolean bl = false;
            $this$networkTransport_u24lambda_u2423.networkTransport = networkTransport;
            return builder;
        }

        public final Builder subscriptionNetworkTransport(NetworkTransport subscriptionNetworkTransport) {
            Builder builder;
            Builder $this$subscriptionNetworkTransport_u24lambda_u2424 = builder = this;
            boolean bl = false;
            $this$subscriptionNetworkTransport_u24lambda_u2424.subscriptionNetworkTransport = subscriptionNetworkTransport;
            return builder;
        }

        public final Builder customScalarAdapters(CustomScalarAdapters customScalarAdapters) {
            Builder builder;
            Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
            Builder $this$customScalarAdapters_u24lambda_u2425 = builder = this;
            boolean bl = false;
            $this$customScalarAdapters_u24lambda_u2425._customScalarAdaptersBuilder.clear();
            $this$customScalarAdapters_u24lambda_u2425._customScalarAdaptersBuilder.addAll(customScalarAdapters);
            return builder;
        }

        public final Builder listeners(List<? extends ApolloClientListener> listeners) {
            Builder builder;
            Intrinsics.checkNotNullParameter(listeners, "listeners");
            Builder $this$listeners_u24lambda_u2428 = builder = this;
            boolean bl = false;
            $this$listeners_u24lambda_u2428._listeners.clear();
            $this$listeners_u24lambda_u2428._listeners.addAll((Collection<ApolloClientListener>)listeners);
            return builder;
        }

        public final Builder interceptors(List<? extends ApolloInterceptor> interceptors) {
            Builder builder;
            Intrinsics.checkNotNullParameter(interceptors, "interceptors");
            Builder $this$interceptors_u24lambda_u2432 = builder = this;
            boolean bl = false;
            $this$interceptors_u24lambda_u2432._interceptors.clear();
            CollectionsKt.addAll((Collection)$this$interceptors_u24lambda_u2432._interceptors, (Iterable)interceptors);
            return builder;
        }

        public final Builder dispatcher(CoroutineDispatcher dispatcher) {
            Builder builder;
            Builder $this$dispatcher_u24lambda_u2433 = builder = this;
            boolean bl = false;
            $this$dispatcher_u24lambda_u2433.dispatcher = dispatcher;
            return builder;
        }

        public final Builder executionContext(ExecutionContext executionContext) {
            Builder builder;
            Intrinsics.checkNotNullParameter(executionContext, "executionContext");
            Builder $this$executionContext_u24lambda_u2435 = builder = this;
            boolean bl = false;
            $this$executionContext_u24lambda_u2435.executionContext = executionContext;
            return builder;
        }

        public final ApolloClient build() {
            return new ApolloClient(this.copy(), null);
        }

        public final Builder copy() {
            return new Builder().customScalarAdapters(this._customScalarAdaptersBuilder.build()).interceptors(this.interceptors).dispatcher(this.dispatcher).executionContext(this.getExecutionContext()).httpMethod(this.getHttpMethod()).httpHeaders(this.getHttpHeaders()).httpServerUrl(this.httpServerUrl).httpEngine(this.httpEngine).httpExposeErrorBody(this.httpExposeErrorBody).httpInterceptors(this.httpInterceptors).sendApqExtensions(this.getSendApqExtensions()).sendDocument(this.getSendDocument()).enableAutoPersistedQueries(this.getEnableAutoPersistedQueries()).canBeBatched(this.getCanBeBatched()).networkTransport(this.networkTransport).subscriptionNetworkTransport(this.subscriptionNetworkTransport).webSocketServerUrl(this.webSocketServerUrl).webSocketServerUrl(this.webSocketReopenServerUrl).webSocketEngine(this.webSocketEngine).webSocketReopenWhen(this.webSocketReopenWhen).webSocketIdleTimeoutMillis(this.webSocketIdleTimeoutMillis).wsProtocol(this.wsProtocolFactory).retryOnError(this.retryOnError).retryOnErrorInterceptor(this.retryOnErrorInterceptor).failFastIfOffline(this.failFastIfOffline).listeners(this.listeners);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

