/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.reftree.Command;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

class RefTreeBatch
extends BatchRefUpdate {
    private final RefTreeDatabase refdb;
    private Ref src;
    private ObjectId parentCommitId;
    private ObjectId parentTreeId;
    private RefTree tree;
    private PersonIdent author;
    private ObjectId newCommitId;

    RefTreeBatch(RefTreeDatabase refdb) {
        super(refdb);
        this.refdb = refdb;
    }

    @Override
    public void execute(RevWalk rw, ProgressMonitor monitor) throws IOException {
        ArrayList<Command> todo = new ArrayList<Command>(this.getCommands().size());
        for (ReceiveCommand c : this.getCommands()) {
            if (!this.isAllowNonFastForwards()) {
                if (c.getType() == ReceiveCommand.Type.UPDATE) {
                    c.updateType(rw);
                }
                if (c.getType() == ReceiveCommand.Type.UPDATE_NONFASTFORWARD) {
                    c.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                    if (!this.isAtomic()) continue;
                    ReceiveCommand.abort(this.getCommands());
                    return;
                }
            }
            todo.add(new Command(rw, c));
        }
        this.init(rw);
        this.execute(rw, todo);
    }

    void init(RevWalk rw) throws IOException {
        this.src = this.refdb.getBootstrap().exactRef(this.refdb.getTxnCommitted());
        if (this.src != null && this.src.getObjectId() != null) {
            RevCommit c = rw.parseCommit(this.src.getObjectId());
            this.parentCommitId = c;
            this.parentTreeId = c.getTree();
            this.tree = RefTree.read(rw.getObjectReader(), c.getTree());
        } else {
            this.parentCommitId = ObjectId.zeroId();
            try (ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();){
                this.parentTreeId = fmt.idFor(2, new byte[0]);
            }
            this.tree = RefTree.newEmptyTree();
        }
    }

    @Nullable
    Ref exactRef(ObjectReader reader, String name) throws IOException {
        return this.tree.exactRef(reader, name);
    }

    void execute(RevWalk rw, List<Command> todo) throws IOException {
        for (Command c : todo) {
            if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                Command.abort(todo, null);
                return;
            }
            if (!this.refdb.conflictsWithBootstrap(c.getRefName())) continue;
            c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().invalidRefName, c.getRefName()));
            Command.abort(todo, null);
            return;
        }
        if (this.apply(todo) && this.newCommitId != null) {
            this.commit(rw, todo);
        }
    }

    private boolean apply(List<Command> todo) throws IOException {
        if (!this.tree.apply(todo)) {
            return false;
        }
        Repository repo = this.refdb.getRepository();
        try (ObjectInserter ins = repo.newObjectInserter();){
            CommitBuilder b = new CommitBuilder();
            b.setTreeId(this.tree.writeTree(ins));
            if (this.parentTreeId.equals(b.getTreeId())) {
                for (Command c : todo) {
                    c.setResult(ReceiveCommand.Result.OK);
                }
                boolean bl = true;
                return bl;
            }
            if (!this.parentCommitId.equals(ObjectId.zeroId())) {
                b.setParentId(this.parentCommitId);
            }
            this.author = this.getRefLogIdent();
            if (this.author == null) {
                this.author = new PersonIdent(repo);
            }
            b.setAuthor(this.author);
            b.setCommitter(this.author);
            b.setMessage(this.getRefLogMessage());
            this.newCommitId = ins.insert(b);
            ins.flush();
        }
        return true;
    }

    private void commit(RevWalk rw, List<Command> todo) throws IOException {
        ReceiveCommand commit = new ReceiveCommand(this.parentCommitId, this.newCommitId, this.refdb.getTxnCommitted());
        this.updateBootstrap(rw, commit);
        if (commit.getResult() == ReceiveCommand.Result.OK) {
            for (Command c : todo) {
                c.setResult(ReceiveCommand.Result.OK);
            }
        } else {
            Command.abort(todo, commit.getResult().name());
        }
    }

    private void updateBootstrap(RevWalk rw, ReceiveCommand commit) throws IOException {
        BatchRefUpdate u = this.refdb.getBootstrap().newBatchUpdate();
        u.setAllowNonFastForwards(true);
        u.setPushCertificate(this.getPushCertificate());
        if (this.isRefLogDisabled()) {
            u.disableRefLog();
        } else {
            u.setRefLogIdent(this.author);
            u.setRefLogMessage(this.getRefLogMessage(), false);
        }
        u.addCommand(commit);
        u.execute(rw, NullProgressMonitor.INSTANCE);
    }
}

