/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.OS;

public class ImageList {
    long handle;
    int style;
    int refCount;
    Image[] images;
    private final int zoom;
    private final int width;
    private final int height;
    private final int flags;
    private HashMap<Integer, Long> zoomToHandle = new HashMap();

    public ImageList(int style, int zoom) {
        this(style, 32, 32, zoom);
    }

    public ImageList(int style, int width, int height, int zoom) {
        this.style = style;
        int listFlags = 33;
        if ((style & 0x4000000) != 0) {
            listFlags |= 0x2000;
        }
        this.flags = listFlags;
        this.height = height;
        this.width = width;
        this.handle = OS.ImageList_Create(width, height, this.flags, 16, 16);
        this.zoomToHandle.put(zoom, this.handle);
        this.images = new Image[4];
        this.zoom = zoom;
    }

    public int add(Image image) {
        Image imageAtIndex;
        int index;
        int count = OS.ImageList_GetImageCount(this.handle);
        for (index = 0; index < count && (imageAtIndex = this.getOrClearIfDisposed(index)) != null; ++index) {
        }
        if (count == 0) {
            Rectangle rect = Win32DPIUtils.scaleBounds(image.getBounds(), this.zoom, 100);
            OS.ImageList_SetIconSize(this.handle, rect.width, rect.height);
        }
        this.setForAllHandles(index, image, count);
        if (index == this.images.length) {
            Image[] newImages = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
        }
        this.images[index] = image;
        return index;
    }

    private Image getOrClearIfDisposed(int index) {
        if (this.images[index] != null && this.images[index].isDisposed()) {
            this.images[index] = null;
        }
        return this.images[index];
    }

    public int addRef() {
        return ++this.refCount;
    }

    long copyBitmap(long hImage, int width, int height) {
        long hBitmap;
        BITMAP bm = new BITMAP();
        OS.GetObject(hImage, BITMAP.sizeof, bm);
        long hDC = OS.GetDC(0L);
        long hdc1 = OS.CreateCompatibleDC(hDC);
        OS.SelectObject(hdc1, hImage);
        long hdc2 = OS.CreateCompatibleDC(hDC);
        if (bm.bmBitsPixel == 32) {
            BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
            bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
            bmiHeader.biWidth = width;
            bmiHeader.biHeight = -height;
            bmiHeader.biPlanes = 1;
            bmiHeader.biBitCount = (short)24;
            bmiHeader.biCompression = 0;
            byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
            long[] pBits = new long[1];
            hBitmap = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
        } else {
            hBitmap = OS.CreateCompatibleBitmap(hDC, width, height);
        }
        OS.SelectObject(hdc2, hBitmap);
        if (width != bm.bmWidth || height != bm.bmHeight) {
            OS.SetStretchBltMode(hdc2, 3);
            OS.StretchBlt(hdc2, 0, 0, width, height, hdc1, 0, 0, bm.bmWidth, bm.bmHeight, 0xCC0020);
        } else {
            OS.BitBlt(hdc2, 0, 0, width, height, hdc1, 0, 0, 0xCC0020);
        }
        OS.DeleteDC(hdc1);
        OS.DeleteDC(hdc2);
        OS.ReleaseDC(0L, hDC);
        return hBitmap;
    }

    long copyIcon(long hImage, int width, int height) {
        long hIcon = OS.CopyImage(hImage, 1, width, height, 0);
        return hIcon != 0L ? hIcon : hImage;
    }

    long copyWithAlpha(long hBitmap, int background, byte[] alphaData, int destWidth, int destHeight) {
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, BITMAP.sizeof, bm);
        int srcWidth = bm.bmWidth;
        int srcHeight = bm.bmHeight;
        long hdc = OS.GetDC(0L);
        long srcHdc = OS.CreateCompatibleDC(hdc);
        long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        long memHdc = OS.CreateCompatibleDC(hdc);
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = srcWidth;
        bmiHeader.biHeight = -srcHeight;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)32;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        long memDib = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
        if (memDib == 0L) {
            SWT.error(2);
        }
        long oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, BITMAP.sizeof, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc, 0, 0, 0xCC0020);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        if (alphaData != null) {
            int spinc = dibBM.bmWidthBytes - srcWidth * 4;
            int ap = 0;
            int sp = 0;
            for (int y = 0; y < srcHeight; ++y) {
                for (int x = 0; x < srcWidth; ++x) {
                    int a;
                    if ((a = alphaData[ap++] & 0xFF) != 0) {
                        srcData[sp] = (byte)(((srcData[sp] & 0xFF) * 255 + a / 2) / a);
                        srcData[sp + 1] = (byte)(((srcData[sp + 1] & 0xFF) * 255 + a / 2) / a);
                        srcData[sp + 2] = (byte)(((srcData[sp + 2] & 0xFF) * 255 + a / 2) / a);
                    }
                    srcData[sp + 3] = (byte)a;
                    sp += 4;
                }
                sp += spinc;
            }
        } else {
            byte transRed = (byte)(background & 0xFF);
            byte transGreen = (byte)(background >> 8 & 0xFF);
            byte transBlue = (byte)(background >> 16 & 0xFF);
            int spinc = dibBM.bmWidthBytes - srcWidth * 4;
            int sp = 3;
            for (int y = 0; y < srcHeight; ++y) {
                for (int x = 0; x < srcWidth; ++x) {
                    srcData[sp] = srcData[sp - 1] == transRed && srcData[sp - 2] == transGreen && srcData[sp - 3] == transBlue ? 0 : -1;
                    sp += 4;
                }
                sp += spinc;
            }
        }
        OS.MoveMemory(dibBM.bmBits, srcData, sizeInBytes);
        if (srcWidth != destWidth || srcHeight != destHeight) {
            BITMAPINFOHEADER bmiHeader2 = new BITMAPINFOHEADER();
            bmiHeader2.biSize = BITMAPINFOHEADER.sizeof;
            bmiHeader2.biWidth = destWidth;
            bmiHeader2.biHeight = -destHeight;
            bmiHeader2.biPlanes = 1;
            bmiHeader2.biBitCount = (short)32;
            bmiHeader2.biCompression = 0;
            byte[] bmi2 = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(bmi2, bmiHeader2, BITMAPINFOHEADER.sizeof);
            long[] pBits2 = new long[1];
            long memDib2 = OS.CreateDIBSection(0L, bmi2, 0, pBits2, 0L, 0);
            long memHdc2 = OS.CreateCompatibleDC(hdc);
            long oldMemBitmap2 = OS.SelectObject(memHdc2, memDib2);
            OS.SetStretchBltMode(memHdc2, 3);
            OS.StretchBlt(memHdc2, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
            OS.SelectObject(memHdc2, oldMemBitmap2);
            OS.DeleteDC(memHdc2);
            OS.SelectObject(memHdc, oldMemBitmap);
            OS.DeleteDC(memHdc);
            OS.DeleteObject(memDib);
            memDib = memDib2;
        } else {
            OS.SelectObject(memHdc, oldMemBitmap);
            OS.DeleteDC(memHdc);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
        OS.ReleaseDC(0L, hdc);
        return memDib;
    }

    long createMaskFromAlpha(ImageData data, int destWidth, int destHeight) {
        int srcWidth = data.width;
        int srcHeight = data.height;
        ImageData mask = ImageData.internal_new(srcWidth, srcHeight, 1, new PaletteData(new RGB(0, 0, 0), new RGB(255, 255, 255)), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int ap = 0;
        for (int y = 0; y < mask.height; ++y) {
            for (int x = 0; x < mask.width; ++x) {
                mask.setPixel(x, y, (data.alphaData[ap++] & 0xFF) <= 127 ? 1 : 0);
            }
        }
        long hMask = OS.CreateBitmap(srcWidth, srcHeight, 1, 1, mask.data);
        if (srcWidth != destWidth || srcHeight != destHeight) {
            long hdc = OS.GetDC(0L);
            long hdc1 = OS.CreateCompatibleDC(hdc);
            OS.SelectObject(hdc1, hMask);
            long hdc2 = OS.CreateCompatibleDC(hdc);
            long hMask2 = OS.CreateBitmap(destWidth, destHeight, 1, 1, null);
            OS.SelectObject(hdc2, hMask2);
            OS.SetStretchBltMode(hdc2, 3);
            OS.StretchBlt(hdc2, 0, 0, destWidth, destHeight, hdc1, 0, 0, srcWidth, srcHeight, 0xCC0020);
            OS.DeleteDC(hdc1);
            OS.DeleteDC(hdc2);
            OS.ReleaseDC(0L, hdc);
            OS.DeleteObject(hMask);
            hMask = hMask2;
        }
        return hMask;
    }

    long createMask(long hBitmap, int destWidth, int destHeight, int background, int transparentPixel) {
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, BITMAP.sizeof, bm);
        int srcWidth = bm.bmWidth;
        int srcHeight = bm.bmHeight;
        long hMask = OS.CreateBitmap(destWidth, destHeight, 1, 1, null);
        long hDC = OS.GetDC(0L);
        long hdc1 = OS.CreateCompatibleDC(hDC);
        if (background != -1) {
            OS.SelectObject(hdc1, hBitmap);
            boolean isDib = bm.bmBits != 0L;
            byte[] originalColors = null;
            if (transparentPixel != -1 && isDib && bm.bmBitsPixel <= 8) {
                int maxColors = 1 << bm.bmBitsPixel;
                byte[] oldColors = new byte[maxColors * 4];
                OS.GetDIBColorTable(hdc1, 0, maxColors, oldColors);
                int offset = transparentPixel * 4;
                byte[] newColors = new byte[oldColors.length];
                newColors[offset] = -1;
                newColors[offset + 1] = -1;
                newColors[offset + 2] = -1;
                OS.SetDIBColorTable(hdc1, 0, maxColors, newColors);
                originalColors = oldColors;
                OS.SetBkColor(hdc1, 0xFFFFFF);
            } else {
                OS.SetBkColor(hdc1, background);
            }
            long hdc2 = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdc2, hMask);
            if (destWidth != srcWidth || destHeight != srcHeight) {
                OS.SetStretchBltMode(hdc2, 3);
                OS.StretchBlt(hdc2, 0, 0, destWidth, destHeight, hdc1, 0, 0, srcWidth, srcHeight, 0xCC0020);
            } else {
                OS.BitBlt(hdc2, 0, 0, destWidth, destHeight, hdc1, 0, 0, 0xCC0020);
            }
            OS.DeleteDC(hdc2);
            if (originalColors != null) {
                OS.SetDIBColorTable(hdc1, 0, 1 << bm.bmBitsPixel, originalColors);
            }
        } else {
            long hOldBitmap = OS.SelectObject(hdc1, hMask);
            OS.PatBlt(hdc1, 0, 0, destWidth, destHeight, 66);
            OS.SelectObject(hdc1, hOldBitmap);
        }
        OS.ReleaseDC(0L, hDC);
        OS.DeleteDC(hdc1);
        return hMask;
    }

    public void dispose() {
        if (this.handle != 0L) {
            OS.ImageList_Destroy(this.handle);
        }
        this.handle = 0L;
        this.images = null;
    }

    public Image get(int index) {
        return this.images[index];
    }

    public int getStyle() {
        return this.style;
    }

    public long getHandle(int targetZoom) {
        if (!this.zoomToHandle.containsKey(targetZoom)) {
            int scaledWidth = DPIUtil.pointToPixel(DPIUtil.pixelToPoint(this.width, this.zoom), targetZoom);
            int scaledHeight = DPIUtil.pointToPixel(DPIUtil.pixelToPoint(this.height, this.zoom), targetZoom);
            long newImageListHandle = OS.ImageList_Create(scaledWidth, scaledHeight, this.flags, 16, 16);
            int count = OS.ImageList_GetImageCount(this.handle);
            for (int i = 0; i < count; ++i) {
                Image image = this.getOrClearIfDisposed(i);
                if (image != null) {
                    this.set(i, image, i, newImageListHandle, targetZoom);
                    continue;
                }
                this.addPlaceholderImageToImageList(newImageListHandle, scaledWidth, scaledHeight);
            }
            this.zoomToHandle.put(targetZoom, newImageListHandle);
        }
        return this.zoomToHandle.get(targetZoom);
    }

    private void addPlaceholderImageToImageList(long imageListHandle, int bitmapWidth, int bitmapHeight) {
        long placeholderBitmapHandle;
        long hDC = OS.GetDC(0L);
        if (hDC == 0L) {
            SWT.error(2);
        }
        if ((placeholderBitmapHandle = OS.CreateCompatibleBitmap(hDC, bitmapWidth, bitmapHeight)) == 0L) {
            SWT.error(2);
        }
        OS.ImageList_Add(imageListHandle, placeholderBitmapHandle, placeholderBitmapHandle);
        OS.DeleteObject(placeholderBitmapHandle);
        OS.ReleaseDC(0L, hDC);
    }

    public Point getImageSize() {
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(this.handle, cx, cy);
        return Win32DPIUtils.pixelToPointAsSize(new Point(cx[0], cy[0]), this.zoom);
    }

    public int indexOf(Image image) {
        int count = OS.ImageList_GetImageCount(this.handle);
        for (int i = 0; i < count; ++i) {
            Image potentialMatch = this.getOrClearIfDisposed(i);
            if (potentialMatch == null || !potentialMatch.equals(image)) continue;
            return i;
        }
        return -1;
    }

    public void put(int index, Image image) {
        if (0 <= index && index < this.images.length && this.images[index] == image) {
            return;
        }
        int count = OS.ImageList_GetImageCount(this.handle);
        if (0 > index || index >= count) {
            return;
        }
        if (image != null) {
            this.setForAllHandles(index, image, count);
        }
        this.images[index] = image;
    }

    public void remove(int index) {
        int count = OS.ImageList_GetImageCount(this.handle);
        if (0 > index || index >= count) {
            return;
        }
        this.zoomToHandle.values().forEach(handle -> OS.ImageList_Remove(handle, index));
        System.arraycopy(this.images, index + 1, this.images, index, --count - index);
        this.images[index] = null;
    }

    public int removeRef() {
        return --this.refCount;
    }

    private void setForAllHandles(int index, Image image, int count) {
        this.zoomToHandle.forEach((zoom, handle) -> this.set(index, image, count, (long)handle, (int)zoom));
    }

    void set(int index, Image image, int count, long listHandle, int zoom) {
        long hImage = Image.win32_getHandle(image, zoom);
        int[] cx = new int[1];
        int[] cy = new int[1];
        OS.ImageList_GetIconSize(listHandle, cx, cy);
        switch (image.type) {
            case 0: {
                long hBitmap = 0L;
                long hMask = 0L;
                ImageData data = image.getImageData(zoom);
                switch (data.getTransparencyType()) {
                    case 1: {
                        boolean fullyTransparent = true;
                        if (data.alphaData == null) {
                            fullyTransparent = false;
                        } else {
                            for (byte alphaData : data.alphaData) {
                                if (alphaData == 0) continue;
                                fullyTransparent = false;
                                break;
                            }
                        }
                        if (!fullyTransparent) {
                            hBitmap = this.copyWithAlpha(hImage, -1, data.alphaData, cx[0], cy[0]);
                            break;
                        }
                        hBitmap = this.copyBitmap(hImage, cx[0], cy[0]);
                        hMask = this.createMaskFromAlpha(data, cx[0], cy[0]);
                        break;
                    }
                    case 4: {
                        int background = -1;
                        Color color = image.getBackground();
                        if (color != null) {
                            background = color.handle;
                        }
                        hBitmap = this.copyBitmap(hImage, cx[0], cy[0]);
                        hMask = this.createMask(hImage, cx[0], cy[0], background, data.transparentPixel);
                        break;
                    }
                    default: {
                        hBitmap = this.copyBitmap(hImage, cx[0], cy[0]);
                        if (index == count) break;
                        hMask = this.createMask(hImage, cx[0], cy[0], -1, -1);
                    }
                }
                if (index == count) {
                    OS.ImageList_Add(listHandle, hBitmap, hMask);
                } else {
                    OS.ImageList_Replace(listHandle, index, hBitmap, hMask);
                }
                if (hMask != 0L) {
                    OS.DeleteObject(hMask);
                }
                if (hBitmap == hImage) break;
                OS.DeleteObject(hBitmap);
                break;
            }
            case 1: {
                long hIcon = this.copyIcon(hImage, cx[0], cy[0]);
                OS.ImageList_ReplaceIcon(listHandle, index == count ? -1 : index, hIcon);
                OS.DestroyIcon(hIcon);
                break;
            }
        }
    }

    public int size() {
        int result = 0;
        int count = OS.ImageList_GetImageCount(this.handle);
        for (int i = 0; i < count; ++i) {
            Image image = this.getOrClearIfDisposed(i);
            if (image == null) continue;
            ++result;
        }
        return result;
    }
}

