/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Control;

public class BidiUtil {
    public static final int KEYBOARD_NON_BIDI = 0;
    public static final int KEYBOARD_BIDI = 1;
    static int isBidiPlatform = -1;
    public static final int CLASSIN = 1;
    public static final int LINKBEFORE = 2;
    public static final int LINKAFTER = 4;
    static Map<LONG, Runnable> languageMap = new HashMap<LONG, Runnable>();
    static Map<LONG, LONG> oldProcMap = new HashMap<LONG, LONG>();
    static Callback callback = new Callback(BidiUtil.class, "windowProc", 4);
    static final int GCP_REORDER = 2;
    static final int GCP_GLYPHSHAPE = 16;
    static final int GCP_LIGATE = 32;
    static final int GCP_CLASSIN = 524288;
    static final byte GCPCLASS_ARABIC = 2;
    static final byte GCPCLASS_HEBREW = 2;
    static final byte GCPCLASS_LOCALNUMBER = 4;
    static final byte GCPCLASS_LATINNUMBER = 5;
    static final int GCPGLYPH_LINKBEFORE = 32768;
    static final int GCPGLYPH_LINKAFTER = 16384;
    static final int ETO_CLIPPED = 4;
    static final int ETO_GLYPH_INDEX = 16;
    static final int LANG_ARABIC = 1;
    static final int LANG_HEBREW = 13;
    static final int LANG_FARSI = 41;
    static final int HKL_NEXT = 1;
    static final int HKL_PREV = 0;
    public static final int CLASS_HEBREW = 2;
    public static final int CLASS_ARABIC = 2;
    public static final int CLASS_LOCALNUMBER = 4;
    public static final int CLASS_LATINNUMBER = 5;
    public static final int REORDER = 2;
    public static final int LIGATE = 32;
    public static final int GLYPHSHAPE = 16;

    private static void addLanguageListener(long hwnd, Runnable runnable) {
        languageMap.put(new LONG(hwnd), runnable);
        BidiUtil.subclass(hwnd);
    }

    public static void addLanguageListener(Control control, Runnable runnable) {
        BidiUtil.addLanguageListener(control.handle, runnable);
    }

    static long EnumSystemLanguageGroupsProc(long lpLangGrpId, long lpLangGrpIdString, long lpLangGrpName, long options, long lParam) {
        if ((int)lpLangGrpId == 12) {
            isBidiPlatform = 1;
            return 0L;
        }
        if ((int)lpLangGrpId == 13) {
            isBidiPlatform = 1;
            return 0L;
        }
        return 1L;
    }

    public static int getKeyboardLanguage() {
        long layout = OS.GetKeyboardLayout(0);
        return BidiUtil.isBidiLang(layout) ? 1 : 0;
    }

    private static long[] getKeyboardLanguageList() {
        int maxSize = 10;
        long[] tempList = new long[maxSize];
        int size = OS.GetKeyboardLayoutList(maxSize, tempList);
        long[] list = new long[size];
        System.arraycopy(tempList, 0, list, 0, size);
        return list;
    }

    private static boolean isBidiLang(long lang) {
        int id = OS.PRIMARYLANGID(OS.LOWORD(lang));
        return id == 1 || id == 13 || id == 41;
    }

    public static boolean isBidiPlatform() {
        if (isBidiPlatform != -1) {
            return isBidiPlatform == 1;
        }
        isBidiPlatform = 0;
        if (!BidiUtil.isKeyboardBidi()) {
            return false;
        }
        Callback callback = new Callback(BidiUtil.class, "EnumSystemLanguageGroupsProc", 5);
        OS.EnumSystemLanguageGroups(callback.getAddress(), 1, 0L);
        callback.dispose();
        return isBidiPlatform == 1;
    }

    private static boolean isKeyboardBidi() {
        for (long language : BidiUtil.getKeyboardLanguageList()) {
            if (!BidiUtil.isBidiLang(language)) continue;
            return true;
        }
        return false;
    }

    private static void removeLanguageListener(long hwnd) {
        languageMap.remove(new LONG(hwnd));
        BidiUtil.unsubclass(hwnd);
    }

    public static void removeLanguageListener(Control control) {
        BidiUtil.removeLanguageListener(control.handle);
    }

    public static int resolveTextDirection(String text) {
        if (text == null) {
            return 0;
        }
        int textDirection = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            byte directionality = Character.getDirectionality(c);
            int strongDirection = BidiUtil.getStrongDirection(directionality);
            if (strongDirection != 0) {
                textDirection = strongDirection;
            }
            if (textDirection == 0x4000000) break;
        }
        return textDirection;
    }

    private static int getStrongDirection(byte directionality) {
        switch (directionality) {
            case 0: {
                return 0x2000000;
            }
            case 1: 
            case 2: {
                return 0x4000000;
            }
        }
        return 0;
    }

    public static void setKeyboardLanguage(int language) {
        if (language == BidiUtil.getKeyboardLanguage()) {
            return;
        }
        boolean bidi = language == 1;
        for (long element : BidiUtil.getKeyboardLanguageList()) {
            if (bidi != BidiUtil.isBidiLang(element)) continue;
            OS.ActivateKeyboardLayout(element, 0);
            return;
        }
    }

    private static void subclass(long hwnd) {
        LONG key = new LONG(hwnd);
        if (oldProcMap.get(key) == null) {
            long oldProc = OS.GetWindowLongPtr(hwnd, -4);
            oldProcMap.put(key, new LONG(oldProc));
            OS.SetWindowLongPtr(hwnd, -4, callback.getAddress());
        }
    }

    private static void unsubclass(long hwnd) {
        LONG key = new LONG(hwnd);
        if (languageMap.get(key) == null) {
            LONG proc = oldProcMap.remove(key);
            if (proc == null) {
                return;
            }
            OS.SetWindowLongPtr(hwnd, -4, proc.value);
        }
    }

    static long windowProc(long hwnd, long msg, long wParam, long lParam) {
        LONG key = new LONG(hwnd);
        switch ((int)msg) {
            case 81: {
                Runnable runnable = languageMap.get(key);
                if (runnable == null) break;
                runnable.run();
            }
        }
        LONG oldProc = oldProcMap.get(key);
        return OS.CallWindowProc(oldProc.value, hwnd, (int)msg, wParam, lParam);
    }
}

