/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArraySerializer;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializersKt;
import kotlinx.serialization.json.JsonLiteralSerializer;
import kotlinx.serialization.json.JsonNullSerializer;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectSerializer;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonPrimitiveSerializer;

public final class JsonElementSerializer
implements KSerializer<JsonElement> {
    public static final JsonElementSerializer INSTANCE = new JsonElementSerializer();
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildSerialDescriptor("kotlinx.serialization.json.JsonElement", PolymorphicKind.SEALED.INSTANCE, new SerialDescriptor[0], JsonElementSerializer::descriptor$lambda$5);

    private JsonElementSerializer() {
    }

    @Override
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public void serialize(Encoder encoder, JsonElement value) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        JsonElementSerializersKt.access$verify(encoder);
        JsonElement jsonElement = value;
        if (jsonElement instanceof JsonPrimitive) {
            encoder.encodeSerializableValue(JsonPrimitiveSerializer.INSTANCE, value);
        } else if (jsonElement instanceof JsonObject) {
            encoder.encodeSerializableValue(JsonObjectSerializer.INSTANCE, value);
        } else if (jsonElement instanceof JsonArray) {
            encoder.encodeSerializableValue(JsonArraySerializer.INSTANCE, value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public JsonElement deserialize(Decoder decoder) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        JsonDecoder input = JsonElementSerializersKt.asJsonDecoder(decoder);
        return input.decodeJsonElement();
    }

    private static final SerialDescriptor descriptor$lambda$5$lambda$0() {
        return JsonPrimitiveSerializer.INSTANCE.getDescriptor();
    }

    private static final SerialDescriptor descriptor$lambda$5$lambda$1() {
        return JsonNullSerializer.INSTANCE.getDescriptor();
    }

    private static final SerialDescriptor descriptor$lambda$5$lambda$2() {
        return JsonLiteralSerializer.INSTANCE.getDescriptor();
    }

    private static final SerialDescriptor descriptor$lambda$5$lambda$3() {
        return JsonObjectSerializer.INSTANCE.getDescriptor();
    }

    private static final SerialDescriptor descriptor$lambda$5$lambda$4() {
        return JsonArraySerializer.INSTANCE.getDescriptor();
    }

    private static final Unit descriptor$lambda$5(ClassSerialDescriptorBuilder $this$buildSerialDescriptor) {
        Intrinsics.checkNotNullParameter($this$buildSerialDescriptor, "$this$buildSerialDescriptor");
        ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, "JsonPrimitive", JsonElementSerializersKt.access$defer(JsonElementSerializer::descriptor$lambda$5$lambda$0), null, false, 12, null);
        ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, "JsonNull", JsonElementSerializersKt.access$defer(JsonElementSerializer::descriptor$lambda$5$lambda$1), null, false, 12, null);
        ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, "JsonLiteral", JsonElementSerializersKt.access$defer(JsonElementSerializer::descriptor$lambda$5$lambda$2), null, false, 12, null);
        ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, "JsonObject", JsonElementSerializersKt.access$defer(JsonElementSerializer::descriptor$lambda$5$lambda$3), null, false, 12, null);
        ClassSerialDescriptorBuilder.element$default($this$buildSerialDescriptor, "JsonArray", JsonElementSerializersKt.access$defer(JsonElementSerializer::descriptor$lambda$5$lambda$4), null, false, 12, null);
        return Unit.INSTANCE;
    }
}

