/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.internal.CachedNames;
import kotlinx.serialization.internal.GeneratedSerializer;
import kotlinx.serialization.internal.Platform_commonKt;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptorKt;
import kotlinx.serialization.internal.PluginHelperInterfacesKt;

public class PluginGeneratedSerialDescriptor
implements SerialDescriptor,
CachedNames {
    private final String serialName;
    private final GeneratedSerializer<?> generatedSerializer;
    private final int elementsCount;
    private int added;
    private final String[] names;
    private final List<Annotation>[] propertiesAnnotations;
    private List<Annotation> classAnnotations;
    private final boolean[] elementsOptionality;
    private Map<String, Integer> indices;
    private final Lazy childSerializers$delegate;
    private final Lazy typeParameterDescriptors$delegate;
    private final Lazy _hashCode$delegate;

    public PluginGeneratedSerialDescriptor(String serialName, GeneratedSerializer<?> generatedSerializer, int elementsCount) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        this.serialName = serialName;
        this.generatedSerializer = generatedSerializer;
        this.elementsCount = elementsCount;
        this.added = -1;
        int n = 0;
        int n2 = this.elementsCount;
        String[] stringArray = new String[n2];
        PluginGeneratedSerialDescriptor pluginGeneratedSerialDescriptor = this;
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = "[UNINITIALIZED]";
        }
        pluginGeneratedSerialDescriptor.names = stringArray;
        this.propertiesAnnotations = new List[this.elementsCount];
        this.elementsOptionality = new boolean[this.elementsCount];
        this.indices = MapsKt.emptyMap();
        this.childSerializers$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> PluginGeneratedSerialDescriptor.childSerializers_delegate$lambda$0(this));
        this.typeParameterDescriptors$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> PluginGeneratedSerialDescriptor.typeParameterDescriptors_delegate$lambda$2(this));
        this._hashCode$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> PluginGeneratedSerialDescriptor._hashCode_delegate$lambda$3(this));
    }

    @Override
    public String getSerialName() {
        return this.serialName;
    }

    @Override
    public final int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    public SerialKind getKind() {
        return StructureKind.CLASS.INSTANCE;
    }

    @Override
    public List<Annotation> getAnnotations() {
        List<Annotation> list = this.classAnnotations;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public Set<String> getSerialNames() {
        return this.indices.keySet();
    }

    private final KSerializer<?>[] getChildSerializers() {
        Lazy lazy = this.childSerializers$delegate;
        return (KSerializer[])lazy.getValue();
    }

    public final SerialDescriptor[] getTypeParameterDescriptors$kotlinx_serialization_core() {
        Lazy lazy = this.typeParameterDescriptors$delegate;
        return (SerialDescriptor[])lazy.getValue();
    }

    private final int get_hashCode() {
        Lazy lazy = this._hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public SerialDescriptor getElementDescriptor(int index) {
        KSerializer<?>[] $this$getChecked$iv = this.getChildSerializers();
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index].getDescriptor();
    }

    @Override
    public boolean isElementOptional(int index) {
        boolean[] $this$getChecked$iv = this.elementsOptionality;
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index];
    }

    @Override
    public List<Annotation> getElementAnnotations(int index) {
        List<Annotation>[] $this$getChecked$iv = this.propertiesAnnotations;
        boolean $i$f$getChecked = false;
        List<Annotation> list = $this$getChecked$iv[index];
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public String getElementName(int index) {
        String[] $this$getChecked$iv = this.names;
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index];
    }

    @Override
    public int getElementIndex(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.indices.get(name);
        return n != null ? n : -3;
    }

    public boolean equals(Object other) {
        boolean bl;
        block13: {
            SerialDescriptor $this$equalsImpl$iv = this;
            boolean $i$f$equalsImpl = false;
            if ($this$equalsImpl$iv == other) {
                bl = true;
            } else if (!(other instanceof PluginGeneratedSerialDescriptor)) {
                bl = false;
            } else if (!Intrinsics.areEqual($this$equalsImpl$iv.getSerialName(), ((SerialDescriptor)other).getSerialName())) {
                bl = false;
            } else {
                PluginGeneratedSerialDescriptor otherDescriptor = (PluginGeneratedSerialDescriptor)other;
                boolean bl2 = false;
                if (!Arrays.equals(this.getTypeParameterDescriptors$kotlinx_serialization_core(), otherDescriptor.getTypeParameterDescriptors$kotlinx_serialization_core())) {
                    bl = false;
                } else if ($this$equalsImpl$iv.getElementsCount() != ((SerialDescriptor)other).getElementsCount()) {
                    bl = false;
                } else {
                    int n = $this$equalsImpl$iv.getElementsCount();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        if (!Intrinsics.areEqual($this$equalsImpl$iv.getElementDescriptor(index$iv).getSerialName(), ((SerialDescriptor)other).getElementDescriptor(index$iv).getSerialName())) {
                            bl = false;
                        } else {
                            if (Intrinsics.areEqual($this$equalsImpl$iv.getElementDescriptor(index$iv).getKind(), ((SerialDescriptor)other).getElementDescriptor(index$iv).getKind())) continue;
                            bl = false;
                        }
                        break block13;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.get_hashCode();
    }

    public String toString() {
        return CollectionsKt.joinToString$default(RangesKt.until(0, this.elementsCount), ", ", this.getSerialName() + '(', ")", 0, null, arg_0 -> PluginGeneratedSerialDescriptor.toString$lambda$6(this, arg_0), 24, null);
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isInline() {
        return SerialDescriptor.DefaultImpls.isInline(this);
    }

    private static final KSerializer[] childSerializers_delegate$lambda$0(PluginGeneratedSerialDescriptor this$0) {
        KSerializer[] kSerializerArray = this$0.generatedSerializer;
        if (this$0.generatedSerializer == null || (kSerializerArray = kSerializerArray.childSerializers()) == null) {
            kSerializerArray = PluginHelperInterfacesKt.EMPTY_SERIALIZER_ARRAY;
        }
        return kSerializerArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final SerialDescriptor[] typeParameterDescriptors_delegate$lambda$2(PluginGeneratedSerialDescriptor this$0) {
        List list;
        KSerializer<?>[] kSerializerArray = this$0.generatedSerializer;
        if (this$0.generatedSerializer != null && (kSerializerArray = kSerializerArray.typeParametersSerializers()) != null) {
            void $this$mapTo$iv$iv;
            KSerializer<?>[] $this$map$iv = kSerializerArray;
            boolean $i$f$map = false;
            KSerializer<?>[] kSerializerArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDescriptor());
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return Platform_commonKt.compactArray(list);
    }

    private static final int _hashCode_delegate$lambda$3(PluginGeneratedSerialDescriptor this$0) {
        return PluginGeneratedSerialDescriptorKt.hashCodeImpl(this$0, this$0.getTypeParameterDescriptors$kotlinx_serialization_core());
    }

    private static final CharSequence toString$lambda$6(PluginGeneratedSerialDescriptor this$0, int i) {
        return this$0.getElementName(i) + ": " + this$0.getElementDescriptor(i).getSerialName();
    }
}

