/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;

public abstract class AbstractPolymorphicSerializer<T>
implements KSerializer<T> {
    public abstract KClass<T> getBaseClass();

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(Encoder encoder, T value) {
        void $this$encodeStructure$iv;
        CompositeEncoder composite$iv;
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        SerializationStrategy<T> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(this, encoder, value);
        Encoder encoder2 = encoder;
        SerialDescriptor descriptor$iv = this.getDescriptor();
        boolean $i$f$encodeStructure = false;
        CompositeEncoder $this$serialize_u24lambda_u240 = composite$iv = $this$encodeStructure$iv.beginStructure(descriptor$iv);
        boolean bl = false;
        $this$serialize_u24lambda_u240.encodeStringElement(this.getDescriptor(), 0, actualSerializer.getDescriptor().getSerialName());
        SerialDescriptor serialDescriptor = this.getDescriptor();
        SerializationStrategy<T> $this$cast$iv = actualSerializer;
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull($this$cast$iv, "null cannot be cast to non-null type kotlinx.serialization.SerializationStrategy<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        $this$serialize_u24lambda_u240.encodeSerializableElement(serialDescriptor, 1, $this$cast$iv, value);
        composite$iv.endStructure(descriptor$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T deserialize(Decoder decoder) {
        Object object;
        void $this$decodeStructure$iv;
        CompositeDecoder composite$iv;
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        Decoder decoder2 = decoder;
        SerialDescriptor descriptor$iv = this.getDescriptor();
        boolean $i$f$decodeStructure = false;
        CompositeDecoder $this$deserialize_u24lambda_u243 = composite$iv = $this$decodeStructure$iv.beginStructure(descriptor$iv);
        boolean bl = false;
        Ref.ObjectRef klassName = new Ref.ObjectRef();
        Object value = null;
        if ($this$deserialize_u24lambda_u243.decodeSequentially()) {
            object = this.decodeSequentially($this$deserialize_u24lambda_u243);
        } else {
            block5: while (true) {
                int index = $this$deserialize_u24lambda_u243.decodeElementIndex(this.getDescriptor());
                switch (index) {
                    case -1: {
                        break block5;
                    }
                    case 0: {
                        klassName.element = $this$deserialize_u24lambda_u243.decodeStringElement(this.getDescriptor(), index);
                        continue block5;
                    }
                    case 1: {
                        if (klassName.element == null) {
                            Object cfr_ignored_0 = klassName.element;
                            Ref.ObjectRef objectRef = klassName;
                            boolean bl2 = false;
                            Ref.ObjectRef objectRef2 = objectRef;
                            String string = "Cannot read polymorphic value before its type token";
                            throw new IllegalArgumentException(string.toString());
                        }
                        klassName.element = klassName.element;
                        DeserializationStrategy serializer = PolymorphicSerializerKt.findPolymorphicSerializer(this, $this$deserialize_u24lambda_u243, (String)klassName.element);
                        value = CompositeDecoder.DefaultImpls.decodeSerializableElement$default($this$deserialize_u24lambda_u243, this.getDescriptor(), index, serializer, null, 8, null);
                        continue block5;
                    }
                    default: {
                        StringBuilder stringBuilder = new StringBuilder().append("Invalid index in polymorphic deserialization of ");
                        String string = (String)klassName.element;
                        if (string == null) {
                            string = "unknown class";
                        }
                        throw new SerializationException(stringBuilder.append(string).append("\n Expected 0, 1 or DECODE_DONE(-1), but found ").append(index).toString());
                    }
                }
                break;
            }
            Object object2 = value;
            if (object2 == null) {
                boolean bl3 = false;
                String string = "Polymorphic value has not been read for class " + (String)klassName.element;
                throw new IllegalArgumentException(string.toString());
            }
            object = object2;
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type T of kotlinx.serialization.internal.AbstractPolymorphicSerializer");
        }
        Object result$iv = object;
        composite$iv.endStructure(descriptor$iv);
        return (T)result$iv;
    }

    private final T decodeSequentially(CompositeDecoder compositeDecoder) {
        String klassName = compositeDecoder.decodeStringElement(this.getDescriptor(), 0);
        DeserializationStrategy serializer = PolymorphicSerializerKt.findPolymorphicSerializer(this, compositeDecoder, klassName);
        return (T)CompositeDecoder.DefaultImpls.decodeSerializableElement$default(compositeDecoder, this.getDescriptor(), 1, serializer, null, 8, null);
    }

    public DeserializationStrategy<T> findPolymorphicSerializerOrNull(CompositeDecoder decoder, String klassName) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        return decoder.getSerializersModule().getPolymorphic(this.getBaseClass(), klassName);
    }

    public SerializationStrategy<T> findPolymorphicSerializerOrNull(Encoder encoder, T value) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        return encoder.getSerializersModule().getPolymorphic(this.getBaseClass(), value);
    }
}

