/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.ranges.RangesKt;

public final class ResizableAtomicArray<T> {
    private volatile AtomicReferenceArray<T> array;

    public ResizableAtomicArray(int initialLength) {
        this.array = new AtomicReferenceArray(initialLength);
    }

    public final int currentLength() {
        return this.array.length();
    }

    public final T get(int index) {
        AtomicReferenceArray<T> array = this.array;
        return index < array.length() ? (T)array.get(index) : null;
    }

    public final void setSynchronized(int index, T value) {
        AtomicReferenceArray<T> curArray = this.array;
        int curLen = curArray.length();
        if (index < curLen) {
            curArray.set(index, value);
            return;
        }
        AtomicReferenceArray<T> newArray = new AtomicReferenceArray<T>(RangesKt.coerceAtLeast(index + 1, 2 * curLen));
        for (int i = 0; i < curLen; ++i) {
            newArray.set(i, curArray.get(i));
        }
        newArray.set(index, value);
        this.array = newArray;
    }
}

