/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.internal.FastServiceLoaderKt;
import kotlinx.coroutines.internal.MainDispatcherFactory;

public final class FastServiceLoader {
    public static final FastServiceLoader INSTANCE = new FastServiceLoader();

    private FastServiceLoader() {
    }

    public final List<MainDispatcherFactory> loadMainDispatcherFactory$kotlinx_coroutines_core() {
        List<MainDispatcherFactory> list;
        Class<MainDispatcherFactory> clz = MainDispatcherFactory.class;
        if (!FastServiceLoaderKt.getANDROID_DETECTED()) {
            return this.load(clz, clz.getClassLoader());
        }
        try {
            MainDispatcherFactory mainDispatcherFactory;
            Object this_$iv;
            Class<?> clz$iv;
            ArrayList<Object> result2 = new ArrayList<Object>(2);
            FastServiceLoader fastServiceLoader = this;
            String serviceClass$iv = "kotlinx.coroutines.android.AndroidDispatcherFactory";
            boolean $i$f$createInstanceOf = false;
            try {
                clz$iv = Class.forName(serviceClass$iv, true, clz.getClassLoader());
                clz$iv = (MainDispatcherFactory)clz.cast(clz$iv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e$iv) {
                clz$iv = null;
            }
            Class<?> clazz = clz$iv;
            if (clazz != null) {
                this_$iv = clazz;
                Class<?> $this$loadMainDispatcherFactory_u24lambda_u240 = this_$iv;
                boolean bl = false;
                result2.add($this$loadMainDispatcherFactory_u24lambda_u240);
            }
            this_$iv = this;
            serviceClass$iv = "kotlinx.coroutines.test.internal.TestMainDispatcherFactory";
            $i$f$createInstanceOf = false;
            try {
                clz$iv = Class.forName(serviceClass$iv, true, clz.getClassLoader());
                mainDispatcherFactory = (MainDispatcherFactory)clz.cast(clz$iv.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e$iv) {
                mainDispatcherFactory = null;
            }
            MainDispatcherFactory mainDispatcherFactory2 = mainDispatcherFactory;
            if (mainDispatcherFactory2 != null) {
                FastServiceLoader $this$loadMainDispatcherFactory_u24lambda_u241 = fastServiceLoader = mainDispatcherFactory2;
                boolean bl = false;
                result2.add($this$loadMainDispatcherFactory_u24lambda_u241);
            }
        }
        catch (Throwable e) {
            list = this.load(clz, clz.getClassLoader());
        }
        return list;
    }

    private final <S> List<S> load(Class<S> service, ClassLoader loader) {
        List<Object> list;
        try {
            list = this.loadProviders$kotlinx_coroutines_core(service, loader);
        }
        catch (Throwable e) {
            list = CollectionsKt.toList((Iterable)ServiceLoader.load(service, loader));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final <S> List<S> loadProviders$kotlinx_coroutines_core(Class<S> service, ClassLoader loader) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        URL it;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        String fullServiceName = "META-INF/services/" + service.getName();
        Enumeration<URL> urls = loader.getResources(fullServiceName);
        ArrayList<URL> arrayList = Collections.list(urls);
        Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$flatMap = false;
        void var8_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (URL)element$iv$iv;
            boolean bl = false;
            list$iv$iv = INSTANCE.parse(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Set providers = CollectionsKt.toSet((List)destination$iv$iv);
        if (!(!((Collection)providers).isEmpty())) {
            boolean $i$a$-require-FastServiceLoader$loadProviders$22 = false;
            String $i$a$-require-FastServiceLoader$loadProviders$22 = "No providers were loaded with FastServiceLoader";
            throw new IllegalArgumentException($i$a$-require-FastServiceLoader$loadProviders$22.toString());
        }
        Iterable $this$map$iv = providers;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.getProviderInstance((String)((Object)it), loader, service));
        }
        return (List)destination$iv$iv;
    }

    private final <S> S getProviderInstance(String name, ClassLoader loader, Class<S> service) {
        Class<?> clazz = Class.forName(name, false, loader);
        if (!service.isAssignableFrom(clazz)) {
            boolean bl = false;
            String string = "Expected service of class " + service + ", but found " + clazz;
            throw new IllegalArgumentException(string.toString());
        }
        return service.cast(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final List<String> parse(URL url) {
        List<String> list;
        String path = url.toString();
        if (StringsKt.startsWith$default(path, "jar", false, 2, null)) {
            String pathToJar = StringsKt.substringBefore$default(StringsKt.substringAfter$default(path, "jar:file:", null, 2, null), '!', null, 2, null);
            String entry = StringsKt.substringAfter$default(path, "!/", null, 2, null);
            FastServiceLoader fastServiceLoader = this;
            JarFile $this$use$iv = new JarFile(pathToJar, false);
            boolean $i$f$use = false;
            Throwable cause$iv = null;
            JarFile file = $this$use$iv;
            boolean bl = false;
            Closeable closeable = new BufferedReader(new InputStreamReader(file.getInputStream(new ZipEntry(entry)), "UTF-8"));
            Throwable throwable = null;
            BufferedReader r = (BufferedReader)closeable;
            boolean bl2 = false;
            List<String> list2 = INSTANCE.parseFile(r);
            CloseableKt.closeFinally(closeable, throwable);
            List<String> list3 = list2;
            $this$use$iv.close();
            return list3;
            {
                catch (Throwable throwable2) {
                    try {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                CloseableKt.closeFinally(closeable, throwable);
                                throw throwable3;
                            }
                        }
                        catch (Throwable e$iv) {
                            cause$iv = e$iv;
                            throw e$iv;
                        }
                    }
                    catch (Throwable throwable4) {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable closeException$iv) {
                            if (cause$iv == null) {
                                throw closeException$iv;
                            }
                            ExceptionsKt.addSuppressed(cause$iv, closeException$iv);
                            throw cause$iv;
                        }
                        throw throwable4;
                    }
                }
            }
        }
        Closeable closeable = new BufferedReader(new InputStreamReader(url.openStream()));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            list = INSTANCE.parseFile(reader);
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return list;
    }

    private final List<String> parseFile(BufferedReader r) {
        Set names = new LinkedHashSet();
        while (r.readLine() != null) {
            boolean bl;
            String serviceName;
            block3: {
                String line;
                serviceName = ((Object)StringsKt.trim(StringsKt.substringBefore$default(line, "#", null, 2, null))).toString();
                CharSequence $this$all$iv = serviceName;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (it == '.' || Character.isJavaIdentifierPart(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) {
                boolean bl3 = false;
                String string = "Illegal service provider class name: " + serviceName;
                throw new IllegalArgumentException(string.toString());
            }
            if (!(((CharSequence)serviceName).length() > 0)) continue;
            names.add(serviceName);
        }
        return CollectionsKt.toList(names);
    }
}

