/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class PackLock {
    private final File keepFile;
    private final FS fs;

    public PackLock(File packFile, FS fs) {
        this.fs = fs;
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, n.substring(0, n.length() - 5) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!((String)msg).endsWith("\n")) {
            msg = (String)msg + "\n";
        }
        if (!(lf = new LockFile(this.keepFile, this.fs)).lock()) {
            return false;
        }
        lf.write(Constants.encode((String)msg));
        return lf.commit();
    }

    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

