/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.descriptors;

import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorImpl;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.internal.PrimitivesKt;

public final class SerialDescriptorsKt {
    public static final SerialDescriptor PrimitiveSerialDescriptor(String serialName, PrimitiveKind kind) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (!(!StringsKt.isBlank(serialName))) {
            boolean bl = false;
            String string = "Blank serial names are prohibited";
            throw new IllegalArgumentException(string.toString());
        }
        return PrimitivesKt.PrimitiveDescriptorSafe(serialName, kind);
    }

    public static final SerialDescriptor buildSerialDescriptor(String serialName, SerialKind kind, SerialDescriptor[] typeParameters, Function1<? super ClassSerialDescriptorBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter(typeParameters, "typeParameters");
        Intrinsics.checkNotNullParameter(builder, "builder");
        if (!(!StringsKt.isBlank(serialName))) {
            boolean $i$a$-require-SerialDescriptorsKt$buildSerialDescriptor$42 = false;
            String $i$a$-require-SerialDescriptorsKt$buildSerialDescriptor$42 = "Blank serial names are prohibited";
            throw new IllegalArgumentException($i$a$-require-SerialDescriptorsKt$buildSerialDescriptor$42.toString());
        }
        if (!(!Intrinsics.areEqual(kind, StructureKind.CLASS.INSTANCE))) {
            boolean bl = false;
            String string = "For StructureKind.CLASS please use 'buildClassSerialDescriptor' instead";
            throw new IllegalArgumentException(string.toString());
        }
        ClassSerialDescriptorBuilder sdBuilder = new ClassSerialDescriptorBuilder(serialName);
        builder.invoke(sdBuilder);
        return new SerialDescriptorImpl(serialName, kind, sdBuilder.getElementNames$kotlinx_serialization_core().size(), ArraysKt.toList(typeParameters), sdBuilder);
    }

    public static /* synthetic */ SerialDescriptor buildSerialDescriptor$default(String string, SerialKind serialKind, SerialDescriptor[] serialDescriptorArray, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = SerialDescriptorsKt::buildSerialDescriptor$lambda$6;
        }
        return SerialDescriptorsKt.buildSerialDescriptor(string, serialKind, serialDescriptorArray, function1);
    }

    private static final Unit buildSerialDescriptor$lambda$6(ClassSerialDescriptorBuilder classSerialDescriptorBuilder) {
        Intrinsics.checkNotNullParameter(classSerialDescriptorBuilder, "<this>");
        return Unit.INSTANCE;
    }
}

