/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.flow.internal;

import java.util.ArrayList;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DebugStringsKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.internal.FusibleFlow;

public abstract class ChannelFlow<T>
implements FusibleFlow<T> {
    public final CoroutineContext context;
    public final int capacity;
    public final BufferOverflow onBufferOverflow;

    public ChannelFlow(CoroutineContext context, int capacity, BufferOverflow onBufferOverflow) {
        this.context = context;
        this.capacity = capacity;
        this.onBufferOverflow = onBufferOverflow;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl = false;
            if (!(this.capacity != -1)) {
                throw new AssertionError();
            }
        }
    }

    public final Function2<ProducerScope<? super T>, Continuation<? super Unit>, Object> getCollectToFun$kotlinx_coroutines_core() {
        return new Function2<ProducerScope<? super T>, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ ChannelFlow<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        ProducerScope it = (ProducerScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.collectTo(it, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<ProducerScope<? super T>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(ProducerScope<? super T> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    public final int getProduceCapacity$kotlinx_coroutines_core() {
        return this.capacity == -3 ? -2 : this.capacity;
    }

    @Override
    public Flow<T> fuse(CoroutineContext context, int capacity, BufferOverflow onBufferOverflow) {
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl = false;
            if (!(capacity != -1)) {
                throw new AssertionError();
            }
        }
        CoroutineContext newContext = context.plus(this.context);
        int newCapacity = 0;
        BufferOverflow newOverflow = null;
        if (onBufferOverflow != BufferOverflow.SUSPEND) {
            newCapacity = capacity;
            newOverflow = onBufferOverflow;
        } else {
            int n;
            if (this.capacity == -3) {
                n = capacity;
            } else if (capacity == -3) {
                n = this.capacity;
            } else if (this.capacity == -2) {
                n = capacity;
            } else if (capacity == -2) {
                n = this.capacity;
            } else {
                int sum;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl = false;
                    if (!(this.capacity >= 0)) {
                        throw new AssertionError();
                    }
                }
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl = false;
                    if (!(capacity >= 0)) {
                        throw new AssertionError();
                    }
                }
                n = (sum = this.capacity + capacity) >= 0 ? sum : Integer.MAX_VALUE;
            }
            newCapacity = n;
            newOverflow = this.onBufferOverflow;
        }
        if (Intrinsics.areEqual(newContext, this.context) && newCapacity == this.capacity && newOverflow == this.onBufferOverflow) {
            return this;
        }
        return this.create(newContext, newCapacity, newOverflow);
    }

    protected abstract ChannelFlow<T> create(CoroutineContext var1, int var2, BufferOverflow var3);

    protected abstract Object collectTo(ProducerScope<? super T> var1, Continuation<? super Unit> var2);

    public ReceiveChannel<T> produceImpl(CoroutineScope scope) {
        return ProduceKt.produce$default(scope, this.context, this.getProduceCapacity$kotlinx_coroutines_core(), this.onBufferOverflow, CoroutineStart.ATOMIC, null, this.getCollectToFun$kotlinx_coroutines_core(), 16, null);
    }

    @Override
    public Object collect(FlowCollector<? super T> collector, Continuation<? super Unit> $completion) {
        return ChannelFlow.collect$suspendImpl(this, collector, $completion);
    }

    static /* synthetic */ <T> Object collect$suspendImpl(ChannelFlow<T> $this, FlowCollector<? super T> collector, Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(collector, $this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FlowCollector<T> $collector;
            final /* synthetic */ ChannelFlow<T> this$0;
            {
                this.$collector = $collector;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = FlowKt.emitAll(this.$collector, this.this$0.produceImpl($this$coroutineScope), (Continuation<? super Unit>)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected String additionalToStringProps() {
        return null;
    }

    public String toString() {
        ArrayList<String> props = new ArrayList<String>(4);
        String string = this.additionalToStringProps();
        if (string != null) {
            String it = string;
            boolean bl = false;
            props.add(it);
        }
        if (this.context != EmptyCoroutineContext.INSTANCE) {
            props.add("context=" + this.context);
        }
        if (this.capacity != -3) {
            props.add("capacity=" + this.capacity);
        }
        if (this.onBufferOverflow != BufferOverflow.SUSPEND) {
            props.add("onBufferOverflow=" + (Object)((Object)this.onBufferOverflow));
        }
        return DebugStringsKt.getClassSimpleName(this) + '[' + CollectionsKt.joinToString$default(props, ", ", null, null, 0, null, null, 62, null) + ']';
    }
}

