/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Waiter;
import kotlinx.coroutines.channels.BufferedChannel;
import kotlinx.coroutines.channels.BufferedChannelKt;
import kotlinx.coroutines.channels.WaiterEB;
import kotlinx.coroutines.internal.OnUndeliveredElementKt;
import kotlinx.coroutines.internal.Segment;
import kotlinx.coroutines.internal.Symbol;

public final class ChannelSegment<E>
extends Segment<ChannelSegment<E>> {
    private final BufferedChannel<E> _channel;
    private final /* synthetic */ AtomicReferenceArray data;

    public ChannelSegment(long id, ChannelSegment<E> prev, BufferedChannel<E> channel, int pointers) {
        super(id, (Segment)prev, pointers);
        this._channel = channel;
        this.data = new AtomicReferenceArray(BufferedChannelKt.SEGMENT_SIZE * 2);
    }

    public final BufferedChannel<E> getChannel() {
        BufferedChannel<E> bufferedChannel = this._channel;
        Intrinsics.checkNotNull(bufferedChannel);
        return bufferedChannel;
    }

    private final /* synthetic */ AtomicReferenceArray getData() {
        return this.data;
    }

    @Override
    public int getNumberOfSlots() {
        return BufferedChannelKt.SEGMENT_SIZE;
    }

    public final void storeElement$kotlinx_coroutines_core(int index, E element) {
        this.setElementLazy(index, element);
    }

    public final E getElement$kotlinx_coroutines_core(int index) {
        return this.getData().get(index * 2);
    }

    public final E retrieveElement$kotlinx_coroutines_core(int index) {
        E e;
        E it = e = this.getElement$kotlinx_coroutines_core(index);
        boolean bl = false;
        this.cleanElement$kotlinx_coroutines_core(index);
        return e;
    }

    public final void cleanElement$kotlinx_coroutines_core(int index) {
        this.setElementLazy(index, null);
    }

    private final void setElementLazy(int index, Object value) {
        this.getData().set(index * 2, value);
    }

    public final Object getState$kotlinx_coroutines_core(int index) {
        return this.getData().get(index * 2 + 1);
    }

    public final void setState$kotlinx_coroutines_core(int index, Object value) {
        this.getData().set(index * 2 + 1, value);
    }

    public final boolean casState$kotlinx_coroutines_core(int index, Object from, Object to) {
        return this.getData().compareAndSet(index * 2 + 1, from, to);
    }

    public final Object getAndSetState$kotlinx_coroutines_core(int index, Object update) {
        return this.getData().getAndSet(index * 2 + 1, update);
    }

    @Override
    public void onCancellation(int index, Throwable cause, CoroutineContext context) {
        Object cur;
        boolean isSender = index >= BufferedChannelKt.SEGMENT_SIZE;
        int index2 = isSender ? index - BufferedChannelKt.SEGMENT_SIZE : index;
        E element = this.getElement$kotlinx_coroutines_core(index2);
        while (true) {
            cur = this.getState$kotlinx_coroutines_core(index2);
            if (cur instanceof Waiter || cur instanceof WaiterEB) {
                Symbol update = isSender ? BufferedChannelKt.access$getINTERRUPTED_SEND$p() : BufferedChannelKt.access$getINTERRUPTED_RCV$p();
                if (!this.casState$kotlinx_coroutines_core(index2, cur, update)) continue;
                this.cleanElement$kotlinx_coroutines_core(index2);
                this.onCancelledRequest(index2, !isSender);
                if (isSender) {
                    Function1 function1 = this.getChannel().onUndeliveredElement;
                    if (function1 != null) {
                        OnUndeliveredElementKt.callUndeliveredElement(function1, element, context);
                    }
                }
                return;
            }
            if (cur == BufferedChannelKt.access$getINTERRUPTED_SEND$p() || cur == BufferedChannelKt.access$getINTERRUPTED_RCV$p()) {
                this.cleanElement$kotlinx_coroutines_core(index2);
                if (isSender) {
                    Function1 function1 = this.getChannel().onUndeliveredElement;
                    if (function1 != null) {
                        OnUndeliveredElementKt.callUndeliveredElement(function1, element, context);
                    }
                }
                return;
            }
            if (cur != BufferedChannelKt.access$getRESUMING_BY_EB$p() && cur != BufferedChannelKt.access$getRESUMING_BY_RCV$p()) break;
        }
        if (cur == BufferedChannelKt.access$getDONE_RCV$p() || cur == BufferedChannelKt.BUFFERED) {
            return;
        }
        if (cur == BufferedChannelKt.getCHANNEL_CLOSED()) {
            return;
        }
        throw new IllegalStateException(("unexpected state: " + cur).toString());
    }

    public final void onCancelledRequest(int index, boolean receiver) {
        if (receiver) {
            this.getChannel().waitExpandBufferCompletion$kotlinx_coroutines_core(this.id * (long)BufferedChannelKt.SEGMENT_SIZE + (long)index);
        }
        this.onSlotCleaned();
    }
}

