/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function2;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Delay;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.DelayWithTimeoutDiagnostics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutCoroutine;
import kotlinx.coroutines.internal.ScopeCoroutine;
import kotlinx.coroutines.intrinsics.UndispatchedKt;

public final class TimeoutKt {
    public static final <T> Object withTimeout(long timeMillis, Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block, Continuation<? super T> $completion) {
        if (timeMillis <= 0L) {
            throw new TimeoutCancellationException("Timed out immediately");
        }
        Continuation<? super T> uCont = $completion;
        boolean bl = false;
        Object object = TimeoutKt.setupTimeout(new TimeoutCoroutine(timeMillis, uCont), block);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private static final <U, T extends U> Object setupTimeout(TimeoutCoroutine<U, ? super T> coroutine, Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block) {
        Continuation cont = coroutine.uCont;
        CoroutineContext context = cont.getContext();
        JobKt.disposeOnCompletion(coroutine, DelayKt.getDelay(context).invokeOnTimeout(coroutine.time, coroutine, coroutine.getContext()));
        return UndispatchedKt.startUndispatchedOrReturnIgnoreTimeout((ScopeCoroutine)coroutine, coroutine, block);
    }

    public static final TimeoutCancellationException TimeoutCancellationException(long time, Delay delay, Job coroutine) {
        Object object;
        block3: {
            block2: {
                object = delay instanceof DelayWithTimeoutDiagnostics ? (DelayWithTimeoutDiagnostics)delay : null;
                if (object == null) break block2;
                if ((object = object.timeoutMessage-LRDsOJo(DurationKt.toDuration(time, DurationUnit.MILLISECONDS))) != null) break block3;
            }
            object = "Timed out waiting for " + time + " ms";
        }
        Object message = object;
        return new TimeoutCancellationException((String)message, coroutine);
    }
}

