/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import kotlin.collections.ArrayDeque;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DispatchedTask;
import kotlinx.coroutines.internal.LimitedDispatcherKt;

public abstract class EventLoop
extends CoroutineDispatcher {
    private long useCount;
    private boolean shared;
    private ArrayDeque<DispatchedTask<?>> unconfinedQueue;

    public long processNextEvent() {
        if (!this.processUnconfinedEvent()) {
            return Long.MAX_VALUE;
        }
        return 0L;
    }

    protected boolean isEmpty() {
        return this.isUnconfinedQueueEmpty();
    }

    protected long getNextTime() {
        ArrayDeque<DispatchedTask<?>> arrayDeque = this.unconfinedQueue;
        if (arrayDeque == null) {
            return Long.MAX_VALUE;
        }
        ArrayDeque<DispatchedTask<?>> queue = arrayDeque;
        return queue.isEmpty() ? Long.MAX_VALUE : 0L;
    }

    public final boolean processUnconfinedEvent() {
        ArrayDeque<DispatchedTask<?>> arrayDeque = this.unconfinedQueue;
        if (arrayDeque == null) {
            return false;
        }
        ArrayDeque<DispatchedTask<?>> queue = arrayDeque;
        DispatchedTask<?> dispatchedTask = queue.removeFirstOrNull();
        if (dispatchedTask == null) {
            return false;
        }
        DispatchedTask<?> task = dispatchedTask;
        task.run();
        return true;
    }

    public final void dispatchUnconfined(DispatchedTask<?> task) {
        ArrayDeque<DispatchedTask<Object>> arrayDeque = this.unconfinedQueue;
        if (arrayDeque == null) {
            ArrayDeque arrayDeque2;
            ArrayDeque it = arrayDeque2 = new ArrayDeque();
            boolean bl = false;
            this.unconfinedQueue = it;
            arrayDeque = arrayDeque2;
        }
        ArrayDeque<DispatchedTask<?>> queue = arrayDeque;
        queue.addLast(task);
    }

    public final boolean isUnconfinedLoopActive() {
        return this.useCount >= this.delta(true);
    }

    public final boolean isUnconfinedQueueEmpty() {
        ArrayDeque<DispatchedTask<?>> arrayDeque = this.unconfinedQueue;
        return arrayDeque != null ? arrayDeque.isEmpty() : true;
    }

    private final long delta(boolean unconfined) {
        return unconfined ? 0x100000000L : 1L;
    }

    public final void incrementUseCount(boolean unconfined) {
        this.useCount += this.delta(unconfined);
        if (!unconfined) {
            this.shared = true;
        }
    }

    public static /* synthetic */ void incrementUseCount$default(EventLoop eventLoop, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: incrementUseCount");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        eventLoop.incrementUseCount(bl);
    }

    public final void decrementUseCount(boolean unconfined) {
        this.useCount -= this.delta(unconfined);
        if (this.useCount > 0L) {
            return;
        }
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl = false;
            if (!(this.useCount == 0L)) {
                throw new AssertionError();
            }
        }
        if (this.shared) {
            this.shutdown();
        }
    }

    @Override
    public final CoroutineDispatcher limitedParallelism(int parallelism) {
        LimitedDispatcherKt.checkParallelism(parallelism);
        return this;
    }

    public void shutdown() {
    }
}

