/*
 * Decompiled with CFR 0.152.
 */
package kotlin.coroutines;

import java.io.Serializable;
import kotlin.coroutines.CombinedContext;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;

public final class CombinedContext
implements Serializable,
CoroutineContext {
    private final CoroutineContext left;
    private final CoroutineContext.Element element;

    public CombinedContext(CoroutineContext left, CoroutineContext.Element element) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(element, "element");
        this.left = left;
        this.element = element;
    }

    @Override
    public <E extends CoroutineContext.Element> E get(CoroutineContext.Key<E> key) {
        CoroutineContext next;
        Intrinsics.checkNotNullParameter(key, "key");
        CombinedContext cur = this;
        while (true) {
            E e;
            if ((e = cur.element.get(key)) != null) {
                E e2;
                E it = e2 = e;
                boolean bl = false;
                return it;
            }
            next = cur.left;
            if (!(next instanceof CombinedContext)) break;
            cur = (CombinedContext)next;
        }
        return next.get(key);
    }

    @Override
    public <R> R fold(R initial, Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        return operation.invoke(this.left.fold(initial, operation), this.element);
    }

    @Override
    public CoroutineContext minusKey(CoroutineContext.Key<?> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object obj = this.element.get(key);
        if (obj != null) {
            Object obj2;
            Object it = obj2 = obj;
            boolean bl = false;
            return this.left;
        }
        CoroutineContext newLeft = this.left.minusKey(key);
        return newLeft == this.left ? (CoroutineContext)this : (newLeft == EmptyCoroutineContext.INSTANCE ? (CoroutineContext)this.element : (CoroutineContext)new CombinedContext(newLeft, this.element));
    }

    private final int size() {
        CombinedContext cur = this;
        int size = 2;
        CoroutineContext coroutineContext;
        while (((coroutineContext = cur.left) instanceof CombinedContext ? (CombinedContext)coroutineContext : null) != null) {
            cur = cur;
            ++size;
        }
        return size;
    }

    private final boolean contains(CoroutineContext.Element element) {
        return Intrinsics.areEqual(this.get(element.getKey()), element);
    }

    private final boolean containsAll(CombinedContext context) {
        CoroutineContext next;
        CombinedContext cur = context;
        while (true) {
            if (!this.contains(cur.element)) {
                return false;
            }
            next = cur.left;
            if (!(next instanceof CombinedContext)) break;
            cur = (CombinedContext)next;
        }
        Intrinsics.checkNotNull(next, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext.Element");
        return this.contains((CoroutineContext.Element)next);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CombinedContext && ((CombinedContext)other).size() == this.size() && ((CombinedContext)other).containsAll(this);
    }

    public int hashCode() {
        return this.left.hashCode() + this.element.hashCode();
    }

    public String toString() {
        return '[' + this.fold("", toString.1.INSTANCE) + ']';
    }

    @Override
    public CoroutineContext plus(CoroutineContext context) {
        return CoroutineContext.DefaultImpls.plus(this, context);
    }
}

