/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Iterator;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;

public final class IndexingIterator<T>
implements Iterator<IndexedValue<? extends T>>,
KMappedMarker {
    private final Iterator<T> iterator;
    private int index;

    public IndexingIterator(Iterator<? extends T> iterator2) {
        Intrinsics.checkNotNullParameter(iterator2, "iterator");
        this.iterator = iterator2;
    }

    @Override
    public final boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public final IndexedValue<T> next() {
        int n = this.index;
        this.index = n + 1;
        if (n < 0) {
            CollectionsKt.throwIndexOverflow();
        }
        return new IndexedValue<T>(n, this.iterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

