/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.EmptyExecutionContext;
import com.apollographql.apollo.api.ExecutionContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;

public final class CombinedExecutionContext
implements ExecutionContext {
    private final ExecutionContext left;
    private final ExecutionContext.Element element;

    public CombinedExecutionContext(ExecutionContext left, ExecutionContext.Element element) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(element, "element");
        this.left = left;
        this.element = element;
    }

    @Override
    public <E extends ExecutionContext.Element> E get(ExecutionContext.Key<E> key) {
        ExecutionContext next;
        Intrinsics.checkNotNullParameter(key, "key");
        CombinedExecutionContext cur = this;
        while (true) {
            E e;
            if ((e = cur.element.get(key)) != null) {
                E it = e;
                boolean bl = false;
                return it;
            }
            next = cur.left;
            if (!(next instanceof CombinedExecutionContext)) break;
            cur = (CombinedExecutionContext)next;
        }
        return next.get(key);
    }

    @Override
    public <R> R fold(R initial, Function2<? super R, ? super ExecutionContext.Element, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        return operation.invoke(this.left.fold(initial, operation), this.element);
    }

    @Override
    public ExecutionContext minusKey(ExecutionContext.Key<?> key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object obj = this.element.get(key);
        if (obj != null) {
            Object it = obj;
            boolean bl = false;
            return this.left;
        }
        ExecutionContext newLeft = this.left.minusKey(key);
        return newLeft == this.left ? (ExecutionContext)this : (newLeft == EmptyExecutionContext.INSTANCE ? (ExecutionContext)this.element : (ExecutionContext)new CombinedExecutionContext(newLeft, this.element));
    }
}

