/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkNode;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.LinkRefDerived;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ast.util.TextNodeConverter;
import com.vladsch.flexmark.internal.Bracket;
import com.vladsch.flexmark.internal.Delimiter;
import com.vladsch.flexmark.internal.LinkRefProcessorData;
import com.vladsch.flexmark.internal.inline.AsteriskDelimiterProcessor;
import com.vladsch.flexmark.internal.inline.UnderscoreDelimiterProcessor;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.InlineParserOptions;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.CharacterNodeFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessor;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.delimiter.DelimiterProcessor;
import com.vladsch.flexmark.util.dependency.DependencyHandler;
import com.vladsch.flexmark.util.dependency.ResolvedDependencies;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InlineParserImpl
implements InlineParser,
ParagraphPreProcessor {
    protected final BitSet originalSpecialCharacters;
    protected final BitSet delimiterCharacters;
    protected final Map<Character, DelimiterProcessor> delimiterProcessors;
    protected final LinkRefProcessorData linkRefProcessorsData;
    protected List<LinkRefProcessor> linkRefProcessors = null;
    protected Map<Character, List<InlineParserExtension>> inlineParserExtensions = null;
    protected List<InlineParserExtensionFactory> inlineParserExtensionFactories = null;
    protected BitSet specialCharacters;
    protected BitSet customCharacters = null;
    protected Map<Character, CharacterNodeFactory> customSpecialCharacterFactoryMap = null;
    protected ArrayList<Node> customSpecialCharacterNodes = null;
    protected ReferenceRepository referenceRepository;
    protected Node block;
    protected BasedSequence input;
    protected int index;
    protected Delimiter lastDelimiter;
    private Bracket lastBracket;
    protected ArrayList<BasedSequence> currentText;
    protected Document document;
    protected final InlineParserOptions options;
    protected Parsing myParsing;

    public static Map<Character, List<InlineParserExtensionFactory>> calculateInlineParserExtensions(DataHolder options, List<InlineParserExtensionFactory> extensionFactories) {
        HashMap<Character, ArrayList<InlineParserExtensionFactory>> extensionMap = new HashMap<Character, ArrayList<InlineParserExtensionFactory>>();
        for (InlineParserExtensionFactory factory : extensionFactories) {
            CharSequence chars = factory.getCharacters();
            for (int i = 0; i < chars.length(); ++i) {
                char c = chars.charAt(i);
                ArrayList<InlineParserExtensionFactory> list = (ArrayList<InlineParserExtensionFactory>)extensionMap.get(Character.valueOf(c));
                if (list == null) {
                    list = new ArrayList<InlineParserExtensionFactory>();
                    extensionMap.put(Character.valueOf(c), list);
                }
                list.add(factory);
            }
        }
        InlineParserExtensionDependencyHandler resolver = new InlineParserExtensionDependencyHandler();
        HashMap<Character, List<InlineParserExtensionFactory>> extensions = new HashMap<Character, List<InlineParserExtensionFactory>>();
        for (Character c : extensionMap.keySet()) {
            ArrayList<InlineParserExtensionFactory> list;
            ArrayList<InlineParserExtensionFactory> resolvedList = list = (ArrayList<InlineParserExtensionFactory>)extensionMap.get(c);
            if (list.size() > 1) {
                InlineParserExtensionDependencies dependencies = (InlineParserExtensionDependencies)resolver.resolveDependencies(list);
                resolvedList = new ArrayList<InlineParserExtensionFactory>(list.size());
                for (InlineParserDependencyStage stage : dependencies.getDependentStages()) {
                    resolvedList.addAll(stage.dependents);
                }
            }
            extensions.put(c, (List<InlineParserExtensionFactory>)resolvedList);
        }
        return extensions;
    }

    @Override
    public void initializeDocument(Parsing parsing, Document document) {
        this.document = document;
        this.referenceRepository = (ReferenceRepository)((Object)document.get(Parser.REFERENCES));
        this.myParsing = parsing;
        this.linkRefProcessors = new ArrayList<LinkRefProcessor>(this.linkRefProcessorsData.processors.size());
        for (LinkRefProcessorFactory factory : this.linkRefProcessorsData.processors) {
            this.linkRefProcessors.add(factory.create(document));
        }
        if (this.inlineParserExtensionFactories != null) {
            Map<Character, List<InlineParserExtensionFactory>> extensions = InlineParserImpl.calculateInlineParserExtensions((DataHolder)document, this.inlineParserExtensionFactories);
            this.inlineParserExtensions = new HashMap<Character, List<InlineParserExtension>>(extensions.size());
            for (Map.Entry<Character, List<InlineParserExtensionFactory>> entry : extensions.entrySet()) {
                ArrayList<InlineParserExtension> extensionList = new ArrayList<InlineParserExtension>(entry.getValue().size());
                for (InlineParserExtensionFactory factory : entry.getValue()) {
                    extensionList.add(factory.create(this));
                }
                this.inlineParserExtensions.put(entry.getKey(), extensionList);
                this.specialCharacters.set(entry.getKey().charValue());
            }
        }
    }

    @Override
    public void finalizeDocument(Document document) {
        assert (this.referenceRepository == document.get(Parser.REFERENCES));
        if (this.inlineParserExtensions != null) {
            for (List<InlineParserExtension> extensionList : this.inlineParserExtensions.values()) {
                for (InlineParserExtension extension : extensionList) {
                    extension.finalizeDocument(this);
                }
            }
        }
    }

    public ArrayList<BasedSequence> getCurrentText() {
        if (this.currentText == null) {
            this.currentText = new ArrayList();
        }
        return this.currentText;
    }

    public InlineParserImpl(DataHolder options, BitSet specialCharacters, BitSet delimiterCharacters, Map<Character, DelimiterProcessor> delimiterProcessors, LinkRefProcessorData linkRefProcessorsData, List<InlineParserExtensionFactory> inlineParserExtensionFactories) {
        this.myParsing = new Parsing(options);
        this.options = new InlineParserOptions(options);
        this.delimiterProcessors = delimiterProcessors;
        this.linkRefProcessorsData = linkRefProcessorsData;
        this.delimiterCharacters = delimiterCharacters;
        this.originalSpecialCharacters = specialCharacters;
        this.specialCharacters = specialCharacters;
        this.inlineParserExtensionFactories = !inlineParserExtensionFactories.isEmpty() ? inlineParserExtensionFactories : null;
    }

    public static BitSet calculateDelimiterCharacters(DataHolder options, Set<Character> characters) {
        BitSet bitSet = new BitSet();
        for (Character character : characters) {
            bitSet.set(character.charValue());
        }
        return bitSet;
    }

    public static BitSet calculateSpecialCharacters(DataHolder options, BitSet delimiterCharacters) {
        BitSet bitSet = new BitSet();
        bitSet.or(delimiterCharacters);
        bitSet.set(10);
        bitSet.set(96);
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(92);
        bitSet.set(33);
        bitSet.set(60);
        bitSet.set(38);
        return bitSet;
    }

    public static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(DataHolder options, List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map = new HashMap<Character, DelimiterProcessor>();
        if (((Boolean)options.get(Parser.ASTERISK_DELIMITER_PROCESSOR)).booleanValue()) {
            InlineParserImpl.addDelimiterProcessors(Collections.singletonList(new AsteriskDelimiterProcessor((Boolean)Parser.STRONG_WRAPS_EMPHASIS.getFrom(options))), map);
        }
        if (((Boolean)options.get(Parser.UNDERSCORE_DELIMITER_PROCESSOR)).booleanValue()) {
            InlineParserImpl.addDelimiterProcessors(Collections.singletonList(new UnderscoreDelimiterProcessor((Boolean)Parser.STRONG_WRAPS_EMPHASIS.getFrom(options))), map);
        }
        InlineParserImpl.addDelimiterProcessors(delimiterProcessors, map);
        return map;
    }

    public static LinkRefProcessorData calculateLinkRefProcessors(final DataHolder options, List<LinkRefProcessorFactory> linkRefProcessors) {
        if (linkRefProcessors.size() > 1) {
            int maxNestingLevel;
            ArrayList<LinkRefProcessorFactory> sortedLinkProcessors = new ArrayList<LinkRefProcessorFactory>(linkRefProcessors.size());
            sortedLinkProcessors.addAll(linkRefProcessors);
            final int[] maxNestingLevelRef = new int[]{0};
            Collections.sort(sortedLinkProcessors, new Comparator<LinkRefProcessorFactory>(){

                @Override
                public int compare(LinkRefProcessorFactory p1, LinkRefProcessorFactory p2) {
                    int lv1 = p1.getBracketNestingLevel(options);
                    int lv2 = p2.getBracketNestingLevel(options);
                    int maxLevel = maxNestingLevelRef[0];
                    if (maxLevel < lv1) {
                        maxLevel = lv1;
                    }
                    if (maxLevel < lv2) {
                        maxLevel = lv2;
                    }
                    maxNestingLevelRef[0] = maxLevel;
                    if (lv1 == lv2) {
                        if (!p1.getWantExclamationPrefix(options)) {
                            ++lv1;
                        }
                        if (!p2.getWantExclamationPrefix(options)) {
                            ++lv2;
                        }
                    }
                    return Integer.compare(lv1, lv2);
                }
            });
            int maxReferenceLinkNesting = maxNestingLevel = maxNestingLevelRef[0];
            int[] nestingLookup = new int[maxNestingLevel + 1];
            maxNestingLevel = -1;
            int index = 0;
            for (LinkRefProcessorFactory linkProcessor : sortedLinkProcessors) {
                if (maxNestingLevel < linkProcessor.getBracketNestingLevel(options)) {
                    maxNestingLevel = linkProcessor.getBracketNestingLevel(options);
                    nestingLookup[maxNestingLevel] = index;
                    if (maxNestingLevel == maxReferenceLinkNesting) break;
                }
                ++index;
            }
            return new LinkRefProcessorData(sortedLinkProcessors, maxReferenceLinkNesting, nestingLookup);
        }
        if (linkRefProcessors.size() > 0) {
            int maxNesting = linkRefProcessors.get(0).getBracketNestingLevel(options);
            int[] nestingLookup = new int[maxNesting + 1];
            return new LinkRefProcessorData(linkRefProcessors, maxNesting, nestingLookup);
        }
        return new LinkRefProcessorData(linkRefProcessors, 0, new int[0]);
    }

    private static void addDelimiterProcessors(List<? extends DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char opening = delimiterProcessor.getOpeningCharacter();
            InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
            char closing = delimiterProcessor.getClosingCharacter();
            if (opening == closing) continue;
            InlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    @Override
    public BasedSequence getInput() {
        return this.input;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Delimiter getLastDelimiter() {
        return this.lastDelimiter;
    }

    @Override
    public Bracket getLastBracket() {
        return this.lastBracket;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public InlineParserOptions getOptions() {
        return this.options;
    }

    @Override
    public Parsing getParsing() {
        return this.myParsing;
    }

    @Override
    public Node getBlock() {
        return this.block;
    }

    @Override
    public List<Node> parseCustom(BasedSequence input, Node node, BitSet customCharacters, Map<Character, CharacterNodeFactory> nodeFactoryMap) {
        this.customCharacters = customCharacters;
        this.specialCharacters.or(customCharacters);
        this.customSpecialCharacterFactoryMap = nodeFactoryMap;
        this.customSpecialCharacterNodes = null;
        this.parse(input, node);
        this.specialCharacters = this.originalSpecialCharacters;
        this.customSpecialCharacterFactoryMap = null;
        this.customCharacters = null;
        return this.customSpecialCharacterNodes;
    }

    @Override
    public void parse(BasedSequence content, Node block) {
        boolean moreToParse;
        this.block = block;
        this.input = content.trim();
        this.index = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
        while (moreToParse = this.parseInline()) {
        }
        this.processDelimiters(null);
        this.flushTextNode();
        if (this.inlineParserExtensions != null) {
            for (List<InlineParserExtension> extensionList : this.inlineParserExtensions.values()) {
                for (InlineParserExtension extension : extensionList) {
                    extension.finalizeBlock(this);
                }
            }
        }
        this.mergeTextNodes(block.getFirstChild(), block.getLastChild());
    }

    @Override
    public void mergeTextNodes(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        for (Node node = fromNode; node != null; node = node.getNext()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (first == null) {
                    first = text;
                }
                last = text;
            } else {
                this.mergeIfNeeded(first, last);
                first = null;
                last = null;
            }
            if (node == toNode) break;
        }
        this.mergeIfNeeded(first, last);
    }

    @Override
    public void mergeIfNeeded(Text first, Text last) {
        if (first != null && last != null && first != last) {
            ArrayList<BasedSequence> sb = new ArrayList<BasedSequence>();
            sb.add(first.getChars());
            Node stop = last.getNext();
            for (Node node = first.getNext(); node != stop; node = node.getNext()) {
                sb.add(node.getChars());
                Node unlink = node;
                unlink.unlink();
            }
            BasedSequence literal = SegmentedSequence.of(sb, (BasedSequence)first.getChars());
            first.setChars(literal);
        }
    }

    @Override
    public int preProcessBlock(Paragraph block, ParserState state) {
        BasedSequence contentChars = block.getChars();
        int leadingSpaces = contentChars.countLeading((CharSequence)" \t");
        int length = contentChars.length();
        while (leadingSpaces <= 3 && length > 3 + leadingSpaces && contentChars.charAt(leadingSpaces) == '[') {
            int pos;
            if (leadingSpaces > 0) {
                contentChars = contentChars.subSequence(leadingSpaces, length);
                length -= leadingSpaces;
            }
            if ((pos = this.parseReference(block, contentChars)) == 0) break;
            contentChars = contentChars.subSequence(pos, length);
            length = contentChars.length();
            leadingSpaces = contentChars.countLeading((CharSequence)" \t");
        }
        return contentChars.getStartOffset() - block.getChars().getStartOffset();
    }

    @Override
    public void moveNodes(Node fromNode, Node toNode) {
        Node next = fromNode.getNext();
        while (next != null) {
            Node nextNode = next.getNext();
            next.unlink();
            fromNode.appendChild(next);
            if (next == toNode) break;
            next = nextNode;
        }
        fromNode.setCharsFromContent();
    }

    protected int parseReference(Block block, BasedSequence s) {
        this.input = s;
        this.index = 0;
        int startIndex = this.index++;
        int matchChars = this.parseLinkLabel();
        if (matchChars == 0) {
            return 0;
        }
        if (this.peek() != ':') {
            return 0;
        }
        BasedSequence rawLabel = this.input.subSequence(0, matchChars + 1);
        this.spnl();
        BasedSequence dest = this.parseLinkDestination();
        if (dest == null || dest.length() == 0) {
            return 0;
        }
        int beforeTitle = this.index;
        this.spnl();
        BasedSequence title = this.parseLinkTitle();
        if (title == null) {
            this.index = beforeTitle;
        }
        boolean atLineEnd = true;
        if (this.index != this.input.length() && this.match(this.myParsing.LINE_END) == null) {
            if (title == null) {
                atLineEnd = false;
            } else {
                title = null;
                this.index = beforeTitle;
                boolean bl = atLineEnd = this.match(this.myParsing.LINE_END) != null;
            }
        }
        if (!atLineEnd) {
            return 0;
        }
        String normalizedLabel = Escaping.normalizeReferenceChars((CharSequence)rawLabel, (boolean)true);
        if (normalizedLabel.isEmpty()) {
            return 0;
        }
        Reference reference = new Reference(rawLabel, dest, title);
        this.referenceRepository.put(normalizedLabel, (Object)reference);
        block.insertBefore((Node)reference);
        return this.index - startIndex;
    }

    public void appendText(BasedSequence text) {
        this.getCurrentText().add(text);
    }

    @Override
    public void appendText(BasedSequence text, int beginIndex, int endIndex) {
        this.getCurrentText().add(text.subSequence(beginIndex, endIndex));
    }

    @Override
    public void appendNode(Node node) {
        this.flushTextNode();
        this.block.appendChild(node);
    }

    @Override
    public Text appendSeparateText(BasedSequence text) {
        Text node = new Text(text);
        this.appendNode(node);
        return node;
    }

    @Override
    public void flushTextNode() {
        if (this.currentText != null) {
            this.block.appendChild((Node)new Text(SegmentedSequence.of(this.currentText, (BasedSequence)BasedSequence.NULL)));
            this.currentText = null;
        }
    }

    protected boolean parseInline() {
        boolean res;
        List<InlineParserExtension> extensions;
        char c = this.peek();
        if (c == '\u0000') {
            return false;
        }
        if (this.inlineParserExtensions != null && (extensions = this.inlineParserExtensions.get(Character.valueOf(c))) != null) {
            for (InlineParserExtension extension : extensions) {
                res = extension.parse(this);
                if (!res) continue;
                return true;
            }
        }
        if (this.customCharacters != null && this.customCharacters.get(c)) {
            res = this.processCustomCharacters();
            if (!res) {
                ++this.index;
                this.appendText(this.input.subSequence(this.index - 1, this.index));
            }
            return true;
        }
        switch (c) {
            case '\n': {
                res = this.parseNewline();
                break;
            }
            case '\\': {
                res = this.parseBackslash();
                break;
            }
            case '`': {
                res = this.parseBackticks();
                break;
            }
            case '[': {
                res = this.parseOpenBracket();
                break;
            }
            case '!': {
                res = this.parseBang();
                break;
            }
            case ']': {
                res = this.parseCloseBracket();
                break;
            }
            case '<': {
                DelimiterProcessor delimiterProcessor;
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter && this.peek(1) == '<') {
                    delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    res = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                res = this.parseAutolink() || this.parseHtmlInline();
                break;
            }
            case '&': {
                res = this.parseEntity();
                break;
            }
            default: {
                DelimiterProcessor delimiterProcessor;
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter) {
                    delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    res = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                res = this.parseString();
            }
        }
        if (!res) {
            ++this.index;
            this.appendText(this.input.subSequence(this.index - 1, this.index));
        }
        return true;
    }

    private boolean processCustomCharacters() {
        char c = this.peek();
        CharacterNodeFactory factory = this.customSpecialCharacterFactoryMap.get(Character.valueOf(c));
        if (factory == null) {
            return false;
        }
        Node node = (Node)factory.create();
        node.setChars(this.input.subSequence(this.index, this.index + 1));
        if (this.currentText != null) {
            int pos;
            BasedSequence prevText = SegmentedSequence.of(this.currentText, (BasedSequence)BasedSequence.NULL);
            this.currentText = null;
            BasedSequence skipped = null;
            for (pos = prevText.length(); pos > 0 && factory.skipPrev(prevText.charAt(pos - 1)); --pos) {
            }
            if (pos < prevText.length()) {
                skipped = prevText.subSequence(pos);
                prevText = prevText.subSequence(0, pos);
            }
            this.block.appendChild((Node)new Text(prevText));
            if (skipped != null && factory.wantSkippedWhitespace()) {
                this.block.appendChild((Node)new WhiteSpace(skipped));
            }
        }
        this.appendNode(node);
        if (this.customSpecialCharacterNodes == null) {
            this.customSpecialCharacterNodes = new ArrayList();
        }
        this.customSpecialCharacterNodes.add(node);
        int pos = this.index + 1;
        do {
            ++this.index;
        } while ((c = this.peek()) != '\u0000' && factory.skipNext(c));
        if (pos < this.index && factory.wantSkippedWhitespace()) {
            this.block.appendChild((Node)new WhiteSpace(this.input.subSequence(pos, this.index)));
        }
        return true;
    }

    @Override
    public BasedSequence match(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher((CharSequence)this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            MatchResult result = matcher.toMatchResult();
            return this.input.subSequence(result.start(), result.end());
        }
        return null;
    }

    @Override
    public BasedSequence[] matchWithGroups(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher((CharSequence)this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            MatchResult result = matcher.toMatchResult();
            int iMax = matcher.groupCount() + 1;
            BasedSequence[] results = new BasedSequence[iMax];
            results[0] = this.input.subSequence(result.start(), result.end());
            for (int i = 1; i < iMax; ++i) {
                results[i] = matcher.group(i) != null ? this.input.subSequence(result.start(i), result.end(i)) : null;
            }
            return results;
        }
        return null;
    }

    @Override
    public Matcher matcher(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher((CharSequence)this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            return matcher;
        }
        return null;
    }

    @Override
    public char peek() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index);
        }
        return '\u0000';
    }

    @Override
    public char peek(int ahead) {
        if (this.index + ahead < this.input.length()) {
            return this.input.charAt(this.index + ahead);
        }
        return '\u0000';
    }

    @Override
    public boolean spnl() {
        this.match(this.myParsing.SPNL);
        return true;
    }

    @Override
    public boolean nonIndentSp() {
        this.match(this.myParsing.SPNI);
        return true;
    }

    @Override
    public boolean sp() {
        this.match(this.myParsing.SP);
        return true;
    }

    @Override
    public boolean spnlUrl() {
        return this.match(this.myParsing.SPNL_URL) != null;
    }

    @Override
    public BasedSequence toEOL() {
        return this.match(this.myParsing.REST_OF_LINE);
    }

    @Override
    public boolean parseNewline() {
        BasedSequence literal;
        Text text;
        boolean crLf = this.index > 0 && this.input.charAt(this.index - 1) == '\r';
        int crLfDelta = crLf ? 1 : 0;
        ++this.index;
        this.flushTextNode();
        Node lastChild = this.block.getLastChild();
        if (lastChild instanceof Text && (lastChild.getChars().endsWith((CharSequence)" ") || crLf && lastChild.getChars().endsWith((CharSequence)" \r"))) {
            int spaces;
            text = (Text)lastChild;
            literal = text.getChars();
            Matcher matcher = this.myParsing.FINAL_SPACE.matcher((CharSequence)literal);
            int n = spaces = matcher.find() ? matcher.end() - matcher.start() - crLfDelta : 0;
            this.appendNode(spaces >= 2 ? new HardLineBreak(this.input.subSequence(this.index - (this.options.hardLineBreakLimit ? 3 + crLfDelta : spaces + 1 + crLfDelta), this.index)) : new SoftLineBreak(this.input.subSequence(this.index - 1 - crLfDelta, this.index)));
            if (spaces + crLfDelta > 0) {
                if (literal.length() > spaces) {
                    lastChild.setChars(literal.subSequence(0, literal.length() - spaces - crLfDelta).trimEnd());
                } else {
                    lastChild.unlink();
                }
            }
        } else {
            if (crLf && lastChild instanceof Text) {
                text = (Text)lastChild;
                literal = text.getChars();
                if (literal.length() > 1) {
                    lastChild.setChars(literal.subSequence(0, literal.length() - crLfDelta).trimEnd());
                } else {
                    lastChild.unlink();
                }
            }
            this.appendNode(new SoftLineBreak(this.input.subSequence(this.index - 1 - crLfDelta, this.index)));
        }
        while (this.peek() == ' ') {
            ++this.index;
        }
        return true;
    }

    protected boolean parseBackslash() {
        ++this.index;
        if (this.peek() == '\n' || this.peek() == '\r') {
            int charsMatched = this.peek(1) == '\n' ? 2 : 1;
            this.appendNode(new HardLineBreak(this.input.subSequence(this.index - 1, this.index + charsMatched)));
            this.index += charsMatched;
        } else if (this.index < this.input.length() && this.myParsing.ESCAPABLE.matcher((CharSequence)this.input.subSequence(this.index, this.index + 1)).matches()) {
            this.appendText(this.input, this.index - 1, this.index + 1);
            ++this.index;
        } else {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
        }
        return true;
    }

    protected boolean parseBackticks() {
        BasedSequence matched;
        BasedSequence ticks = this.match(this.myParsing.TICKS_HERE);
        if (ticks == null) {
            return false;
        }
        int afterOpenTicks = this.index;
        while ((matched = this.match(this.myParsing.TICKS)) != null) {
            if (!matched.equals(ticks)) continue;
            int ticksLength = ticks.length();
            BasedSequence content = this.input.subSequence(afterOpenTicks - ticksLength, this.index - ticksLength);
            BasedSequence codeText = this.input.subSequence(afterOpenTicks, this.index - ticksLength);
            Code node = new Code(this.input.subSequence(afterOpenTicks - ticksLength, afterOpenTicks), codeText, this.input.subSequence(this.index - ticksLength, this.index));
            if (this.options.codeSoftLineBreaks) {
                int length = codeText.length();
                int lastPos = 0;
                while (lastPos < length) {
                    int pos;
                    int softBreak = codeText.indexOfAny((CharSequence)"\n\r", lastPos);
                    int lineBreak = pos = softBreak == -1 ? length : softBreak;
                    Text textNode = new Text(codeText.subSequence(lastPos, pos));
                    node.appendChild(textNode);
                    lastPos = pos;
                    if (lastPos >= length) break;
                    if (codeText.charAt(lastPos) == '\r') {
                        if (++lastPos >= length) break;
                        if (codeText.charAt(lastPos) == '\n') {
                            ++lastPos;
                        }
                    } else {
                        ++lastPos;
                    }
                    if (lastPos < length) {
                        if (lineBreak >= lastPos) continue;
                        SoftLineBreak softLineBreak = new SoftLineBreak(codeText.subSequence(softBreak, lastPos));
                        node.appendChild(softLineBreak);
                        continue;
                    }
                    break;
                }
            } else {
                Text textNode = new Text(codeText);
                node.appendChild(textNode);
            }
            this.appendNode(node);
            return true;
        }
        this.index = afterOpenTicks;
        this.appendText(ticks);
        return true;
    }

    protected boolean parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return false;
        }
        int numDelims = res.count;
        int startIndex = this.index;
        this.index += numDelims;
        Text node = this.appendSeparateText(this.input.subSequence(startIndex, this.index));
        this.lastDelimiter = new Delimiter(this.input, node, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter, startIndex);
        this.lastDelimiter.numDelims = numDelims;
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return true;
    }

    protected boolean parseOpenBracket() {
        int startIndex = this.index++;
        Text node = this.appendSeparateText(this.input.subSequence(this.index - 1, this.index));
        this.addBracket(Bracket.link(this.input, node, startIndex, this.lastBracket, this.lastDelimiter));
        return true;
    }

    protected boolean parseBang() {
        int startIndex = this.index++;
        if (this.peek() == '[') {
            ++this.index;
            Text node = this.appendSeparateText(this.input.subSequence(this.index - 2, this.index));
            this.addBracket(Bracket.image(this.input, node, startIndex + 1, this.lastBracket, this.lastDelimiter));
        } else {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
        }
        return true;
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private ReferenceProcessorMatch matchLinkRef(Bracket opener, int startIndex, int lookAhead, int nesting) {
        int startProc;
        LinkRefProcessor linkProcessor;
        if (this.linkRefProcessorsData.nestingIndex.length == 0) {
            return null;
        }
        ReferenceProcessorMatch match = null;
        BasedSequence textNoBang = null;
        BasedSequence textWithBang = null;
        int iMax = this.linkRefProcessorsData.processors.size();
        for (int i = startProc = this.linkRefProcessorsData.nestingIndex[lookAhead + nesting]; i < iMax && lookAhead + nesting >= (linkProcessor = this.linkRefProcessors.get(i)).getBracketNestingLevel(); ++i) {
            BasedSequence nodeChars;
            boolean wantBang = linkProcessor.getWantExclamationPrefix();
            if (opener.image && wantBang) {
                if (textWithBang == null) {
                    textWithBang = this.input.subSequence(opener.index - 1 - lookAhead, startIndex + lookAhead);
                }
                nodeChars = textWithBang;
            } else if (wantBang && opener.index >= lookAhead + 1 && this.input.charAt(opener.index - 1 - lookAhead) == '!') {
                if (textWithBang == null) {
                    textWithBang = this.input.subSequence(opener.index - 1 - lookAhead, startIndex + lookAhead);
                }
                nodeChars = textWithBang;
            } else {
                if (textNoBang == null) {
                    textNoBang = this.input.subSequence(opener.index - lookAhead, startIndex + lookAhead);
                }
                nodeChars = textNoBang;
            }
            if (!linkProcessor.isMatch(nodeChars)) continue;
            match = new ReferenceProcessorMatch(linkProcessor, wantBang, nodeChars);
            break;
        }
        return match;
    }

    protected boolean parseCloseBracket() {
        ++this.index;
        int startIndex = this.index;
        Bracket opener = this.lastBracket;
        if (opener == null) {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
            return true;
        }
        if (!opener.allowed) {
            this.appendText(this.input.subSequence(this.index - 1, this.index));
            this.removeLastBracket();
            return true;
        }
        int nestedBrackets = 0;
        BasedSequence dest = null;
        BasedSequence title = null;
        BasedSequence ref = null;
        boolean isLinkOrImage = false;
        boolean refIsBare = false;
        ReferenceProcessorMatch linkRefProcessorMatch = null;
        boolean refIsDefined = false;
        BasedSequence linkOpener = BasedSequence.NULL;
        BasedSequence linkCloser = BasedSequence.NULL;
        BasedSequence bareRef = BasedSequence.NULL;
        BasedSequence imageUrlContent = null;
        int preSpaceIndex = this.index;
        if (this.options.spaceInLinkElements && this.peek() == ' ') {
            this.sp();
        }
        if (this.peek() == '(') {
            int savedIndex = this.index;
            linkOpener = this.input.subSequence(this.index, this.index + 1);
            ++this.index;
            this.spnl();
            dest = this.parseLinkDestination();
            if (dest != null) {
                if (this.options.parseMultiLineImageUrls && opener.image && !dest.startsWith((CharSequence)"<") && dest.endsWith((CharSequence)"?") && this.spnlUrl()) {
                    int contentStart;
                    int contentEnd = contentStart = this.index;
                    while (true) {
                        this.sp();
                        BasedSequence multiLineTitle = this.parseLinkTitle();
                        if (multiLineTitle != null) {
                            this.sp();
                        }
                        if (this.peek() == ')') {
                            linkCloser = this.input.subSequence(this.index, this.index + 1);
                            ++this.index;
                            imageUrlContent = this.input.subSequence(contentStart, contentEnd);
                            title = multiLineTitle;
                            isLinkOrImage = true;
                        } else {
                            BasedSequence restOfLine = this.toEOL();
                            if (restOfLine != null) {
                                contentEnd = this.index;
                                continue;
                            }
                        }
                        break;
                    }
                } else {
                    this.spnl();
                    if (this.myParsing.WHITESPACE.matcher((CharSequence)this.input.subSequence(this.index - 1, this.index)).matches()) {
                        title = this.parseLinkTitle();
                        this.spnl();
                    }
                    if (this.peek() == ')') {
                        linkCloser = this.input.subSequence(this.index, this.index + 1);
                        ++this.index;
                        isLinkOrImage = true;
                    } else {
                        this.index = savedIndex;
                    }
                }
            } else {
                this.index = savedIndex;
            }
        } else {
            this.index = preSpaceIndex;
        }
        if (!isLinkOrImage) {
            if (!this.options.matchLookaheadFirst) {
                linkRefProcessorMatch = this.matchLinkRef(opener, startIndex, 0, nestedBrackets);
            }
            if (linkRefProcessorMatch == null) {
                int maxWanted = this.linkRefProcessorsData.maxNesting;
                int maxAvail = 0;
                if (maxWanted > nestedBrackets) {
                    Bracket nested = opener;
                    while (nested.previous != null && nested.index == nested.previous.index + 1 && this.peek(maxAvail) == ']') {
                        nested = nested.previous;
                        if (++maxAvail + nestedBrackets != maxWanted && !nested.image) continue;
                    }
                }
                int nesting = maxAvail + 1;
                while (nesting-- > 0) {
                    linkRefProcessorMatch = this.matchLinkRef(opener, startIndex, nesting, nestedBrackets);
                    if (linkRefProcessorMatch == null) continue;
                    if (nesting <= 0) break;
                    while (nesting-- > 0) {
                        ++this.index;
                        this.lastBracket.node.unlink();
                        this.removeLastBracket();
                    }
                    opener = this.lastBracket;
                    break;
                }
            }
            if (linkRefProcessorMatch == null) {
                int beforeLabel = this.index;
                int labelLength = this.parseLinkLabel();
                if (labelLength > 2) {
                    ref = this.input.subSequence(beforeLabel, beforeLabel + labelLength);
                } else if (!opener.bracketAfter) {
                    bareRef = this.input.subSequence(beforeLabel, beforeLabel + labelLength);
                    ref = opener.image ? this.input.subSequence(opener.index - 1, startIndex) : this.input.subSequence(opener.index, startIndex);
                    refIsBare = true;
                }
                if (ref != null) {
                    String normalizedLabel = Escaping.normalizeReferenceChars((CharSequence)ref, (boolean)true);
                    if (this.referenceRepository.containsKey(normalizedLabel)) {
                        BasedSequence sequence = this.input.subSequence(opener.index, startIndex);
                        boolean containsLinks = InlineParserImpl.containsLinkRefs(refIsBare ? ref : sequence, opener.node.getNext(), true);
                        isLinkOrImage = !containsLinks;
                        refIsDefined = true;
                    } else if (!opener.isStraddling(ref)) {
                        if (!refIsBare && this.peek() == '[') {
                            int beforeNext = this.index;
                            int nextLength = this.parseLinkLabel();
                            if (nextLength > 0) {
                                this.index = beforeLabel;
                            } else {
                                boolean containsLinks = InlineParserImpl.containsLinkRefs(ref, opener.node.getNext(), null);
                                if (!containsLinks) {
                                    refIsBare = true;
                                    isLinkOrImage = true;
                                }
                            }
                        } else {
                            boolean containsLinks = InlineParserImpl.containsLinkRefs(ref, opener.node.getNext(), null);
                            if (!containsLinks) {
                                isLinkOrImage = true;
                            }
                        }
                    }
                }
            }
        }
        if (isLinkOrImage || linkRefProcessorMatch != null) {
            LinkNode insertNode;
            this.flushTextNode();
            boolean isImage = opener.image;
            if (linkRefProcessorMatch != null) {
                if (!linkRefProcessorMatch.wantExclamation && isImage) {
                    this.appendText(this.input.subSequence(opener.index - 1, opener.index));
                    opener.node.setChars(opener.node.getChars().subSequence(1));
                    isImage = false;
                }
                insertNode = linkRefProcessorMatch.processor.createNode(linkRefProcessorMatch.nodeChars);
            } else {
                insertNode = ref != null ? (isImage ? new ImageRef() : new LinkRef()) : (isImage ? new Image() : new Link());
            }
            Node node = opener.node.getNext();
            while (node != null) {
                Node next = node.getNext();
                insertNode.appendChild(node);
                node = next;
            }
            if (linkRefProcessorMatch != null && insertNode.hasChildren()) {
                BasedSequence original = insertNode.getChildChars();
                BasedSequence text = linkRefProcessorMatch.processor.adjustInlineText(this.document, insertNode);
                Delimiter delimiter = this.lastDelimiter;
                while (delimiter != null) {
                    Delimiter prevDelimiter = delimiter.previous;
                    BasedSequence delimiterChars = delimiter.getInput().subSequence(delimiter.getStartIndex(), delimiter.getEndIndex());
                    if (!(!original.containsAllOf(delimiterChars) || text.containsAllOf(delimiterChars) && linkRefProcessorMatch.processor.allowDelimiters(delimiterChars, this.document, insertNode))) {
                        this.removeDelimiterKeepNode(delimiter);
                    }
                    delimiter = prevDelimiter;
                }
                if (!text.containsAllOf(original)) {
                    for (Node node2 : insertNode.getChildren()) {
                        BasedSequence nodeChars = node2.getChars();
                        if (text.containsSomeOf(nodeChars)) {
                            if (text.containsAllOf(nodeChars)) continue;
                            BasedSequence chars = text.intersect(nodeChars);
                            node2.setChars(chars);
                            continue;
                        }
                        node2.unlink();
                    }
                }
            }
            this.appendNode(insertNode);
            if (insertNode instanceof RefNode) {
                RefNode refNode = insertNode;
                refNode.setReferenceChars(ref);
                if (refIsDefined) {
                    refNode.setDefined(true);
                }
                if (!refIsBare) {
                    refNode.setTextChars(this.input.subSequence(isImage ? opener.index - 1 : opener.index, startIndex));
                } else if (!bareRef.isEmpty()) {
                    refNode.setTextOpeningMarker(bareRef.subSequence(0, 1));
                    refNode.setTextClosingMarker(bareRef.endSequence(1));
                }
                insertNode.setCharsFromContent();
            } else if (insertNode instanceof InlineLinkNode) {
                InlineLinkNode inlineLinkNode = (InlineLinkNode)insertNode;
                inlineLinkNode.setUrlChars(dest);
                inlineLinkNode.setTitleChars(title);
                inlineLinkNode.setLinkOpeningMarker(linkOpener);
                inlineLinkNode.setLinkClosingMarker(linkCloser);
                inlineLinkNode.setTextChars(isImage ? this.input.subSequence(opener.index - 1, startIndex) : this.input.subSequence(opener.index, startIndex));
                if (imageUrlContent != null) {
                    ((Image)insertNode).setUrlContent(imageUrlContent);
                }
                insertNode.setCharsFromContent();
            }
            this.processDelimiters(opener.previousDelimiter);
            Text toRemove = opener.node;
            this.removeLastBracket();
            if (linkRefProcessorMatch != null) {
                linkRefProcessorMatch.processor.updateNodeElements(this.document, insertNode);
            }
            if (insertNode instanceof Link) {
                Bracket bracket = this.lastBracket;
                while (bracket != null) {
                    if (!bracket.image) {
                        bracket.allowed = false;
                    }
                    bracket = bracket.previous;
                }
                InlineParserImpl.collapseLinkRefChildren(insertNode, null);
            } else if (insertNode instanceof RefNode) {
                InlineParserImpl.collapseLinkRefChildren(insertNode, true);
            }
            toRemove.unlink();
            return true;
        }
        this.index = startIndex;
        this.appendText(this.input.subSequence(this.index - 1, this.index));
        this.removeLastBracket();
        return true;
    }

    protected static boolean containsLinkRefs(BasedSequence nodeChars, Node next, Boolean isDefined) {
        int startOffset = nodeChars.getStartOffset();
        int endOffset = nodeChars.getEndOffset();
        while (next != null) {
            if (next instanceof LinkRef && (isDefined == null || ((LinkRef)next).isDefined() == isDefined.booleanValue()) && next.getChars().getStartOffset() < endOffset && next.getChars().getEndOffset() > startOffset) {
                return true;
            }
            next = next.getNext();
        }
        return false;
    }

    protected static void collapseLinkRefChildren(Node node, Boolean isTentative) {
        Node child = node.getFirstChild();
        boolean hadCollapse = false;
        while (child != null) {
            Node nextChild = child.getNext();
            if (child instanceof LinkRefDerived && (isTentative == null || isTentative.booleanValue() == ((RefNode)child).isTentative())) {
                InlineParserImpl.collapseLinkRefChildren(child, isTentative);
                child.unlink();
                TextNodeConverter list = new TextNodeConverter(child.getChars());
                list.addChildrenOf(child);
                if (nextChild != null) {
                    list.insertMergedBefore(nextChild);
                } else {
                    list.appendMergedTo(node);
                }
                hadCollapse = true;
            }
            child = nextChild;
        }
        if (hadCollapse) {
            TextNodeConverter.mergeTextNodes(node);
        }
    }

    @Override
    public BasedSequence parseLinkDestination() {
        BasedSequence res = this.match(this.myParsing.LINK_DESTINATION_ANGLES);
        if (res != null) {
            return res;
        }
        if (this.options.linksAllowMatchedParentheses) {
            BasedSequence matched = this.match(this.myParsing.LINK_DESTINATION_MATCHED_PARENS);
            if (matched != null) {
                int openCount = 0;
                int iMax = matched.length();
                for (int i = 0; i < iMax; ++i) {
                    char c = matched.charAt(i);
                    if (c == '\\') {
                        if (i + 1 >= iMax || !this.myParsing.ESCAPABLE.matcher((CharSequence)matched.subSequence(i + 1, i + 2)).matches()) continue;
                        ++i;
                        continue;
                    }
                    if (c == '(') {
                        ++openCount;
                        continue;
                    }
                    if (c != ')') continue;
                    if (openCount == 0) {
                        this.index -= iMax - i;
                        matched = matched.subSequence(0, i);
                        break;
                    }
                    --openCount;
                }
                return this.options.spaceInLinkUrls ? matched.trimEnd((CharSequence)BasedSequence.SPACE) : matched;
            }
            return null;
        }
        BasedSequence matched = this.match(this.myParsing.LINK_DESTINATION);
        return matched != null && this.options.spaceInLinkUrls ? matched.trimEnd((CharSequence)BasedSequence.SPACE) : matched;
    }

    @Override
    public BasedSequence parseLinkTitle() {
        BasedSequence title = this.match(this.myParsing.LINK_TITLE);
        if (title != null) {
            return title;
        }
        return null;
    }

    @Override
    public int parseLinkLabel() {
        BasedSequence m = this.match(this.myParsing.LINK_LABEL);
        return m == null ? 0 : m.length();
    }

    @Override
    public boolean parseAutolink() {
        BasedSequence m = this.match(this.myParsing.EMAIL_AUTOLINK);
        if (m != null) {
            MailLink node = new MailLink(m.subSequence(0, 1), m.subSequence(1, m.length() - 1), m.subSequence(m.length() - 1, m.length()));
            this.appendNode(node);
            return true;
        }
        m = this.match(this.myParsing.AUTOLINK);
        if (m != null) {
            AutoLink node = new AutoLink(m.subSequence(0, 1), m.subSequence(1, m.length() - 1), m.subSequence(m.length() - 1, m.length()));
            this.appendNode(node);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseHtmlInline() {
        BasedSequence m = this.match(this.myParsing.HTML_TAG);
        if (m != null) {
            HtmlInlineBase node = m.startsWith((CharSequence)"<!--") && m.endsWith((CharSequence)"-->") ? new HtmlInlineComment(m) : new HtmlInline(m);
            this.appendNode(node);
            return true;
        }
        return false;
    }

    @Override
    public boolean parseEntity() {
        BasedSequence m = this.match(this.myParsing.ENTITY_HERE);
        if (m != null) {
            HtmlEntity node = new HtmlEntity(m);
            this.appendNode(node);
            return true;
        }
        return false;
    }

    protected boolean parseString() {
        int begin = this.index;
        int length = this.input.length();
        while (this.index != length && !this.specialCharacters.get(this.input.charAt(this.index))) {
            ++this.index;
        }
        if (begin != this.index) {
            this.appendText(this.input, begin, this.index);
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean rightFlanking;
        boolean leftFlanking;
        boolean afterIsPunctuation;
        boolean beforeIsPunctuation;
        int startIndex = this.index;
        int delimiterCount = 0;
        while (this.peek() == delimiterChar) {
            ++delimiterCount;
            ++this.index;
        }
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.index = startIndex;
            return null;
        }
        String before = startIndex == 0 ? "\n" : String.valueOf(this.input.charAt(startIndex - 1));
        char charAfter = this.peek();
        String after = charAfter == '\u0000' ? "\n" : String.valueOf(charAfter);
        boolean beforeIsWhitespace = this.myParsing.UNICODE_WHITESPACE_CHAR.matcher(before).matches();
        boolean afterIsWhitespace = this.myParsing.UNICODE_WHITESPACE_CHAR.matcher(after).matches();
        if (this.options.inlineDelimiterDirectionalPunctuations) {
            beforeIsPunctuation = this.myParsing.PUNCTUATION_OPEN.matcher(before).matches();
            afterIsPunctuation = this.myParsing.PUNCTUATION_CLOSE.matcher(after).matches();
            leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
            rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        } else {
            beforeIsPunctuation = this.myParsing.PUNCTUATION.matcher(before).matches();
            afterIsPunctuation = this.myParsing.PUNCTUATION.matcher(after).matches();
            leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
            rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        }
        boolean canOpen = delimiterChar == delimiterProcessor.getOpeningCharacter() && delimiterProcessor.canBeOpener(before, after, leftFlanking, rightFlanking, beforeIsPunctuation, afterIsPunctuation, beforeIsWhitespace, afterIsWhitespace);
        boolean canClose = delimiterChar == delimiterProcessor.getClosingCharacter() && delimiterProcessor.canBeCloser(before, after, leftFlanking, rightFlanking, beforeIsPunctuation, afterIsPunctuation, beforeIsWhitespace, afterIsWhitespace);
        this.index = startIndex;
        if (canOpen || canClose || !delimiterProcessor.skipNonOpenerCloser()) {
            return new DelimiterData(delimiterCount, canOpen, canClose);
        }
        return null;
    }

    @Override
    public void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int useDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    useDelims = delimiterProcessor.getDelimiterUse(opener, closer);
                    if (useDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            opener.numDelims -= useDelims;
            closer.numDelims -= useDelims;
            this.removeDelimitersBetween(opener, closer);
            opener.numDelims += useDelims;
            closer.numDelims += useDelims;
            delimiterProcessor.process(opener, closer, useDelims);
            opener.numDelims -= useDelims;
            closer.numDelims -= useDelims;
            if (opener.numDelims == 0) {
                this.removeDelimiterAndNode(opener);
            } else {
                opener.node.setChars(opener.node.getChars().subSequence(0, opener.numDelims));
            }
            if (closer.numDelims == 0) {
                Delimiter next = closer.next;
                this.removeDelimiterAndNode(closer);
                closer = next;
                continue;
            }
            BasedSequence chars = closer.node.getChars();
            int length = chars.length();
            closer.node.setChars(chars.subSequence(length - closer.numDelims, length));
            closer.setIndex(closer.getIndex() + useDelims);
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    @Override
    public void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    @Override
    public void removeDelimiterAndNode(Delimiter delim) {
        Text node = delim.node;
        Text previousText = delim.getPreviousNonDelimiterTextNode();
        Text nextText = delim.getNextNonDelimiterTextNode();
        if (previousText != null && nextText != null) {
            previousText.setChars(this.input.baseSubSequence(previousText.getStartOffset(), nextText.getEndOffset()));
            nextText.unlink();
        }
        node.unlink();
        this.removeDelimiter(delim);
    }

    @Override
    public void removeDelimiterKeepNode(Delimiter delim) {
        Node node;
        DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delim.delimiterChar));
        Node node2 = node = delimiterProcessor != null ? delimiterProcessor.unmatchedDelimiterNode(this, delim) : null;
        if (node != null) {
            if (node != delim.node) {
                delim.node.insertAfter(node);
                delim.node.unlink();
            }
        } else {
            node = delim.node;
        }
        Text previousText = delim.getPreviousNonDelimiterTextNode();
        Text nextText = delim.getNextNonDelimiterTextNode();
        if (node instanceof Text && (previousText != null || nextText != null)) {
            if (nextText != null && previousText != null) {
                node.setChars(this.input.baseSubSequence(previousText.getStartOffset(), nextText.getEndOffset()));
                previousText.unlink();
                nextText.unlink();
            } else if (previousText != null) {
                node.setChars(this.input.baseSubSequence(previousText.getStartOffset(), node.getEndOffset()));
                previousText.unlink();
            } else {
                node.setChars(this.input.baseSubSequence(node.getStartOffset(), nextText.getEndOffset()));
                nextText.unlink();
            }
        }
        this.removeDelimiter(delim);
    }

    @Override
    public void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    static class ReferenceProcessorMatch {
        public final LinkRefProcessor processor;
        public final BasedSequence nodeChars;
        public final boolean wantExclamation;

        public ReferenceProcessorMatch(LinkRefProcessor processor, boolean wantExclamation, BasedSequence nodeChars) {
            this.processor = processor;
            this.nodeChars = nodeChars;
            this.wantExclamation = wantExclamation;
        }
    }

    private static class DelimiterData {
        final int count;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(int count, boolean canOpen, boolean canClose) {
            this.count = count;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }

    static class InlineParserExtensionDependencyHandler
    extends DependencyHandler<InlineParserExtensionFactory, InlineParserDependencyStage, InlineParserExtensionDependencies> {
        InlineParserExtensionDependencyHandler() {
        }

        protected Class<? extends InlineParserExtensionFactory> getDependentClass(InlineParserExtensionFactory dependent) {
            return dependent.getClass();
        }

        protected InlineParserExtensionDependencies createResolvedDependencies(List<InlineParserDependencyStage> stages) {
            return new InlineParserExtensionDependencies(stages);
        }

        protected InlineParserDependencyStage createStage(List<InlineParserExtensionFactory> dependents) {
            return new InlineParserDependencyStage(dependents);
        }
    }

    static class InlineParserDependencyStage {
        final List<InlineParserExtensionFactory> dependents;

        public InlineParserDependencyStage(List<InlineParserExtensionFactory> dependents) {
            this.dependents = dependents;
        }
    }

    static class InlineParserExtensionDependencies
    extends ResolvedDependencies<InlineParserDependencyStage> {
        public InlineParserExtensionDependencies(List<InlineParserDependencyStage> dependentStages) {
            super(dependentStages);
        }
    }
}

