/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.revwalk.AddUnseenToBitmapFilter;
import org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexRemapper;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.SystemReader;

class PackWriterBitmapPreparer {
    private static final int DAY_IN_SECONDS = 86400;
    private static final int DISTANCE_THRESHOLD = 2000;
    private static final Comparator<RevCommit> ORDER_BY_REVERSE_TIMESTAMP = (a, b) -> Integer.signum(b.getCommitTime() - a.getCommitTime());
    private final ObjectReader reader;
    private final ProgressMonitor pm;
    private final Set<? extends ObjectId> want;
    private final PackBitmapIndexBuilder writeBitmaps;
    private final BitmapIndexImpl commitBitmapIndex;
    private final PackBitmapIndexRemapper bitmapRemapper;
    private final BitmapIndexImpl bitmapIndex;
    private final int contiguousCommitCount;
    private final int recentCommitCount;
    private final int recentCommitSpan;
    private final int distantCommitSpan;
    private final int excessiveBranchCount;
    private final long inactiveBranchTimestamp;

    PackWriterBitmapPreparer(ObjectReader reader, PackBitmapIndexBuilder writeBitmaps, ProgressMonitor pm, Set<? extends ObjectId> want, PackConfig config) throws IOException {
        this.reader = reader;
        this.writeBitmaps = writeBitmaps;
        this.pm = pm;
        this.want = want;
        this.commitBitmapIndex = new BitmapIndexImpl(writeBitmaps);
        this.bitmapRemapper = PackBitmapIndexRemapper.newPackBitmapIndex(reader.getBitmapIndex(), writeBitmaps);
        this.bitmapIndex = new BitmapIndexImpl(this.bitmapRemapper);
        this.contiguousCommitCount = config.getBitmapContiguousCommitCount();
        this.recentCommitCount = config.getBitmapRecentCommitCount();
        this.recentCommitSpan = config.getBitmapRecentCommitSpan();
        this.distantCommitSpan = config.getBitmapDistantCommitSpan();
        this.excessiveBranchCount = config.getBitmapExcessiveBranchCount();
        long now = SystemReader.getInstance().getCurrentTime();
        long ageInSeconds = config.getBitmapInactiveBranchAgeInDays() * 86400;
        this.inactiveBranchTimestamp = now / 1000L - ageInSeconds;
    }

    Collection<BitmapCommit> selectCommits(int expectedCommitCount, Set<? extends ObjectId> excludeFromBitmapSelection) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        try (RevWalk rw = new RevWalk(this.reader);){
            BlockList<BitmapCommit> selections;
            int newCommits;
            CommitSelectionHelper selectionHelper;
            RevWalk rw2;
            block26: {
                rw2 = new RevWalk(this.reader);
                this.pm.beginTask(JGitText.get().selectingCommits, 0);
                rw.setRetainBody(false);
                selectionHelper = this.captureOldAndNewCommits(rw, expectedCommitCount, excludeFromBitmapSelection);
                this.pm.endTask();
                newCommits = selectionHelper.getCommitCount();
                selections = new BlockList<BitmapCommit>(selectionHelper.reusedCommits.size() + newCommits / this.recentCommitSpan + 1);
                for (BitmapCommit bitmapCommit : selectionHelper.reusedCommits) {
                    selections.add(bitmapCommit);
                }
                if (newCommits != 0) break block26;
                for (AnyObjectId anyObjectId : selectionHelper.newWants) {
                    selections.add(new BitmapCommit(anyObjectId, false, 0));
                }
                BlockList<BitmapCommit> blockList = selections;
                rw2.close();
                return blockList;
            }
            try {
                this.pm.beginTask(JGitText.get().selectingCommits, newCommits);
                int totalWants = this.want.size();
                BitmapIndexImpl.CompressedBitmapBuilder compressedBitmapBuilder = this.commitBitmapIndex.newBitmapBuilder();
                compressedBitmapBuilder.or(selectionHelper.reusedCommitsBitmap);
                rw2.setRetainBody(false);
                rw2.setRevFilter(new NotInBitmapFilter(compressedBitmapBuilder));
                for (RevCommit revCommit : selectionHelper.newWantsByNewest) {
                    RevCommit rc2;
                    BitmapIndexImpl.CompressedBitmapBuilder tipBitmap = this.commitBitmapIndex.newBitmapBuilder();
                    rw2.markStart((RevCommit)rw2.peel(rw2.parseAny(revCommit)));
                    while ((rc2 = rw2.next()) != null) {
                        tipBitmap.addObject(rc2, 1);
                    }
                    int cardinality = tipBitmap.cardinality();
                    compressedBitmapBuilder.or(tipBitmap);
                    ArrayList chains = new ArrayList();
                    boolean isActiveBranch = true;
                    if (totalWants > this.excessiveBranchCount && !this.isRecentCommit(revCommit)) {
                        isActiveBranch = false;
                    }
                    int index = -1;
                    int nextIn = this.nextSpan(cardinality);
                    int nextFlg = nextIn == this.distantCommitSpan ? 1 : 0;
                    for (RevCommit revCommit2 : selectionHelper) {
                        int distanceFromTip = cardinality - index - 1;
                        if (distanceFromTip == 0) break;
                        if (!tipBitmap.contains(revCommit2)) continue;
                        ++index;
                        --nextIn;
                        this.pm.update(1);
                        if (selectionHelper.newWants.remove(revCommit2)) {
                            if (nextIn > 0) {
                                nextFlg = 0;
                            }
                        } else {
                            boolean mustPick;
                            boolean stillInSpan = nextIn >= 0;
                            boolean isMergeCommit = revCommit2.getParentCount() > 1;
                            boolean bl = mustPick = nextIn <= -this.recentCommitSpan || isActiveBranch && distanceFromTip <= this.contiguousCommitCount || distanceFromTip == 1;
                            if (!mustPick && (stillInSpan || !isMergeCommit)) continue;
                        }
                        int flags = nextFlg;
                        int currDist = distanceFromTip;
                        nextIn = this.nextSpan(distanceFromTip);
                        nextFlg = nextIn == this.distantCommitSpan ? 1 : 0;
                        BitmapIndexImpl.CompressedBitmapBuilder bitmap = this.commitBitmapIndex.newBitmapBuilder();
                        rw.reset();
                        rw.markStart(revCommit2);
                        rw.setRevFilter(new AddUnseenToBitmapFilter(selectionHelper.reusedCommitsBitmap, bitmap));
                        while (rw.next() != null) {
                        }
                        List<BitmapCommit> longestAncestorChain = null;
                        for (List list : chains) {
                            BitmapCommit mostRecentCommit = (BitmapCommit)list.get(list.size() - 1);
                            if (!bitmap.contains(mostRecentCommit) || longestAncestorChain != null && longestAncestorChain.size() >= list.size()) continue;
                            longestAncestorChain = list;
                        }
                        if (longestAncestorChain == null) {
                            longestAncestorChain = new ArrayList<BitmapCommit>();
                            chains.add(longestAncestorChain);
                        }
                        BitmapCommit bc = BitmapCommit.newBuilder(revCommit2).setFlags(flags).setAddToIndex(currDist >= 2000).setReuseWalker(!longestAncestorChain.isEmpty()).build();
                        longestAncestorChain.add(bc);
                        this.writeBitmaps.addBitmap((AnyObjectId)revCommit2, bitmap, 0);
                    }
                    for (List list : chains) {
                        selections.addAll(list);
                    }
                }
                for (AnyObjectId anyObjectId : selectionHelper.newWants) {
                    selections.add(new BitmapCommit(anyObjectId, false, 0));
                }
                this.writeBitmaps.resetBitmaps(selections.size());
                this.pm.endTask();
                BlockList<BitmapCommit> blockList = selections;
                rw2.close();
                return blockList;
            }
            catch (Throwable throwable) {
                try {
                    rw2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private boolean isRecentCommit(RevCommit revCommit) {
        return (long)revCommit.getCommitTime() > this.inactiveBranchTimestamp;
    }

    /*
     * WARNING - void declaration
     */
    private CommitSelectionHelper captureOldAndNewCommits(RevWalk rw, int expectedCommitCount, Set<? extends ObjectId> excludeFromBitmapSelection) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        void var9_13;
        RevCommit rc;
        BitmapIndexImpl.CompressedBitmapBuilder reuse = this.commitBitmapIndex.newBitmapBuilder();
        ArrayList<BitmapCommit> reuseCommits = new ArrayList<BitmapCommit>();
        for (PackBitmapIndexRemapper.Entry entry : this.bitmapRemapper) {
            Object ro;
            if ((entry.getFlags() & 1) != 1 || !((ro = rw.peel(rw.parseAny(entry))) instanceof RevCommit)) continue;
            RevCommit revCommit = (RevCommit)ro;
            reuseCommits.add(new BitmapCommit(revCommit, false, entry.getFlags()));
            if (reuse.contains(revCommit)) continue;
            EWAHCompressedBitmap bitmap = this.bitmapRemapper.ofObjectType(this.bitmapRemapper.getBitmap(revCommit), 1);
            reuse.or(new BitmapIndexImpl.CompressedBitmap(bitmap, this.commitBitmapIndex));
        }
        ArrayList<RevCommit> newWantsByNewest = new ArrayList<RevCommit>(this.want.size());
        HashSet<RevCommit> newWants = new HashSet<RevCommit>(this.want.size());
        for (AnyObjectId anyObjectId : this.want) {
            RevObject ro = rw.peel(rw.parseAny(anyObjectId));
            if (!(ro instanceof RevCommit) || reuse.contains(ro) || excludeFromBitmapSelection.contains(ro)) continue;
            RevCommit rc3 = (RevCommit)ro;
            rw.markStart(rc3);
            newWants.add(rc3);
            newWantsByNewest.add(rc3);
        }
        rw.setRevFilter(new NotInBitmapFilter(reuse));
        RevCommit[] commits = new RevCommit[expectedCommitCount];
        int n = commits.length;
        while ((rc = rw.next()) != null && var9_13 > 0) {
            commits[--var9_13] = rc;
            this.pm.update(1);
        }
        Collections.sort(newWantsByNewest, ORDER_BY_REVERSE_TIMESTAMP);
        return new CommitSelectionHelper(newWants, commits, (int)var9_13, newWantsByNewest, reuse, reuseCommits);
    }

    int nextSpan(int distanceFromTip) {
        if (distanceFromTip < 0) {
            throw new IllegalArgumentException();
        }
        if (distanceFromTip <= this.recentCommitCount) {
            return this.recentCommitSpan;
        }
        int next = Math.min(distanceFromTip - this.recentCommitCount, this.distantCommitSpan);
        return Math.max(next, this.recentCommitSpan);
    }

    BitmapWalker newBitmapWalker() {
        return new BitmapWalker(new ObjectWalk(this.reader), this.bitmapIndex, null);
    }

    private static final class CommitSelectionHelper
    implements Iterable<RevCommit> {
        final Set<? extends ObjectId> newWants;
        final List<RevCommit> newWantsByNewest;
        final BitmapIndex.BitmapBuilder reusedCommitsBitmap;
        final List<BitmapCommit> reusedCommits;
        final RevCommit[] newCommitsByOldest;
        final int newCommitStartPos;

        CommitSelectionHelper(Set<? extends ObjectId> newWants, RevCommit[] commitsByOldest, int commitStartPos, List<RevCommit> newWantsByNewest, BitmapIndex.BitmapBuilder reusedCommitsBitmap, List<BitmapCommit> reuse) {
            this.newWants = newWants;
            this.newCommitsByOldest = commitsByOldest;
            this.newCommitStartPos = commitStartPos;
            this.newWantsByNewest = newWantsByNewest;
            this.reusedCommitsBitmap = reusedCommitsBitmap;
            this.reusedCommits = reuse;
        }

        @Override
        public Iterator<RevCommit> iterator() {
            return new Iterator<RevCommit>(){
                int pos;
                {
                    this.pos = newCommitStartPos;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < newCommitsByOldest.length;
                }

                @Override
                public RevCommit next() {
                    return newCommitsByOldest[this.pos++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        int getCommitCount() {
            return this.newCommitsByOldest.length - this.newCommitStartPos;
        }
    }

    private static class NotInBitmapFilter
    extends RevFilter {
        private final BitmapIndex.BitmapBuilder bitmap;

        NotInBitmapFilter(BitmapIndex.BitmapBuilder bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public final boolean include(RevWalk rw, RevCommit c) {
            if (!this.bitmap.contains(c)) {
                return true;
            }
            for (RevCommit p : c.getParents()) {
                p.add(RevFlag.SEEN);
            }
            return false;
        }

        @Override
        public final NotInBitmapFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }
    }
}

