/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.net.Proxy;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class RequestLine {
    public static final RequestLine INSTANCE = new RequestLine();

    private RequestLine() {
    }

    public final String get(Request request, Proxy.Type proxyType) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter((Object)proxyType, "proxyType");
        StringBuilder $this$get_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$get_u24lambda_u2d0.append(request.method());
        $this$get_u24lambda_u2d0.append(' ');
        if (INSTANCE.includeAuthorityInRequestLine(request, proxyType)) {
            $this$get_u24lambda_u2d0.append(request.url());
        } else {
            $this$get_u24lambda_u2d0.append(INSTANCE.requestPath(request.url()));
        }
        $this$get_u24lambda_u2d0.append(" HTTP/1.1");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public final String requestPath(HttpUrl url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String path = url.encodedPath();
        String query2 = url.encodedQuery();
        return query2 != null ? path + '?' + query2 : path;
    }
}

