/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ForwardingSink;
import okio.Sink;

public class FaultHidingSink
extends ForwardingSink {
    private final Function1<IOException, Unit> onException;
    private boolean hasErrors;

    public FaultHidingSink(Sink delegate, Function1<? super IOException, Unit> onException) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        Intrinsics.checkNotNullParameter(onException, "onException");
        super(delegate);
        this.onException = onException;
    }

    @Override
    public void write(Buffer source2, long byteCount) {
        Intrinsics.checkNotNullParameter(source2, "source");
        if (this.hasErrors) {
            source2.skip(byteCount);
            return;
        }
        try {
            super.write(source2, byteCount);
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke(e);
        }
    }

    @Override
    public void flush() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke(e);
        }
    }

    @Override
    public void close() {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException.invoke(e);
        }
    }
}

