/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.json.internal.CharArrayPool;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.StringOpsKt;

public final class JsonToStringWriter
implements InternalJsonWriter {
    private char[] array = CharArrayPool.INSTANCE.take();
    private int size;

    @Override
    public void writeLong(long value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void writeChar(char c) {
        this.ensureAdditionalCapacity(1);
        int n = this.size;
        this.size = n + 1;
        this.array[n] = c;
    }

    @Override
    public void write(String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        int length = text.length();
        if (length == 0) {
            return;
        }
        this.ensureAdditionalCapacity(length);
        String string = text;
        char[] cArray = this.array;
        int n = this.size;
        int n2 = 0;
        int n3 = text.length();
        string.getChars(n2, n3, cArray, n);
        this.size += length;
    }

    @Override
    public void writeQuoted(String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.ensureAdditionalCapacity(text.length() + 2);
        char[] arr = this.array;
        int sz = this.size;
        arr[sz++] = 34;
        int length = text.length();
        String string = text;
        int n = 0;
        string.getChars(n, length, arr, sz);
        n = sz + length;
        for (int i = sz; i < n; ++i) {
            char ch = arr[i];
            if (ch >= StringOpsKt.getESCAPE_MARKERS().length || StringOpsKt.getESCAPE_MARKERS()[ch] == 0) continue;
            this.appendStringSlowPath(i - sz, i, text);
            return;
        }
        sz += length;
        arr[sz++] = 34;
        this.size = sz;
    }

    private final void appendStringSlowPath(int firstEscapedChar, int currentSize, String string) {
        int sz = currentSize;
        int n = string.length();
        for (int i = firstEscapedChar; i < n; ++i) {
            sz = this.ensureTotalCapacity(sz, 2);
            char ch = string.charAt(i);
            if (ch < StringOpsKt.getESCAPE_MARKERS().length) {
                byte marker = StringOpsKt.getESCAPE_MARKERS()[ch];
                if (marker == 0) {
                    this.array[sz++] = ch;
                    continue;
                }
                if (marker == 1) {
                    String escapedString;
                    Intrinsics.checkNotNull(StringOpsKt.getESCAPE_STRINGS()[ch]);
                    sz = this.ensureTotalCapacity(sz, escapedString.length());
                    String string2 = escapedString;
                    char[] cArray = this.array;
                    int n2 = 0;
                    int n3 = escapedString.length();
                    string2.getChars(n2, n3, cArray, sz);
                    this.size = sz += escapedString.length();
                    continue;
                }
                this.array[sz] = 92;
                this.array[sz + 1] = (char)marker;
                this.size = sz += 2;
                continue;
            }
            this.array[sz++] = ch;
        }
        sz = this.ensureTotalCapacity(sz, 1);
        this.array[sz++] = 34;
        this.size = sz;
    }

    public void release() {
        CharArrayPool.INSTANCE.release(this.array);
    }

    public String toString() {
        return new String(this.array, 0, this.size);
    }

    private final void ensureAdditionalCapacity(int expected) {
        this.ensureTotalCapacity(this.size, expected);
    }

    private final int ensureTotalCapacity(int oldSize, int additional) {
        int newSize = oldSize + additional;
        if (this.array.length <= newSize) {
            char[] cArray = Arrays.copyOf(this.array, RangesKt.coerceAtLeast(newSize, oldSize * 2));
            Intrinsics.checkNotNullExpressionValue(cArray, "copyOf(...)");
            this.array = cArray;
        }
        return oldSize;
    }
}

