/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.ArrayListClassDesc;
import kotlinx.serialization.internal.CollectionSerializer;

public final class ArrayListSerializer<E>
extends CollectionSerializer<E, List<? extends E>, ArrayList<E>> {
    private final SerialDescriptor descriptor;

    public ArrayListSerializer(KSerializer<E> element) {
        Intrinsics.checkNotNullParameter(element, "element");
        super(element);
        this.descriptor = new ArrayListClassDesc(element.getDescriptor());
    }

    @Override
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected ArrayList<E> builder() {
        return new ArrayList();
    }

    @Override
    protected int builderSize(ArrayList<E> $this$builderSize) {
        Intrinsics.checkNotNullParameter($this$builderSize, "<this>");
        return $this$builderSize.size();
    }

    @Override
    protected List<E> toResult(ArrayList<E> $this$toResult) {
        Intrinsics.checkNotNullParameter($this$toResult, "<this>");
        return $this$toResult;
    }

    @Override
    protected ArrayList<E> toBuilder(List<? extends E> $this$toBuilder) {
        Intrinsics.checkNotNullParameter($this$toBuilder, "<this>");
        ArrayList arrayList = $this$toBuilder instanceof ArrayList ? (ArrayList)$this$toBuilder : null;
        if (arrayList == null) {
            arrayList = new ArrayList($this$toBuilder);
        }
        return arrayList;
    }

    @Override
    protected void checkCapacity(ArrayList<E> $this$checkCapacity, int size) {
        Intrinsics.checkNotNullParameter($this$checkCapacity, "<this>");
        $this$checkCapacity.ensureCapacity(size);
    }

    @Override
    protected void insert(ArrayList<E> $this$insert, int index, E element) {
        Intrinsics.checkNotNullParameter($this$insert, "<this>");
        $this$insert.add(index, element);
    }
}

