/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;

public class StringJsonLexer
extends AbstractJsonLexer {
    private final String source;

    public StringJsonLexer(String source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this.source = source2;
    }

    @Override
    protected String getSource() {
        return this.source;
    }

    @Override
    public int prefetchOrEof(int position) {
        return position < this.getSource().length() ? position : -1;
    }

    @Override
    public byte consumeNextToken() {
        String source2 = this.getSource();
        int cpos = this.currentPosition;
        while (cpos != -1 && cpos < source2.length()) {
            char c = source2.charAt(cpos++);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass(c);
        }
        this.currentPosition = source2.length();
        return 10;
    }

    @Override
    public boolean canConsumeValue() {
        int current = this.currentPosition;
        if (current == -1) {
            return false;
        }
        String source2 = this.getSource();
        while (current < source2.length()) {
            char c = source2.charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            this.currentPosition = current;
            return this.isValidValueStart(c);
        }
        this.currentPosition = current;
        return false;
    }

    @Override
    public int skipWhitespaces() {
        int current = this.currentPosition;
        if (current == -1) {
            return current;
        }
        String source2 = this.getSource();
        while (current < source2.length()) {
            char c = source2.charAt(current);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if (!($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t')) break;
            ++current;
        }
        this.currentPosition = current;
        return current;
    }

    @Override
    public void consumeNextToken(char expected) {
        if (this.currentPosition == -1) {
            this.unexpectedToken(expected);
        }
        String source2 = this.getSource();
        int cpos = this.currentPosition;
        while (cpos < source2.length()) {
            char c = source2.charAt(cpos++);
            AbstractJsonLexer abstractJsonLexer = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') continue;
            this.currentPosition = cpos;
            if (c == expected) {
                return;
            }
            this.unexpectedToken(expected);
        }
        this.currentPosition = -1;
        this.unexpectedToken(expected);
    }

    @Override
    public String consumeKeyString() {
        this.consumeNextToken('\"');
        int current = this.currentPosition;
        int closingQuote = StringsKt.indexOf$default((CharSequence)this.getSource(), '\"', current, false, 4, null);
        if (closingQuote == -1) {
            this.consumeStringLenient();
            this.fail$kotlinx_serialization_json((byte)1, false);
            throw new KotlinNothingValueException();
        }
        for (int i = current; i < closingQuote; ++i) {
            if (this.getSource().charAt(i) != '\\') continue;
            return this.consumeString(this.getSource(), this.currentPosition, i);
        }
        this.currentPosition = closingQuote + 1;
        String string = this.getSource().substring(current, closingQuote);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String peekLeadingMatchingValue(String keyToMatch, boolean isLenient) {
        Intrinsics.checkNotNullParameter(keyToMatch, "keyToMatch");
        int positionSnapshot = this.currentPosition;
        try {
            if (this.consumeNextToken() != 6) {
                String string = null;
                return string;
            }
            String firstKey = this.peekString(isLenient);
            if (!Intrinsics.areEqual(firstKey, keyToMatch)) {
                String string = null;
                return string;
            }
            this.discardPeeked();
            if (this.consumeNextToken() != 5) {
                String string = null;
                return string;
            }
            String string = this.peekString(isLenient);
            return string;
        }
        finally {
            this.currentPosition = positionSnapshot;
            this.discardPeeked();
        }
    }
}

