/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.internal.InlineClassDescriptorKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringOpsKt;

public final class JsonElementKt {
    private static final SerialDescriptor jsonUnquotedLiteralDescriptor = InlineClassDescriptorKt.InlinePrimitiveDescriptor("kotlinx.serialization.json.JsonUnquotedLiteral", BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE));

    public static final JsonPrimitive JsonPrimitive(String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, true, null, 4, null);
    }

    public static final SerialDescriptor getJsonUnquotedLiteralDescriptor() {
        return jsonUnquotedLiteralDescriptor;
    }

    public static final JsonPrimitive getJsonPrimitive(JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter($this$jsonPrimitive, "<this>");
        JsonPrimitive jsonPrimitive = $this$jsonPrimitive instanceof JsonPrimitive ? (JsonPrimitive)$this$jsonPrimitive : null;
        if (jsonPrimitive == null) {
            JsonElementKt.error($this$jsonPrimitive, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    public static final int getInt(JsonPrimitive $this$int) {
        long l;
        Intrinsics.checkNotNullParameter($this$int, "<this>");
        boolean $i$f$mapExceptions = false;
        try {
            boolean bl = false;
            l = new StringJsonLexer($this$int.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            throw new NumberFormatException(e$iv.getMessage());
        }
        long result2 = l;
        if (!(Integer.MIN_VALUE <= result2 ? result2 <= Integer.MAX_VALUE : false)) {
            throw new NumberFormatException($this$int.getContent() + " is not an Int");
        }
        return (int)result2;
    }

    public static final long getLong(JsonPrimitive $this$long) {
        long l;
        Intrinsics.checkNotNullParameter($this$long, "<this>");
        boolean $i$f$mapExceptions = false;
        try {
            boolean bl = false;
            l = new StringJsonLexer($this$long.getContent()).consumeNumericLiteral();
        }
        catch (JsonDecodingException e$iv) {
            throw new NumberFormatException(e$iv.getMessage());
        }
        return l;
    }

    public static final double getDouble(JsonPrimitive $this$double) {
        Intrinsics.checkNotNullParameter($this$double, "<this>");
        return Double.parseDouble($this$double.getContent());
    }

    public static final float getFloat(JsonPrimitive $this$float) {
        Intrinsics.checkNotNullParameter($this$float, "<this>");
        return Float.parseFloat($this$float.getContent());
    }

    public static final Boolean getBooleanOrNull(JsonPrimitive $this$booleanOrNull) {
        Intrinsics.checkNotNullParameter($this$booleanOrNull, "<this>");
        return StringOpsKt.toBooleanStrictOrNull($this$booleanOrNull.getContent());
    }

    public static final String getContentOrNull(JsonPrimitive $this$contentOrNull) {
        Intrinsics.checkNotNullParameter($this$contentOrNull, "<this>");
        return $this$contentOrNull instanceof JsonNull ? null : $this$contentOrNull.getContent();
    }

    private static final Void error(JsonElement $this$error, String element) {
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass($this$error.getClass()) + " is not a " + element);
    }
}

