/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;

public abstract class TaggedDecoder<Tag>
implements CompositeDecoder,
Decoder {
    private final ArrayList<Tag> tagStack = new ArrayList();
    private boolean flag;

    @Override
    public SerializersModule getSerializersModule() {
        return SerializersModuleBuildersKt.EmptySerializersModule();
    }

    protected abstract Tag getTag(SerialDescriptor var1, int var2);

    protected Object decodeTaggedValue(Tag tag) {
        throw new SerializationException(Reflection.getOrCreateKotlinClass(this.getClass()) + " can't retrieve untyped values");
    }

    protected boolean decodeTaggedNotNullMark(Tag tag) {
        return true;
    }

    protected boolean decodeTaggedBoolean(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    protected byte decodeTaggedByte(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Byte");
        return (Byte)object;
    }

    protected short decodeTaggedShort(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Short");
        return (Short)object;
    }

    protected int decodeTaggedInt(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
        return (Integer)object;
    }

    protected long decodeTaggedLong(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
        return (Long)object;
    }

    protected float decodeTaggedFloat(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Float");
        return ((Float)object).floatValue();
    }

    protected double decodeTaggedDouble(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Double");
        return (Double)object;
    }

    protected char decodeTaggedChar(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
        return ((Character)object).charValue();
    }

    protected String decodeTaggedString(Tag tag) {
        Object object = this.decodeTaggedValue(tag);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    protected Decoder decodeTaggedInline(Tag tag, SerialDescriptor inlineDescriptor) {
        TaggedDecoder taggedDecoder;
        Intrinsics.checkNotNullParameter(inlineDescriptor, "inlineDescriptor");
        TaggedDecoder $this$decodeTaggedInline_u24lambda_u240 = taggedDecoder = this;
        boolean bl = false;
        $this$decodeTaggedInline_u24lambda_u240.pushTag(tag);
        return taggedDecoder;
    }

    protected <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer);
    }

    @Override
    public Decoder decodeInline(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedInline(this.popTag(), descriptor);
    }

    @Override
    public boolean decodeNotNullMark() {
        Tag Tag = this.getCurrentTagOrNull();
        if (Tag == null) {
            return false;
        }
        Tag currentTag = Tag;
        return this.decodeTaggedNotNullMark(currentTag);
    }

    @Override
    public final Void decodeNull() {
        return null;
    }

    @Override
    public final boolean decodeBoolean() {
        return this.decodeTaggedBoolean(this.popTag());
    }

    @Override
    public final byte decodeByte() {
        return this.decodeTaggedByte(this.popTag());
    }

    @Override
    public final short decodeShort() {
        return this.decodeTaggedShort(this.popTag());
    }

    @Override
    public final int decodeInt() {
        return this.decodeTaggedInt(this.popTag());
    }

    @Override
    public final long decodeLong() {
        return this.decodeTaggedLong(this.popTag());
    }

    @Override
    public final float decodeFloat() {
        return this.decodeTaggedFloat(this.popTag());
    }

    @Override
    public final double decodeDouble() {
        return this.decodeTaggedDouble(this.popTag());
    }

    @Override
    public final char decodeChar() {
        return this.decodeTaggedChar(this.popTag());
    }

    @Override
    public final String decodeString() {
        return this.decodeTaggedString(this.popTag());
    }

    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this;
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
    }

    @Override
    public final boolean decodeBooleanElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedBoolean(this.getTag(descriptor, index));
    }

    @Override
    public final byte decodeByteElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedByte(this.getTag(descriptor, index));
    }

    @Override
    public final short decodeShortElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedShort(this.getTag(descriptor, index));
    }

    @Override
    public final int decodeIntElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedInt(this.getTag(descriptor, index));
    }

    @Override
    public final long decodeLongElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedLong(this.getTag(descriptor, index));
    }

    @Override
    public final float decodeFloatElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedFloat(this.getTag(descriptor, index));
    }

    @Override
    public final double decodeDoubleElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedDouble(this.getTag(descriptor, index));
    }

    @Override
    public final char decodeCharElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedChar(this.getTag(descriptor, index));
    }

    @Override
    public final String decodeStringElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedString(this.getTag(descriptor, index));
    }

    @Override
    public final Decoder decodeInlineElement(SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return this.decodeTaggedInline(this.getTag(descriptor, index), descriptor.getElementDescriptor(index));
    }

    @Override
    public final <T> T decodeSerializableElement(SerialDescriptor descriptor, int index, DeserializationStrategy<? extends T> deserializer, T previousValue) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return (T)this.tagBlock(this.getTag(descriptor, index), () -> TaggedDecoder.decodeSerializableElement$lambda$1(this, deserializer, previousValue));
    }

    private final <E> E tagBlock(Tag tag, Function0<? extends E> block) {
        this.pushTag(tag);
        E r = block.invoke();
        if (!this.flag) {
            this.popTag();
        }
        this.flag = false;
        return r;
    }

    public final ArrayList<Tag> getTagStack$kotlinx_serialization_core() {
        return this.tagStack;
    }

    protected final Tag getCurrentTagOrNull() {
        return (Tag)CollectionsKt.lastOrNull((List)this.tagStack);
    }

    protected final void pushTag(Tag name) {
        this.tagStack.add(name);
    }

    protected final Tag popTag() {
        Tag r = this.tagStack.remove(CollectionsKt.getLastIndex((List)this.tagStack));
        this.flag = true;
        return r;
    }

    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer) {
        return Decoder.DefaultImpls.decodeSerializableValue(this, deserializer);
    }

    @Override
    public boolean decodeSequentially() {
        return CompositeDecoder.DefaultImpls.decodeSequentially(this);
    }

    @Override
    public int decodeCollectionSize(SerialDescriptor descriptor) {
        return CompositeDecoder.DefaultImpls.decodeCollectionSize(this, descriptor);
    }

    private static final Object decodeSerializableElement$lambda$1(TaggedDecoder this$0, DeserializationStrategy $deserializer, Object $previousValue) {
        return this$0.decodeSerializableValue($deserializer, $previousValue);
    }
}

