/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.BufferedChannel;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ConflatedBufferedChannel;

public final class ChannelKt {
    public static final <E> Channel<E> Channel(int capacity, BufferOverflow onBufferOverflow, Function1<? super E, Unit> onUndeliveredElement) {
        Channel channel;
        switch (capacity) {
            case 0: {
                channel = onBufferOverflow == BufferOverflow.SUSPEND ? new BufferedChannel(0, onUndeliveredElement) : (BufferedChannel)new ConflatedBufferedChannel<E>(1, onBufferOverflow, onUndeliveredElement);
                break;
            }
            case -1: {
                if (!(onBufferOverflow == BufferOverflow.SUSPEND)) {
                    boolean bl = false;
                    String string = "CONFLATED capacity cannot be used with non-default onBufferOverflow";
                    throw new IllegalArgumentException(string.toString());
                }
                channel = new ConflatedBufferedChannel<E>(1, BufferOverflow.DROP_OLDEST, onUndeliveredElement);
                break;
            }
            case 0x7FFFFFFF: {
                channel = new BufferedChannel<E>(Integer.MAX_VALUE, onUndeliveredElement);
                break;
            }
            case -2: {
                channel = onBufferOverflow == BufferOverflow.SUSPEND ? new BufferedChannel(Channel.Factory.getCHANNEL_DEFAULT_CAPACITY$kotlinx_coroutines_core(), onUndeliveredElement) : (BufferedChannel)new ConflatedBufferedChannel<E>(1, onBufferOverflow, onUndeliveredElement);
                break;
            }
            default: {
                channel = onBufferOverflow == BufferOverflow.SUSPEND ? new BufferedChannel(capacity, onUndeliveredElement) : (BufferedChannel)new ConflatedBufferedChannel<E>(capacity, onBufferOverflow, onUndeliveredElement);
            }
        }
        return channel;
    }

    public static /* synthetic */ Channel Channel$default(int n, BufferOverflow bufferOverflow, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bufferOverflow = BufferOverflow.SUSPEND;
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        return ChannelKt.Channel(n, bufferOverflow, function1);
    }
}

