/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.api.DeferredFragmentIdentifier;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.BufferedSourceJsonReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import okio.BufferedSource;

public final class DeferredJsonMerger {
    private final Map<String, Object> _merged = new LinkedHashMap();
    private final Map<String, Object> merged = this._merged;
    private final Set<DeferredFragmentIdentifier> _mergedFragmentIds = new LinkedHashSet();
    private final Set<DeferredFragmentIdentifier> mergedFragmentIds = this._mergedFragmentIds;
    private boolean hasNext = true;
    private boolean isEmptyPayload;

    public final Set<DeferredFragmentIdentifier> getMergedFragmentIds() {
        return this.mergedFragmentIds;
    }

    public final boolean getHasNext() {
        return this.hasNext;
    }

    public final boolean isEmptyPayload() {
        return this.isEmptyPayload;
    }

    public final Map<String, Object> merge(BufferedSource payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        Map<String, Object> payloadMap = this.jsonToMap(payload);
        return this.merge(payloadMap);
    }

    public final Map<String, Object> merge(Map<String, ? extends Object> payload) {
        List incrementalList;
        Intrinsics.checkNotNullParameter(payload, "payload");
        if (this.merged.isEmpty()) {
            this._merged.putAll(payload);
            return this.merged;
        }
        Object object = payload.get("incremental");
        List list = incrementalList = object instanceof List ? (List)object : null;
        if (incrementalList == null) {
            this.isEmptyPayload = true;
        } else {
            this.isEmptyPayload = false;
            List mergedErrors = new ArrayList();
            List mergedExtensions = new ArrayList();
            for (Map incrementalItem : incrementalList) {
                Object it;
                this.mergeData(incrementalItem);
                Object v = incrementalItem.get("errors");
                if ((v instanceof List ? (List)v : null) != null) {
                    it = it;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)mergedErrors, (Iterable)it);
                }
                v = incrementalItem.get("extensions");
                if ((v instanceof Map ? (Map)v : null) == null) continue;
                it = it;
                boolean bl = false;
                ((Collection)mergedExtensions).add(it);
            }
            if (!((Collection)mergedErrors).isEmpty()) {
                this._merged.put("errors", mergedErrors);
            } else {
                this._merged.remove("errors");
            }
            if (!((Collection)mergedExtensions).isEmpty()) {
                this._merged.put("extensions", MapsKt.mapOf(TuplesKt.to("incremental", mergedExtensions)));
            } else {
                this._merged.remove("extensions");
            }
        }
        Boolean bl = (Boolean)payload.get("hasNext");
        this.hasNext = bl != null ? bl : false;
        return this.merged;
    }

    private final void mergeData(Map<String, ? extends Object> incrementalItem) {
        Map data = (Map)incrementalItem.get("data");
        Object object = incrementalItem.get("path");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
        List path = (List)object;
        Object object2 = this.merged.get("data");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        Map mergedData = (Map)object2;
        if (data != null) {
            Object object3 = this.nodeAtPath(mergedData, path);
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
            Map nodeToMergeInto = TypeIntrinsics.asMutableMap(object3);
            this.deepMerge(nodeToMergeInto, data);
            ((Collection)this._mergedFragmentIds).add(new DeferredFragmentIdentifier(path, (String)incrementalItem.get("label")));
        }
    }

    private final void deepMerge(Map<String, Object> destination, Map<String, ? extends Object> map2) {
        for (Map.Entry<String, ? extends Object> entry : map2.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (destination.containsKey(key) && TypeIntrinsics.isMutableMap(destination.get(key))) {
                Map fieldMap;
                Object object = destination.get(key);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any?>");
                Map fieldDestination = TypeIntrinsics.asMutableMap(object);
                if ((value instanceof Map ? (Map)value : null) == null) {
                    throw new IllegalStateException(('\'' + key + "' is an object in destination but not in map").toString());
                }
                fieldMap = fieldMap;
                this.deepMerge(fieldDestination, fieldMap);
                continue;
            }
            destination.put(key, value);
        }
    }

    private final Map<String, Object> jsonToMap(BufferedSource json) {
        Object object = -JsonReaders.readAny(new BufferedSourceJsonReader(json));
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        return (Map)object;
    }

    private final Object nodeAtPath(Map<String, ? extends Object> map2, List<? extends Object> path) {
        Object node = map2;
        for (Object object : path) {
            Object object2;
            if (node instanceof List) {
                List list = (List)node;
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
                object2 = list.get((Integer)object);
            } else {
                Intrinsics.checkNotNull(node, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                object2 = node.get(object);
            }
            node = object2;
        }
        return node;
    }

    public final void reset() {
        this._merged.clear();
        this._mergedFragmentIds.clear();
        this.hasNext = true;
        this.isEmptyPayload = false;
    }
}

