/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.api.http.HttpMethod;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

public final class ApolloRequest<D extends Operation.Data> {
    private final Operation<D> operation;
    private final UUID requestUuid;
    private final ExecutionContext executionContext;
    private final HttpMethod httpMethod;
    private final List<HttpHeader> httpHeaders;
    private final Boolean sendApqExtensions;
    private final Boolean sendDocument;
    private final Boolean enableAutoPersistedQueries;
    private final Boolean canBeBatched;
    private final Boolean ignoreApolloClientHttpHeaders;
    private final Boolean retryOnError;
    private final Boolean failFastIfOffline;

    private ApolloRequest(Operation<D> operation, UUID requestUuid, ExecutionContext executionContext, HttpMethod httpMethod, List<HttpHeader> httpHeaders, Boolean sendApqExtensions, Boolean sendDocument, Boolean enableAutoPersistedQueries, Boolean canBeBatched, Boolean ignoreApolloClientHttpHeaders, Boolean retryOnError, Boolean failFastIfOffline) {
        this.operation = operation;
        this.requestUuid = requestUuid;
        this.executionContext = executionContext;
        this.httpMethod = httpMethod;
        this.httpHeaders = httpHeaders;
        this.sendApqExtensions = sendApqExtensions;
        this.sendDocument = sendDocument;
        this.enableAutoPersistedQueries = enableAutoPersistedQueries;
        this.canBeBatched = canBeBatched;
        this.ignoreApolloClientHttpHeaders = ignoreApolloClientHttpHeaders;
        this.retryOnError = retryOnError;
        this.failFastIfOffline = failFastIfOffline;
    }

    public final Operation<D> getOperation() {
        return this.operation;
    }

    public final UUID getRequestUuid() {
        return this.requestUuid;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public List<HttpHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public Boolean getSendApqExtensions() {
        return this.sendApqExtensions;
    }

    public Boolean getSendDocument() {
        return this.sendDocument;
    }

    public Boolean getEnableAutoPersistedQueries() {
        return this.enableAutoPersistedQueries;
    }

    public Boolean getCanBeBatched() {
        return this.canBeBatched;
    }

    public final Boolean getRetryOnError() {
        return this.retryOnError;
    }

    public final Boolean getFailFastIfOffline() {
        return this.failFastIfOffline;
    }

    public final Builder<D> newBuilder() {
        return this.newBuilder(this.operation);
    }

    public final <E extends Operation.Data> Builder<E> newBuilder(Operation<E> operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        return new Builder<E>(operation).requestUuid(this.requestUuid).executionContext(this.getExecutionContext()).httpMethod(this.getHttpMethod()).httpHeaders(this.getHttpHeaders()).sendApqExtensions(this.getSendApqExtensions()).sendDocument(this.getSendDocument()).enableAutoPersistedQueries(this.getEnableAutoPersistedQueries()).canBeBatched(this.getCanBeBatched()).retryOnError(this.retryOnError).failFastIfOffline(this.failFastIfOffline).ignoreApolloClientHttpHeaders(this.ignoreApolloClientHttpHeaders);
    }

    public /* synthetic */ ApolloRequest(Operation operation, UUID requestUuid, ExecutionContext executionContext, HttpMethod httpMethod, List httpHeaders, Boolean sendApqExtensions, Boolean sendDocument, Boolean enableAutoPersistedQueries, Boolean canBeBatched, Boolean ignoreApolloClientHttpHeaders, Boolean retryOnError, Boolean failFastIfOffline, DefaultConstructorMarker $constructor_marker) {
        this(operation, requestUuid, executionContext, httpMethod, httpHeaders, sendApqExtensions, sendDocument, enableAutoPersistedQueries, canBeBatched, ignoreApolloClientHttpHeaders, retryOnError, failFastIfOffline);
    }

    public static final class Builder<D extends Operation.Data> {
        private final Operation<D> operation;
        private UUID requestUuid;
        private ExecutionContext executionContext;
        private HttpMethod httpMethod;
        private List<HttpHeader> httpHeaders;
        private Boolean enableAutoPersistedQueries;
        private Boolean sendApqExtensions;
        private Boolean sendDocument;
        private Boolean canBeBatched;
        private Boolean ignoreApolloClientHttpHeaders;
        private Boolean retryOnError;
        private Boolean failFastIfOffline;

        public Builder(Operation<D> operation) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            this.operation = operation;
            this.executionContext = ExecutionContext.Empty;
        }

        public ExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        public List<HttpHeader> getHttpHeaders() {
            return this.httpHeaders;
        }

        public Boolean getEnableAutoPersistedQueries() {
            return this.enableAutoPersistedQueries;
        }

        public Boolean getSendApqExtensions() {
            return this.sendApqExtensions;
        }

        public Boolean getSendDocument() {
            return this.sendDocument;
        }

        public Boolean getCanBeBatched() {
            return this.canBeBatched;
        }

        public final Boolean getIgnoreApolloClientHttpHeaders() {
            return this.ignoreApolloClientHttpHeaders;
        }

        public final Boolean getRetryOnError() {
            return this.retryOnError;
        }

        public final Boolean getFailFastIfOffline() {
            return this.failFastIfOffline;
        }

        public final Builder<D> requestUuid(UUID requestUuid) {
            Builder builder;
            Intrinsics.checkNotNullParameter(requestUuid, "requestUuid");
            Builder $this$requestUuid_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$requestUuid_u24lambda_u240.requestUuid = requestUuid;
            return builder;
        }

        public final Builder<D> executionContext(ExecutionContext executionContext) {
            Builder builder;
            Intrinsics.checkNotNullParameter(executionContext, "executionContext");
            Builder $this$executionContext_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$executionContext_u24lambda_u241.executionContext = executionContext;
            return builder;
        }

        public final Builder<D> ignoreApolloClientHttpHeaders(Boolean ignoreApolloClientHttpHeaders) {
            Builder builder;
            Builder $this$ignoreApolloClientHttpHeaders_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$ignoreApolloClientHttpHeaders_u24lambda_u243.ignoreApolloClientHttpHeaders = ignoreApolloClientHttpHeaders;
            return builder;
        }

        public Builder<D> httpMethod(HttpMethod httpMethod) {
            Builder builder;
            Builder $this$httpMethod_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$httpMethod_u24lambda_u244.httpMethod = httpMethod;
            return builder;
        }

        public Builder<D> httpHeaders(List<HttpHeader> httpHeaders) {
            Builder builder;
            Builder $this$httpHeaders_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$httpHeaders_u24lambda_u245.httpHeaders = httpHeaders;
            return builder;
        }

        public Builder<D> addHttpHeader(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$addHttpHeader_u24lambda_u246 = builder = this;
            boolean bl = false;
            List<HttpHeader> list = $this$addHttpHeader_u24lambda_u246.getHttpHeaders();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            $this$addHttpHeader_u24lambda_u246.httpHeaders = CollectionsKt.plus((Collection)list, new HttpHeader(name, value));
            return builder;
        }

        public Builder<D> sendApqExtensions(Boolean sendApqExtensions) {
            Builder builder;
            Builder $this$sendApqExtensions_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$sendApqExtensions_u24lambda_u247.sendApqExtensions = sendApqExtensions;
            return builder;
        }

        public Builder<D> sendDocument(Boolean sendDocument) {
            Builder builder;
            Builder $this$sendDocument_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$sendDocument_u24lambda_u248.sendDocument = sendDocument;
            return builder;
        }

        public Builder<D> enableAutoPersistedQueries(Boolean enableAutoPersistedQueries) {
            Builder builder;
            Builder $this$enableAutoPersistedQueries_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$enableAutoPersistedQueries_u24lambda_u249.enableAutoPersistedQueries = enableAutoPersistedQueries;
            return builder;
        }

        public Builder<D> canBeBatched(Boolean canBeBatched) {
            Builder builder;
            Builder $this$canBeBatched_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$canBeBatched_u24lambda_u2410.canBeBatched = canBeBatched;
            return builder;
        }

        public final Builder<D> retryOnError(Boolean retryOnError) {
            Builder builder;
            Builder $this$retryOnError_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$retryOnError_u24lambda_u2411.retryOnError = retryOnError;
            return builder;
        }

        public final Builder<D> failFastIfOffline(Boolean failFastIfOffline) {
            Builder builder;
            Builder $this$failFastIfOffline_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$failFastIfOffline_u24lambda_u2412.failFastIfOffline = failFastIfOffline;
            return builder;
        }

        public final ApolloRequest<D> build() {
            UUID uUID = this.requestUuid;
            if (uUID == null) {
                boolean $i$f$uuid4 = false;
                UUID uUID2 = UUID.randomUUID();
                uUID = uUID2;
                Intrinsics.checkNotNullExpressionValue(uUID2, "randomUUID(...)");
            }
            return new ApolloRequest(this.operation, uUID, this.getExecutionContext(), this.getHttpMethod(), this.getHttpHeaders(), this.getSendApqExtensions(), this.getSendDocument(), this.getEnableAutoPersistedQueries(), this.getCanBeBatched(), this.ignoreApolloClientHttpHeaders, this.retryOnError, this.failFastIfOffline, null);
        }
    }
}

