/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import org.eclipse.jgit.api.AddNoteCommand;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class RemoveNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected RemoveNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        try (RevWalk walk = new RevWalk(this.repo);){
            ObjectInserter inserter = this.repo.newObjectInserter();
            try {
                NoteMap map = NoteMap.newEmptyMap();
                RevCommit notesCommit = null;
                Ref ref = this.repo.exactRef(this.notesRef);
                if (ref != null) {
                    notesCommit = walk.parseCommit(ref.getObjectId());
                    map = NoteMap.read(walk.getObjectReader(), notesCommit);
                }
                map.set(this.id, null, inserter);
                AddNoteCommand.commitNoteMap(this.repo, this.notesRef, walk, map, notesCommit, inserter, "Notes removed by 'git notes remove'");
                Note note = map.getNote(this.id);
                if (inserter != null) {
                    inserter.close();
                }
                return note;
            }
            catch (Throwable throwable) {
                if (inserter != null) {
                    try {
                        inserter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public RemoveNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public RemoveNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

