/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.jvm.internal.Intrinsics;
import okio.Okio;
import okio.Sink;
import okio.Source;

public interface FileSystem {
    public static final Companion Companion = okhttp3.internal.io.FileSystem$Companion.$$INSTANCE;
    public static final FileSystem SYSTEM = new Companion.SystemFileSystem();

    public Source source(File var1) throws FileNotFoundException;

    public Sink sink(File var1) throws FileNotFoundException;

    public Sink appendingSink(File var1) throws FileNotFoundException;

    public void delete(File var1) throws IOException;

    public boolean exists(File var1);

    public long size(File var1);

    public void rename(File var1, File var2) throws IOException;

    public void deleteContents(File var1) throws IOException;

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }

        private static final class SystemFileSystem
        implements FileSystem {
            @Override
            public Source source(File file) throws FileNotFoundException {
                Intrinsics.checkNotNullParameter(file, "file");
                return Okio.source(file);
            }

            @Override
            public Sink sink(File file) throws FileNotFoundException {
                Sink sink2;
                Intrinsics.checkNotNullParameter(file, "file");
                try {
                    sink2 = Okio.sink$default(file, false, 1, null);
                }
                catch (FileNotFoundException _) {
                    file.getParentFile().mkdirs();
                    sink2 = Okio.sink$default(file, false, 1, null);
                }
                return sink2;
            }

            @Override
            public Sink appendingSink(File file) throws FileNotFoundException {
                Sink sink2;
                Intrinsics.checkNotNullParameter(file, "file");
                try {
                    sink2 = Okio.appendingSink(file);
                }
                catch (FileNotFoundException _) {
                    file.getParentFile().mkdirs();
                    sink2 = Okio.appendingSink(file);
                }
                return sink2;
            }

            @Override
            public void delete(File file) throws IOException {
                Intrinsics.checkNotNullParameter(file, "file");
                if (!file.delete() && file.exists()) {
                    throw new IOException(Intrinsics.stringPlus("failed to delete ", file));
                }
            }

            @Override
            public boolean exists(File file) {
                Intrinsics.checkNotNullParameter(file, "file");
                return file.exists();
            }

            @Override
            public long size(File file) {
                Intrinsics.checkNotNullParameter(file, "file");
                return file.length();
            }

            @Override
            public void rename(File from, File to) throws IOException {
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                this.delete(to);
                if (!from.renameTo(to)) {
                    throw new IOException("failed to rename " + from + " to " + to);
                }
            }

            @Override
            public void deleteContents(File directory) throws IOException {
                Intrinsics.checkNotNullParameter(directory, "directory");
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    throw new IOException(Intrinsics.stringPlus("not a readable directory: ", directory));
                }
                File[] files = fileArray;
                int n = 0;
                int n2 = files.length;
                while (n < n2) {
                    File file = files[n];
                    ++n;
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNullExpressionValue(file, "file");
                        this.deleteContents(file);
                    }
                    if (file.delete()) continue;
                    throw new IOException(Intrinsics.stringPlus("failed to delete ", file));
                }
            }

            public String toString() {
                return "FileSystem.SYSTEM";
            }
        }
    }
}

