/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Challenge;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpHeaders;

public final class Response
implements Closeable {
    private final Request request;
    private final Protocol protocol;
    private final String message;
    private final int code;
    private final Handshake handshake;
    private final Headers headers;
    private final ResponseBody body;
    private final Response networkResponse;
    private final Response cacheResponse;
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final Exchange exchange;
    private CacheControl lazyCacheControl;

    public Response(Request request, Protocol protocol, String message, int code, Handshake handshake2, Headers headers, ResponseBody body, Response networkResponse, Response cacheResponse, Response priorResponse, long sentRequestAtMillis, long receivedResponseAtMillis, Exchange exchange) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(headers, "headers");
        this.request = request;
        this.protocol = protocol;
        this.message = message;
        this.code = code;
        this.handshake = handshake2;
        this.headers = headers;
        this.body = body;
        this.networkResponse = networkResponse;
        this.cacheResponse = cacheResponse;
        this.priorResponse = priorResponse;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
        this.exchange = exchange;
    }

    public final Request request() {
        return this.request;
    }

    public final Protocol protocol() {
        return this.protocol;
    }

    public final String message() {
        return this.message;
    }

    public final int code() {
        return this.code;
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final ResponseBody body() {
        return this.body;
    }

    public final Response networkResponse() {
        return this.networkResponse;
    }

    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    public final Response priorResponse() {
        return this.priorResponse;
    }

    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public final Exchange exchange() {
        return this.exchange;
    }

    public final String header(String name, String defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = this.headers.get(name);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public static /* synthetic */ String header$default(Response response, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return response.header(string, string2);
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final List<Challenge> challenges() {
        String string;
        switch (this.code) {
            case 401: {
                string = "WWW-Authenticate";
                break;
            }
            case 407: {
                string = "Proxy-Authenticate";
                break;
            }
            default: {
                return CollectionsKt.emptyList();
            }
        }
        return HttpHeaders.parseChallenges(this.headers, string);
    }

    public final CacheControl cacheControl() {
        CacheControl result2 = this.lazyCacheControl;
        if (result2 == null) {
            this.lazyCacheControl = result2 = CacheControl.Companion.parse(this.headers);
        }
        return result2;
    }

    @Override
    public void close() {
        ResponseBody responseBody = this.body;
        if (responseBody == null) {
            boolean bl = false;
            String string = "response is not eligible for a body and must not be closed";
            throw new IllegalStateException(string.toString());
        }
        responseBody.close();
    }

    public String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    public static class Builder {
        private Request request;
        private Protocol protocol;
        private int code;
        private String message;
        private Handshake handshake;
        private Headers.Builder headers;
        private ResponseBody body;
        private Response networkResponse;
        private Response cacheResponse;
        private Response priorResponse;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;
        private Exchange exchange;

        public final void setRequest$okhttp(Request request) {
            this.request = request;
        }

        public final void setProtocol$okhttp(Protocol protocol) {
            this.protocol = protocol;
        }

        public final int getCode$okhttp() {
            return this.code;
        }

        public final void setCode$okhttp(int n) {
            this.code = n;
        }

        public final void setMessage$okhttp(String string) {
            this.message = string;
        }

        public final void setHandshake$okhttp(Handshake handshake2) {
            this.handshake = handshake2;
        }

        public final Headers.Builder getHeaders$okhttp() {
            return this.headers;
        }

        public final void setHeaders$okhttp(Headers.Builder builder) {
            Intrinsics.checkNotNullParameter(builder, "<set-?>");
            this.headers = builder;
        }

        public final void setBody$okhttp(ResponseBody responseBody) {
            this.body = responseBody;
        }

        public final void setNetworkResponse$okhttp(Response response) {
            this.networkResponse = response;
        }

        public final void setCacheResponse$okhttp(Response response) {
            this.cacheResponse = response;
        }

        public final void setPriorResponse$okhttp(Response response) {
            this.priorResponse = response;
        }

        public final void setSentRequestAtMillis$okhttp(long l) {
            this.sentRequestAtMillis = l;
        }

        public final void setReceivedResponseAtMillis$okhttp(long l) {
            this.receivedResponseAtMillis = l;
        }

        public Builder() {
            this.code = -1;
            this.headers = new Headers.Builder();
        }

        public Builder(Response response) {
            Intrinsics.checkNotNullParameter(response, "response");
            this.code = -1;
            this.request = response.request();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.handshake = response.handshake();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
            this.networkResponse = response.networkResponse();
            this.cacheResponse = response.cacheResponse();
            this.priorResponse = response.priorResponse();
            this.sentRequestAtMillis = response.sentRequestAtMillis();
            this.receivedResponseAtMillis = response.receivedResponseAtMillis();
            this.exchange = response.exchange();
        }

        public Builder request(Request request) {
            Builder builder;
            Intrinsics.checkNotNullParameter(request, "request");
            Builder $this$request_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$request_u24lambda_u2d0.setRequest$okhttp(request);
            return builder;
        }

        public Builder protocol(Protocol protocol) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
            Builder $this$protocol_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$protocol_u24lambda_u2d1.setProtocol$okhttp(protocol);
            return builder;
        }

        public Builder code(int code) {
            Builder builder;
            Builder $this$code_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$code_u24lambda_u2d2.setCode$okhttp(code);
            return builder;
        }

        public Builder message(String message) {
            Builder builder;
            Intrinsics.checkNotNullParameter(message, "message");
            Builder $this$message_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$message_u24lambda_u2d3.setMessage$okhttp(message);
            return builder;
        }

        public Builder handshake(Handshake handshake2) {
            Builder builder;
            Builder $this$handshake_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$handshake_u24lambda_u2d4.setHandshake$okhttp(handshake2);
            return builder;
        }

        public Builder header(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$header_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$header_u24lambda_u2d5.getHeaders$okhttp().set(name, value);
            return builder;
        }

        public Builder addHeader(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$addHeader_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u2d6.getHeaders$okhttp().add(name, value);
            return builder;
        }

        public Builder headers(Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, "headers");
            Builder $this$headers_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2d8.setHeaders$okhttp(headers.newBuilder());
            return builder;
        }

        public Builder body(ResponseBody body) {
            Builder builder;
            Builder $this$body_u24lambda_u2d9 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u2d9.setBody$okhttp(body);
            return builder;
        }

        public Builder networkResponse(Response networkResponse) {
            Builder builder;
            Builder $this$networkResponse_u24lambda_u2d10 = builder = this;
            boolean bl = false;
            $this$networkResponse_u24lambda_u2d10.checkSupportResponse("networkResponse", networkResponse);
            $this$networkResponse_u24lambda_u2d10.setNetworkResponse$okhttp(networkResponse);
            return builder;
        }

        public Builder cacheResponse(Response cacheResponse) {
            Builder builder;
            Builder $this$cacheResponse_u24lambda_u2d11 = builder = this;
            boolean bl = false;
            $this$cacheResponse_u24lambda_u2d11.checkSupportResponse("cacheResponse", cacheResponse);
            $this$cacheResponse_u24lambda_u2d11.setCacheResponse$okhttp(cacheResponse);
            return builder;
        }

        private final void checkSupportResponse(String name, Response response) {
            Response response2 = response;
            if (response2 != null) {
                Response response3;
                Response $this$checkSupportResponse_u24lambda_u2d16 = response3 = response2;
                boolean bl = false;
                if (!($this$checkSupportResponse_u24lambda_u2d16.body() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$52 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$52 = Intrinsics.stringPlus(name, ".body != null");
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$52.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2d16.networkResponse() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$62 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$62 = Intrinsics.stringPlus(name, ".networkResponse != null");
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$62.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2d16.cacheResponse() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$72 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$72 = Intrinsics.stringPlus(name, ".cacheResponse != null");
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$72.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2d16.priorResponse() == null)) {
                    boolean bl2 = false;
                    String string = Intrinsics.stringPlus(name, ".priorResponse != null");
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        public Builder priorResponse(Response priorResponse) {
            Builder builder;
            Builder $this$priorResponse_u24lambda_u2d17 = builder = this;
            boolean bl = false;
            $this$priorResponse_u24lambda_u2d17.checkPriorResponse(priorResponse);
            $this$priorResponse_u24lambda_u2d17.setPriorResponse$okhttp(priorResponse);
            return builder;
        }

        private final void checkPriorResponse(Response response) {
            Response response2 = response;
            if (response2 != null) {
                Response response3;
                Response $this$checkPriorResponse_u24lambda_u2d19 = response3 = response2;
                boolean bl = false;
                if (!($this$checkPriorResponse_u24lambda_u2d19.body() == null)) {
                    boolean bl2 = false;
                    String string = "priorResponse.body != null";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        public Builder sentRequestAtMillis(long sentRequestAtMillis) {
            Builder builder;
            Builder $this$sentRequestAtMillis_u24lambda_u2d20 = builder = this;
            boolean bl = false;
            $this$sentRequestAtMillis_u24lambda_u2d20.setSentRequestAtMillis$okhttp(sentRequestAtMillis);
            return builder;
        }

        public Builder receivedResponseAtMillis(long receivedResponseAtMillis) {
            Builder builder;
            Builder $this$receivedResponseAtMillis_u24lambda_u2d21 = builder = this;
            boolean bl = false;
            $this$receivedResponseAtMillis_u24lambda_u2d21.setReceivedResponseAtMillis$okhttp(receivedResponseAtMillis);
            return builder;
        }

        public final void initExchange$okhttp(Exchange deferredTrailers) {
            Intrinsics.checkNotNullParameter(deferredTrailers, "deferredTrailers");
            this.exchange = deferredTrailers;
        }

        public Response build() {
            if (!(this.code >= 0)) {
                boolean $i$a$-check-Response$Builder$build$22 = false;
                String $i$a$-check-Response$Builder$build$22 = Intrinsics.stringPlus("code < 0: ", this.getCode$okhttp());
                throw new IllegalStateException($i$a$-check-Response$Builder$build$22.toString());
            }
            Request request = this.request;
            if (request == null) {
                boolean $i$a$-checkNotNull-Response$Builder$build$52 = false;
                String $i$a$-checkNotNull-Response$Builder$build$52 = "request == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$52.toString());
            }
            Protocol protocol = this.protocol;
            if (protocol == null) {
                Request request2 = request;
                boolean $i$a$-checkNotNull-Response$Builder$build$62 = false;
                Request request3 = request2;
                String $i$a$-checkNotNull-Response$Builder$build$62 = "protocol == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$62.toString());
            }
            String string = this.message;
            if (string == null) {
                Protocol protocol2 = protocol;
                Request request4 = request;
                boolean bl = false;
                String string2 = "message == null";
                Request request5 = request4;
                Protocol protocol3 = protocol2;
                String string3 = string2;
                throw new IllegalStateException(string3.toString());
            }
            Exchange exchange = this.exchange;
            long l = this.receivedResponseAtMillis;
            long l2 = this.sentRequestAtMillis;
            Response response = this.priorResponse;
            Response response2 = this.cacheResponse;
            Response response3 = this.networkResponse;
            ResponseBody responseBody = this.body;
            Headers headers = this.headers.build();
            Handshake handshake2 = this.handshake;
            int n = this.code;
            String string4 = string;
            Protocol protocol4 = protocol;
            Request request6 = request;
            return new Response(request6, protocol4, string4, n, handshake2, headers, responseBody, response3, response2, response, l2, l, exchange);
        }
    }
}

