/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;

public abstract class MapLikeDescriptor
implements SerialDescriptor {
    private final String serialName;
    private final SerialDescriptor keyDescriptor;
    private final SerialDescriptor valueDescriptor;
    private final int elementsCount;

    private MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor) {
        this.serialName = serialName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.elementsCount = 2;
    }

    @Override
    public String getSerialName() {
        return this.serialName;
    }

    @Override
    public SerialKind getKind() {
        return StructureKind.MAP.INSTANCE;
    }

    @Override
    public int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    public String getElementName(int index) {
        return String.valueOf(index);
    }

    @Override
    public int getElementIndex(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = StringsKt.toIntOrNull(name);
        if (n == null) {
            throw new IllegalArgumentException(name + " is not a valid map index");
        }
        return n;
    }

    @Override
    public boolean isElementOptional(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Illegal index " + index + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string.toString());
        }
        return false;
    }

    @Override
    public List<Annotation> getElementAnnotations(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Illegal index " + index + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public SerialDescriptor getElementDescriptor(int index) {
        SerialDescriptor serialDescriptor;
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Illegal index " + index + ", " + this.getSerialName() + " expects only non-negative indices";
            throw new IllegalArgumentException(string.toString());
        }
        switch (index % 2) {
            case 0: {
                serialDescriptor = this.keyDescriptor;
                break;
            }
            case 1: {
                serialDescriptor = this.valueDescriptor;
                break;
            }
            default: {
                throw new IllegalStateException("Unreached".toString());
            }
        }
        return serialDescriptor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapLikeDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getSerialName(), ((MapLikeDescriptor)other).getSerialName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyDescriptor, ((MapLikeDescriptor)other).keyDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual(this.valueDescriptor, ((MapLikeDescriptor)other).valueDescriptor);
    }

    public int hashCode() {
        int result2 = this.getSerialName().hashCode();
        result2 = 31 * result2 + this.keyDescriptor.hashCode();
        result2 = 31 * result2 + this.valueDescriptor.hashCode();
        return result2;
    }

    public String toString() {
        return this.getSerialName() + '(' + this.keyDescriptor + ", " + this.valueDescriptor + ')';
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isInline() {
        return SerialDescriptor.DefaultImpls.isInline(this);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return SerialDescriptor.DefaultImpls.getAnnotations(this);
    }

    public /* synthetic */ MapLikeDescriptor(String serialName, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(serialName, keyDescriptor, valueDescriptor);
    }
}

