/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    public static final Companion Companion = new Companion(null);
    private final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        Intrinsics.checkNotNullParameter(trustRootIndex, "trustRootIndex");
        this.trustRootIndex = trustRootIndex;
    }

    @Override
    public List<Certificate> clean(List<? extends Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter(chain, "chain");
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        Deque queue = new ArrayDeque(chain);
        List result2 = new ArrayList();
        Object e = queue.removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, "queue.removeFirst()");
        result2.add(e);
        boolean foundTrustedCertificate = false;
        int n = 0;
        block0: while (n < 9) {
            int c = n++;
            X509Certificate toVerify = (X509Certificate)result2.get(result2.size() - 1);
            X509Certificate trustedCert = this.trustRootIndex.findByIssuerAndSignature(toVerify);
            if (trustedCert != null) {
                if (result2.size() > 1 || !Intrinsics.areEqual(toVerify, trustedCert)) {
                    result2.add(trustedCert);
                }
                if (this.verifySignature(trustedCert, trustedCert)) {
                    return result2;
                }
                foundTrustedCertificate = true;
                continue;
            }
            Iterator iterator2 = queue.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "queue.iterator()");
            Iterator i = iterator2;
            while (i.hasNext()) {
                Object e2 = i.next();
                if (e2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                }
                X509Certificate signingCert = (X509Certificate)e2;
                if (!this.verifySignature(toVerify, signingCert)) continue;
                i.remove();
                result2.add(signingCert);
                continue block0;
            }
            if (foundTrustedCertificate) {
                return result2;
            }
            throw new SSLPeerUnverifiedException(Intrinsics.stringPlus("Failed to find a trusted cert that signed ", toVerify));
        }
        throw new SSLPeerUnverifiedException(Intrinsics.stringPlus("Certificate chain too long: ", result2));
    }

    private final boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
        boolean bl;
        if (!Intrinsics.areEqual(toVerify.getIssuerDN(), signingCert.getSubjectDN())) {
            return false;
        }
        try {
            toVerify.verify(signingCert.getPublicKey());
            bl = true;
        }
        catch (GeneralSecurityException verifyFailed) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    public boolean equals(Object other) {
        return other == this ? true : other instanceof BasicCertificateChainCleaner && Intrinsics.areEqual(((BasicCertificateChainCleaner)other).trustRootIndex, this.trustRootIndex);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

