/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.InternalJsonWriter;

public final class ComposerForUnsignedNumbers
extends Composer {
    private final boolean forceQuoting;

    public ComposerForUnsignedNumbers(InternalJsonWriter writer, boolean forceQuoting) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        super(writer);
        this.forceQuoting = forceQuoting;
    }

    @Override
    public void print(int v) {
        if (this.forceQuoting) {
            this.printQuoted(Integer.toUnsignedString(UInt.constructor-impl(v)));
        } else {
            this.print(Integer.toUnsignedString(UInt.constructor-impl(v)));
        }
    }

    @Override
    public void print(long v) {
        if (this.forceQuoting) {
            this.printQuoted(Long.toUnsignedString(ULong.constructor-impl(v)));
        } else {
            this.print(Long.toUnsignedString(ULong.constructor-impl(v)));
        }
    }

    @Override
    public void print(byte v) {
        if (this.forceQuoting) {
            this.printQuoted(UByte.toString-impl(UByte.constructor-impl(v)));
        } else {
            this.print(UByte.toString-impl(UByte.constructor-impl(v)));
        }
    }

    @Override
    public void print(short v) {
        if (this.forceQuoting) {
            this.printQuoted(UShort.toString-impl(UShort.constructor-impl(v)));
        } else {
            this.print(UShort.toString-impl(UShort.constructor-impl(v)));
        }
    }
}

