/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlin.text.StringsKt__StringNumberConversionsJVMKt;

class StringsKt__StringNumberConversionsKt
extends StringsKt__StringNumberConversionsJVMKt {
    public static final Integer toIntOrNull(String $this$toIntOrNull) {
        Intrinsics.checkNotNullParameter($this$toIntOrNull, "<this>");
        return StringsKt.toIntOrNull($this$toIntOrNull, 10);
    }

    public static final Integer toIntOrNull(String $this$toIntOrNull, int radix) {
        int limitForMaxRadix;
        int limit;
        boolean isNegative;
        int length;
        block14: {
            int start;
            block13: {
                Intrinsics.checkNotNullParameter($this$toIntOrNull, "<this>");
                CharsKt.checkRadix(radix);
                length = $this$toIntOrNull.length();
                if (length == 0) {
                    return null;
                }
                start = 0;
                isNegative = false;
                limit = 0;
                char firstChar = $this$toIntOrNull.charAt(0);
                if (Intrinsics.compare(firstChar, 48) >= 0) break block13;
                if (length == 1) {
                    return null;
                }
                start = 1;
                switch (firstChar) {
                    case '-': {
                        isNegative = true;
                        limit = Integer.MIN_VALUE;
                        break block14;
                    }
                    case '+': {
                        isNegative = false;
                        limit = -2147483647;
                        break block14;
                    }
                    default: {
                        return null;
                    }
                }
            }
            start = 0;
            isNegative = false;
            limit = -2147483647;
        }
        int limitBeforeMul = limitForMaxRadix = -59652323;
        int result2 = 0;
        for (int i = start; i < length; ++i) {
            int digit = CharsKt.digitOf($this$toIntOrNull.charAt(i), radix);
            if (digit < 0) {
                return null;
            }
            if (result2 < limitBeforeMul) {
                if (limitBeforeMul == limitForMaxRadix) {
                    limitBeforeMul = limit / radix;
                    if (result2 < limitBeforeMul) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if ((result2 *= radix) < limit + digit) {
                return null;
            }
            result2 -= digit;
        }
        return isNegative ? Integer.valueOf(result2) : Integer.valueOf(-result2);
    }

    public static final Long toLongOrNull(String $this$toLongOrNull) {
        Intrinsics.checkNotNullParameter($this$toLongOrNull, "<this>");
        return StringsKt.toLongOrNull($this$toLongOrNull, 10);
    }

    public static final Long toLongOrNull(String $this$toLongOrNull, int radix) {
        long limitForMaxRadix;
        long limit;
        boolean isNegative;
        int length;
        block14: {
            int start;
            block13: {
                Intrinsics.checkNotNullParameter($this$toLongOrNull, "<this>");
                CharsKt.checkRadix(radix);
                length = $this$toLongOrNull.length();
                if (length == 0) {
                    return null;
                }
                start = 0;
                isNegative = false;
                limit = 0L;
                char firstChar = $this$toLongOrNull.charAt(0);
                if (Intrinsics.compare(firstChar, 48) >= 0) break block13;
                if (length == 1) {
                    return null;
                }
                start = 1;
                switch (firstChar) {
                    case '-': {
                        isNegative = true;
                        limit = Long.MIN_VALUE;
                        break block14;
                    }
                    case '+': {
                        isNegative = false;
                        limit = -9223372036854775807L;
                        break block14;
                    }
                    default: {
                        return null;
                    }
                }
            }
            start = 0;
            isNegative = false;
            limit = -9223372036854775807L;
        }
        long limitBeforeMul = limitForMaxRadix = -256204778801521550L;
        long result2 = 0L;
        for (int i = start; i < length; ++i) {
            int digit = CharsKt.digitOf($this$toLongOrNull.charAt(i), radix);
            if (digit < 0) {
                return null;
            }
            if (result2 < limitBeforeMul) {
                if (limitBeforeMul == limitForMaxRadix) {
                    limitBeforeMul = limit / (long)radix;
                    if (result2 < limitBeforeMul) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if ((result2 *= (long)radix) < limit + (long)digit) {
                return null;
            }
            result2 -= (long)digit;
        }
        return isNegative ? Long.valueOf(result2) : Long.valueOf(-result2);
    }

    public static final Void numberFormatError(String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        throw new NumberFormatException("Invalid number format: '" + input + '\'');
    }
}

