/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.ws;

import com.apollographql.apollo.api.Adapters;
import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.json.-JsonWriters;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.network.ws.WebSocketConnection;
import com.apollographql.apollo.network.ws.WsFrameType;
import com.apollographql.apollo.network.ws.WsProtocol;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import okio.Buffer;
import okio.ByteString;

public abstract class WsProtocol {
    private final WebSocketConnection webSocketConnection;
    private final Listener listener;

    public WsProtocol(WebSocketConnection webSocketConnection, Listener listener2) {
        Intrinsics.checkNotNullParameter(webSocketConnection, "webSocketConnection");
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.webSocketConnection = webSocketConnection;
        this.listener = listener2;
    }

    protected final Listener getListener() {
        return this.listener;
    }

    public abstract Object connectionInit(Continuation<? super Unit> var1);

    public abstract void handleServerMessage(Map<String, ? extends Object> var1);

    public abstract <D extends Operation.Data> void startOperation(ApolloRequest<D> var1);

    public abstract <D extends Operation.Data> void stopOperation(ApolloRequest<D> var1);

    protected final ByteString toByteString(Map<String, ? extends Object> $this$toByteString) {
        Intrinsics.checkNotNullParameter($this$toByteString, "<this>");
        String indent$iv = null;
        boolean $i$f$buildJsonByteString = false;
        Buffer buffer$iv = new Buffer();
        JsonWriter $this$toByteString_u24lambda_u240 = new BufferedSinkJsonWriter(buffer$iv, indent$iv);
        boolean bl = false;
        -JsonWriters.writeAny($this$toByteString_u24lambda_u240, $this$toByteString);
        return buffer$iv.readByteString();
    }

    protected final String toUtf8(Map<String, ? extends Object> $this$toUtf8) {
        Intrinsics.checkNotNullParameter($this$toUtf8, "<this>");
        String indent$iv = null;
        boolean $i$f$buildJsonString = false;
        Buffer buffer$iv = new Buffer();
        JsonWriter $this$toUtf8_u24lambda_u241 = new BufferedSinkJsonWriter(buffer$iv, indent$iv);
        boolean bl = false;
        -JsonWriters.writeAny($this$toUtf8_u24lambda_u241, $this$toUtf8);
        return buffer$iv.readUtf8();
    }

    protected final Map<String, Object> toMessageMap(String $this$toMessageMap) {
        Object object;
        Intrinsics.checkNotNullParameter($this$toMessageMap, "<this>");
        try {
            object = Adapters.AnyAdapter.fromJson(new BufferedSourceJsonReader(new Buffer().writeUtf8($this$toMessageMap)), CustomScalarAdapters.Empty);
            object = object instanceof Map ? (Map)object : null;
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    protected final void sendMessageMapBinary(Map<String, ? extends Object> messageMap) {
        Intrinsics.checkNotNullParameter(messageMap, "messageMap");
        this.webSocketConnection.send(this.toByteString(messageMap));
    }

    protected final void sendMessageMapText(Map<String, ? extends Object> messageMap) {
        Intrinsics.checkNotNullParameter(messageMap, "messageMap");
        this.webSocketConnection.send(this.toUtf8(messageMap));
    }

    protected final void sendMessageMap(Map<String, ? extends Object> messageMap, WsFrameType frameType) {
        Intrinsics.checkNotNullParameter(messageMap, "messageMap");
        Intrinsics.checkNotNullParameter((Object)frameType, "frameType");
        switch (WhenMappings.$EnumSwitchMapping$0[frameType.ordinal()]) {
            case 1: {
                this.sendMessageMapText(messageMap);
                break;
            }
            case 2: {
                this.sendMessageMapBinary(messageMap);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final Object receiveMessageMap(Continuation<? super Map<String, ? extends Object>> $completion) {
        if (!($completion instanceof receiveMessageMap.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ WsProtocol this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                public final Object invokeSuspend(Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.receiveMessageMap(this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                while (true) {
                    var3_6 = this;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var3_6;
                    $continuation.label = 1;
                    v0 = this.webSocketConnection.receive($continuation);
                    if (v0 != var6_4) continue;
                    return var6_4;
                }
            }
            case 1: {
                var3_6 = (WsProtocol)$continuation.L$1;
                this = (WsProtocol)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                if ((map = var3_6.toMessageMap((String)v0)) == null) ** continue;
                return map;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public Object run(Continuation<? super Unit> $completion) {
        return WsProtocol.run$suspendImpl(this, $completion);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Object run$suspendImpl(WsProtocol var0, Continuation<? super Unit> $completion) {
        if (!($completion instanceof run.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ WsProtocol this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                public final Object invokeSuspend(Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WsProtocol.run$suspendImpl(this.this$0, this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                try {
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    $this.listener.networkError(e);
                    return Unit.INSTANCE;
                }
lbl21:
                // 2 sources

                while (true) {
                    var3_5 = $this;
                    $continuation.L$0 = $this;
                    $continuation.L$1 = var3_5;
                    $continuation.label = 1;
                    v0 = $this.receiveMessageMap($continuation);
                    if (v0 == var6_4) {
                        return var6_4;
                    }
                    ** GOTO lbl36
                    break;
                }
            }
            case 1: {
                var3_5 = (WsProtocol)$continuation.L$1;
                $this = (WsProtocol)$continuation.L$0;
                {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl36:
                    // 2 sources

                    var3_5.handleServerMessage((Map)v0);
                    ** continue;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void close() {
        this.webSocketConnection.close();
    }

    public static interface Factory {
        public String getName();

        public WsProtocol create(WebSocketConnection var1, Listener var2, CoroutineScope var3);
    }

    public static interface Listener {
        public void operationResponse(String var1, Map<String, ? extends Object> var2);

        public void operationError(String var1, Map<String, ? extends Object> var2);

        public void operationComplete(String var1);

        public void generalError(Map<String, ? extends Object> var1);

        public void networkError(Throwable var1);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WsFrameType.values().length];
            try {
                nArray[WsFrameType.Text.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WsFrameType.Binary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

