/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.internal;

import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.DeferredFragmentIdentifier;
import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Executables;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.ResponseParserKt;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonReader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;

public final class ResponseParser {
    public static final ResponseParser INSTANCE = new ResponseParser();

    private ResponseParser() {
    }

    public final <D extends Operation.Data> ApolloResponse<D> parse(JsonReader jsonReader, Operation<D> operation, UUID requestUuid, CustomScalarAdapters customScalarAdapters, Set<DeferredFragmentIdentifier> deferredFragmentIds) {
        Intrinsics.checkNotNullParameter(jsonReader, "jsonReader");
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        jsonReader.beginObject();
        Operation.Data data = null;
        List<Error> errors = null;
        Map extensions = null;
        block10: while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "data": {
                    Set<String> falseVariables = Executables.falseVariables(operation, customScalarAdapters);
                    data = (Operation.Data)Executables.parseData(operation, jsonReader, customScalarAdapters, falseVariables, deferredFragmentIds, errors);
                    continue block10;
                }
                case "errors": {
                    errors = ResponseParserKt.readErrors(jsonReader);
                    continue block10;
                }
                case "extensions": {
                    Object object = -JsonReaders.readAny(jsonReader);
                    extensions = object instanceof Map ? (Map)object : null;
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        UUID uUID = requestUuid;
        if (uUID == null) {
            boolean $i$f$uuid4 = false;
            UUID uUID2 = UUID.randomUUID();
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue(uUID2, "randomUUID(...)");
        }
        return new ApolloResponse.Builder<D>(operation, uUID).errors(errors).data(data).extensions(extensions).build();
    }
}

