/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;

public class TaskItem
extends Item {
    TaskBar parent;
    Shell shell;
    boolean hasTaskbarButton = false;
    int progress;
    int progressState = -1;
    Image overlayImage;
    String overlayText = "";
    boolean showingText = false;
    Menu menu;
    static final int PROGRESS_MAX = 100;

    TaskItem(TaskBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, -1);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        if (null != this.parent.mTaskbarList3) {
            this.parent.mTaskbarList3.SetOverlayIcon(this.shell.handle, 0L, 0L);
        }
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Image getOverlayImage() {
        this.checkWidget();
        return this.overlayImage;
    }

    public String getOverlayText() {
        this.checkWidget();
        return this.overlayText;
    }

    public TaskBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getProgress() {
        this.checkWidget();
        return this.progress;
    }

    public int getProgressState() {
        this.checkWidget();
        return this.progressState;
    }

    void updateImageAndText() {
        if (this.showingText && this.overlayText.length() != 0) {
            this.updateText();
        } else if (this.overlayImage != null) {
            this.updateImage();
        } else {
            this.parent.mTaskbarList3.SetOverlayIcon(this.shell.handle, 0L, 0L);
        }
    }

    void updateAll() {
        this.updateImageAndText();
        if (this.progress != 0) {
            this.updateProgress();
        }
        if (this.progressState != -1) {
            this.updateProgressState();
        }
    }

    void onTaskbarButtonCreated() {
        this.hasTaskbarButton = true;
        this.updateAll();
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.overlayImage = null;
        this.overlayText = null;
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
        }
        if (this.shell != null) {
            return;
        }
        this.menu = menu;
        this.parent.setMenu(menu);
    }

    public void setOverlayImage(Image overlayImage) {
        this.checkWidget();
        if (overlayImage != null && overlayImage.isDisposed()) {
            this.error(5);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayImage = overlayImage;
        boolean bl = this.showingText = this.overlayImage == null;
        if (!this.hasTaskbarButton) {
            return;
        }
        this.updateImageAndText();
    }

    public void setOverlayText(String overlayText) {
        this.checkWidget();
        if (overlayText == null) {
            this.error(4);
        }
        if (this.shell == null) {
            return;
        }
        this.overlayText = overlayText;
        boolean bl = this.showingText = this.overlayText.length() != 0;
        if (!this.hasTaskbarButton) {
            return;
        }
        this.updateImageAndText();
    }

    public void setProgress(int progress) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progress == (progress = Math.max(0, Math.min(progress, 100)))) {
            return;
        }
        this.progress = progress;
        if (!this.hasTaskbarButton) {
            return;
        }
        this.updateProgress();
    }

    public void setProgressState(int progressState) {
        this.checkWidget();
        if (this.shell == null) {
            return;
        }
        if (this.progressState == progressState) {
            return;
        }
        this.progressState = progressState;
        if (!this.hasTaskbarButton) {
            return;
        }
        this.updateProgressState();
    }

    void setShell(Shell shell) {
        this.shell = shell;
        shell.addListener(12, event -> {
            if (this.isDisposed()) {
                return;
            }
            this.dispose();
        });
    }

    void updateImage() {
        Image image2 = null;
        long hIcon = 0L;
        switch (this.overlayImage.type) {
            case 0: {
                image2 = Display.createIcon(this.overlayImage, this.getZoom());
                hIcon = Image.win32_getHandle(image2, this.getZoom());
                break;
            }
            case 1: {
                hIcon = Image.win32_getHandle(this.overlayImage, this.getZoom());
            }
        }
        this.parent.mTaskbarList3.SetOverlayIcon(this.shell.handle, hIcon, 0L);
        if (image2 != null) {
            image2.dispose();
        }
    }

    void updateProgress() {
        if (this.progressState == 2) {
            return;
        }
        if (this.progressState == -1) {
            return;
        }
        this.parent.mTaskbarList3.SetProgressValue(this.shell.handle, this.progress, 100L);
    }

    void updateProgressState() {
        int tbpFlags = 0;
        switch (this.progressState) {
            case 0: {
                tbpFlags = 2;
                break;
            }
            case 1: {
                tbpFlags = 4;
                break;
            }
            case 4: {
                tbpFlags = 8;
                break;
            }
            case 2: {
                tbpFlags = 1;
            }
        }
        this.parent.mTaskbarList3.SetProgressValue(this.shell.handle, this.progress, 100L);
        this.parent.mTaskbarList3.SetProgressState(this.shell.handle, tbpFlags);
    }

    long renderTextIcon() {
        int width = 16;
        int height = 16;
        long hdc = OS.GetDC(0L);
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)32;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        long hBitmap = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
        if (hBitmap == 0L) {
            this.error(2);
        }
        long dstHdc = OS.CreateCompatibleDC(hdc);
        long oldBitmap = OS.SelectObject(dstHdc, hBitmap);
        long hMask = OS.CreateBitmap(width, height, 1, 1, null);
        if (hMask == 0L) {
            this.error(2);
        }
        long maskHdc = OS.CreateCompatibleDC(hdc);
        long oldMask = OS.SelectObject(maskHdc, hMask);
        OS.PatBlt(maskHdc, 0, 0, width, height, 16711778);
        long oldBrush = OS.SelectObject(maskHdc, OS.GetStockObject(4));
        OS.RoundRect(maskHdc, 0, 0, width, height, 8, 8);
        OS.SelectObject(maskHdc, oldBrush);
        long brush = OS.CreateSolidBrush(OS.GetSysColor(13));
        oldBrush = OS.SelectObject(dstHdc, brush);
        OS.RoundRect(dstHdc, 0, 0, width, height, 8, 8);
        OS.SelectObject(dstHdc, oldBrush);
        OS.DeleteObject(brush);
        int uFormat = 2080;
        RECT rect = new RECT();
        char[] buffer = this.overlayText.toCharArray();
        int length = buffer.length;
        long hFont = 0L;
        long oldHFont = 0L;
        NONCLIENTMETRICS info = new NONCLIENTMETRICS();
        info.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, info, 0)) {
            LOGFONT logFont = info.lfMessageFont;
            logFont.lfHeight = -10;
            hFont = OS.CreateFontIndirect(logFont);
            oldHFont = OS.SelectObject(dstHdc, hFont);
            OS.DrawText(dstHdc, buffer, length, rect, uFormat | 0x400);
            if (rect.right > width - 2) {
                OS.SelectObject(dstHdc, oldHFont);
                OS.DeleteObject(hFont);
                logFont.lfHeight = -8;
                hFont = OS.CreateFontIndirect(logFont);
                OS.SelectObject(dstHdc, hFont);
            }
        }
        OS.DrawText(dstHdc, buffer, length, rect, uFormat | 0x400);
        OS.OffsetRect(rect, (width - rect.right) / 2, (height - rect.bottom) / 2);
        int oldBkMode = OS.SetBkMode(dstHdc, 1);
        OS.SetTextColor(dstHdc, OS.GetSysColor(14));
        OS.DrawText(dstHdc, buffer, length, rect, uFormat);
        if (hFont != 0L) {
            OS.SelectObject(dstHdc, oldHFont);
            OS.DeleteObject(hFont);
        }
        OS.SetBkMode(dstHdc, oldBkMode);
        OS.SelectObject(dstHdc, oldBitmap);
        OS.DeleteDC(dstHdc);
        OS.SelectObject(maskHdc, oldMask);
        OS.DeleteDC(maskHdc);
        OS.ReleaseDC(0L, hdc);
        ICONINFO iconInfo = new ICONINFO();
        iconInfo.fIcon = true;
        iconInfo.hbmColor = hBitmap;
        iconInfo.hbmMask = hMask;
        long hIcon = OS.CreateIconIndirect(iconInfo);
        if (hIcon == 0L) {
            this.error(2);
        }
        OS.DeleteObject(hBitmap);
        OS.DeleteObject(hMask);
        return hIcon;
    }

    void updateText() {
        long hIcon = this.renderTextIcon();
        this.parent.mTaskbarList3.SetOverlayIcon(this.shell.handle, hIcon, 0L);
        OS.DestroyIcon(hIcon);
    }
}

