/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.net.ssl.OpenJSSE;

public final class OpenJSSEPlatform
extends Platform {
    public static final Companion Companion;
    private final Provider provider = (Provider)new OpenJSSE();
    private static final boolean isSupported;

    private OpenJSSEPlatform() {
    }

    @Override
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLSv1.3\", provider)");
        return sSLContext;
    }

    @Override
    public X509TrustManager platformTrustManager() {
        TrustManagerFactory factory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), this.provider);
        factory2.init((KeyStore)null);
        Object[] objectArray = factory2.getTrustManagers();
        Intrinsics.checkNotNull(objectArray);
        Object[] trustManagers = objectArray;
        if (!(trustManagers.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
            boolean bl = false;
            String string = Arrays.toString(trustManagers);
            Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
            String string2 = Intrinsics.stringPlus("Unexpected default trust managers: ", string);
            throw new IllegalStateException(string2.toString());
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)trustManager;
    }

    @Override
    public void configureTlsExtensions(javax.net.ssl.SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(protocols, "protocols");
        if (sslSocket instanceof SSLSocket) {
            SSLParameters sslParameters = ((SSLSocket)sslSocket).getSSLParameters();
            if (sslParameters instanceof org.openjsse.javax.net.ssl.SSLParameters) {
                List<String> names = Platform.Companion.alpnProtocolNames(protocols);
                Collection $this$toTypedArray$iv = names;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                ((org.openjsse.javax.net.ssl.SSLParameters)sslParameters).setApplicationProtocols(stringArray);
                ((SSLSocket)sslSocket).setSSLParameters(sslParameters);
            }
        } else {
            super.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSelectedProtocol(javax.net.ssl.SSLSocket sslSocket) {
        Object object;
        Intrinsics.checkNotNullParameter(sslSocket, "sslSocket");
        if (sslSocket instanceof SSLSocket) {
            void var2_2;
            String protocol;
            String string = protocol = ((SSLSocket)sslSocket).getApplicationProtocol();
            object = (string == null ? true : Intrinsics.areEqual(string, "")) ? null : var2_2;
        } else {
            object = super.getSelectedProtocol(sslSocket);
        }
        return object;
    }

    public /* synthetic */ OpenJSSEPlatform(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        try {
            Class.forName("org.openjsse.net.ssl.OpenJSSE", false, Companion.getClass().getClassLoader());
            bl = true;
        }
        catch (ClassNotFoundException _) {
            bl = false;
        }
        isSupported = bl;
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupported() {
            return isSupported;
        }

        public final OpenJSSEPlatform buildIfSupported() {
            return this.isSupported() ? new OpenJSSEPlatform(null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

