/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;

public final class Header {
    public static final Companion Companion = new Companion(null);
    public final ByteString name;
    public final ByteString value;
    public final int hpackSize;
    public static final ByteString PSEUDO_PREFIX = ByteString.Companion.encodeUtf8(":");
    public static final ByteString RESPONSE_STATUS = ByteString.Companion.encodeUtf8(":status");
    public static final ByteString TARGET_METHOD = ByteString.Companion.encodeUtf8(":method");
    public static final ByteString TARGET_PATH = ByteString.Companion.encodeUtf8(":path");
    public static final ByteString TARGET_SCHEME = ByteString.Companion.encodeUtf8(":scheme");
    public static final ByteString TARGET_AUTHORITY = ByteString.Companion.encodeUtf8(":authority");

    public Header(ByteString name, ByteString value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this.name = name;
        this.value = value;
        this.hpackSize = 32 + this.name.size() + this.value.size();
    }

    public Header(String name, String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this(ByteString.Companion.encodeUtf8(name), ByteString.Companion.encodeUtf8(value));
    }

    public Header(ByteString name, String value) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        this(name, ByteString.Companion.encodeUtf8(value));
    }

    public String toString() {
        return this.name.utf8() + ": " + this.value.utf8();
    }

    public final ByteString component1() {
        return this.name;
    }

    public final ByteString component2() {
        return this.value;
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Header)) {
            return false;
        }
        Header header = (Header)other;
        if (!Intrinsics.areEqual(this.name, header.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, header.value);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

