/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.proxy.NullProxySelector;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.internal.ws.RealWebSocket;

public class OkHttpClient
implements Cloneable,
Call.Factory,
WebSocket.Factory {
    public static final Companion Companion = new Companion(null);
    private final Dispatcher dispatcher;
    private final ConnectionPool connectionPool;
    private final List<Interceptor> interceptors;
    private final List<Interceptor> networkInterceptors;
    private final EventListener.Factory eventListenerFactory;
    private final boolean retryOnConnectionFailure;
    private final Authenticator authenticator;
    private final boolean followRedirects;
    private final boolean followSslRedirects;
    private final CookieJar cookieJar;
    private final Cache cache;
    private final Dns dns;
    private final Proxy proxy;
    private final ProxySelector proxySelector;
    private final Authenticator proxyAuthenticator;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactoryOrNull;
    private final X509TrustManager x509TrustManager;
    private final List<ConnectionSpec> connectionSpecs;
    private final List<Protocol> protocols;
    private final HostnameVerifier hostnameVerifier;
    private final CertificatePinner certificatePinner;
    private final CertificateChainCleaner certificateChainCleaner;
    private final int callTimeoutMillis;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int pingIntervalMillis;
    private final long minWebSocketMessageToCompress;
    private final RouteDatabase routeDatabase;
    private static final List<Protocol> DEFAULT_PROTOCOLS;
    private static final List<ConnectionSpec> DEFAULT_CONNECTION_SPECS;

    public OkHttpClient(Builder builder) {
        boolean bl;
        block12: {
            ProxySelector proxySelector;
            Intrinsics.checkNotNullParameter(builder, "builder");
            this.dispatcher = builder.getDispatcher$okhttp();
            this.connectionPool = builder.getConnectionPool$okhttp();
            this.interceptors = Util.toImmutableList(builder.getInterceptors$okhttp());
            this.networkInterceptors = Util.toImmutableList(builder.getNetworkInterceptors$okhttp());
            this.eventListenerFactory = builder.getEventListenerFactory$okhttp();
            this.retryOnConnectionFailure = builder.getRetryOnConnectionFailure$okhttp();
            this.authenticator = builder.getAuthenticator$okhttp();
            this.followRedirects = builder.getFollowRedirects$okhttp();
            this.followSslRedirects = builder.getFollowSslRedirects$okhttp();
            this.cookieJar = builder.getCookieJar$okhttp();
            this.cache = builder.getCache$okhttp();
            this.dns = builder.getDns$okhttp();
            this.proxy = builder.getProxy$okhttp();
            if (builder.getProxy$okhttp() != null) {
                proxySelector = NullProxySelector.INSTANCE;
            } else {
                ProxySelector proxySelector2 = builder.getProxySelector$okhttp();
                if (proxySelector2 == null) {
                    proxySelector2 = proxySelector = ProxySelector.getDefault();
                }
                if (proxySelector2 == null) {
                    proxySelector = NullProxySelector.INSTANCE;
                }
            }
            this.proxySelector = proxySelector;
            this.proxyAuthenticator = builder.getProxyAuthenticator$okhttp();
            this.socketFactory = builder.getSocketFactory$okhttp();
            this.connectionSpecs = builder.getConnectionSpecs$okhttp();
            this.protocols = builder.getProtocols$okhttp();
            this.hostnameVerifier = builder.getHostnameVerifier$okhttp();
            this.callTimeoutMillis = builder.getCallTimeout$okhttp();
            this.connectTimeoutMillis = builder.getConnectTimeout$okhttp();
            this.readTimeoutMillis = builder.getReadTimeout$okhttp();
            this.writeTimeoutMillis = builder.getWriteTimeout$okhttp();
            this.pingIntervalMillis = builder.getPingInterval$okhttp();
            this.minWebSocketMessageToCompress = builder.getMinWebSocketMessageToCompress$okhttp();
            RouteDatabase routeDatabase = builder.getRouteDatabase$okhttp();
            if (routeDatabase == null) {
                routeDatabase = new RouteDatabase();
            }
            this.routeDatabase = routeDatabase;
            Iterable $this$none$iv = this.connectionSpecs;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConnectionSpec it = (ConnectionSpec)element$iv;
                    boolean bl2 = false;
                    if (!it.isTls()) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            this.sslSocketFactoryOrNull = null;
            this.certificateChainCleaner = null;
            this.x509TrustManager = null;
            this.certificatePinner = CertificatePinner.DEFAULT;
        } else if (builder.getSslSocketFactoryOrNull$okhttp() != null) {
            this.sslSocketFactoryOrNull = builder.getSslSocketFactoryOrNull$okhttp();
            CertificateChainCleaner certificateChainCleaner = builder.getCertificateChainCleaner$okhttp();
            Intrinsics.checkNotNull(certificateChainCleaner);
            this.certificateChainCleaner = certificateChainCleaner;
            X509TrustManager x509TrustManager = builder.getX509TrustManagerOrNull$okhttp();
            Intrinsics.checkNotNull(x509TrustManager);
            this.x509TrustManager = x509TrustManager;
            CertificatePinner certificatePinner = builder.getCertificatePinner$okhttp();
            CertificateChainCleaner certificateChainCleaner2 = this.certificateChainCleaner;
            Intrinsics.checkNotNull(certificateChainCleaner2);
            this.certificatePinner = certificatePinner.withCertificateChainCleaner$okhttp(certificateChainCleaner2);
        } else {
            this.x509TrustManager = Platform.Companion.get().platformTrustManager();
            Platform platform = Platform.Companion.get();
            X509TrustManager x509TrustManager = this.x509TrustManager;
            Intrinsics.checkNotNull(x509TrustManager);
            this.sslSocketFactoryOrNull = platform.newSslSocketFactory(x509TrustManager);
            X509TrustManager x509TrustManager2 = this.x509TrustManager;
            Intrinsics.checkNotNull(x509TrustManager2);
            this.certificateChainCleaner = CertificateChainCleaner.Companion.get(x509TrustManager2);
            CertificatePinner certificatePinner = builder.getCertificatePinner$okhttp();
            CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
            Intrinsics.checkNotNull(certificateChainCleaner);
            this.certificatePinner = certificatePinner.withCertificateChainCleaner$okhttp(certificateChainCleaner);
        }
        this.verifyClientState();
    }

    public final Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public final ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public final List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public final List<Interceptor> networkInterceptors() {
        return this.networkInterceptors;
    }

    public final EventListener.Factory eventListenerFactory() {
        return this.eventListenerFactory;
    }

    public final boolean retryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public final Authenticator authenticator() {
        return this.authenticator;
    }

    public final boolean followRedirects() {
        return this.followRedirects;
    }

    public final boolean followSslRedirects() {
        return this.followSslRedirects;
    }

    public final CookieJar cookieJar() {
        return this.cookieJar;
    }

    public final Cache cache() {
        return this.cache;
    }

    public final Dns dns() {
        return this.dns;
    }

    public final Proxy proxy() {
        return this.proxy;
    }

    public final ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public final Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public final SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public final SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.sslSocketFactoryOrNull;
        if (sSLSocketFactory == null) {
            throw new IllegalStateException("CLEARTEXT-only client");
        }
        return sSLSocketFactory;
    }

    public final X509TrustManager x509TrustManager() {
        return this.x509TrustManager;
    }

    public final List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    public final List<Protocol> protocols() {
        return this.protocols;
    }

    public final HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public final CertificateChainCleaner certificateChainCleaner() {
        return this.certificateChainCleaner;
    }

    public final int callTimeoutMillis() {
        return this.callTimeoutMillis;
    }

    public final int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public final int readTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public final int writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public final int pingIntervalMillis() {
        return this.pingIntervalMillis;
    }

    public final long minWebSocketMessageToCompress() {
        return this.minWebSocketMessageToCompress;
    }

    public final RouteDatabase getRouteDatabase() {
        return this.routeDatabase;
    }

    public OkHttpClient() {
        this(new Builder());
    }

    private final void verifyClientState() {
        boolean bl;
        block14: {
            if (!(!this.interceptors.contains(null))) {
                boolean $i$a$-check-OkHttpClient$verifyClientState$32 = false;
                String $i$a$-check-OkHttpClient$verifyClientState$32 = Intrinsics.stringPlus("Null interceptor: ", this.interceptors());
                throw new IllegalStateException($i$a$-check-OkHttpClient$verifyClientState$32.toString());
            }
            if (!(!this.networkInterceptors.contains(null))) {
                boolean $i$a$-check-OkHttpClient$verifyClientState$42 = false;
                String $i$a$-check-OkHttpClient$verifyClientState$42 = Intrinsics.stringPlus("Null network interceptor: ", this.networkInterceptors());
                throw new IllegalStateException($i$a$-check-OkHttpClient$verifyClientState$42.toString());
            }
            Iterable $this$none$iv = this.connectionSpecs;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConnectionSpec it = (ConnectionSpec)element$iv;
                    boolean bl2 = false;
                    if (!it.isTls()) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            if (!(this.sslSocketFactoryOrNull == null)) {
                String $i$f$none = "Check failed.";
                throw new IllegalStateException($i$f$none.toString());
            }
            if (!(this.certificateChainCleaner == null)) {
                String $i$f$none = "Check failed.";
                throw new IllegalStateException($i$f$none.toString());
            }
            if (!(this.x509TrustManager == null)) {
                String $i$f$none = "Check failed.";
                throw new IllegalStateException($i$f$none.toString());
            }
            if (!Intrinsics.areEqual(this.certificatePinner, CertificatePinner.DEFAULT)) {
                String $i$f$none = "Check failed.";
                throw new IllegalStateException($i$f$none.toString());
            }
        } else {
            if (this.sslSocketFactoryOrNull == null) {
                boolean $i$a$-checkNotNull-OkHttpClient$verifyClientState$72 = false;
                String $i$a$-checkNotNull-OkHttpClient$verifyClientState$72 = "sslSocketFactory == null";
                throw new IllegalStateException($i$a$-checkNotNull-OkHttpClient$verifyClientState$72.toString());
            }
            if (this.certificateChainCleaner == null) {
                boolean $i$a$-checkNotNull-OkHttpClient$verifyClientState$82 = false;
                String $i$a$-checkNotNull-OkHttpClient$verifyClientState$82 = "certificateChainCleaner == null";
                throw new IllegalStateException($i$a$-checkNotNull-OkHttpClient$verifyClientState$82.toString());
            }
            if (this.x509TrustManager == null) {
                boolean bl3 = false;
                String string = "x509TrustManager == null";
                throw new IllegalStateException(string.toString());
            }
        }
    }

    @Override
    public Call newCall(Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        return new RealCall(this, request, false);
    }

    @Override
    public WebSocket newWebSocket(Request request, WebSocketListener listener2) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(listener2, "listener");
        RealWebSocket webSocket2 = new RealWebSocket(TaskRunner.INSTANCE, request, listener2, new Random(), this.pingIntervalMillis, null, this.minWebSocketMessageToCompress);
        webSocket2.connect(this);
        return webSocket2;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Object clone() {
        return super.clone();
    }

    static {
        Object[] objectArray = new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1};
        DEFAULT_PROTOCOLS = Util.immutableListOf(objectArray);
        objectArray = new ConnectionSpec[]{ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT};
        DEFAULT_CONNECTION_SPECS = Util.immutableListOf(objectArray);
    }

    public static final class Builder {
        private Dispatcher dispatcher;
        private ConnectionPool connectionPool;
        private final List<Interceptor> interceptors;
        private final List<Interceptor> networkInterceptors;
        private EventListener.Factory eventListenerFactory;
        private boolean retryOnConnectionFailure;
        private Authenticator authenticator;
        private boolean followRedirects;
        private boolean followSslRedirects;
        private CookieJar cookieJar;
        private Cache cache;
        private Dns dns;
        private Proxy proxy;
        private ProxySelector proxySelector;
        private Authenticator proxyAuthenticator;
        private SocketFactory socketFactory;
        private SSLSocketFactory sslSocketFactoryOrNull;
        private X509TrustManager x509TrustManagerOrNull;
        private List<ConnectionSpec> connectionSpecs;
        private List<? extends Protocol> protocols;
        private HostnameVerifier hostnameVerifier;
        private CertificatePinner certificatePinner;
        private CertificateChainCleaner certificateChainCleaner;
        private int callTimeout;
        private int connectTimeout;
        private int readTimeout;
        private int writeTimeout;
        private int pingInterval;
        private long minWebSocketMessageToCompress;
        private RouteDatabase routeDatabase;

        public Builder() {
            this.dispatcher = new Dispatcher();
            this.connectionPool = new ConnectionPool();
            this.interceptors = new ArrayList();
            this.networkInterceptors = new ArrayList();
            this.eventListenerFactory = Util.asFactory(EventListener.NONE);
            this.retryOnConnectionFailure = true;
            this.authenticator = Authenticator.NONE;
            this.followRedirects = true;
            this.followSslRedirects = true;
            this.cookieJar = CookieJar.NO_COOKIES;
            this.dns = Dns.SYSTEM;
            this.proxyAuthenticator = Authenticator.NONE;
            SocketFactory socketFactory = SocketFactory.getDefault();
            Intrinsics.checkNotNullExpressionValue(socketFactory, "getDefault()");
            this.socketFactory = socketFactory;
            this.connectionSpecs = Companion.getDEFAULT_CONNECTION_SPECS$okhttp();
            this.protocols = Companion.getDEFAULT_PROTOCOLS$okhttp();
            this.hostnameVerifier = OkHostnameVerifier.INSTANCE;
            this.certificatePinner = CertificatePinner.DEFAULT;
            this.connectTimeout = 10000;
            this.readTimeout = 10000;
            this.writeTimeout = 10000;
            this.minWebSocketMessageToCompress = 1024L;
        }

        public final Dispatcher getDispatcher$okhttp() {
            return this.dispatcher;
        }

        public final ConnectionPool getConnectionPool$okhttp() {
            return this.connectionPool;
        }

        public final List<Interceptor> getInterceptors$okhttp() {
            return this.interceptors;
        }

        public final List<Interceptor> getNetworkInterceptors$okhttp() {
            return this.networkInterceptors;
        }

        public final EventListener.Factory getEventListenerFactory$okhttp() {
            return this.eventListenerFactory;
        }

        public final void setEventListenerFactory$okhttp(EventListener.Factory factory2) {
            Intrinsics.checkNotNullParameter(factory2, "<set-?>");
            this.eventListenerFactory = factory2;
        }

        public final boolean getRetryOnConnectionFailure$okhttp() {
            return this.retryOnConnectionFailure;
        }

        public final Authenticator getAuthenticator$okhttp() {
            return this.authenticator;
        }

        public final boolean getFollowRedirects$okhttp() {
            return this.followRedirects;
        }

        public final boolean getFollowSslRedirects$okhttp() {
            return this.followSslRedirects;
        }

        public final CookieJar getCookieJar$okhttp() {
            return this.cookieJar;
        }

        public final Cache getCache$okhttp() {
            return this.cache;
        }

        public final Dns getDns$okhttp() {
            return this.dns;
        }

        public final Proxy getProxy$okhttp() {
            return this.proxy;
        }

        public final void setProxy$okhttp(Proxy proxy) {
            this.proxy = proxy;
        }

        public final ProxySelector getProxySelector$okhttp() {
            return this.proxySelector;
        }

        public final Authenticator getProxyAuthenticator$okhttp() {
            return this.proxyAuthenticator;
        }

        public final void setProxyAuthenticator$okhttp(Authenticator authenticator) {
            Intrinsics.checkNotNullParameter(authenticator, "<set-?>");
            this.proxyAuthenticator = authenticator;
        }

        public final SocketFactory getSocketFactory$okhttp() {
            return this.socketFactory;
        }

        public final SSLSocketFactory getSslSocketFactoryOrNull$okhttp() {
            return this.sslSocketFactoryOrNull;
        }

        public final void setSslSocketFactoryOrNull$okhttp(SSLSocketFactory sSLSocketFactory) {
            this.sslSocketFactoryOrNull = sSLSocketFactory;
        }

        public final X509TrustManager getX509TrustManagerOrNull$okhttp() {
            return this.x509TrustManagerOrNull;
        }

        public final void setX509TrustManagerOrNull$okhttp(X509TrustManager x509TrustManager) {
            this.x509TrustManagerOrNull = x509TrustManager;
        }

        public final List<ConnectionSpec> getConnectionSpecs$okhttp() {
            return this.connectionSpecs;
        }

        public final List<Protocol> getProtocols$okhttp() {
            return this.protocols;
        }

        public final void setProtocols$okhttp(List<? extends Protocol> list) {
            Intrinsics.checkNotNullParameter(list, "<set-?>");
            this.protocols = list;
        }

        public final HostnameVerifier getHostnameVerifier$okhttp() {
            return this.hostnameVerifier;
        }

        public final void setHostnameVerifier$okhttp(HostnameVerifier hostnameVerifier) {
            Intrinsics.checkNotNullParameter(hostnameVerifier, "<set-?>");
            this.hostnameVerifier = hostnameVerifier;
        }

        public final CertificatePinner getCertificatePinner$okhttp() {
            return this.certificatePinner;
        }

        public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
            return this.certificateChainCleaner;
        }

        public final void setCertificateChainCleaner$okhttp(CertificateChainCleaner certificateChainCleaner) {
            this.certificateChainCleaner = certificateChainCleaner;
        }

        public final int getCallTimeout$okhttp() {
            return this.callTimeout;
        }

        public final int getConnectTimeout$okhttp() {
            return this.connectTimeout;
        }

        public final void setConnectTimeout$okhttp(int n) {
            this.connectTimeout = n;
        }

        public final int getReadTimeout$okhttp() {
            return this.readTimeout;
        }

        public final void setReadTimeout$okhttp(int n) {
            this.readTimeout = n;
        }

        public final int getWriteTimeout$okhttp() {
            return this.writeTimeout;
        }

        public final int getPingInterval$okhttp() {
            return this.pingInterval;
        }

        public final long getMinWebSocketMessageToCompress$okhttp() {
            return this.minWebSocketMessageToCompress;
        }

        public final RouteDatabase getRouteDatabase$okhttp() {
            return this.routeDatabase;
        }

        public final void setRouteDatabase$okhttp(RouteDatabase routeDatabase) {
            this.routeDatabase = routeDatabase;
        }

        public Builder(OkHttpClient okHttpClient) {
            Intrinsics.checkNotNullParameter(okHttpClient, "okHttpClient");
            this();
            this.dispatcher = okHttpClient.dispatcher();
            this.connectionPool = okHttpClient.connectionPool();
            CollectionsKt.addAll((Collection)this.interceptors, (Iterable)okHttpClient.interceptors());
            CollectionsKt.addAll((Collection)this.networkInterceptors, (Iterable)okHttpClient.networkInterceptors());
            this.eventListenerFactory = okHttpClient.eventListenerFactory();
            this.retryOnConnectionFailure = okHttpClient.retryOnConnectionFailure();
            this.authenticator = okHttpClient.authenticator();
            this.followRedirects = okHttpClient.followRedirects();
            this.followSslRedirects = okHttpClient.followSslRedirects();
            this.cookieJar = okHttpClient.cookieJar();
            this.cache = okHttpClient.cache();
            this.dns = okHttpClient.dns();
            this.proxy = okHttpClient.proxy();
            this.proxySelector = okHttpClient.proxySelector();
            this.proxyAuthenticator = okHttpClient.proxyAuthenticator();
            this.socketFactory = okHttpClient.socketFactory();
            this.sslSocketFactoryOrNull = okHttpClient.sslSocketFactoryOrNull;
            this.x509TrustManagerOrNull = okHttpClient.x509TrustManager();
            this.connectionSpecs = okHttpClient.connectionSpecs();
            this.protocols = okHttpClient.protocols();
            this.hostnameVerifier = okHttpClient.hostnameVerifier();
            this.certificatePinner = okHttpClient.certificatePinner();
            this.certificateChainCleaner = okHttpClient.certificateChainCleaner();
            this.callTimeout = okHttpClient.callTimeoutMillis();
            this.connectTimeout = okHttpClient.connectTimeoutMillis();
            this.readTimeout = okHttpClient.readTimeoutMillis();
            this.writeTimeout = okHttpClient.writeTimeoutMillis();
            this.pingInterval = okHttpClient.pingIntervalMillis();
            this.minWebSocketMessageToCompress = okHttpClient.minWebSocketMessageToCompress();
            this.routeDatabase = okHttpClient.getRouteDatabase();
        }

        public final Builder addInterceptor(Interceptor interceptor) {
            Builder builder;
            Intrinsics.checkNotNullParameter(interceptor, "interceptor");
            Builder $this$addInterceptor_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            ((Collection)$this$addInterceptor_u24lambda_u2d2.getInterceptors$okhttp()).add(interceptor);
            return builder;
        }

        public final Builder eventListener(EventListener eventListener) {
            Builder builder;
            Intrinsics.checkNotNullParameter(eventListener, "eventListener");
            Builder $this$eventListener_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$eventListener_u24lambda_u2d4.setEventListenerFactory$okhttp(Util.asFactory(eventListener));
            return builder;
        }

        public final Builder proxy(Proxy proxy) {
            Builder builder;
            Builder $this$proxy_u24lambda_u2d13 = builder = this;
            boolean bl = false;
            if (!Intrinsics.areEqual(proxy, $this$proxy_u24lambda_u2d13.getProxy$okhttp())) {
                $this$proxy_u24lambda_u2d13.setRouteDatabase$okhttp(null);
            }
            $this$proxy_u24lambda_u2d13.setProxy$okhttp(proxy);
            return builder;
        }

        public final Builder proxyAuthenticator(Authenticator proxyAuthenticator) {
            Builder builder;
            Intrinsics.checkNotNullParameter(proxyAuthenticator, "proxyAuthenticator");
            Builder $this$proxyAuthenticator_u24lambda_u2d15 = builder = this;
            boolean bl = false;
            if (!Intrinsics.areEqual(proxyAuthenticator, $this$proxyAuthenticator_u24lambda_u2d15.getProxyAuthenticator$okhttp())) {
                $this$proxyAuthenticator_u24lambda_u2d15.setRouteDatabase$okhttp(null);
            }
            $this$proxyAuthenticator_u24lambda_u2d15.setProxyAuthenticator$okhttp(proxyAuthenticator);
            return builder;
        }

        public final Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            Builder builder;
            Intrinsics.checkNotNullParameter(sslSocketFactory, "sslSocketFactory");
            Intrinsics.checkNotNullParameter(trustManager, "trustManager");
            Builder $this$sslSocketFactory_u24lambda_u2d19 = builder = this;
            boolean bl = false;
            if (!Intrinsics.areEqual(sslSocketFactory, $this$sslSocketFactory_u24lambda_u2d19.getSslSocketFactoryOrNull$okhttp()) || !Intrinsics.areEqual(trustManager, $this$sslSocketFactory_u24lambda_u2d19.getX509TrustManagerOrNull$okhttp())) {
                $this$sslSocketFactory_u24lambda_u2d19.setRouteDatabase$okhttp(null);
            }
            $this$sslSocketFactory_u24lambda_u2d19.setSslSocketFactoryOrNull$okhttp(sslSocketFactory);
            $this$sslSocketFactory_u24lambda_u2d19.setCertificateChainCleaner$okhttp(CertificateChainCleaner.Companion.get(trustManager));
            $this$sslSocketFactory_u24lambda_u2d19.setX509TrustManagerOrNull$okhttp(trustManager);
            return builder;
        }

        public final Builder protocols(List<? extends Protocol> protocols) {
            Builder builder;
            Intrinsics.checkNotNullParameter(protocols, "protocols");
            Builder $this$protocols_u24lambda_u2d25 = builder = this;
            boolean bl = false;
            List protocolsCopy = CollectionsKt.toMutableList((Collection)protocols);
            if (!(protocolsCopy.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) || protocolsCopy.contains((Object)Protocol.HTTP_1_1))) {
                boolean $i$a$-require-OkHttpClient$Builder$protocols$1$52 = false;
                String $i$a$-require-OkHttpClient$Builder$protocols$1$52 = Intrinsics.stringPlus("protocols must contain h2_prior_knowledge or http/1.1: ", protocolsCopy);
                throw new IllegalArgumentException($i$a$-require-OkHttpClient$Builder$protocols$1$52.toString());
            }
            if (!(!protocolsCopy.contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) || protocolsCopy.size() <= 1)) {
                boolean $i$a$-require-OkHttpClient$Builder$protocols$1$62 = false;
                String $i$a$-require-OkHttpClient$Builder$protocols$1$62 = Intrinsics.stringPlus("protocols containing h2_prior_knowledge cannot use other protocols: ", protocolsCopy);
                throw new IllegalArgumentException($i$a$-require-OkHttpClient$Builder$protocols$1$62.toString());
            }
            if (!(!protocolsCopy.contains((Object)Protocol.HTTP_1_0))) {
                boolean $i$a$-require-OkHttpClient$Builder$protocols$1$72 = false;
                String $i$a$-require-OkHttpClient$Builder$protocols$1$72 = Intrinsics.stringPlus("protocols must not contain http/1.0: ", protocolsCopy);
                throw new IllegalArgumentException($i$a$-require-OkHttpClient$Builder$protocols$1$72.toString());
            }
            if (!(!protocolsCopy.contains(null))) {
                boolean bl2 = false;
                String string = "protocols must not contain null";
                throw new IllegalArgumentException(string.toString());
            }
            protocolsCopy.remove((Object)Protocol.SPDY_3);
            if (!Intrinsics.areEqual(protocolsCopy, $this$protocols_u24lambda_u2d25.getProtocols$okhttp())) {
                $this$protocols_u24lambda_u2d25.setRouteDatabase$okhttp(null);
            }
            List list = Collections.unmodifiableList(protocolsCopy);
            Intrinsics.checkNotNullExpressionValue(list, "unmodifiableList(protocolsCopy)");
            $this$protocols_u24lambda_u2d25.setProtocols$okhttp(list);
            return builder;
        }

        public final Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            Builder builder;
            Intrinsics.checkNotNullParameter(hostnameVerifier, "hostnameVerifier");
            Builder $this$hostnameVerifier_u24lambda_u2d26 = builder = this;
            boolean bl = false;
            if (!Intrinsics.areEqual(hostnameVerifier, $this$hostnameVerifier_u24lambda_u2d26.getHostnameVerifier$okhttp())) {
                $this$hostnameVerifier_u24lambda_u2d26.setRouteDatabase$okhttp(null);
            }
            $this$hostnameVerifier_u24lambda_u2d26.setHostnameVerifier$okhttp(hostnameVerifier);
            return builder;
        }

        public final Builder connectTimeout(long timeout2, TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            Builder $this$connectTimeout_u24lambda_u2d30 = builder = this;
            boolean bl = false;
            $this$connectTimeout_u24lambda_u2d30.setConnectTimeout$okhttp(Util.checkDuration("timeout", timeout2, unit));
            return builder;
        }

        public final Builder readTimeout(long timeout2, TimeUnit unit) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)unit, "unit");
            Builder $this$readTimeout_u24lambda_u2d32 = builder = this;
            boolean bl = false;
            $this$readTimeout_u24lambda_u2d32.setReadTimeout$okhttp(Util.checkDuration("timeout", timeout2, unit));
            return builder;
        }

        public final OkHttpClient build() {
            return new OkHttpClient(this);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final List<Protocol> getDEFAULT_PROTOCOLS$okhttp() {
            return DEFAULT_PROTOCOLS;
        }

        public final List<ConnectionSpec> getDEFAULT_CONNECTION_SPECS$okhttp() {
            return DEFAULT_CONNECTION_SPECS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

